/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.entity.attack.ray.RayAttack;
import cn.leolezury.eternalstarlight.common.entity.interfaces.RayAttackUser;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public abstract class LaserBeamRenderer<T extends RayAttack>
extends EntityRenderer<T> {
    private boolean playerCast = false;

    public LaserBeamRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public float getTextureWidth() {
        return 32.0f;
    }

    public float getBeamRadius() {
        return 1.0f;
    }

    public void render(T laserBeam, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        RayAttackUser user;
        Entity entity;
        if (((RayAttack)((Object)laserBeam)).tickCount < 5) {
            return;
        }
        double entityX = Mth.lerp((double)partialTicks, (double)((RayAttack)((Object)laserBeam)).xo, (double)laserBeam.getX());
        double entityY = Mth.lerp((double)partialTicks, (double)((RayAttack)((Object)laserBeam)).yo, (double)laserBeam.getY());
        double entityZ = Mth.lerp((double)partialTicks, (double)((RayAttack)((Object)laserBeam)).zo, (double)laserBeam.getZ());
        stack.pushPose();
        if (((RayAttack)((Object)laserBeam)).getCaster().isPresent()) {
            Entity caster = ((RayAttack)((Object)laserBeam)).getCaster().get();
            double posX = Mth.lerp((double)partialTicks, (double)caster.xo, (double)caster.getX());
            double posY = Mth.lerp((double)partialTicks, (double)caster.yo, (double)caster.getY());
            double posZ = Mth.lerp((double)partialTicks, (double)caster.zo, (double)caster.getZ());
            Vec3 pos = ((RayAttack)((Object)laserBeam)).getPositionForCaster(caster, new Vec3(posX, posY, posZ));
            posX = pos.x;
            posY = pos.y;
            posZ = pos.z;
            stack.translate(posX - entityX, posY - entityY, posZ - entityZ);
        }
        boolean bl = this.playerCast = Minecraft.getInstance().options.getCameraType().isFirstPerson() && ((RayAttack)((Object)laserBeam)).getCaster().isPresent() && Minecraft.getInstance().player != null && ((RayAttack)((Object)laserBeam)).getCaster().get().getUUID().equals(Minecraft.getInstance().player.getUUID());
        if (this.playerCast && Minecraft.getInstance().getCameraEntity() != null) {
            Vec3 offset = ESMathUtil.rotationToPosition(0.5f, -Minecraft.getInstance().getCameraEntity().getXRot() - 90.0f, Minecraft.getInstance().getCameraEntity().getYHeadRot() + 90.0f);
            stack.translate(offset.x, offset.y, offset.z);
        }
        float yaw = Mth.lerp((float)partialTicks, (float)((RayAttack)((Object)laserBeam)).prevYaw, (float)((RayAttack)((Object)laserBeam)).getYaw()) * ((float)Math.PI / 180);
        float pitch = Mth.lerp((float)partialTicks, (float)((RayAttack)((Object)laserBeam)).prevPitch, (float)((RayAttack)((Object)laserBeam)).getPitch()) * ((float)Math.PI / 180);
        if (((RayAttack)((Object)laserBeam)).getCaster().isPresent() && ((entity = ((RayAttack)((Object)laserBeam)).getCaster().get()) instanceof RayAttackUser && (user = (RayAttackUser)entity).isRayFollowingHeadRotation() || !(((RayAttack)((Object)laserBeam)).getCaster().get() instanceof RayAttackUser)) && (entity = ((RayAttack)((Object)laserBeam)).getCaster().get()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            yaw = (living.getViewYRot(partialTicks) + 90.0f) * ((float)Math.PI / 180);
            pitch = -living.getViewXRot(partialTicks) * ((float)Math.PI / 180);
        }
        float length = ((RayAttack)((Object)laserBeam)).getLength();
        VertexConsumer consumer = ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(ESRenderType.entityGlow(this.getTextureLocation((Entity)laserBeam)));
        this.renderBeam(length, yaw, pitch, (float)((RayAttack)((Object)laserBeam)).tickCount + partialTicks, stack, consumer, packedLight);
        stack.popPose();
    }

    private void renderBeamPart(float length, float tickCount, PoseStack stack, VertexConsumer consumer, int packedLight) {
        PoseStack.Pose pose = stack.last();
        float factor = (float)Math.sin(tickCount);
        float xOffset = tickCount * 0.2f % this.getTextureWidth();
        this.vertex(pose, consumer, -this.getBeamRadius() * 0.8f - factor * this.getBeamRadius() * 0.2f, 0.0f, 0.0f, -xOffset, 0.0f, 1.0f, packedLight);
        this.vertex(pose, consumer, -this.getBeamRadius() * 0.8f - factor * this.getBeamRadius() * 0.2f, length, 0.0f, 1.0f - xOffset, 0.0f, 1.0f, packedLight);
        this.vertex(pose, consumer, this.getBeamRadius() * 0.8f + factor * this.getBeamRadius() * 0.2f, length, 0.0f, 1.0f - xOffset, 1.0f, 1.0f, packedLight);
        this.vertex(pose, consumer, this.getBeamRadius() * 0.8f + factor * this.getBeamRadius() * 0.2f, 0.0f, 0.0f, -xOffset, 1.0f, 1.0f, packedLight);
    }

    private void renderBeam(float length, float yaw, float pitch, float tickCount, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(new Quaternionf().rotationX(1.5707964f));
        poseStack.mulPose(new Quaternionf().rotationZ(yaw - 1.5707964f));
        poseStack.mulPose(new Quaternionf().rotationX(-pitch));
        poseStack.pushPose();
        if (!this.playerCast) {
            poseStack.mulPose(new Quaternionf().rotationY(tickCount * ((float)Math.PI / 180)));
        }
        this.renderBeamPart(length, tickCount, poseStack, vertexConsumer, packedLight);
        poseStack.popPose();
        if (!this.playerCast) {
            for (int i = 1; i < 3; ++i) {
                poseStack.pushPose();
                poseStack.mulPose(new Quaternionf().rotationY((float)(i * 30) * ((float)Math.PI / 180)));
                this.renderBeamPart(length, tickCount, poseStack, vertexConsumer, packedLight);
                poseStack.popPose();
            }
        }
        poseStack.popPose();
    }

    public void vertex(PoseStack.Pose pose, VertexConsumer consumer, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLight) {
        consumer.addVertex(pose, offsetX, offsetY, offsetZ).setColor(1.0f, 1.0f, 1.0f, 1.0f * alpha).setUv(textureX, textureY).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }
}

