/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.entity.misc.ESBoat;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class ESBoatRenderer
extends EntityRenderer<ESBoat> {
    private final Map<ESBoat.Type, Pair<ResourceLocation, BoatModel>> boatResources;

    public ESBoatRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context);
        this.shadowRadius = 0.8f;
        this.boatResources = (Map)Stream.of(ESBoat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)EternalStarlight.id(ESBoatRenderer.getTextureLocation(type, chest)), (Object)this.createBoatModel(context, (ESBoat.Type)((Object)type), chest))));
    }

    private static ModelLayerLocation createLocation(String path, String model) {
        return new ModelLayerLocation(EternalStarlight.id(path), model);
    }

    public static ModelLayerLocation createBoatModelName(ESBoat.Type pType) {
        return ESBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(ESBoat.Type type) {
        return ESBoatRenderer.createLocation("chest_boat/" + type.getName(), "main");
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, ESBoat.Type type, boolean chest) {
        ModelLayerLocation modellayerlocation = chest ? ESBoatRenderer.createChestBoatModelName(type) : ESBoatRenderer.createBoatModelName(type);
        return chest ? new ChestBoatModel(context.bakeLayer(modellayerlocation)) : new BoatModel(context.bakeLayer(modellayerlocation));
    }

    private static String getTextureLocation(ESBoat.Type type, boolean chest) {
        return chest ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    public void render(ESBoat boat, float boatYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        float f2;
        stack.pushPose();
        stack.translate(0.0f, 0.375f, 0.0f);
        stack.mulPose(Axis.YP.rotationDegrees(180.0f - boatYaw));
        float f = (float)boat.getHurtTime() - partialTicks;
        float f1 = boat.getDamage() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            stack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)boat.getHurtDir()));
        }
        if (!Mth.equal((float)(f2 = boat.getBubbleAngle(partialTicks)), (float)0.0f)) {
            stack.mulPose(new Quaternionf().setAngleAxis(boat.getBubbleAngle(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, BoatModel> pair = this.getModelWithLocation(boat);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        BoatModel model = (BoatModel)pair.getSecond();
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.mulPose(Axis.YP.rotationDegrees(90.0f));
        model.setupAnim((Boat)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.getBuffer(model.renderType(resourcelocation));
        model.renderToBuffer(stack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        if (!boat.isUnderWater()) {
            VertexConsumer vertexconsumer1 = buffer.getBuffer(RenderType.waterMask());
            model.waterPatch().render(stack, vertexconsumer1, light, OverlayTexture.NO_OVERLAY);
        }
        stack.popPose();
        super.render((Entity)boat, boatYaw, partialTicks, stack, buffer, light);
    }

    public ResourceLocation getTextureLocation(ESBoat entity) {
        return (ResourceLocation)this.boatResources.get((Object)entity.getESBoatType()).getFirst();
    }

    public Pair<ResourceLocation, BoatModel> getModelWithLocation(ESBoat boat) {
        return this.boatResources.get((Object)boat.getESBoatType());
    }
}

