/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.entity.projectile.ChainOfSouls;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.Color;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChainOfSoulsRenderer
extends EntityRenderer<ChainOfSouls> {
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/chain_of_souls.png");

    public ChainOfSoulsRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(ChainOfSouls chain, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        Player player = chain.getPlayerOwner();
        if (player != null) {
            stack.pushPose();
            float attackAnim = player.getAttackAnim(partialTicks);
            Entity target = chain.level().getEntity(chain.getTargetId());
            Vec3 handPos = this.getPlayerHandPos(player, Mth.sin((float)(Mth.sqrt((float)attackAnim) * (float)Math.PI)), partialTicks);
            Vec3 endPos = new Vec3(Mth.lerp((double)partialTicks, (double)chain.xo, (double)chain.getX()), Mth.lerp((double)partialTicks, (double)chain.yo, (double)chain.getY()), Mth.lerp((double)partialTicks, (double)chain.zo, (double)chain.getZ()));
            if (target != null) {
                Vec3 targetPos = new Vec3(Mth.lerp((double)partialTicks, (double)target.xo, (double)target.getX()), Mth.lerp((double)partialTicks, (double)target.yo, (double)target.getY()) + (double)(target.getBbHeight() / 2.0f), Mth.lerp((double)partialTicks, (double)target.zo, (double)target.getZ()));
                Vec3 diff = targetPos.subtract(endPos);
                stack.translate(diff.x(), diff.y(), diff.z());
                endPos = targetPos;
            }
            float age = (float)chain.tickCount + partialTicks;
            float j = age * 0.15f % 1.0f;
            Vec3 offset = handPos.subtract(endPos);
            float k = (float)(offset.length() + 0.1);
            offset = offset.normalize();
            float l = (float)Math.acos(offset.y);
            float m = (float)Math.atan2(offset.z, offset.x);
            stack.mulPose(Axis.YP.rotationDegrees((1.5707964f - m) * 57.295776f));
            stack.mulPose(Axis.XP.rotationDegrees(l * 57.295776f));
            float n = age * 0.05f * -1.5f;
            float width = 0.2f;
            float p = Mth.cos((float)(n + (float)Math.PI)) * width;
            float q = Mth.sin((float)(n + (float)Math.PI)) * width;
            float r = Mth.cos((float)(n + 0.0f)) * width;
            float s = Mth.sin((float)(n + 0.0f)) * width;
            float t = Mth.cos((float)(n + 1.5707964f)) * width;
            float u = Mth.sin((float)(n + 1.5707964f)) * width;
            float v = Mth.cos((float)(n + 4.712389f)) * width;
            float w = Mth.sin((float)(n + 4.712389f)) * width;
            float aa = -1.0f + j;
            float ab = k * 2.5f + aa;
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)ENTITY_TEXTURE));
            PoseStack.Pose pose = stack.last();
            ChainOfSoulsRenderer.vertex(vertexConsumer, pose, p, k, q, 0.4999f, ab);
            ChainOfSoulsRenderer.vertex(vertexConsumer, pose, p, 0.0f, q, 0.4999f, aa);
            ChainOfSoulsRenderer.vertex(vertexConsumer, pose, r, 0.0f, s, 0.0f, aa);
            ChainOfSoulsRenderer.vertex(vertexConsumer, pose, r, k, s, 0.0f, ab);
            ChainOfSoulsRenderer.vertex(vertexConsumer, pose, t, k, u, 0.4999f, ab);
            ChainOfSoulsRenderer.vertex(vertexConsumer, pose, t, 0.0f, u, 0.4999f, aa);
            ChainOfSoulsRenderer.vertex(vertexConsumer, pose, v, 0.0f, w, 0.0f, aa);
            ChainOfSoulsRenderer.vertex(vertexConsumer, pose, v, k, w, 0.0f, ab);
            stack.popPose();
            super.render((Entity)chain, yaw, partialTicks, stack, buffer, light);
        }
    }

    private static void vertex(VertexConsumer vertexConsumer, PoseStack.Pose pose, float x, float y, float z, float uvX, float uvY) {
        vertexConsumer.addVertex(pose, x, y, z).setColor(Color.WHITE.argb()).setUv(uvX, uvY).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
    }

    private Vec3 getPlayerHandPos(Player player, float f, float g) {
        int i = player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
        ItemStack itemStack = player.getMainHandItem();
        if (!itemStack.is(ESItems.CHAIN_OF_SOULS.get())) {
            i = -i;
        }
        if (this.entityRenderDispatcher.options.getCameraType().isFirstPerson() && player == Minecraft.getInstance().player) {
            double n = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
            float xRotFactor = player.getViewXRot(g) / 750.0f;
            Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)i * (0.85f + xRotFactor), 0.1f - f * 0.1f).scale(n).yRot(f * 0.5f).xRot(-f * 0.7f);
            return player.getEyePosition(g).add(vec3);
        }
        float h = Mth.lerp((float)g, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
        double d = Mth.sin((float)h);
        double e = Mth.cos((float)h);
        float j = player.getScale();
        double k = (double)i * 0.35 * (double)j;
        double l = 0.8 * (double)j;
        float m = player.isCrouching() ? -0.1875f : 0.0f;
        return player.getEyePosition(g).add(-e * k - d * l, (double)m - 0.45 * (double)j, -d * k + e * l);
    }

    public ResourceLocation getTextureLocation(ChainOfSouls chain) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

