/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.environment;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FireflyParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private int ticksSinceMotionChange;

    protected FireflyParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.quadSize = 0.2f + this.random.nextFloat() * 0.1f;
        this.lifetime = 50 + this.random.nextInt(21);
        this.spriteSet = spriteSet;
        this.setSpriteFromAge(spriteSet);
        this.setAlpha();
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.spriteSet);
        ++this.ticksSinceMotionChange;
        if (this.ticksSinceMotionChange > 40) {
            Vec3 movement = new Vec3((double)((this.random.nextBoolean() ? 1 : -1) * this.random.nextInt(1, 10)), (double)((this.random.nextBoolean() ? 1 : -1) * this.random.nextInt(1, 10)), (double)((this.random.nextBoolean() ? 1 : -1) * this.random.nextInt(1, 10))).normalize().scale(new Vec3(this.xd, this.yd, this.zd).length());
            this.xd = movement.x;
            this.yd = movement.y;
            this.zd = movement.z;
            this.ticksSinceMotionChange = 0;
        }
        this.setAlpha();
    }

    private void setAlpha() {
        this.alpha = (float)((double)(0.85f * (1.0f - (float)Math.abs(this.age - this.lifetime / 2) / ((float)this.lifetime / 2.0f))) + (double)0.15f * ((Math.sin((double)this.age / 2.0) + 1.0) / 2.0));
    }

    public void move(double xd, double yd, double zd) {
        this.setBoundingBox(this.getBoundingBox().move(xd, yd, zd));
        this.setLocationFromBoundingbox();
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        super.render(vertexConsumer, camera, f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public int getLightColor(float partialTicks) {
        return 0xF000F0;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel clientLevel, double x, double y, double z, double xs, double ys, double zs) {
            return new FireflyParticle(clientLevel, x, y, z, this.sprites);
        }
    }
}

