/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.TwilightGazeAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.animal.TwilightGaze;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class TwilightGazeModel<T extends TwilightGaze>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("twilight_gaze"), "main");
    private final ModelPart root;

    public TwilightGazeModel(ModelPart root) {
        this.root = root.getChild("root");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(36, 9).addBox(-2.0f, -4.0f, -0.5f, 4.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)12.5f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -4.5f, -0.5f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)4.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition body1 = root.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(18, 8).addBox(0.0f, -8.75f, -10.75f, 0.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 20).addBox(-1.5f, -3.75f, -10.75f, 3.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.75f, (float)11.5f));
        PartDefinition body2 = body1.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(20, 26).addBox(-1.5f, -2.75f, -9.75f, 3.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 23).addBox(0.0f, -5.75f, -9.75f, 0.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 8).addBox(0.0f, 3.25f, -9.75f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-11.0f));
        PartDefinition tail1 = body2.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(21, 0).addBox(-1.0f, -1.75f, -4.75f, 2.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-10.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        tail2.addOrReplaceChild("upper_tail_fin", CubeListBuilder.create().texOffs(21, 0).addBox(0.0f, -3.25f, -9.75f, 0.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-1.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        tail2.addOrReplaceChild("lower_tail_fin", CubeListBuilder.create().texOffs(0, 14).addBox(0.0f, -1.5f, -5.75f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-1.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        body1.addOrReplaceChild("left_fin", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -0.5f, -3.0f, 0.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)2.0f, (float)-2.5f, (float)-0.2182f, (float)0.0f, (float)0.9599f));
        body1.addOrReplaceChild("right_fin", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, -0.5f, -3.0f, 0.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.5f, (float)2.0f, (float)-2.5f, (float)-0.2182f, (float)0.0f, (float)-0.9599f));
        body1.addOrReplaceChild("body1_swell", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -3.75f, -10.75f, 3.0f, 5.0f, 15.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.root.xRot = -headPitch * ((float)Math.PI / 180);
        this.root.yRot = (netHeadYaw + 180.0f) * ((float)Math.PI / 180);
        this.animate(((TwilightGaze)((Object)entity)).swimAnimationState, TwilightGazeAnimation.SWIM, ageInTicks, (float)(16.0 * entity.getDeltaMovement().length()), entity.isInWater() ? 1.0f : 1.5f);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

