/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.AuroraDeerAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.animal.AuroraDeer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AuroraDeerModel<T extends AuroraDeer>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("aurora_deer"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart leftHorn;
    private final ModelPart rightHorn;

    public AuroraDeerModel(ModelPart root) {
        this.root = root.getChild("root");
        this.head = root.getChild("root").getChild("body").getChild("neck").getChild("head");
        this.leftHorn = this.head.getChild("left_horn");
        this.rightHorn = this.head.getChild("right_horn");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -7.153f, -10.6325f, 8.0f, 7.0f, 20.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)-8.847f, (float)0.6325f));
        body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(4, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.153f, (float)9.3675f, (float)-0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.153f, (float)-8.6325f));
        neck.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(26, 30).addBox(-2.0f, -0.9f, -2.2f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 27).addBox(-2.0f, -6.1f, -6.0f, 4.0f, 6.0f, 8.0f, new CubeDeformation(0.01f)).texOffs(0, 0).addBox(-2.0f, -3.1f, -9.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(10, 1).addBox(-5.5f, -1.5f, -0.4f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-5.5f, (float)2.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 12).addBox(-0.3f, -1.5f, -2.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-5.5f, (float)2.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        head.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(16, 20).addBox(-0.5f, -7.0f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-6.0f, (float)0.5f, (float)-0.3927f, (float)0.1745f, (float)0.2138f));
        head.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(0, 0).addBox(0.5f, -7.0f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-6.0f, (float)0.5f, (float)-0.3927f, (float)-0.1745f, (float)-0.2138f));
        root.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(20, 38).addBox(-1.5f, -1.0f, -2.25f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(9, 46).addBox(-1.5f, 4.0f, -1.25f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-9.0f, (float)-7.65f));
        root.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(34, 38).addBox(-1.5f, -1.0f, -2.25f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(45, 44).addBox(-1.5f, 4.0f, -1.25f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-9.0f, (float)-7.65f));
        root.addOrReplaceChild("left_rear_leg", CubeListBuilder.create().texOffs(36, 9).addBox(-1.5f, -1.0f, -2.25f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 41).addBox(-1.5f, 4.0f, -1.25f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-9.0f, (float)8.15f));
        root.addOrReplaceChild("right_rear_leg", CubeListBuilder.create().texOffs(42, 27).addBox(-1.5f, 4.0f, -1.25f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(36, 0).addBox(-1.5f, -1.0f, -2.25f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-9.0f, (float)8.15f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        if (this.young) {
            this.root.xScale = 0.6f;
            this.root.yScale = 0.6f;
            this.root.zScale = 0.6f;
            this.head.xScale = 1.67f;
            this.head.yScale = 1.67f;
            this.head.zScale = 1.67f;
        }
        this.leftHorn.visible = ((AuroraDeer)entity).hasLeftHorn();
        this.rightHorn.visible = ((AuroraDeer)entity).hasRightHorn();
        this.animate(((AuroraDeer)entity).idleAnimationState, AuroraDeerAnimation.IDLE, ageInTicks);
        this.animateWalk(AuroraDeerAnimation.WALK, limbSwing, limbSwingAmount, this.young ? 3.0f : 5.0f, 1.0f);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

