/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.handler;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ClientWeatherState;
import cn.leolezury.eternalstarlight.common.client.handler.ClientSetupHandlers;
import cn.leolezury.eternalstarlight.common.client.sound.BossMusicSoundInstance;
import cn.leolezury.eternalstarlight.common.client.visual.DelayedMultiBufferSource;
import cn.leolezury.eternalstarlight.common.client.visual.ScreenShake;
import cn.leolezury.eternalstarlight.common.client.visual.WorldVisualEffect;
import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESBiomes;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosity;
import cn.leolezury.eternalstarlight.common.entity.projectile.SoulitSpectator;
import cn.leolezury.eternalstarlight.common.item.component.CurrentCrestComponent;
import cn.leolezury.eternalstarlight.common.network.NoParametersPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESFluids;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.spell.SpellCastData;
import cn.leolezury.eternalstarlight.common.util.ESBlockUtil;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESGuiUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@OnlyIn(value=Dist.CLIENT)
public class ClientHandlers {
    public static final int FULL_BRIGHT = 0xF000F0;
    public static final Set<Mob> BOSSES = Collections.newSetFromMap(new WeakHashMap());
    public static final List<WorldVisualEffect> VISUAL_EFFECTS = new ArrayList<WorldVisualEffect>();
    public static final List<ScreenShake> SCREEN_SHAKES = new ArrayList<ScreenShake>();
    private static final ResourceLocation[] BAR_BACKGROUND_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"boss_bar/pink_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/blue_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/red_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/green_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/purple_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/white_background")};
    private static final ResourceLocation[] BAR_PROGRESS_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"boss_bar/pink_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/blue_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/red_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/green_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/purple_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/white_progress")};
    private static final ResourceLocation[] OVERLAY_BACKGROUND_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_6_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_10_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_12_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_20_background")};
    private static final ResourceLocation[] OVERLAY_PROGRESS_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_6_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_10_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_12_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_20_progress")};
    private static final ResourceLocation ETHER_EROSION_OVERLAY = EternalStarlight.id("textures/misc/ether_erosion.png");
    private static final ResourceLocation ETHER_ARMOR_EMPTY = EternalStarlight.id("textures/gui/hud/ether_armor_empty.png");
    private static final ResourceLocation ETHER_ARMOR_HALF = EternalStarlight.id("textures/gui/hud/ether_armor_half.png");
    private static final ResourceLocation ETHER_ARMOR_FULL = EternalStarlight.id("textures/gui/hud/ether_armor_full.png");
    private static final ResourceLocation ORB_OF_PROPHECY_USE = EternalStarlight.id("textures/misc/orb_of_prophecy_use.png");
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_attack_indicator_background");
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_attack_indicator_progress");
    private static final ResourceLocation PUMPKIN_BLUR_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/misc/pumpkinblur.png");
    public static final ResourceLocation WIP = EternalStarlight.id("textures/gui/wip.png");
    private static final Map<ResourceKey<Crest>, GuiCrest> GUI_CRESTS = new HashMap<ResourceKey<Crest>, GuiCrest>();
    private static final List<DreamCatcherText> DREAM_CATCHER_TEXTS = new ArrayList<DreamCatcherText>();
    public static int clientTickCount = 0;
    public static BossMusicSoundInstance bossMusicInstance = null;
    public static int resetCameraIn;
    public static float fogStartDecrement;
    public static float fogEndDecrement;
    public static float abyssalFogModifier;
    public static float oldAbyssalFogModifier;
    public static final MultiBufferSource.BufferSource DELAYED_BUFFER_SOURCE;
    private static Matrix4f modelViewMatrix;
    public static boolean isHalloween;

    public static void onClientTick() {
        LocalPlayer player;
        block44: {
            block45: {
                block47: {
                    List<ESBoss> bosses;
                    block46: {
                        ClientWeatherState.tickRainLevel();
                        ArrayList<WorldVisualEffect> effectsToRemove = new ArrayList<WorldVisualEffect>();
                        ArrayList<ScreenShake> screenShakesToRemove = new ArrayList<ScreenShake>();
                        if (Minecraft.getInstance().level == null || !Minecraft.getInstance().level.tickRateManager().runsNormally()) break block44;
                        if (!Minecraft.getInstance().isPaused() && ++clientTickCount % 1000 == 5) {
                            Calendar calendar = Calendar.getInstance();
                            isHalloween = calendar.get(2) == 10 && calendar.get(5) == 1;
                        }
                        for (WorldVisualEffect worldVisualEffect : VISUAL_EFFECTS) {
                            if (worldVisualEffect.shouldRemove()) {
                                effectsToRemove.add(worldVisualEffect);
                                continue;
                            }
                            if (Minecraft.getInstance().isPaused()) continue;
                            worldVisualEffect.worldTick();
                        }
                        for (WorldVisualEffect worldVisualEffect : effectsToRemove) {
                            VISUAL_EFFECTS.remove(worldVisualEffect);
                        }
                        for (ScreenShake screenShake : SCREEN_SHAKES) {
                            if (screenShake.shouldRemove()) {
                                screenShakesToRemove.add(screenShake);
                                continue;
                            }
                            if (Minecraft.getInstance().isPaused()) continue;
                            screenShake.tick();
                        }
                        for (ScreenShake screenShake : screenShakesToRemove) {
                            SCREEN_SHAKES.remove(screenShake);
                        }
                        if (!Minecraft.getInstance().isPaused() && ClientWeatherState.weather != null && Minecraft.getInstance().level.dimension().location().equals((Object)ESDimensions.STARLIGHT_KEY.location())) {
                            ClientWeatherState.weather.clientTick();
                        }
                        if (Minecraft.getInstance().player == null) break block45;
                        if (Minecraft.getInstance().player.tickCount % 15 != 0) break block44;
                        bosses = Minecraft.getInstance().level.getEntitiesOfClass(ESBoss.class, Minecraft.getInstance().player.getBoundingBox().inflate(50.0));
                        bosses.sort(Comparator.comparingDouble(b -> b.distanceTo((Entity)Minecraft.getInstance().player)));
                        bosses = bosses.stream().filter(ESBoss::shouldPlayBossMusic).filter(b -> b.tickCount > 20).toList();
                        if (bossMusicInstance == null) break block46;
                        if (bosses.stream().anyMatch(bossMusicInstance::sameBoss)) break block47;
                    }
                    if (!bosses.isEmpty()) {
                        ESBoss eSBoss = bosses.getFirst();
                        if (bossMusicInstance == null || !bossMusicInstance.sameBoss(eSBoss)) {
                            if (bossMusicInstance != null) {
                                Minecraft.getInstance().getSoundManager().stop((SoundInstance)bossMusicInstance);
                            }
                            bossMusicInstance = new BossMusicSoundInstance(eSBoss.getBossMusic(), eSBoss);
                        }
                    } else if (bossMusicInstance != null) {
                        Minecraft.getInstance().getSoundManager().stop((SoundInstance)bossMusicInstance);
                        bossMusicInstance = null;
                    }
                }
                if (bossMusicInstance != null && !Minecraft.getInstance().getSoundManager().isActive((SoundInstance)bossMusicInstance)) {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)bossMusicInstance);
                }
                break block44;
            }
            if (bossMusicInstance != null) {
                Minecraft.getInstance().getSoundManager().stop((SoundInstance)bossMusicInstance);
                bossMusicInstance = null;
            }
        }
        if (Minecraft.getInstance().level != null) {
            for (ClientSetupHandlers.WorldVisualEffectSpawnFunction worldVisualEffectSpawnFunction : ClientSetupHandlers.VISUAL_EFFECT_SPAWN_FUNCTIONS) {
                worldVisualEffectSpawnFunction.clientTick(Minecraft.getInstance().level, VISUAL_EFFECTS);
            }
        }
        if (Minecraft.getInstance().player != null) {
            Registry registry;
            Optional key;
            ArrayList<ResourceKey<Crest>> toRemove = new ArrayList<ResourceKey<Crest>>();
            for (ResourceKey<Crest> resourceKey : GUI_CRESTS.keySet()) {
                GuiCrest crest = GUI_CRESTS.get(resourceKey);
                if (!((double)Math.abs(crest.angle + 135.0f) < 0.1) || crest.shouldShow) continue;
                toRemove.add(resourceKey);
            }
            for (ResourceKey resourceKey : toRemove) {
                GUI_CRESTS.remove(resourceKey);
            }
            for (Map.Entry<ResourceKey<Crest>, GuiCrest> entry : GUI_CRESTS.entrySet()) {
                entry.getValue().tick();
            }
            ItemStack itemStack = Minecraft.getInstance().player.getMainHandItem();
            ItemStack itemStack2 = Minecraft.getInstance().player.getOffhandItem();
            CurrentCrestComponent component = null;
            if (itemStack.has(ESDataComponents.CURRENT_CREST.get())) {
                component = (CurrentCrestComponent)itemStack.get(ESDataComponents.CURRENT_CREST.get());
            } else if (itemStack2.has(ESDataComponents.CURRENT_CREST.get())) {
                component = (CurrentCrestComponent)itemStack2.get(ESDataComponents.CURRENT_CREST.get());
            }
            for (Map.Entry<ResourceKey<Crest>, GuiCrest> entry : GUI_CRESTS.entrySet()) {
                entry.getValue().shouldShow = false;
            }
            if (component != null && component.crest().isBound() && (key = (registry = Minecraft.getInstance().player.registryAccess().registryOrThrow(ESRegistries.CREST)).getResourceKey((Object)((Crest)component.crest().value()))).isPresent()) {
                if (!GUI_CRESTS.containsKey(key.get())) {
                    GUI_CRESTS.put((ResourceKey<Crest>)((ResourceKey)key.get()), new GuiCrest());
                }
                ClientHandlers.GUI_CRESTS.get(key.get()).shouldShow = true;
            }
            if (ClientSetupHandlers.KEY_MAPPINGS.get(EternalStarlight.id("switch_crest")).consumeClick()) {
                ESPlatform.INSTANCE.sendToServer(new NoParametersPacket("switch_crest"));
            }
        }
        if (Minecraft.getInstance().player != null) {
            if (resetCameraIn > 0) {
                Minecraft.getInstance().options.hideGui = true;
                if (--resetCameraIn <= 0) {
                    Minecraft.getInstance().setCameraEntity((Entity)Minecraft.getInstance().player);
                    Minecraft.getInstance().options.hideGui = false;
                    resetCameraIn = 0;
                }
            } else if (Minecraft.getInstance().getCameraEntity() instanceof SoulitSpectator) {
                Minecraft.getInstance().setCameraEntity((Entity)Minecraft.getInstance().player);
                Minecraft.getInstance().options.hideGui = false;
            }
        }
        if (Minecraft.getInstance().player != null) {
            player = Minecraft.getInstance().player;
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            fogStartDecrement -= 0.5f;
            fogEndDecrement -= 0.5f;
            Holder holder = player.level().getBiome(player.blockPosition());
            if (camera.getFluidInCamera() == FogType.NONE && player.level().getBlockState(camera.getBlockPosition()).getFluidState().isEmpty() && holder.is(ESBiomes.STARLIGHT_PERMAFROST_FOREST)) {
                fogStartDecrement += 1.25f;
                fogEndDecrement += 1.0f;
                fogEndDecrement = Mth.clamp((float)fogEndDecrement, (float)0.0f, (float)80.0f);
            }
            fogStartDecrement = Mth.clamp((float)fogStartDecrement, (float)0.0f, (float)100.0f);
            fogEndDecrement = Mth.clamp((float)fogEndDecrement, (float)0.0f, (float)100.0f);
            oldAbyssalFogModifier = abyssalFogModifier;
            abyssalFogModifier = holder.is(ESBiomes.THE_ABYSS) ? (abyssalFogModifier -= 0.02f) : (abyssalFogModifier += 0.02f);
            abyssalFogModifier = Mth.clamp((float)abyssalFogModifier, (float)0.0f, (float)1.0f);
        }
        if ((player = Minecraft.getInstance().player) != null && player.hasEffect(ESMobEffects.DREAM_CATCHER.asHolder())) {
            ArrayList<DreamCatcherText> arrayList = new ArrayList<DreamCatcherText>();
            for (DreamCatcherText text : DREAM_CATCHER_TEXTS) {
                text.updatePosition();
                int width = Minecraft.getInstance().font.width((FormattedText)text.getText());
                Objects.requireNonNull(Minecraft.getInstance().font);
                int height = 9;
                if (text.getX() - width / 2 <= Minecraft.getInstance().getWindow().getGuiScaledWidth() && text.getY() - height / 2 <= Minecraft.getInstance().getWindow().getGuiScaledHeight()) continue;
                arrayList.add(text);
            }
            for (DreamCatcherText text : arrayList) {
                DREAM_CATCHER_TEXTS.remove(text);
            }
            if (player.getRandom().nextInt(40) == 0 && DREAM_CATCHER_TEXTS.size() < 20) {
                MutableComponent mutableComponent = Component.translatable((String)("message.eternal_starlight.dream_catcher_" + player.getRandom().nextInt(7)));
                DREAM_CATCHER_TEXTS.add(new DreamCatcherText((Component)mutableComponent, (int)(player.getRandom().nextFloat() * 5.0f + 1.0f), -Minecraft.getInstance().font.width((FormattedText)mutableComponent) / 2, player.getRandom().nextInt(Minecraft.getInstance().getWindow().getGuiScaledHeight())));
            }
        } else {
            DREAM_CATCHER_TEXTS.clear();
        }
    }

    public static float getScreenShakeYawOffset() {
        float sum = 0.0f;
        for (ScreenShake screenShake : SCREEN_SHAKES) {
            sum += screenShake.getYawOffset();
        }
        return sum;
    }

    public static float getScreenShakePitchOffset() {
        float sum = 0.0f;
        for (ScreenShake screenShake : SCREEN_SHAKES) {
            sum += screenShake.getPitchOffset();
        }
        return sum;
    }

    public static void onAfterRenderEntities(MultiBufferSource source, PoseStack stack, float partialTicks) {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        stack.pushPose();
        stack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        for (WorldVisualEffect effect : VISUAL_EFFECTS) {
            if (effect.shouldRemove()) continue;
            effect.render(source, stack, partialTicks);
        }
        stack.popPose();
    }

    public static void onAfterRenderParticles() {
        modelViewMatrix = RenderSystem.getModelViewMatrix();
    }

    public static void onAfterRenderWeather() {
        RenderSystem.enableCull();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        RenderSystem.getModelViewMatrix().set((Matrix4fc)modelViewMatrix);
        if (Minecraft.useShaderTransparency()) {
            Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        }
        DELAYED_BUFFER_SOURCE.endBatch();
        RenderSystem.getModelViewMatrix().set((Matrix4fc)matrix4f);
        if (Minecraft.useShaderTransparency() && Minecraft.getInstance().levelRenderer.getCloudsTarget() != null) {
            Minecraft.getInstance().levelRenderer.getCloudsTarget().bindWrite(false);
        }
    }

    public static Vec3 computeCameraAngles(Vec3 angles) {
        return angles.add(Mth.clamp((double)ClientHandlers.getScreenShakePitchOffset(), (double)-0.5, (double)0.5), Mth.clamp((double)ClientHandlers.getScreenShakeYawOffset(), (double)-0.5, (double)0.5), 0.0);
    }

    public static OptionalDouble modifyFov(float original) {
        ItemStack itemStack;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.isUsingItem() && ((itemStack = player.getUseItem()).is(ESItems.MOONRING_BOW.get()) || itemStack.is(ESItems.STARFALL_LONGBOW.get()) || itemStack.is(ESItems.BOW_OF_BLOOD.get()))) {
            float f = (float)player.getTicksUsingItem() / 20.0f;
            f = f > 1.0f ? 1.0f : f * f;
            return OptionalDouble.of(Mth.lerp((double)((Double)Minecraft.getInstance().options.fovEffectScale().get()), (double)1.0, (double)(original * (1.0f - f * 0.15f))));
        }
        return OptionalDouble.empty();
    }

    public static void onRenderFog(Camera camera, FogRenderer.FogMode fogMode) {
        FluidState fluidState;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        if (ESPlatform.INSTANCE.getLoader() == ESPlatform.Loader.FABRIC && ((fluidState = camera.getEntity().level().getFluidState(camera.getBlockPosition())).is((Fluid)ESFluids.ETHER_STILL.get()) || fluidState.is((Fluid)ESFluids.ETHER_FLOWING.get())) && camera.getPosition().y < (double)((float)camera.getBlockPosition().getY() + fluidState.getHeight((BlockGetter)camera.getEntity().level(), camera.getBlockPosition()))) {
            RenderSystem.setShaderFogStart((float)0.0f);
            RenderSystem.setShaderFogEnd((float)3.0f);
            RenderSystem.setShaderFogColor((float)0.9098039f, (float)1.0f, (float)0.87058824f);
            RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
        }
        if (player.level().dimension() == ESDimensions.STARLIGHT_KEY && camera.getFluidInCamera() == FogType.NONE && player.level().getBlockState(camera.getBlockPosition()).getFluidState().isEmpty() && fogMode == FogRenderer.FogMode.FOG_TERRAIN) {
            RenderSystem.setShaderFogStart((float)(RenderSystem.getShaderFogStart() - Mth.clamp((float)fogStartDecrement, (float)0.0f, (float)(RenderSystem.getShaderFogStart() + 5.0f))));
            RenderSystem.setShaderFogEnd((float)(RenderSystem.getShaderFogEnd() - Mth.clamp((float)fogEndDecrement, (float)0.0f, (float)(RenderSystem.getShaderFogEnd() - 50.0f))));
            Holder biomeHolder = player.level().getBiome(player.blockPosition());
            if (biomeHolder.is(ESBiomes.STARLIGHT_PERMAFROST_FOREST)) {
                RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
            }
        }
    }

    public static boolean renderBossBar(GuiGraphics guiGraphics, LerpingBossEvent bossEvent, int x, int y) {
        ResourceLocation barLocation;
        Mob boss = null;
        if (BOSSES.isEmpty()) {
            return false;
        }
        for (Mob mob : BOSSES) {
            if (!mob.getUUID().equals(bossEvent.getId())) continue;
            boss = mob;
            break;
        }
        Iterator<Mob> iterator = boss;
        int mob = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TheGatekeeper.class, StarlightGolem.class, LunarMonstrosity.class}, iterator, mob)) {
            case 0: {
                TheGatekeeper theGatekeeper = (TheGatekeeper)((Object)iterator);
                barLocation = ResourceLocation.fromNamespaceAndPath((String)"eternal_starlight", (String)"textures/gui/bars/the_gatekeeper.png");
                break;
            }
            case 1: {
                StarlightGolem starlightGolem = (StarlightGolem)((Object)iterator);
                barLocation = ResourceLocation.fromNamespaceAndPath((String)"eternal_starlight", (String)"textures/gui/bars/starlight_golem.png");
                break;
            }
            case 2: {
                LunarMonstrosity lunarMonstrosity = (LunarMonstrosity)((Object)iterator);
                barLocation = ResourceLocation.fromNamespaceAndPath((String)"eternal_starlight", (String)("textures/gui/bars/lunar_monstrosity" + (lunarMonstrosity.getPhase() > 0 ? "_soul.png" : ".png")));
                break;
            }
            default: {
                return false;
            }
        }
        ClientHandlers.drawBar(guiGraphics, x, y, (BossEvent)bossEvent, barLocation);
        Component component = bossEvent.getName();
        int textWidth = Minecraft.getInstance().font.width((FormattedText)component);
        int textX = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 - textWidth / 2;
        int textY = y - 9;
        guiGraphics.drawString(Minecraft.getInstance().font, component, textX, textY, 0xFFFFFF);
        return true;
    }

    public static void drawBar(GuiGraphics guiGraphics, int x, int y, BossEvent event, ResourceLocation barLocation) {
        ClientHandlers.drawBar(guiGraphics, x, y, event, 182, BAR_BACKGROUND_SPRITES, OVERLAY_BACKGROUND_SPRITES);
        int k = Mth.lerpDiscrete((float)event.getProgress(), (int)0, (int)182);
        if (k > 0) {
            ClientHandlers.drawBar(guiGraphics, x, y, event, k, BAR_PROGRESS_SPRITES, OVERLAY_PROGRESS_SPRITES);
        }
        guiGraphics.blit(barLocation, x - 1, y - 5, 0.0f, 0.0f, 184, 16, 184, 16);
    }

    private static void drawBar(GuiGraphics guiGraphics, int x, int y, BossEvent bossEvent, int progress, ResourceLocation[] bars, ResourceLocation[] overlays) {
        guiGraphics.blitSprite(bars[bossEvent.getColor().ordinal()], 182, 5, 0, 0, x, y, progress, 5);
        if (bossEvent.getOverlay() != BossEvent.BossBarOverlay.PROGRESS) {
            RenderSystem.enableBlend();
            guiGraphics.blitSprite(overlays[bossEvent.getOverlay().ordinal() - 1], 182, 5, 0, 0, x, y, progress, 5);
            RenderSystem.disableBlend();
        }
    }

    public static void renderTextureOverlay(GuiGraphics guiGraphics, ResourceLocation resourceLocation, float f) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, f);
        guiGraphics.blit(resourceLocation, 0, 0, -90, 0.0f, 0.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight());
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderSpellCrosshair(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        SpellCaster caster;
        LocalPlayer player;
        Options options = Minecraft.getInstance().options;
        if (options.getCameraType().isFirstPerson() && (player = Minecraft.getInstance().player) instanceof SpellCaster && (caster = (SpellCaster)player).getESSpellData().hasSpell()) {
            SpellCastData data = caster.getESSpellData();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (Minecraft.getInstance().options.attackIndicator().get() == AttackIndicatorStatus.CROSSHAIR) {
                float f = Math.min(1.0f, (float)data.castTicks() / (float)data.spell().spellProperties().preparationTicks());
                if (data.castTicks() > data.spell().spellProperties().preparationTicks()) {
                    f = Math.max(0.0f, 1.0f - (float)(data.castTicks() - data.spell().spellProperties().preparationTicks()) / (float)data.spell().spellProperties().spellTicks());
                }
                int j = screenHeight / 2 - 7 + 16;
                int k = screenWidth / 2 - 8;
                int l = (int)(f * 17.0f);
                guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE, k, j, 16, 4);
                guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE, 16, 4, 0, 0, k, j, l, 4);
            }
            RenderSystem.defaultBlendFunc();
        }
    }

    public static void renderEtherErosion(GuiGraphics guiGraphics) {
        float clientEtherTicksRaw = ESEntityUtil.getPersistentData((Entity)Minecraft.getInstance().player).getInt("client_in_ether_ticks");
        float clientEtherTicks = Math.min(clientEtherTicksRaw + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally()), 140.0f);
        float erosionProgress = Math.min(clientEtherTicks, 140.0f) / 140.0f;
        if (clientEtherTicksRaw > 0.0f) {
            ClientHandlers.renderTextureOverlay(guiGraphics, ETHER_EROSION_OVERLAY, erosionProgress);
        }
    }

    public static void renderEtherArmor(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        Minecraft minecraft = Minecraft.getInstance();
        if (ESBlockUtil.isEntityInBlock((Entity)minecraft.player, (Block)ESBlocks.ETHER.get())) {
            minecraft.getProfiler().push("armor");
            int initialX = screenWidth / 2 - 91;
            int initialY = screenHeight - 39;
            float maxHealth = (float)Math.max(minecraft.player.getAttributeValue(Attributes.MAX_HEALTH), (double)Mth.ceil((float)minecraft.player.getHealth()));
            int absorptionAmount = Mth.ceil((float)minecraft.player.getAbsorptionAmount());
            int q = Mth.ceil((float)((maxHealth + (float)absorptionAmount) / 2.0f / 10.0f));
            int r = Math.max(10 - (q - 2), 3);
            int armorValue = minecraft.player.getArmorValue();
            int y = initialY - (q - 1) * r - 10;
            for (int i = 0; i < 10; ++i) {
                if (armorValue <= 0) continue;
                int x = initialX + i * 8;
                if (i * 2 + 1 < armorValue) {
                    guiGraphics.blit(ETHER_ARMOR_FULL, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                }
                if (i * 2 + 1 == armorValue) {
                    guiGraphics.blit(ETHER_ARMOR_HALF, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                }
                if (i * 2 + 1 <= armorValue) continue;
                guiGraphics.blit(ETHER_ARMOR_EMPTY, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
            }
        }
    }

    public static void renderOrbOfProphecyUse(GuiGraphics guiGraphics) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.isUsingItem() && player.getUseItem().is(ESItems.ORB_OF_PROPHECY.get()) && !player.getUseItem().has(ESDataComponents.CURRENT_CREST.get())) {
            int usingTicks = player.getTicksUsingItem();
            float ticks = Math.min((float)usingTicks + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally()), 150.0f);
            float progress = Math.min(ticks, 150.0f) / 150.0f;
            if (usingTicks < 150) {
                ClientHandlers.renderTextureOverlay(guiGraphics, ORB_OF_PROPHECY_USE, progress);
            }
        }
    }

    public static void renderCurrentCrest(GuiGraphics guiGraphics) {
        if (Minecraft.getInstance().player != null) {
            Registry registry = Minecraft.getInstance().player.registryAccess().registryOrThrow(ESRegistries.CREST);
            float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally());
            for (Map.Entry<ResourceKey<Crest>, GuiCrest> entry : GUI_CRESTS.entrySet()) {
                GuiCrest guiCrest = entry.getValue();
                Crest crest = (Crest)registry.get(entry.getKey());
                if (crest == null) continue;
                ESGuiUtil.blit(guiGraphics, crest.texture(), guiCrest.getX(partialTicks), guiCrest.getY(partialTicks), 72.0f, 72.0f, 72.0f, 72.0f);
            }
        }
    }

    public static void renderCarvedLunarisCactusFruitBlur(GuiGraphics guiGraphics) {
        ItemStack itemStack;
        if (Minecraft.getInstance().options.getCameraType().isFirstPerson() && Minecraft.getInstance().player != null && (itemStack = Minecraft.getInstance().player.getInventory().getArmor(3)).is(ESBlocks.CARVED_LUNARIS_CACTUS_FRUIT.get().asItem())) {
            ClientHandlers.renderTextureOverlay(guiGraphics, PUMPKIN_BLUR_LOCATION, 1.0f);
        }
    }

    public static void renderDreamCatcher(GuiGraphics guiGraphics) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.hasEffect(ESMobEffects.DREAM_CATCHER.asHolder())) {
            for (DreamCatcherText text : DREAM_CATCHER_TEXTS) {
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, text.getText(), text.getX(), text.getY(), 5343172);
            }
        }
    }

    static {
        abyssalFogModifier = 1.0f;
        oldAbyssalFogModifier = 1.0f;
        DELAYED_BUFFER_SOURCE = new DelayedMultiBufferSource(new ByteBufferBuilder(1536));
        modelViewMatrix = new Matrix4f();
    }

    private static class GuiCrest {
        private boolean shouldShow = false;
        private float prevAngle = -135.0f;
        private float angle = -135.0f;

        private GuiCrest() {
        }

        public void tick() {
            this.prevAngle = this.angle;
            this.angle = Mth.approachDegrees((float)this.angle, (float)(this.shouldShow ? 45.0f : -135.0f), (float)15.0f);
        }

        public float getX(float partialTicks) {
            return (float)Math.cos(Mth.lerp((float)partialTicks, (float)this.prevAngle, (float)this.angle) * ((float)Math.PI / 180)) * 36.0f * Mth.SQRT_OF_TWO - 36.0f;
        }

        public float getY(float partialTicks) {
            return (float)Math.sin(Mth.lerp((float)partialTicks, (float)this.prevAngle, (float)this.angle) * ((float)Math.PI / 180)) * 36.0f * Mth.SQRT_OF_TWO - 36.0f;
        }
    }

    private static class DreamCatcherText {
        private final Component text;
        private final int speed;
        private int x;
        private final int y;

        public DreamCatcherText(Component component, int speed, int x, int y) {
            this.text = component;
            this.speed = speed;
            this.x = x;
            this.y = y;
        }

        public Component getText() {
            return this.text;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void updatePosition() {
            this.x += this.speed;
        }
    }
}

