/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.gui.screen;

import cn.leolezury.eternalstarlight.common.client.gui.screen.widget.NpcDialogueChoiceButton;
import cn.leolezury.eternalstarlight.common.client.gui.screen.widget.NpcDialogueTextWidget;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import cn.leolezury.eternalstarlight.common.network.CloseGatekeeperGuiPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GatekeeperDialogueScreen
extends Screen {
    private Component currentText;
    private NpcDialogueTextWidget text;
    private final List<NpcDialogueChoiceButton> choiceButtons = new ArrayList<NpcDialogueChoiceButton>();
    private final TheGatekeeper gatekeeper;
    private final boolean killedDragon;
    private final boolean challenged;
    private boolean packetSent = false;

    public GatekeeperDialogueScreen(TheGatekeeper gatekeeper, boolean killedDragon, boolean challenged) {
        super((Component)Component.empty());
        this.gatekeeper = gatekeeper;
        this.killedDragon = killedDragon;
        this.challenged = challenged;
    }

    protected void init() {
        if (this.currentText == null) {
            Object object = this.challenged ? Component.translatable((String)"message.eternal_starlight.gatekeeper_give_orb") : (this.currentText = this.killedDragon ? Component.translatable((String)"message.eternal_starlight.gatekeeper_killed_dragon_hello") : Component.translatable((String)"message.eternal_starlight.gatekeeper_hello"));
        }
        if (this.choiceButtons.isEmpty()) {
            if (this.challenged) {
                this.addChoices(new NpcDialogueChoiceButton((Component)Component.translatable((String)"message.eternal_starlight.gatekeeper_ok"), button -> {
                    this.sendClosePacket(2);
                    Minecraft.getInstance().setScreen(null);
                }));
            } else {
                this.addChoices(new NpcDialogueChoiceButton((Component)Component.translatable((String)"message.eternal_starlight.gatekeeper_backoff"), button -> {
                    this.currentText = Component.translatable((String)"message.eternal_starlight.gatekeeper_bye");
                    this.addChoices(new NpcDialogueChoiceButton((Component)Component.translatable((String)"message.eternal_starlight.gatekeeper_ok"), button1 -> this.onClose()));
                }), new NpcDialogueChoiceButton((Component)Component.translatable((String)"message.eternal_starlight.gatekeeper_look_at_portal"), button -> {
                    if (this.killedDragon) {
                        this.currentText = Component.translatable((String)"message.eternal_starlight.gatekeeper_praise");
                        this.addChoices(new NpcDialogueChoiceButton((Component)Component.translatable((String)"message.eternal_starlight.gatekeeper_ok"), button2 -> {
                            this.sendClosePacket(2);
                            Minecraft.getInstance().setScreen(null);
                        }));
                    } else {
                        this.currentText = Component.translatable((String)"message.eternal_starlight.gatekeeper_portal_response");
                        this.addChoices(new NpcDialogueChoiceButton((Component)Component.translatable((String)"message.eternal_starlight.gatekeeper_step_forward"), button1 -> {
                            this.currentText = Component.translatable((String)"message.eternal_starlight.gatekeeper_block_way");
                            this.addChoices(new NpcDialogueChoiceButton((Component)Component.translatable((String)"message.eternal_starlight.gatekeeper_accept_fight"), button2 -> {
                                this.sendClosePacket(1);
                                Minecraft.getInstance().setScreen(null);
                            }), new NpcDialogueChoiceButton((Component)Component.translatable((String)"message.eternal_starlight.gatekeeper_backoff"), button2 -> {
                                this.currentText = Component.translatable((String)"message.eternal_starlight.gatekeeper_bye");
                                this.addChoices(new NpcDialogueChoiceButton((Component)Component.translatable((String)"message.eternal_starlight.gatekeeper_ok"), button3 -> this.onClose()));
                            }));
                        }), new NpcDialogueChoiceButton((Component)Component.translatable((String)"message.eternal_starlight.gatekeeper_backoff"), button1 -> {
                            this.currentText = Component.translatable((String)"message.eternal_starlight.gatekeeper_bye");
                            this.addChoices(new NpcDialogueChoiceButton((Component)Component.translatable((String)"message.eternal_starlight.gatekeeper_ok"), button2 -> this.onClose()));
                        }));
                    }
                }));
            }
        } else {
            int y = this.height;
            this.text = (NpcDialogueTextWidget)this.addRenderableWidget((GuiEventListener)new NpcDialogueTextWidget(this.currentText));
            for (NpcDialogueChoiceButton button2 : this.choiceButtons) {
                this.addRenderableWidget((GuiEventListener)button2);
                button2.reposition(this.width / 4, y -= button2.getIncrement(this.width / 4 * 3), this.width / 4 * 3);
            }
            this.text.reposition(this.width / 4, y -= this.text.getIncrement(this.width / 4 * 3), this.width / 4 * 3);
        }
    }

    private void addChoices(NpcDialogueChoiceButton ... buttons) {
        this.clearWidgets();
        this.choiceButtons.clear();
        int y = this.height;
        this.text = (NpcDialogueTextWidget)this.addRenderableWidget((GuiEventListener)new NpcDialogueTextWidget(this.currentText));
        for (int i = buttons.length - 1; i >= 0; --i) {
            this.choiceButtons.add((NpcDialogueChoiceButton)this.addRenderableWidget((GuiEventListener)buttons[i]));
            buttons[i].reposition(this.width / 4, y -= buttons[i].getIncrement(this.width / 4 * 3), this.width / 4 * 3);
        }
        this.text.reposition(this.width / 4, y -= this.text.getIncrement(this.width / 4 * 3), this.width / 4 * 3);
    }

    public void tick() {
        if (this.text != null) {
            this.text.tick();
        }
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)0, (int)(this.height / 2), (int)(this.width / 4), (int)this.height, (int)60, (float)0.0625f, (float)i, (float)j, (LivingEntity)this.gatekeeper);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void sendClosePacket(int id) {
        if (!this.packetSent) {
            ESPlatform.INSTANCE.sendToServer(new CloseGatekeeperGuiPacket(this.gatekeeper.getId(), id));
        }
        this.packetSent = true;
    }

    public void removed() {
        super.removed();
        this.sendClosePacket(0);
    }

    public void onClose() {
        super.onClose();
        this.sendClosePacket(0);
    }
}

