/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.component;

import cn.leolezury.eternalstarlight.common.client.book.BookAccess;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentDefinition;
import cn.leolezury.eternalstarlight.common.util.Color;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IndexBookComponent
extends BookComponent {
    private final Component introText;
    private final List<IndexItem> indexItems = new ArrayList<IndexItem>();
    private final Int2BooleanArrayMap leftHovers = new Int2BooleanArrayMap();
    private final Int2BooleanArrayMap rightHovers = new Int2BooleanArrayMap();
    private final Int2IntArrayMap oldHoverTicks = new Int2IntArrayMap();
    private final Int2IntArrayMap hoverTicks = new Int2IntArrayMap();
    private final List<FormattedCharSequence> cachedComponents = new ArrayList<FormattedCharSequence>();
    private final List<FormattedCharSequence> hoveredIndexItemComponents = new ArrayList<FormattedCharSequence>();
    private final IntList linesPerIndexItem = new IntArrayList();
    private int indexStartLine;

    public IndexBookComponent(Component introText, List<IndexItem> indexItems, int width, int height) {
        super(width, height);
        this.introText = introText;
        for (IndexItem indexItem : indexItems) {
            if (!indexItem.enabled()) continue;
            this.indexItems.add(indexItem);
        }
    }

    @Override
    public int getPageCount(int pagesBefore, Font font) {
        if (this.cachedComponents.isEmpty()) {
            this.cachedComponents.addAll(font.split((FormattedText)this.introText, this.width));
            this.indexStartLine = this.cachedComponents.size();
            for (IndexItem indexItem : this.indexItems) {
                this.cachedComponents.addAll(font.split((FormattedText)indexItem.text().copy().withColor(4668747), this.width));
                List list = font.split((FormattedText)indexItem.text().copy().withColor(2497545).withStyle(ChatFormatting.ITALIC), this.width);
                this.hoveredIndexItemComponents.addAll(list);
                this.linesPerIndexItem.add(list.size());
            }
        }
        Objects.requireNonNull(font);
        int linesPerPage = this.height / 9;
        return this.cachedComponents.size() % linesPerPage == 0 ? this.cachedComponents.size() / linesPerPage : this.cachedComponents.size() / linesPerPage + 1;
    }

    private int getIndexItemFromRelativeLine(int line) {
        int lines = 0;
        for (int i = 0; i < this.indexItems.size(); ++i) {
            if ((lines += this.linesPerIndexItem.getInt(i)) <= line) continue;
            return i;
        }
        return -1;
    }

    private boolean isHovered(int index) {
        return this.leftHovers.getOrDefault(index, false) || this.rightHovers.getOrDefault(index, false);
    }

    @Override
    public void render(BookAccess access, GuiGraphics graphics, Font font, int x, int y, int mouseX, int mouseY) {
        Objects.requireNonNull(font);
        int linesPerPage = this.height / 9;
        for (int i = access.getRelativePage() * linesPerPage; i < Math.min((access.getRelativePage() + 1) * linesPerPage, this.cachedComponents.size()); ++i) {
            int n = i - access.getRelativePage() * linesPerPage;
            Objects.requireNonNull(font);
            int textY = n * 9;
            FormattedCharSequence toDraw = this.cachedComponents.get(i);
            if (i >= this.indexStartLine) {
                int currentIndexItem = this.getIndexItemFromRelativeLine(i - this.indexStartLine);
                int oldHover = this.oldHoverTicks.getOrDefault(currentIndexItem, 0);
                int hover = this.hoverTicks.getOrDefault(currentIndexItem, 0);
                float hoverTicks = Math.min(Mth.lerp((float)Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally()), (float)oldHover, (float)hover), 20.0f);
                int color = Color.argbi(0, 1, 1, 1).blend(Color.argb(0x66000000), hoverTicks / 20.0f).argb();
                Objects.requireNonNull(font);
                graphics.fillGradient(x, y + textY, x + this.width, y + textY + 9, color, color);
                if (this.isHovered(this.getIndexItemFromRelativeLine(i - this.indexStartLine))) {
                    toDraw = this.hoveredIndexItemComponents.get(i - this.indexStartLine);
                }
            }
            graphics.drawString(font, toDraw, x, y + textY, 0, false);
        }
    }

    @Override
    public void tick(BookAccess access, Font font, int x, int y, int mouseX, int mouseY) {
        Objects.requireNonNull(font);
        int linesPerPage = this.height / 9;
        int relativeY = mouseY - y;
        int n = access.getRelativePage() * linesPerPage;
        Objects.requireNonNull(font);
        int line = n + Math.min(relativeY / 9, linesPerPage - 1);
        int hovered = this.getIndexItemFromRelativeLine(line - this.indexStartLine);
        Int2BooleanArrayMap hovers = access.isLeftPage() ? this.leftHovers : this.rightHovers;
        for (Int2BooleanMap.Entry entry : hovers.int2BooleanEntrySet()) {
            hovers.put(entry.getIntKey(), false);
        }
        if (line >= this.indexStartLine && hovered != -1 && mouseX > x && mouseX < x + this.width && mouseY > y && mouseY < y + this.height) {
            hovers.put(hovered, true);
        }
    }

    @Override
    public void singleTick(BookAccess access, Font font, int x, int y, int mouseX, int mouseY) {
        this.oldHoverTicks.putAll((Map)this.hoverTicks);
        for (int i = 0; i < this.indexItems.size(); ++i) {
            int value = this.hoverTicks.getOrDefault(i, 0);
            if (!this.isHovered(i)) {
                this.hoverTicks.put(i, Math.max(value - 1, 0));
                continue;
            }
            if (value >= 20) continue;
            this.hoverTicks.put(i, value + 1);
        }
    }

    @Override
    public void onClick(BookAccess access, Font font, int x, int y, int mouseX, int mouseY) {
        Objects.requireNonNull(font);
        int linesPerPage = this.height / 9;
        int relativeY = mouseY - y;
        int n = access.getRelativePage() * linesPerPage;
        Objects.requireNonNull(font);
        int line = n + Math.min(relativeY / 9, linesPerPage - 1);
        int selected = this.getIndexItemFromRelativeLine(line - this.indexStartLine);
        if (line >= this.indexStartLine && selected != -1 && mouseX > x && mouseX < x + this.width && mouseY > y && mouseY < y + this.height) {
            ResourceLocation jumpTo = this.indexItems.get(selected).jumpTo();
            for (int i = 0; i < access.getComponents().size(); ++i) {
                BookComponentDefinition definition = access.getComponents().get(i);
                if (!definition.id().equals((Object)jumpTo)) continue;
                int pages = 0;
                for (int j = 0; j < i; ++j) {
                    pages += access.getComponents().get(j).component().getPageCount(pages, font);
                }
                access.setPage(pages);
                break;
            }
        }
    }

    public record IndexItem(Component text, ResourceLocation jumpTo, boolean enabled) {
        public IndexItem(Component text, ResourceLocation jumpTo) {
            this(text, jumpTo, true);
        }
    }
}

