/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity.spawner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BossSpawnerBlockEntity<T extends Mob>
extends BlockEntity {
    protected final EntityType<T> entityType;
    protected boolean spawnedBoss = false;

    protected BossSpawnerBlockEntity(BlockEntityType<?> type, EntityType<T> entityType, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.entityType = entityType;
    }

    public boolean anyPlayerInRange() {
        return this.getLevel().hasNearbyAlivePlayer((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, (double)this.getRange());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BossSpawnerBlockEntity<?> entity) {
        if (entity.spawnedBoss || !entity.anyPlayerInRange()) {
            return;
        }
        if (level.isClientSide) {
            double rx = (float)pos.getX() - 0.2f + level.getRandom().nextFloat() * 1.25f;
            double ry = (float)pos.getY() - 0.2f + level.getRandom().nextFloat() * 1.25f;
            double rz = (float)pos.getZ() - 0.2f + level.getRandom().nextFloat() * 1.25f;
            level.addParticle(entity.getSpawnerParticle(), rx, ry, rz, 0.0, 0.0, 0.0);
        } else if (level.getDifficulty() != Difficulty.PEACEFUL && entity.spawnBoss((ServerLevelAccessor)level)) {
            level.destroyBlock(pos, false);
            entity.spawnedBoss = true;
        }
    }

    protected boolean spawnBoss(ServerLevelAccessor accessor) {
        T mob = this.makeMob();
        mob.moveTo(this.getBlockPos(), accessor.getLevel().getRandom().nextFloat() * 360.0f, 0.0f);
        mob.finalizeSpawn(accessor, accessor.getCurrentDifficultyAt(this.getBlockPos()), MobSpawnType.SPAWNER, null);
        this.initializeCreature(mob);
        return accessor.addFreshEntity(mob);
    }

    public abstract ParticleOptions getSpawnerParticle();

    protected void initializeCreature(T mob) {
        mob.restrictTo(this.getBlockPos(), 50);
        mob.setPersistenceRequired();
    }

    protected int getRange() {
        return 50;
    }

    protected T makeMob() {
        return (T)((Mob)this.entityType.create(this.getLevel()));
    }
}

