/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.TorreyaVinesPlantBlock;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TorreyaVinesBlock
extends GrowingPlantHeadBlock {
    public static final MapCodec<TorreyaVinesBlock> CODEC = TorreyaVinesBlock.simpleCodec(TorreyaVinesBlock::new);
    public static final VoxelShape SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public TorreyaVinesBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.DOWN, SHAPE, false, 0.1);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends GrowingPlantHeadBlock> codec() {
        return CODEC;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource randomSource) {
        return 1;
    }

    protected boolean canGrowInto(BlockState state) {
        return state.isAir();
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockPos blockPos2 = blockPos.relative(this.growthDirection.getOpposite());
        BlockState blockState2 = levelReader.getBlockState(blockPos2);
        if (!this.canAttachTo(blockState2)) {
            return false;
        }
        return blockState2.is((Block)this.getHeadBlock()) || blockState2.is(this.getBodyBlock()) || blockState2.is(BlockTags.LEAVES) || blockState2.isFaceSturdy((BlockGetter)levelReader, blockPos2, this.growthDirection);
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        BlockState state = levelAccessor.getBlockState(blockPos.above());
        if (state.is((Block)ESBlocks.TORREYA_VINES_PLANT.get()) && !levelAccessor.getBlockState(blockPos.above(2)).is((Block)ESBlocks.TORREYA_VINES_PLANT.get()) && !((Boolean)state.getValue((Property)TorreyaVinesPlantBlock.TOP)).booleanValue()) {
            state = (BlockState)state.setValue((Property)TorreyaVinesPlantBlock.TOP, (Comparable)Boolean.valueOf(true));
            levelAccessor.setBlock(blockPos.above(), state, 2);
        }
        return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    protected Block getBodyBlock() {
        return (Block)ESBlocks.TORREYA_VINES_PLANT.get();
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ESItems.TORREYA_VINES.get());
    }
}

