/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class IcicleBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<IcicleBlock> CODEC = IcicleBlock.simpleCodec(IcicleBlock::new);
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<IcicleThickness> THICKNESS = EnumProperty.create((String)"icicle_thickness", IcicleThickness.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape TIP_SHAPE_UP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public IcicleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TIP_DIRECTION, (Comparable)Direction.UP)).setValue(THICKNESS, (Comparable)((Object)IcicleThickness.TIP))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<IcicleBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getSuitableState((BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)context.getNearestLookingVerticalDirection().getOpposite()), (LevelAccessor)context.getLevel(), context.getClickedPos(), false);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockState newState;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        BlockState blockState = newState = direction.getAxis() == Direction.Axis.Y ? this.getSuitableState(state, level, pos, true) : state;
        if (newState.isAir() && state.getValue((Property)TIP_DIRECTION) == Direction.DOWN) {
            level.scheduleTick(pos, (Block)this, 2);
            newState = state;
        }
        return newState;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.getSuitableState(state, (LevelAccessor)level, pos, false).isAir()) {
            this.spawnFallingStalactite(state, (Level)level, pos);
        }
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hitResult, Projectile projectile) {
        BlockPos pos;
        if (!level.isClientSide && projectile.mayInteract(level, pos = hitResult.getBlockPos()) && projectile.mayBreak(level) && projectile.getDeltaMovement().length() > 0.6) {
            level.destroyBlock(pos, true);
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP && state.getValue(THICKNESS) == IcicleThickness.TIP) {
            entity.causeFallDamage(fallDistance + 2.0f, 2.0f, level.damageSources().stalagmite());
        } else {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    private BlockState getSuitableState(BlockState state, LevelAccessor level, BlockPos pos, boolean updateOthers) {
        Direction tipDir = (Direction)state.getValue((Property)TIP_DIRECTION);
        BlockPos tipPos = this.findTip(state, (LevelReader)level, pos);
        if (tipPos == null) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockPos basePos = this.findBase(state, (LevelReader)level, pos);
        if (basePos == null) {
            return Blocks.AIR.defaultBlockState();
        }
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        switch (tipPos.distManhattan((Vec3i)basePos)) {
            case 0: {
                return (BlockState)state.setValue(THICKNESS, (Comparable)((Object)IcicleThickness.TIP));
            }
            case 1: {
                if (updateOthers) {
                    if (pos.equals((Object)tipPos)) {
                        BlockState original = level.getBlockState(basePos);
                        if (original.is((Block)this) && original.getValue(THICKNESS) != IcicleThickness.TOP) {
                            level.setBlock(basePos, (BlockState)original.setValue(THICKNESS, (Comparable)((Object)IcicleThickness.TOP)), 3);
                        }
                    } else {
                        BlockState original = level.getBlockState(tipPos);
                        if (original.is((Block)this) && original.getValue(THICKNESS) != IcicleThickness.TIP) {
                            level.setBlock(tipPos, (BlockState)original.setValue(THICKNESS, (Comparable)((Object)IcicleThickness.TIP)), 3);
                        }
                    }
                }
                return (BlockState)state.setValue(THICKNESS, (Comparable)((Object)(pos.equals((Object)tipPos) ? IcicleThickness.TIP : IcicleThickness.TOP)));
            }
            case 2: {
                BlockPos topPos = basePos.relative(tipDir, 1);
                IcicleThickness thickness = pos.equals((Object)tipPos) ? IcicleThickness.TIP : (pos.equals((Object)topPos) ? IcicleThickness.TOP : IcicleThickness.BASE);
                if (updateOthers) {
                    for (int i = 0; i < 3; ++i) {
                        BlockState original;
                        IcicleThickness partThickness;
                        BlockPos partPos = basePos.relative(tipDir, i);
                        switch (i) {
                            case 0: {
                                IcicleThickness icicleThickness = IcicleThickness.BASE;
                                break;
                            }
                            case 1: {
                                IcicleThickness icicleThickness = IcicleThickness.TOP;
                                break;
                            }
                            default: {
                                IcicleThickness icicleThickness = partThickness = IcicleThickness.TIP;
                            }
                        }
                        if (pos.equals((Object)partPos) || !(original = level.getBlockState(partPos)).is((Block)this) || original.getValue(THICKNESS) == partThickness) continue;
                        level.setBlock(partPos, (BlockState)original.setValue(THICKNESS, (Comparable)((Object)partThickness)), 3);
                    }
                }
                return (BlockState)state.setValue(THICKNESS, (Comparable)((Object)thickness));
            }
            case 3: {
                BlockPos topPos = basePos.relative(tipDir, 2);
                BlockPos middlePos = basePos.relative(tipDir, 1);
                IcicleThickness thickness = pos.equals((Object)tipPos) ? IcicleThickness.TIP : (pos.equals((Object)topPos) ? IcicleThickness.TOP : (pos.equals((Object)middlePos) ? IcicleThickness.MIDDLE : IcicleThickness.BASE));
                if (updateOthers) {
                    for (int i = 0; i < 4; ++i) {
                        BlockState original;
                        IcicleThickness partThickness;
                        BlockPos partPos = basePos.relative(tipDir, i);
                        switch (i) {
                            case 0: {
                                IcicleThickness icicleThickness = IcicleThickness.BASE;
                                break;
                            }
                            case 1: {
                                IcicleThickness icicleThickness = IcicleThickness.MIDDLE;
                                break;
                            }
                            case 2: {
                                IcicleThickness icicleThickness = IcicleThickness.TOP;
                                break;
                            }
                            default: {
                                IcicleThickness icicleThickness = partThickness = IcicleThickness.TIP;
                            }
                        }
                        if (pos.equals((Object)partPos) || !(original = level.getBlockState(partPos)).is((Block)this) || original.getValue(THICKNESS) == partThickness) continue;
                        level.setBlock(partPos, (BlockState)original.setValue(THICKNESS, (Comparable)((Object)partThickness)), 3);
                    }
                }
                return (BlockState)state.setValue(THICKNESS, (Comparable)((Object)thickness));
            }
        }
        return state;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction tipDir = (Direction)state.getValue((Property)TIP_DIRECTION);
        BlockPos tipPos = this.findTip(state, level, pos);
        if (tipPos == null) {
            return false;
        }
        BlockPos basePos = this.findBase(state, level, pos);
        if (basePos == null) {
            return false;
        }
        BlockState support = level.getBlockState(pos.relative(tipDir.getOpposite()));
        return support.isFaceSturdy((BlockGetter)level, pos.relative(tipDir.getOpposite()), tipDir) || support.is((Block)this) && (!support.hasProperty((Property)TIP_DIRECTION) || support.getValue((Property)TIP_DIRECTION) == state.getValue((Property)TIP_DIRECTION));
    }

    private BlockPos findTip(BlockState state, LevelReader level, BlockPos pos) {
        Direction tipDir = (Direction)state.getValue((Property)TIP_DIRECTION);
        BlockPos tipPos = null;
        for (int i = 0; i < 4 && (i == 0 || level.getBlockState(pos.relative(tipDir, i)).is((Block)this)); ++i) {
            if (i == 0) {
                if (level.getBlockState(pos.relative(tipDir, i + 1)).is((Block)this) && (!level.getBlockState(pos.relative(tipDir, i + 1)).hasProperty((Property)TIP_DIRECTION) || level.getBlockState(pos.relative(tipDir, i + 1)).getValue((Property)TIP_DIRECTION) == tipDir)) continue;
                tipPos = pos.relative(tipDir, i);
                continue;
            }
            if (!level.getBlockState(pos.relative(tipDir, i)).is((Block)this) || level.getBlockState(pos.relative(tipDir, i)).getValue((Property)TIP_DIRECTION) != tipDir || level.getBlockState(pos.relative(tipDir, i + 1)).is((Block)this) && (!level.getBlockState(pos.relative(tipDir, i + 1)).hasProperty((Property)TIP_DIRECTION) || level.getBlockState(pos.relative(tipDir, i + 1)).getValue((Property)TIP_DIRECTION) == level.getBlockState(pos.relative(tipDir, i)).getValue((Property)TIP_DIRECTION))) continue;
            tipPos = pos.relative(tipDir, i);
        }
        return tipPos;
    }

    private BlockPos findBase(BlockState state, LevelReader level, BlockPos pos) {
        Direction tipDir = (Direction)state.getValue((Property)TIP_DIRECTION);
        BlockPos basePos = null;
        for (int i = 0; i < 4 && (i == 0 || level.getBlockState(pos.relative(tipDir.getOpposite(), i)).is((Block)this)); ++i) {
            if (i == 0) {
                if (level.getBlockState(pos.relative(tipDir.getOpposite(), i + 1)).is((Block)this) && (!level.getBlockState(pos.relative(tipDir.getOpposite(), i + 1)).hasProperty((Property)TIP_DIRECTION) || level.getBlockState(pos.relative(tipDir.getOpposite(), i + 1)).getValue((Property)TIP_DIRECTION) == tipDir)) continue;
                basePos = pos.relative(tipDir.getOpposite(), i);
                continue;
            }
            if (!level.getBlockState(pos.relative(tipDir.getOpposite(), i)).is((Block)this) || level.getBlockState(pos.relative(tipDir.getOpposite(), i)).getValue((Property)TIP_DIRECTION) != tipDir || level.getBlockState(pos.relative(tipDir.getOpposite(), i + 1)).is((Block)this) && (!level.getBlockState(pos.relative(tipDir.getOpposite(), i + 1)).hasProperty((Property)TIP_DIRECTION) || level.getBlockState(pos.relative(tipDir.getOpposite(), i + 1)).getValue((Property)TIP_DIRECTION) == level.getBlockState(pos.relative(tipDir.getOpposite(), i)).getValue((Property)TIP_DIRECTION))) continue;
            basePos = pos.relative(tipDir.getOpposite(), i);
        }
        return basePos;
    }

    private void spawnFallingStalactite(BlockState state, Level level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        BlockState blockState = state;
        while (blockState.is((Block)this) && blockState.getValue((Property)TIP_DIRECTION) == Direction.DOWN) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)level, (BlockPos)mutable, (BlockState)blockState);
            if (blockState.getValue(THICKNESS) == IcicleThickness.TIP) {
                fallingblockentity.setHurtsEntities(5.0f, 40);
                break;
            }
            level.destroyBlock((BlockPos)mutable, false);
            mutable.move(Direction.DOWN);
            blockState = level.getBlockState((BlockPos)mutable);
        }
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return blockState.getValue(THICKNESS) == IcicleThickness.TIP ? (blockState.getValue((Property)TIP_DIRECTION) == Direction.UP ? TIP_SHAPE_UP : TIP_SHAPE_DOWN) : SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public static enum IcicleThickness implements StringRepresentable
    {
        TIP("tip"),
        TOP("top"),
        MIDDLE("middle"),
        BASE("base");

        private final String name;

        private IcicleThickness(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

