/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.entity.ESPortalBlockEntity;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.world.ESTeleporter;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ESPortalBlock
extends BaseEntityBlock
implements Portal {
    public static final MapCodec<ESPortalBlock> CODEC = ESPortalBlock.simpleCodec(ESPortalBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final BooleanProperty CENTER = BooleanProperty.create((String)"center");
    public static final IntegerProperty SIZE = IntegerProperty.create((String)"size", (int)0, (int)20);
    protected static final VoxelShape X_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public ESPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)CENTER, (Comparable)Boolean.valueOf(false))).setValue((Property)SIZE, (Comparable)Integer.valueOf(2)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ESPortalBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return ESPortalBlock.createTickerHelper(blockEntityType, ESBlockEntities.STARLIGHT_PORTAL.get(), ESPortalBlockEntity::tick);
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return ESConfig.INSTANCE.enablePortalShader ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.getValue(AXIS)) {
            case Direction.Axis.Z -> Z_AABB;
            default -> X_AABB;
        };
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        Direction rightDir;
        Direction leftDir;
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        if (axis == Direction.Axis.X) {
            leftDir = Direction.EAST;
            rightDir = Direction.WEST;
        } else {
            leftDir = Direction.NORTH;
            rightDir = Direction.SOUTH;
        }
        List<Direction> directions = List.of(leftDir, rightDir, Direction.UP, Direction.DOWN);
        for (Direction direction : directions) {
            if (level.getBlockState(currentPos.relative(direction)).is(ESTags.Blocks.PORTAL_FRAME_BLOCKS) || level.getBlockState(currentPos.relative(direction)).is((Block)this) && level.getBlockState(currentPos.relative(direction)).getValue(AXIS) == axis) continue;
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.canUsePortal(true) && !level.isClientSide) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return ItemStack.EMPTY;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Z: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, CENTER, SIZE});
    }

    public static boolean validateAndPlacePortal(LevelAccessor level, BlockPos framePos) {
        Validator validator = new Validator(level, framePos, Direction.Axis.X);
        if (!validator.isValid()) {
            validator = new Validator(level, framePos, Direction.Axis.Z);
            if (validator.isValid()) {
                validator.fillPortal();
                return true;
            }
        } else {
            validator.fillPortal();
            return true;
        }
        return false;
    }

    public static boolean placePortal(LevelAccessor level, BlockPos bottomPos, Direction.Axis axis, int size) {
        Direction rightDir;
        Direction leftDir;
        ArrayList<BlockPos> framePositions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> hollowPositions = new ArrayList<BlockPos>();
        if (axis == Direction.Axis.X) {
            leftDir = Direction.EAST;
            rightDir = Direction.WEST;
        } else {
            leftDir = Direction.NORTH;
            rightDir = Direction.SOUTH;
        }
        for (int height = -size; height <= size; ++height) {
            int hollowWidth = size - Math.abs(height);
            framePositions.add(new BlockPos(0, height + size, 0).relative(leftDir, hollowWidth));
            framePositions.add(new BlockPos(0, height + size, 0).relative(rightDir, hollowWidth));
            if (hollowWidth < 1) continue;
            for (int i = 0; i < hollowWidth; ++i) {
                hollowPositions.add(new BlockPos(0, height + size, 0).relative(leftDir, i));
                hollowPositions.add(new BlockPos(0, height + size, 0).relative(rightDir, i));
            }
        }
        WorldBorder border = level.getWorldBorder();
        BlockPos center = bottomPos.above(size);
        for (BlockPos blockPos : framePositions) {
            if (level.isEmptyBlock(blockPos.offset((Vec3i)bottomPos)) && border.isWithinBounds(blockPos.offset((Vec3i)bottomPos))) continue;
            return false;
        }
        for (BlockPos blockPos : hollowPositions) {
            if (level.isEmptyBlock(blockPos.offset((Vec3i)bottomPos)) && border.isWithinBounds(blockPos.offset((Vec3i)bottomPos))) continue;
            return false;
        }
        for (BlockPos blockPos : framePositions) {
            level.setBlock(blockPos.offset((Vec3i)bottomPos), ESBlocks.CHISELED_VOIDSTONE.get().defaultBlockState(), 3);
        }
        for (BlockPos blockPos : hollowPositions) {
            level.setBlock(blockPos.offset((Vec3i)bottomPos), ESBlocks.CHISELED_VOIDSTONE.get().defaultBlockState(), 3);
        }
        for (BlockPos blockPos : hollowPositions) {
            level.setBlock(blockPos.offset((Vec3i)bottomPos), (BlockState)((BlockState)((BlockState)ESBlocks.STARLIGHT_PORTAL.get().defaultBlockState().setValue(AXIS, (Comparable)axis)).setValue((Property)CENTER, (Comparable)Boolean.valueOf(blockPos.offset((Vec3i)bottomPos).equals((Object)center)))).setValue((Property)SIZE, (Comparable)Integer.valueOf(size)), 3);
        }
        return true;
    }

    @Nullable
    public DimensionTransition getPortalDestination(ServerLevel serverLevel, Entity entity, BlockPos blockPos) {
        ServerLevel destinationLevel;
        ResourceKey<Level> destination;
        Level entityLevel = entity.level();
        MinecraftServer server = entityLevel.getServer();
        ResourceKey<Level> resourceKey = destination = entity.level().dimension() == ESDimensions.STARLIGHT_KEY ? Level.OVERWORLD : ESDimensions.STARLIGHT_KEY;
        if (server != null && (destinationLevel = server.getLevel(destination)) != null && ESPlatform.INSTANCE.postTravelToDimensionEvent(entity, destination)) {
            return ESTeleporter.getPortalInfo(entity, blockPos, destinationLevel);
        }
        return null;
    }

    public static class Validator {
        private static final int MAX_SIZE = 10;
        private static final int MIN_SIZE = 2;
        private final LevelAccessor level;
        private final Direction.Axis axis;
        private final List<BlockPos> frames = new ArrayList<BlockPos>();
        private final List<BlockPos> hollows = new ArrayList<BlockPos>();
        private final BlockPos center;
        private final int portalSize;

        public Validator(LevelAccessor level, BlockPos framePos, Direction.Axis axis) {
            Direction rightDir;
            Direction leftDir;
            this.level = level;
            this.axis = axis;
            if (axis == Direction.Axis.X) {
                leftDir = Direction.EAST;
                rightDir = Direction.WEST;
            } else {
                leftDir = Direction.NORTH;
                rightDir = Direction.SOUTH;
            }
            for (int size = 2; size <= 10; ++size) {
                ArrayList<BlockPos> framePositions = new ArrayList<BlockPos>();
                ArrayList<BlockPos> hollowPositions = new ArrayList<BlockPos>();
                for (int height = -size; height <= size; ++height) {
                    int hollowWidth = size - Math.abs(height);
                    framePositions.add(new BlockPos(0, height, 0).relative(leftDir, hollowWidth));
                    framePositions.add(new BlockPos(0, height, 0).relative(rightDir, hollowWidth));
                    if (hollowWidth < 1) continue;
                    for (int i = 0; i < hollowWidth; ++i) {
                        hollowPositions.add(new BlockPos(0, height, 0).relative(leftDir, i));
                        hollowPositions.add(new BlockPos(0, height, 0).relative(rightDir, i));
                    }
                }
                for (BlockPos blockPos : framePositions) {
                    BlockPos offset = framePos.subtract((Vec3i)blockPos);
                    List<BlockPos> offsetFrames = framePositions.stream().map(pos -> pos.offset((Vec3i)offset)).toList();
                    List<BlockPos> offsetHollows = hollowPositions.stream().map(pos -> pos.offset((Vec3i)offset)).toList();
                    boolean correctFrames = this.validateBlocks(offsetFrames, pos -> !level.getBlockState(pos).is(ESTags.Blocks.PORTAL_FRAME_BLOCKS));
                    boolean correctHollows = this.validateBlocks(offsetHollows, pos -> !level.getBlockState(pos).is((Block)ESBlocks.STARLIGHT_PORTAL.get()) && !level.getBlockState(pos).isAir());
                    if (!correctFrames || !correctHollows) continue;
                    this.frames.addAll(offsetFrames);
                    this.hollows.addAll(offsetHollows);
                    this.center = offset;
                    this.portalSize = size;
                    return;
                }
            }
            this.center = BlockPos.ZERO;
            this.portalSize = 0;
        }

        private boolean validateBlocks(List<BlockPos> positions, Function<BlockPos, Boolean> function) {
            for (BlockPos offsetFrame : positions) {
                if (!function.apply(offsetFrame).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public boolean isValid() {
            return !this.frames.isEmpty() && !this.hollows.isEmpty();
        }

        public void fillPortal() {
            for (BlockPos blockPos : this.frames) {
                this.level.setBlock(blockPos, ESBlocks.CHISELED_VOIDSTONE.get().defaultBlockState(), 3);
            }
            for (BlockPos blockPos : this.hollows) {
                this.level.setBlock(blockPos, ESBlocks.CHISELED_VOIDSTONE.get().defaultBlockState(), 3);
            }
            for (BlockPos blockPos : this.hollows) {
                this.level.setBlock(blockPos, (BlockState)((BlockState)((BlockState)ESBlocks.STARLIGHT_PORTAL.get().defaultBlockState().setValue(AXIS, (Comparable)this.axis)).setValue((Property)CENTER, (Comparable)Boolean.valueOf(blockPos.equals((Object)this.center)))).setValue((Property)SIZE, (Comparable)Integer.valueOf(this.portalSize)), 3);
            }
        }
    }
}

