/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.entity.misc.CrestEntity;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrestPotBlock
extends Block {
    public static final MapCodec<? extends CrestPotBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CrestPotBlock.propertiesCodec()).apply((Applicative)instance, CrestPotBlock::new));
    private static final VoxelShape BOUNDING_BOX = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);

    public CrestPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends CrestPotBlock> codec() {
        return CODEC;
    }

    public BlockState playerWillDestroy(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        Registry registry = level.registryAccess().registryOrThrow(ESRegistries.CREST);
        registry.getRandomElementOf(ESTags.Crests.IS_IN_CREST_POT, player.getRandom()).ifPresent(holder -> {
            Optional key;
            if (holder.isBound() && (key = registry.getResourceKey((Object)((Crest)holder.value()))).isPresent()) {
                CrestEntity crest = new CrestEntity(level, blockPos.getX(), blockPos.getY(), blockPos.getZ(), (ResourceKey<Crest>)((ResourceKey)key.get()));
                level.addFreshEntity((Entity)crest);
            }
        });
        return super.playerWillDestroy(level, blockPos, blockState, player);
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return BOUNDING_BOX;
    }
}

