/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.part.PartStateEmpty;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.core.client.gui.CraftingJobGuiData;
import org.cyclops.integratedterminals.part.PartTypeTerminalCraftingJob;

public class ContainerTerminalCraftingJobsPlan
extends ContainerMultipart<PartTypeTerminalCraftingJob, PartStateEmpty<PartTypeTerminalCraftingJob>> {
    private final CraftingJobGuiData craftingJobGuiData;
    private final int craftingPlanNotifierId;
    private final int craftingPlanFlatNotifierId;
    private long lastUpdate;
    private Optional<ITerminalCraftingPlan> craftingPlan;
    private Optional<ITerminalCraftingPlanFlat> craftingPlanFlat;

    public ContainerTerminalCraftingJobsPlan(int id, Inventory playerInventory, RegistryFriendlyByteBuf packetBuffer) {
        this(id, playerInventory, PartHelpers.readPartTarget((RegistryFriendlyByteBuf)packetBuffer), Optional.empty(), (PartTypeTerminalCraftingJob)PartHelpers.readPart((FriendlyByteBuf)packetBuffer), CraftingJobGuiData.readFromPacketBuffer((FriendlyByteBuf)packetBuffer));
    }

    public ContainerTerminalCraftingJobsPlan(int id, Inventory playerInventory, PartTarget target, Optional<IPartContainer> partContainer, PartTypeTerminalCraftingJob partType, CraftingJobGuiData craftingJobGuiData) {
        super((MenuType)RegistryEntries.CONTAINER_PART_TERMINAL_CRAFTING_JOBS_PLAN.get(), id, playerInventory, (Container)new SimpleContainer(new ItemStack[0]), Optional.of(target), partContainer, (IPartType)partType);
        this.craftingJobGuiData = craftingJobGuiData;
        this.craftingPlan = Optional.empty();
        this.craftingPlanFlat = Optional.empty();
        this.craftingPlanNotifierId = this.getNextValueId();
        this.craftingPlanFlatNotifierId = this.getNextValueId();
    }

    public CraftingJobGuiData getCraftingJobGuiData() {
        return this.craftingJobGuiData;
    }

    public Optional<ITerminalCraftingPlan> getCraftingPlan() {
        return this.craftingPlan;
    }

    public Optional<ITerminalCraftingPlanFlat> getCraftingPlanFlat() {
        return this.craftingPlanFlat;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (!this.getLevel().isClientSide() && this.lastUpdate < System.currentTimeMillis()) {
            this.lastUpdate = System.currentTimeMillis() + (long)GeneralConfig.guiTerminalCraftingJobsUpdateFrequency;
            this.updateCraftingPlan();
        }
    }

    public int getCraftingPlanNotifierId() {
        return this.craftingPlanNotifierId;
    }

    public int getCraftingPlanFlatNotifierId() {
        return this.craftingPlanFlatNotifierId;
    }

    protected void updateCraftingPlan() {
        this.getTarget().ifPresent(target -> {
            INetwork network = NetworkHelpers.getNetworkChecked((PartPos)target.getCenter());
            this.craftingPlan = Optional.ofNullable(this.craftingJobGuiData.getHandler().getCraftingJob(network, this.craftingJobGuiData.getChannel(), this.craftingJobGuiData.getCraftingJob()));
            if (this.craftingPlan.isPresent()) {
                ITerminalCraftingPlan plan = this.craftingPlan.get();
                if (!ContainerTerminalCraftingJobsPlan.isPlanTooLarge(plan)) {
                    this.setValue(this.craftingPlanNotifierId, this.craftingJobGuiData.getHandler().serializeCraftingPlan((HolderLookup.Provider)this.player.level().registryAccess(), plan));
                }
                this.setValue(this.craftingPlanFlatNotifierId, this.craftingJobGuiData.getHandler().serializeCraftingPlanFlat((HolderLookup.Provider)this.player.level().registryAccess(), plan.flatten()));
            } else {
                this.setValue(this.craftingPlanNotifierId, new CompoundTag());
            }
        });
    }

    protected int getSizeInventory() {
        return 0;
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public void onUpdate(int valueId, CompoundTag value) {
        if (valueId == this.craftingPlanNotifierId) {
            try {
                this.craftingPlan = Optional.of(this.craftingJobGuiData.getHandler().deserializeCraftingPlan((HolderLookup.Provider)this.player.level().registryAccess(), value));
            }
            catch (IllegalArgumentException e) {
                this.craftingPlan = Optional.empty();
            }
        } else if (valueId == this.craftingPlanFlatNotifierId) {
            try {
                this.craftingPlanFlat = Optional.of(this.craftingJobGuiData.getHandler().deserializeCraftingPlanFlat((HolderLookup.Provider)this.player.level().registryAccess(), value));
            }
            catch (IllegalArgumentException e) {
                this.craftingPlanFlat = Optional.empty();
            }
        }
        super.onUpdate(valueId, value);
    }

    public static boolean isPlanTooLarge(ITerminalCraftingPlan craftingPlan) {
        return ContainerTerminalCraftingJobsPlan.getPlanSize(craftingPlan) > GeneralConfig.terminalStorageMaxTreePlanSize;
    }

    public static int getPlanSize(ITerminalCraftingPlan craftingPlan) {
        List deps = craftingPlan.getDependencies();
        if (deps.isEmpty()) {
            return 1;
        }
        return deps.stream().mapToInt(ContainerTerminalCraftingJobsPlan::getPlanSize).sum();
    }
}

