/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollapsedCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientArrayList;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionPrototypeMap;
import org.cyclops.cyclopscore.ingredient.collection.diff.IngredientCollectionDiff;
import org.cyclops.cyclopscore.ingredient.collection.diff.IngredientCollectionDiffHelpers;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integratedterminals.Capabilities;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalRowColumnProvider;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.api.terminalstorage.TerminalClickType;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientLoadButtonsEvent;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientSearchFieldUpdateEvent;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentCommon;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonFilterCrafting;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonScaleGui;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonSort;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;
import org.cyclops.integratedterminals.core.terminalstorage.query.IIngredientQuery;
import org.cyclops.integratedterminals.core.terminalstorage.slot.TerminalStorageSlotIngredient;
import org.cyclops.integratedterminals.core.terminalstorage.slot.TerminalStorageSlotIngredientCraftingOption;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientSlotClickPacket;

public class TerminalStorageTabIngredientComponentClient<T, M>
implements ITerminalStorageTabClient<TerminalStorageSlotIngredient<T, M>> {
    private final ResourceLocation name;
    protected final IngredientComponent<T, M> ingredientComponent;
    private final IIngredientComponentTerminalStorageHandler<T, M> ingredientComponentViewHandler;
    private final ItemStack icon;
    protected final ContainerTerminalStorageBase container;
    private final List<ITerminalButton<?, ?, ?>> buttons;
    private final Int2ObjectMap<List<InstanceWithMetadata<T>>> ingredientsViews;
    private final Int2ObjectMap<List<InstanceWithMetadata<T>>> filteredIngredientsViews;
    private final Int2ObjectMap<Collection<HandlerWrappedTerminalCraftingOption<T>>> craftingOptions;
    private final Int2LongMap maxQuantities;
    private final Int2LongMap totalQuantities;
    private final IntSet channels;
    private boolean enabled;
    private int activeSlotId;
    private int activeSlotQuantity;
    private int activeChannel;
    private int lastChangeId;

    @SubscribeEvent
    public static void onToolTip(ItemTooltipEvent event) {
        IIngredientComponentTerminalStorageHandler handler;
        Object instance;
        ContainerTerminalStorageBase container;
        ITerminalStorageTabClient<?> tab;
        if (event.getEntity() != null && event.getEntity().containerMenu instanceof ContainerTerminalStorageBase && (tab = (container = (ContainerTerminalStorageBase)event.getEntity().containerMenu).getTabsClient().get(container.getSelectedTab())) instanceof TerminalStorageTabIngredientComponentClient && !((instance = (handler = ((TerminalStorageTabIngredientComponentClient)tab).ingredientComponentViewHandler).getInstance(event.getItemStack())) instanceof ItemStack)) {
            handler.addQuantityTooltip(event.getToolTip(), instance);
        }
    }

    public TerminalStorageTabIngredientComponentClient(ContainerTerminalStorageBase container, ResourceLocation name, IngredientComponent<?, ?> ingredientComponent) {
        this.name = name;
        this.ingredientComponent = ingredientComponent;
        this.ingredientComponentViewHandler = (IIngredientComponentTerminalStorageHandler)this.ingredientComponent.getCapability(Capabilities.IngredientComponentTerminalStorageHandler.INGREDIENT).orElseThrow(() -> new IllegalStateException("Could not find an ingredient terminal storage handler"));
        this.icon = this.ingredientComponentViewHandler.getIcon();
        this.container = container;
        ArrayList buttons = Lists.newArrayList();
        this.loadButtons(buttons);
        TerminalStorageTabClientLoadButtonsEvent event = new TerminalStorageTabClientLoadButtonsEvent(container, this, buttons);
        NeoForge.EVENT_BUS.post((Event)event);
        this.buttons = event.getButtons();
        this.ingredientsViews = new Int2ObjectOpenHashMap();
        this.filteredIngredientsViews = new Int2ObjectOpenHashMap();
        this.craftingOptions = new Int2ObjectOpenHashMap();
        this.maxQuantities = new Int2LongOpenHashMap();
        this.totalQuantities = new Int2LongOpenHashMap();
        this.enabled = false;
        this.channels = new IntOpenHashSet();
        this.resetActiveSlot();
        this.lastChangeId = 0;
    }

    protected void loadButtons(List<ITerminalButton<?, ?, ?>> buttons) {
        for (IIngredientInstanceSorter<T> instanceSorter : this.ingredientComponentViewHandler.getInstanceSorters()) {
            buttons.add(new TerminalButtonSort<T>(instanceSorter, this.container.getGuiState(), this));
        }
        if (!TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandlers().isEmpty()) {
            buttons.add(new TerminalButtonFilterCrafting(this.container.getGuiState(), this));
        }
        buttons.add(new TerminalButtonScaleGui(this.container.getGuiState(), this));
    }

    public IngredientComponent<T, M> getIngredientComponent() {
        return this.ingredientComponent;
    }

    @Override
    public void onSelect(int channel) {
        this.setInstanceFilter(channel, this.container.getGuiState().getSearch(this.getTabSettingsName().toString(), channel));
        for (ITerminalButton<?, ?, ?> button : this.getButtons()) {
            button.reloadFromState();
        }
    }

    @Override
    public void onDeselect(int channel) {
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public List<Component> getTooltip() {
        return Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"gui.integratedterminals.terminal_storage.storage_name", (Object[])new Object[]{Component.translatable((String)this.ingredientComponent.getTranslationKey())})});
    }

    @Override
    public String getInstanceFilter(int channel) {
        if (this.container.getGuiState().hasSearch(this.getTabSettingsName().toString(), channel)) {
            return this.container.getGuiState().getSearch(this.getTabSettingsName().toString(), channel);
        }
        return "";
    }

    public Predicate<InstanceWithMetadata<T>> getInstanceFilterMetadata() {
        for (ITerminalButton<?, ?, ?> button : this.buttons) {
            if (!(button instanceof TerminalButtonFilterCrafting)) continue;
            return ((TerminalButtonFilterCrafting)button).getEffectiveFilter();
        }
        return Predicates.alwaysTrue();
    }

    public void resetFilteredIngredientsViews(int channel) {
        this.filteredIngredientsViews.remove(channel);
    }

    @Override
    public void setInstanceFilter(int channel, String filter) {
        TerminalStorageTabClientSearchFieldUpdateEvent event = new TerminalStorageTabClientSearchFieldUpdateEvent(this, filter);
        NeoForge.EVENT_BUS.post((Event)event);
        filter = event.getSearchString();
        this.resetFilteredIngredientsViews(channel);
        this.container.getGuiState().setSearch(this.getTabSettingsName().toString(), channel, filter.toLowerCase(Locale.ENGLISH));
    }

    public List<InstanceWithMetadata<T>> getRawUnfilteredIngredientsView(int channel) {
        List ingredientsView = (List)this.ingredientsViews.get(channel);
        if (ingredientsView == null) {
            ingredientsView = Lists.newArrayList();
            this.ingredientsViews.put(channel, (Object)ingredientsView);
        }
        return ingredientsView;
    }

    @Nullable
    public Collection<HandlerWrappedTerminalCraftingOption<T>> getCraftingOptions(int channel) {
        return (Collection)this.craftingOptions.get(channel);
    }

    public List<InstanceWithMetadata<T>> getUnfilteredIngredientsView(int channel) {
        Collection<HandlerWrappedTerminalCraftingOption<T>> craftingOptions = this.getCraftingOptions(channel);
        if (craftingOptions == null) {
            return this.getRawUnfilteredIngredientsView(channel);
        }
        ArrayList enrichedIngredients = Lists.newArrayList();
        enrichedIngredients.addAll(this.getRawUnfilteredIngredientsView(channel));
        for (HandlerWrappedTerminalCraftingOption<T> craftingOption : craftingOptions) {
            for (T output : this.getUniqueCraftingOptionOutputs(craftingOption.getCraftingOption())) {
                enrichedIngredients.add(new InstanceWithMetadata<T>(output, craftingOption));
            }
        }
        return enrichedIngredients;
    }

    protected Collection<T> getUniqueCraftingOptionOutputs(ITerminalCraftingOption<T> craftingOption) {
        TreeSet uniqueOutputs = Sets.newTreeSet((Comparator)this.ingredientComponent.getMatcher());
        Iterator<T> it = craftingOption.getOutputs();
        while (it.hasNext()) {
            uniqueOutputs.add(it.next());
        }
        return uniqueOutputs;
    }

    protected List<InstanceWithMetadata<T>> getFilteredIngredientsView(int channel) {
        ArrayList ingredientsView = (ArrayList)this.filteredIngredientsViews.get(channel);
        if (ingredientsView == null) {
            ingredientsView = this.getUnfilteredIngredientsView(channel);
            ingredientsView = Lists.newArrayList((Iterable)this.transformIngredientsView(ingredientsView.stream()).filter(im -> IIngredientQuery.parse(this.ingredientComponent, this.getInstanceFilter(channel)).test(im.getInstance())).filter(this.getInstanceFilterMetadata()).collect(Collectors.toList()));
            Comparator<T> sorter = this.getInstanceSorter();
            if (sorter != null) {
                try {
                    ingredientsView.sort(InstanceWithMetadata.createComparator(sorter));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.filteredIngredientsViews.put(channel, (Object)ingredientsView);
        }
        return ingredientsView;
    }

    protected Stream<InstanceWithMetadata<T>> transformIngredientsView(Stream<InstanceWithMetadata<T>> ingredientStream) {
        return ingredientStream;
    }

    @Override
    public List<TerminalStorageSlotIngredient<T, M>> getSlots(int channel, int offset, int limit) {
        List<InstanceWithMetadata<T>> ingredients = this.getFilteredIngredientsView(channel);
        int size = ingredients.size();
        if (offset >= size) {
            return Lists.newArrayList();
        }
        return ingredients.subList(offset, Math.min(offset + limit, size)).stream().map(instanceWithMetadata -> {
            Object instance = instanceWithMetadata.getInstance();
            HandlerWrappedTerminalCraftingOption craftingOption = instanceWithMetadata.getCraftingOption();
            if (craftingOption == null) {
                return new TerminalStorageSlotIngredient<T, M>(this.ingredientComponentViewHandler, instance);
            }
            return new TerminalStorageSlotIngredientCraftingOption<T, M>(this.ingredientComponentViewHandler, instance, craftingOption);
        }).collect(Collectors.toList());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public Optional<T> getSlotInstance(int channel, int index) {
        return this.getSlot(channel, index).map(TerminalStorageSlotIngredient::getInstance);
    }

    public Optional<TerminalStorageSlotIngredient<T, M>> getSlot(int channel, int index) {
        List<TerminalStorageSlotIngredient<T, M>> lastSlots;
        if (index >= 0 && !(lastSlots = this.getSlots(channel, index, 1)).isEmpty()) {
            return Optional.of(lastSlots.get(0));
        }
        return Optional.empty();
    }

    @Override
    public int getSlotCount(int channel) {
        return this.getFilteredIngredientsView(channel).size();
    }

    @Override
    public String getStatus(int channel) {
        return String.format(Locale.ROOT, "%,d / %,d", this.getTotalQuantity(channel), this.getMaxQuantity(channel));
    }

    public synchronized void onChange(int channel, IIngredientComponentStorageObservable.Change changeType, IngredientArrayList<T, M> ingredients, boolean enabled) {
        ++this.lastChangeId;
        boolean wasEnabled = this.enabled;
        boolean bl = this.enabled = enabled || this.craftingOptions.containsKey(channel);
        if (channel != -1) {
            this.channels.add(channel);
        }
        Optional<T> lastInstance = this.getSlotInstance(channel, this.activeSlotId);
        if (channel != -1) {
            this.onChange(-1, changeType, ingredients, enabled);
        }
        long quantity = 0L;
        IIngredientMatcher matcher = ingredients.getComponent().getMatcher();
        for (Object ingredient : ingredients) {
            quantity += matcher.getQuantity(ingredient);
        }
        if (changeType != IIngredientComponentStorageObservable.Change.ADDITION) {
            quantity = -quantity;
        }
        long newQuantity = this.totalQuantities.get(channel) + quantity;
        this.totalQuantities.put(channel, newQuantity);
        List<InstanceWithMetadata<T>> rawPersistedIngredients = this.getRawUnfilteredIngredientsView(channel);
        IngredientCollectionPrototypeMap persistedIngredients = new IngredientCollectionPrototypeMap(this.ingredientComponent);
        rawPersistedIngredients.stream().map(InstanceWithMetadata::getInstance).forEach(arg_0 -> ((IIngredientCollapsedCollectionMutable)persistedIngredients).add(arg_0));
        IngredientCollectionDiff diff = new IngredientCollectionDiff(changeType == IIngredientComponentStorageObservable.Change.ADDITION ? ingredients : null, changeType == IIngredientComponentStorageObservable.Change.DELETION ? ingredients : null, false);
        IngredientCollectionDiffHelpers.applyDiff(this.ingredientComponent, (IngredientCollectionDiff)diff, (IIngredientCollectionMutable)persistedIngredients);
        rawPersistedIngredients.clear();
        for (Object persistedIngredient : persistedIngredients) {
            rawPersistedIngredients.add(new InstanceWithMetadata(persistedIngredient, null));
        }
        this.resetFilteredIngredientsViews(channel);
        this.updateActiveInstance(lastInstance, channel);
        if (!wasEnabled && enabled) {
            this.container.screen.init();
        }
    }

    protected void updateActiveInstance(Optional<T> lastInstance, int channel) {
        if (lastInstance.isPresent() && this.activeChannel == channel) {
            this.activeSlotId = this.findActiveSlotId(channel, lastInstance.get());
            Optional<Object> slotIngredient = this.getSlotInstance(channel, this.activeSlotId);
            this.activeSlotQuantity = slotIngredient.map(t -> Math.min(this.activeSlotQuantity, Helpers.castSafe((long)this.ingredientComponent.getMatcher().getQuantity(t)))).orElse(0);
        }
    }

    public synchronized void addCraftingOptions(int channel, List<HandlerWrappedTerminalCraftingOption<T>> craftingOptions, boolean reset, boolean firstChannel) {
        Collection existingOptions;
        Optional<T> lastInstance = this.getSlotInstance(channel, this.activeSlotId);
        if (channel != -1) {
            this.addCraftingOptions(-1, craftingOptions, reset && firstChannel, firstChannel);
        }
        boolean wasEnabled = this.enabled;
        this.enabled = true;
        if (channel != -1) {
            this.channels.add(channel);
        }
        if ((existingOptions = (Collection)this.craftingOptions.get(channel)) == null || reset) {
            this.craftingOptions.put(channel, (Object)Lists.newArrayList(craftingOptions));
        } else {
            existingOptions.addAll(craftingOptions);
        }
        this.resetFilteredIngredientsViews(channel);
        this.updateActiveInstance(lastInstance, channel);
        if (!wasEnabled && this.enabled) {
            this.container.screen.init();
        }
    }

    protected int findActiveSlotId(int channel, T instance) {
        IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
        int newActiveSlot = 0;
        Object matchCondition = matcher.getExactMatchNoQuantityCondition();
        List<TerminalStorageSlotIngredient<T, M>> slots = this.getSlots(channel, 0, Integer.MAX_VALUE);
        for (TerminalStorageSlotIngredient<T, M> slot : slots) {
            T ingredient = slot.getInstance();
            if (matcher.matches(ingredient, instance, matchCondition)) {
                return newActiveSlot;
            }
            ++newActiveSlot;
        }
        return -1;
    }

    public synchronized void handleActiveIngredientUpdate(int channel, T activeInstance) {
        IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
        this.activeChannel = channel;
        if (!matcher.isEmpty(activeInstance)) {
            this.activeSlotId = this.findActiveSlotId(channel, activeInstance);
            Optional<Object> slotIngredient = this.getSlotInstance(channel, this.activeSlotId);
            this.activeSlotQuantity += slotIngredient.map(t -> Helpers.castSafe((long)matcher.getQuantity(activeInstance))).orElse(0).intValue();
        }
    }

    public long getMaxQuantity(int channel) {
        if (channel == -1) {
            return Arrays.stream(this.getChannels()).mapToLong(this::getMaxQuantity).sum();
        }
        return this.maxQuantities.get(channel);
    }

    public void setMaxQuantity(int channel, long maxQuantity) {
        this.maxQuantities.put(channel, maxQuantity);
    }

    public long getTotalQuantity(int channel) {
        return this.totalQuantities.get(channel);
    }

    @Override
    public int[] getChannels() {
        int[] channels = this.channels.toIntArray();
        Arrays.sort(channels);
        return channels;
    }

    @Override
    public void resetActiveSlot() {
        this.activeSlotId = -1;
        this.activeSlotQuantity = 0;
        this.activeChannel = -2;
    }

    @Override
    public boolean handleClick(AbstractContainerMenu container, int channel, int hoveringStorageSlot, int mouseButton, boolean hasClickedOutside, boolean hasClickedInStorage, int hoveredContainerSlot, boolean isQuickMove) {
        this.activeChannel = channel;
        IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
        Optional<TerminalStorageSlotIngredient<TerminalStorageSlotIngredient, M>> hoveringStorageSlotObject = this.getSlot(channel, hoveringStorageSlot);
        Optional<Object> hoveringStorageInstance = hoveringStorageSlotObject.map(TerminalStorageSlotIngredient::getInstance);
        boolean validHoveringStorageSlot = hoveringStorageInstance.isPresent();
        boolean isCraftingOption = hoveringStorageSlotObject.isPresent() && hoveringStorageSlotObject.get() instanceof TerminalStorageSlotIngredientCraftingOption;
        IIngredientComponentTerminalStorageHandler<T, M> viewHandler = this.getViewHandler();
        boolean shift = MinecraftHelpers.isShifted();
        boolean transferFullSelection = true;
        LocalPlayer player = Minecraft.getInstance().player;
        boolean initiateCraftingOption = false;
        if (mouseButton == 0 || mouseButton == 1 || mouseButton == 2) {
            TerminalClickType clickType = null;
            long moveQuantity = this.activeSlotQuantity;
            long movePlayerQuantity = 0L;
            boolean reset = false;
            if (validHoveringStorageSlot && container.getCarried().isEmpty() && this.activeSlotId < 0) {
                if (isCraftingOption) {
                    initiateCraftingOption = true;
                } else if (shift) {
                    clickType = mouseButton == 2 ? TerminalClickType.STORAGE_QUICK_MOVE_INCREMENTAL : TerminalClickType.STORAGE_QUICK_MOVE;
                } else {
                    this.activeSlotId = hoveringStorageSlot;
                    this.activeSlotQuantity = Math.min((int)this.ingredientComponent.getMatcher().getQuantity(hoveringStorageInstance.orElse(matcher.getEmptyInstance())), viewHandler.getInitialInstanceMovementQuantity());
                    if (mouseButton == 1) {
                        this.activeSlotQuantity = (int)Math.ceil((double)this.activeSlotQuantity / 2.0);
                    } else if (mouseButton == 2) {
                        this.activeSlotQuantity = 1;
                    }
                }
            } else if (hoveredContainerSlot >= 0 && !container.getSlot(hoveredContainerSlot).getItem().isEmpty() && isQuickMove) {
                clickType = mouseButton == 2 ? TerminalClickType.PLAYER_QUICK_MOVE_INCREMENTAL : TerminalClickType.PLAYER_QUICK_MOVE;
            } else if (hasClickedInStorage && !container.getCarried().isEmpty()) {
                clickType = TerminalClickType.PLAYER_PLACE_STORAGE;
                movePlayerQuantity = mouseButton == 0 ? viewHandler.getActivePlayerStackQuantity(player.getInventory(), container) : (mouseButton == 1 ? (long)viewHandler.getIncrementalInstanceMovementQuantity() : (long)((int)Math.ceil((double)viewHandler.getActivePlayerStackQuantity(player.getInventory(), container) / 2.0)));
                viewHandler.drainActivePlayerStackQuantity(player.getInventory(), container, movePlayerQuantity);
                this.resetActiveSlot();
            } else if (this.activeSlotId >= 0) {
                if (hasClickedOutside) {
                    clickType = TerminalClickType.STORAGE_PLACE_WORLD;
                    reset = true;
                } else if (hoveredContainerSlot >= 0) {
                    clickType = TerminalClickType.STORAGE_PLACE_PLAYER;
                    if (mouseButton == 0) {
                        reset = true;
                        moveQuantity = this.activeSlotQuantity;
                    } else if (mouseButton == 1) {
                        transferFullSelection = false;
                        moveQuantity = viewHandler.getIncrementalInstanceMovementQuantity();
                    } else {
                        transferFullSelection = false;
                        moveQuantity = (int)Math.ceil((double)this.activeSlotQuantity / 2.0);
                    }
                    this.activeSlotQuantity = (int)((long)this.activeSlotQuantity - moveQuantity);
                } else if (hasClickedInStorage) {
                    if ((mouseButton == 0 || mouseButton == 2) && this.activeSlotId == hoveringStorageSlot) {
                        this.activeSlotQuantity = (int)Math.min(this.ingredientComponent.getMatcher().getQuantity(hoveringStorageInstance.get()), (long)(this.activeSlotQuantity + (shift ? viewHandler.getInitialInstanceMovementQuantity() : viewHandler.getIncrementalInstanceMovementQuantity())));
                    } else if (mouseButton == 1) {
                        this.activeSlotQuantity = Math.max(0, this.activeSlotQuantity - (shift ? viewHandler.getInitialInstanceMovementQuantity() : viewHandler.getIncrementalInstanceMovementQuantity()));
                        if (this.activeSlotQuantity == 0) {
                            this.activeSlotId = -1;
                        }
                    } else {
                        this.resetActiveSlot();
                    }
                } else {
                    this.resetActiveSlot();
                }
                if (moveQuantity == 0L) {
                    this.activeSlotId = -1;
                }
            }
            if (initiateCraftingOption) {
                ContainerTerminalStorageBase containerTerminalStorage = (ContainerTerminalStorageBase)container;
                CraftingOptionGuiData craftingOptionData = new CraftingOptionGuiData(this.ingredientComponent, this.getName().toString(), channel, ((TerminalStorageSlotIngredientCraftingOption)hoveringStorageSlotObject.get()).getCraftingOption(), 1, null, containerTerminalStorage.getLocation(), containerTerminalStorage.getLocationInstance());
                if (shift) {
                    containerTerminalStorage.sendOpenCraftingPlanGuiPacketToServer((HolderLookup.Provider)player.level().registryAccess(), craftingOptionData);
                } else {
                    containerTerminalStorage.sendOpenCraftingJobAmountGuiPacketToServer((HolderLookup.Provider)player.level().registryAccess(), craftingOptionData);
                }
            } else if (clickType != null) {
                Object activeInstance = matcher.getEmptyInstance();
                if (this.activeSlotId >= 0) {
                    activeInstance = matcher.withQuantity(this.getSlots(channel, this.activeSlotId, 1).get(0).getInstance(), moveQuantity);
                }
                IntegratedTerminals._instance.getPacketHandler().sendToServer(new TerminalStorageIngredientSlotClickPacket<Object>((HolderLookup.Provider)player.level().registryAccess(), this.getName().toString(), this.ingredientComponent, clickType, channel, hoveringStorageInstance.orElse(matcher.getEmptyInstance()), hoveredContainerSlot, movePlayerQuantity, activeInstance, transferFullSelection));
                if (reset) {
                    this.resetActiveSlot();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean handleScroll(AbstractContainerMenu container, int channel, int hoveringStorageSlot, double delta, boolean hasClickedOutside, boolean hasClickedInStorage, int hoveredContainerSlot) {
        boolean increment;
        this.activeChannel = channel;
        Optional<TerminalStorageSlotIngredient<TerminalStorageSlotIngredient, M>> hoveringStorageSlotObject = this.getSlot(channel, hoveringStorageSlot);
        Optional<Object> hoveringStorageInstance = hoveringStorageSlotObject.map(TerminalStorageSlotIngredient::getInstance);
        boolean validHoveringStorageSlot = hoveringStorageInstance.isPresent();
        boolean isCraftingOption = hoveringStorageSlotObject.isPresent() && hoveringStorageSlotObject.get() instanceof TerminalStorageSlotIngredientCraftingOption;
        IIngredientComponentTerminalStorageHandler<T, M> viewHandler = this.getViewHandler();
        boolean shift = MinecraftHelpers.isShifted();
        boolean bl = increment = delta < 0.0;
        if (hasClickedInStorage && validHoveringStorageSlot && !isCraftingOption) {
            if (this.activeSlotId < 0) {
                this.activeSlotId = hoveringStorageSlot;
                this.activeSlotQuantity = 0;
            }
            if (this.activeSlotId == hoveringStorageSlot) {
                if (increment) {
                    this.activeSlotQuantity = (int)Math.min(this.ingredientComponent.getMatcher().getQuantity(hoveringStorageInstance.get()), (long)(this.activeSlotQuantity + (shift ? viewHandler.getInitialInstanceMovementQuantity() : viewHandler.getIncrementalInstanceMovementQuantity())));
                } else {
                    this.activeSlotQuantity = Math.max(0, this.activeSlotQuantity - (shift ? viewHandler.getInitialInstanceMovementQuantity() : viewHandler.getIncrementalInstanceMovementQuantity()));
                    if (this.activeSlotQuantity == 0) {
                        this.activeSlotId = -1;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public int getActiveSlotId() {
        return this.activeSlotId;
    }

    @Override
    public int getActiveSlotQuantity() {
        return this.activeSlotQuantity;
    }

    @Override
    public void setActiveSlotQuantity(int quantity) {
        this.activeSlotQuantity = quantity;
        if (quantity == 0) {
            this.activeSlotId = -1;
        }
    }

    @Override
    public List<ITerminalButton<?, ?, ?>> getButtons() {
        return this.buttons;
    }

    @Nullable
    public Comparator<T> getInstanceSorter() {
        Comparator sorter = null;
        for (ITerminalButton<?, ?, ?> button : this.buttons) {
            Comparator partSorter;
            if (!(button instanceof TerminalButtonSort) || (partSorter = ((TerminalButtonSort)button).getEffectiveSorter()) == null) continue;
            if (sorter == null) {
                sorter = partSorter;
                continue;
            }
            sorter = sorter.thenComparing(partSorter);
        }
        if (sorter != null) {
            sorter = sorter.thenComparing(this.ingredientComponent.getMatcher());
        }
        return sorter;
    }

    @Override
    public ITerminalRowColumnProvider getRowColumnProvider() {
        for (ITerminalButton<?, ?, ?> button : this.buttons) {
            if (!(button instanceof TerminalButtonScaleGui)) continue;
            return ((TerminalButtonScaleGui)button).getRowColumnProvider();
        }
        throw new IllegalStateException("Could not find a TerminalButtonScaleGui registered on storage tab " + String.valueOf(this.getName()));
    }

    @Override
    public void onCommonSlotRender(AbstractContainerScreen gui, GuiGraphics guiGraphics, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, int slot, ITerminalStorageTabCommon tabCommon) {
        TerminalStorageTabIngredientComponentCommon tab = (TerminalStorageTabIngredientComponentCommon)tabCommon;
        if (slot >= tab.getVariableSlotNumberStart() && slot < tab.getVariableSlotNumberEnd()) {
            ArrayList errors = Lists.newArrayList();
            errors.addAll(tab.getGlobalErrors());
            errors.addAll(tab.getLocalErrors(slot));
            if (!errors.isEmpty()) {
                if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
                    Images.ERROR.draw(guiGraphics, x + 2, y + 2);
                } else if (RenderHelpers.isPointInRegion((int)x, (int)y, (int)GuiHelpers.SLOT_SIZE, (int)GuiHelpers.SLOT_SIZE, (double)mouseX, (double)mouseY)) {
                    GuiHelpers.drawTooltip((AbstractContainerScreen)gui, (PoseStack)guiGraphics.pose(), errors.stream().map(Component::getString).map(s -> StringHelpers.splitLines((String)s, (int)25, (String)ChatFormatting.RED.toString())).flatMap(Collection::stream).map(Component::literal).collect(Collectors.toList()), (int)(x - gui.getGuiLeft() + 10), (int)(y - gui.getGuiTop()));
                }
            }
        }
    }

    protected IIngredientComponentTerminalStorageHandler<T, M> getViewHandler() {
        return this.ingredientComponentViewHandler;
    }

    @Override
    public boolean isSlotValidForDraggingInto(int channel, Slot slot) {
        ItemStack stack;
        IIngredientComponentTerminalStorageHandler<T, M> viewHandler = this.getViewHandler();
        if (!viewHandler.isInstance(stack = slot.getItem())) {
            return false;
        }
        T stackInstance = viewHandler.getInstance(stack);
        Optional<T> activeInstance = this.getSlotInstance(channel, this.getActiveSlotId());
        IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
        return activeInstance.isPresent() && (matcher.isEmpty(stackInstance) || matcher.matches(stackInstance, activeInstance.get(), matcher.getExactMatchNoQuantityCondition())) && matcher.getQuantity(stackInstance) != viewHandler.getMaxQuantity(stack);
    }

    @Override
    public int computeDraggingQuantity(Set<Slot> dragSlots, int dragMode, ItemStack stack, int quantity) {
        int instanceQuantity = 0;
        switch (dragMode) {
            case 0: {
                instanceQuantity = Mth.floor((float)((float)quantity / (float)dragSlots.size()));
                break;
            }
            case 1: {
                instanceQuantity = this.getViewHandler().getIncrementalInstanceMovementQuantity();
                break;
            }
            case 2: {
                instanceQuantity = Helpers.castSafe((long)this.getViewHandler().getMaxQuantity(stack));
            }
        }
        return instanceQuantity;
    }

    @Override
    public int dragIntoSlot(AbstractContainerMenu container, int channel, Slot slot, int quantity, boolean simulate) {
        if (!simulate) {
            int oldActiveSlotId = this.activeSlotId;
            int activeSlotQuantityOld = this.activeSlotQuantity;
            this.activeSlotQuantity = quantity;
            this.handleClick(container, channel, this.getActiveSlotId(), 0, false, false, slot.index, false);
            this.activeSlotId = oldActiveSlotId;
            this.activeSlotQuantity = activeSlotQuantityOld;
        }
        IIngredientComponentTerminalStorageHandler<T, M> viewHandler = this.getViewHandler();
        ItemStack stack = slot.getItem();
        T stackInstance = viewHandler.getInstance(stack);
        IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
        int instanceQuantity = Helpers.castSafe((long)matcher.getQuantity(stackInstance));
        int maxQuantity = Helpers.castSafe((long)viewHandler.getMaxQuantity(stack));
        int freeQuantity = maxQuantity - instanceQuantity;
        return Math.min(Math.max(0, quantity), freeQuantity);
    }

    public void resetScale() {
        this.container.screen.init();
    }

    public int getLastChangeId() {
        return this.lastChangeId;
    }

    static {
        NeoForge.EVENT_BUS.register(TerminalStorageTabIngredientComponentClient.class);
    }

    public static class InstanceWithMetadata<T> {
        private final T instance;
        @Nullable
        private final HandlerWrappedTerminalCraftingOption<T> craftingOption;

        public InstanceWithMetadata(T instance, @Nullable HandlerWrappedTerminalCraftingOption<T> craftingOption) {
            this.instance = instance;
            this.craftingOption = craftingOption;
        }

        public T getInstance() {
            return this.instance;
        }

        @Nullable
        public HandlerWrappedTerminalCraftingOption<T> getCraftingOption() {
            return this.craftingOption;
        }

        public static <T> Comparator<InstanceWithMetadata<T>> createComparator(Comparator<T> comparator) {
            return (o1, o2) -> {
                int comp = comparator.compare(o1.getInstance(), o2.getInstance());
                if (comp == 0) {
                    HandlerWrappedTerminalCraftingOption c1 = o1.getCraftingOption();
                    HandlerWrappedTerminalCraftingOption c2 = o2.getCraftingOption();
                    if (c1 == null) {
                        if (c2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (c2 == null) {
                        return 1;
                    }
                    return c1.getCraftingOption().compareTo(c2.getCraftingOption());
                }
                return comp;
            };
        }
    }
}

