/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlan;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlanFlat;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlanToggler;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingPlanBase;

public class ContainerScreenTerminalStorageCraftingPlan<L, C extends ContainerTerminalStorageCraftingPlanBase<L>>
extends ContainerScreenExtended<C> {
    private GuiCraftingPlanToggler guiCraftingPlanToggler = new GuiCraftingPlanToggler(() -> this.craftingPlan, () -> this.craftingPlanFlat, () -> {
        this.guiCraftingPlan = new GuiCraftingPlan((AbstractContainerScreen)this, this.craftingPlan, this.leftPos, this.topPos, 9, 18, 10);
        this.addRenderableWidget((GuiEventListener)this.guiCraftingPlan);
        if (this.craftingPlanFlat != null) {
            this.addRenderableWidget((GuiEventListener)new ButtonText(this.leftPos + 8, this.topPos + 198, 80, 20, (Component)Component.translatable((String)"gui.integratedterminals.craftingplan.view.flat"), (Component)Component.translatable((String)"gui.integratedterminals.craftingplan.view.flat").withStyle(ChatFormatting.ITALIC), b -> {
                this.guiCraftingPlanToggler.setCraftingPlanDisplayMode(GuiCraftingPlanToggler.CraftingPlanDisplayMode.FLAT);
                this.init();
            }, true));
        }
    }, () -> {
        this.guiCraftingPlanFlat = new GuiCraftingPlanFlat((AbstractContainerScreen)this, this.craftingPlanFlat, this.leftPos, this.topPos, 9, 18, 10);
        this.addRenderableWidget((GuiEventListener)this.guiCraftingPlanFlat);
        if (this.craftingPlan != null) {
            this.addRenderableWidget((GuiEventListener)new ButtonText(this.leftPos + 8, this.topPos + 198, 80, 20, (Component)Component.translatable((String)"gui.integratedterminals.craftingplan.view.tree"), (Component)Component.translatable((String)"gui.integratedterminals.craftingplan.view.tree").withStyle(ChatFormatting.ITALIC), b -> {
                this.guiCraftingPlanToggler.setCraftingPlanDisplayMode(GuiCraftingPlanToggler.CraftingPlanDisplayMode.TREE);
                this.init();
            }, true));
        }
    });
    @Nullable
    private GuiCraftingPlan guiCraftingPlan;
    @Nullable
    private GuiCraftingPlanFlat guiCraftingPlanFlat;
    private ITerminalCraftingPlan craftingPlan;
    private ITerminalCraftingPlanFlat craftingPlanFlat;
    private ButtonText buttonConfirm;

    public ContainerScreenTerminalStorageCraftingPlan(C container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"textures/gui/crafting_plan.png");
    }

    public ResourceLocation getGuiTexture() {
        return this.guiCraftingPlanToggler.getCraftingPlanDisplayMode() == GuiCraftingPlanToggler.CraftingPlanDisplayMode.FLAT ? ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"textures/gui/crafting_plan_flat.png") : super.getGuiTexture();
    }

    public int getBaseXSize() {
        return 256;
    }

    public int getBaseYSize() {
        return 222;
    }

    public void init() {
        super.init();
        this.renderables.clear();
        this.children().clear();
        this.guiCraftingPlan = null;
        this.guiCraftingPlanFlat = null;
        this.guiCraftingPlanToggler.init();
        this.buttonConfirm = new ButtonText(this.leftPos + 221 + 10 - 50, this.topPos + 198, 50, 20, (Component)Component.translatable((String)"gui.integratedterminals.terminal_storage.step.craft"), (Component)Component.translatable((String)"gui.integratedterminals.terminal_storage.step.craft").withStyle(ChatFormatting.YELLOW), this.createServerPressable("start", b -> {}), true);
        this.addRenderableWidget((GuiEventListener)this.buttonConfirm);
        this.buttonConfirm.active = this.guiCraftingPlan != null && this.guiCraftingPlan.isValid() || this.guiCraftingPlanFlat != null && this.guiCraftingPlanFlat.isValid();
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (this.guiCraftingPlan != null && this.guiCraftingPlan.isValid() && (typedChar == 257 || typedChar == 335)) {
            this.buttonConfirm.onPress();
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    private void returnToTerminalStorage() {
        CraftingOptionGuiData data = ((ContainerTerminalStorageCraftingPlanBase)this.getMenu()).getCraftingOptionGuiData();
        data.getLocation().openContainerFromClient(data);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawGuiContainerBackgroundLayer(guiGraphics, partialTicks, mouseX, mouseY);
        } else if (this.guiCraftingPlanFlat != null) {
            this.guiCraftingPlanFlat.drawGuiContainerBackgroundLayer(guiGraphics, partialTicks, mouseX, mouseY);
        } else {
            guiGraphics.drawCenteredString(this.font, L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.step.crafting_plan_calculating", (Object[])new Object[0]), this.leftPos + this.getBaseXSize() / 2, this.topPos + 23, 0xFFFFFF);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawGuiContainerForegroundLayer(guiGraphics, mouseX, mouseY);
        } else if (this.guiCraftingPlanFlat != null) {
            this.guiCraftingPlanFlat.drawGuiContainerForegroundLayer(guiGraphics, mouseX, mouseY);
        }
    }

    protected void drawCurrentScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawCurrentScreen(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.render(guiGraphics, mouseX, mouseY, partialTicks);
        } else if (this.guiCraftingPlanFlat != null) {
            this.guiCraftingPlanFlat.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double delta) {
        if (this.guiCraftingPlan != null) {
            return this.guiCraftingPlan.mouseScrolled(mouseX, mouseY, mouseZ, delta);
        }
        if (this.guiCraftingPlanFlat != null) {
            return this.guiCraftingPlanFlat.mouseScrolled(mouseX, mouseY, mouseZ, delta);
        }
        return super.mouseScrolled(mouseX, mouseY, mouseZ, delta);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        if (this.guiCraftingPlan != null) {
            return this.guiCraftingPlan.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
        }
        if (this.guiCraftingPlanFlat != null) {
            return this.guiCraftingPlanFlat.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        if (((ContainerTerminalStorageCraftingPlanBase)this.getMenu()).getCraftingPlanNotifierId() == valueId) {
            this.craftingPlan = ((ContainerTerminalStorageCraftingPlanBase)this.getMenu()).getCraftingOptionGuiData().getCraftingOption().getHandler().deserializeCraftingPlan((HolderLookup.Provider)((ContainerTerminalStorageCraftingPlanBase)this.getMenu()).getPlayerIInventory().player.registryAccess(), value);
            this.guiCraftingPlanToggler.setCraftingPlanDisplayMode(null);
            this.init();
        }
        if (((ContainerTerminalStorageCraftingPlanBase)this.getMenu()).getCraftingPlanFlatNotifierId() == valueId) {
            this.craftingPlanFlat = ((ContainerTerminalStorageCraftingPlanBase)this.getMenu()).getCraftingOptionGuiData().getCraftingOption().getHandler().deserializeCraftingPlanFlat((HolderLookup.Provider)((ContainerTerminalStorageCraftingPlanBase)this.getMenu()).getPlayerIInventory().player.registryAccess(), value);
            this.guiCraftingPlanToggler.setCraftingPlanDisplayMode(null);
            this.init();
        }
    }
}

