/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.dynamic_resources;

import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.sugar.Local;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.duck.IExtendedModelBakery;
import org.embeddedt.modernfix.duck.IExtendedModelManager;
import org.embeddedt.modernfix.util.CacheUtil;
import org.embeddedt.modernfix.util.LambdaMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelManager.class})
@ClientOnlyMixin
public class ModelManagerMixin
implements IExtendedModelManager {
    @Shadow
    private Map<ResourceLocation, BakedModel> bakedRegistry;
    @Unique
    private Runnable tickHandler = () -> {};

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void injectDummyBakedRegistry(CallbackInfo ci) {
        if (this.bakedRegistry == null) {
            this.bakedRegistry = new HashMap<ResourceLocation, BakedModel>();
        }
    }

    @Redirect(method={"reload"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/ModelManager;loadBlockModels(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<Map<ResourceLocation, BlockModel>> deferBlockModelLoad(ResourceManager manager, Executor executor) {
        LoadingCache<ResourceLocation, BlockModel> cache = CacheUtil.simpleCacheForLambda(location -> this.loadSingleBlockModel(manager, (ResourceLocation)location), 100L);
        return CompletableFuture.completedFuture(new LambdaMap<ResourceLocation, BlockModel>(location -> (BlockModel)cache.getUnchecked(location)));
    }

    @Redirect(method={"reload"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/ModelManager;loadBlockStates(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<Map<ResourceLocation, List<BlockStateModelLoader.LoadedJson>>> deferBlockStateLoad(ResourceManager manager, Executor executor) {
        LoadingCache<ResourceLocation, List> cache = CacheUtil.simpleCacheForLambda(location -> this.loadSingleBlockState(manager, (ResourceLocation)location), 100L);
        return CompletableFuture.completedFuture(new LambdaMap<ResourceLocation, List>(location -> (List)cache.getUnchecked(location)));
    }

    @Redirect(method={"loadModels"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/StateDefinition;getPossibleStates()Lcom/google/common/collect/ImmutableList;"))
    private ImmutableList<BlockState> skipCollection(StateDefinition<Block, BlockState> definition) {
        return ImmutableList.of();
    }

    private BlockModel loadSingleBlockModel(ResourceManager manager, ResourceLocation location) {
        return manager.getResource(location).map(resource -> {
            BlockModel blockModel;
            block8: {
                BufferedReader reader = resource.openAsReader();
                try {
                    blockModel = BlockModel.fromStream((Reader)reader);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        ModernFix.LOGGER.error("Couldn't load model", (Throwable)e);
                        return null;
                    }
                }
                reader.close();
            }
            return blockModel;
        }).orElse(null);
    }

    private List<BlockStateModelLoader.LoadedJson> loadSingleBlockState(ResourceManager manager, ResourceLocation location) {
        return manager.getResourceStack(location).stream().map(resource -> {
            BlockStateModelLoader.LoadedJson loadedJson;
            block8: {
                BufferedReader reader = resource.openAsReader();
                try {
                    loadedJson = new BlockStateModelLoader.LoadedJson(resource.sourcePackId(), (JsonElement)GsonHelper.parse((Reader)reader));
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        ModernFix.LOGGER.error("Couldn't load blockstate", (Throwable)e);
                        return null;
                    }
                }
                reader.close();
            }
            return loadedJson;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Inject(method={"loadModels"}, at={@At(value="RETURN")})
    private void storeTicker(ProfilerFiller profilerFiller, Map<ResourceLocation, AtlasSet.StitchResult> map, ModelBakery modelBakery, CallbackInfoReturnable<?> cir) {
        this.tickHandler = ((IExtendedModelBakery)modelBakery)::mfix$tick;
    }

    @Inject(method={"apply"}, at={@At(value="RETURN")})
    private void freezeBakery(@Coerce Object reloadState, ProfilerFiller profilerFiller, CallbackInfo ci, @Local(ordinal=0) ModelBakery bakery) {
        ((IExtendedModelBakery)bakery).mfix$finishLoading();
    }

    @Override
    public void mfix$tick() {
        this.tickHandler.run();
    }
}

