/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ReplaceNotAirProcessor
extends StructureProcessor {
    public static final MapCodec<ReplaceNotAirProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().listOf().xmap(Sets::newHashSet, Lists::newArrayList).optionalFieldOf("blocks_to_always_replace", new HashSet()).forGetter(config -> config.blocksToAlwaysReplace)).apply((Applicative)instance, instance.stable(ReplaceNotAirProcessor::new)));
    public final HashSet<Block> blocksToAlwaysReplace;

    private ReplaceNotAirProcessor(HashSet<Block> blocksToAlwaysReplace) {
        this.blocksToAlwaysReplace = blocksToAlwaysReplace;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        BlockPos position;
        BlockState worldState;
        if ((this.blocksToAlwaysReplace.isEmpty() || this.blocksToAlwaysReplace.contains(structureBlockInfoWorld.state().getBlock())) && (worldState = worldView.getBlockState(position = structureBlockInfoWorld.pos())).isAir()) {
            return null;
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.REPLACE_NOT_AIR_PROCESSOR.get();
    }
}

