/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class HoneycombCaves
extends Feature<NoneFeatureConfiguration> {
    protected long seed;
    protected static OpenSimplex2F noiseGen;
    protected static OpenSimplex2F noiseGen2;
    private static final int[][] hexagon7;
    private static final int[][] hexagon6;
    private static final int[][] hexagon5;
    private static final int[][] hexagon4;
    private static final int[][] hexagon3;
    private static final int[][] hexagon2;
    private static final int[][] hexagon1;
    private static final int[][][] hexagonArray;

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplex2F(seed);
            noiseGen2 = new OpenSimplex2F(seed + 1000L);
            this.seed = seed;
        }
    }

    public HoneycombCaves(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        this.setSeed(level.getSeed());
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)context.origin());
        int disallowedBottomRange = Integer.MAX_VALUE;
        int disallowedTopRange = Integer.MIN_VALUE;
        WorldGenLevel worldGenLevel = context.level();
        if (worldGenLevel instanceof WorldGenRegion) {
            WorldGenRegion worldGenRegion = (WorldGenRegion)worldGenLevel;
            Registry structureRegistry = (Registry)worldGenRegion.registryAccess().registry(Registries.STRUCTURE).get();
            StructureManager structureManager = context.level().getLevel().structureManager();
            SectionPos sectionPos = SectionPos.of((BlockPos)mutableBlockPos);
            List<StructureStart> structureStarts = GeneralUtils.startsForAllStructure((LevelReader)worldGenRegion, structureManager, sectionPos, struct -> structureRegistry.getHolderOrThrow((ResourceKey)structureRegistry.getResourceKey(struct).get()).is(BzTags.NO_CAVES));
            for (StructureStart structureStart : structureStarts) {
                disallowedBottomRange = Math.min(disallowedBottomRange, structureStart.getBoundingBox().minY());
                disallowedTopRange = Math.max(disallowedTopRange, structureStart.getBoundingBox().maxY());
            }
        }
        int orgX = context.origin().getX();
        int orgY = context.origin().getY();
        int orgZ = context.origin().getZ();
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)context.level());
        for (int y = 15; y < 241; ++y) {
            if (y > disallowedBottomRange && y < disallowedTopRange) continue;
            block2: for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    mutableBlockPos.set(orgX, orgY, orgZ).move(x, y, z);
                    if (bulkSectionAccess.getSection((BlockPos)mutableBlockPos).hasOnlyAir()) {
                        x = 16;
                        y += 16 - y % 16;
                        continue block2;
                    }
                    double noise1 = noiseGen.noise3_Classic((double)mutableBlockPos.getX() * 0.019, (double)mutableBlockPos.getZ() * 0.019, (double)mutableBlockPos.getY() * 0.038);
                    if (noise1 >= 0.0360555127546399) {
                        z = this.zSkipping(z, noise1);
                        continue;
                    }
                    double noise2 = noiseGen2.noise3_Classic((double)mutableBlockPos.getX() * 0.019, (double)mutableBlockPos.getZ() * 0.019, (double)mutableBlockPos.getY() * 0.038);
                    double finalNoise = noise1 * noise1 + noise2 * noise2;
                    if (finalNoise < (double)0.0013f) {
                        HoneycombCaves.hexagon(level, bulkSectionAccess, context.chunkGenerator(), (BlockPos)mutableBlockPos, context.random(), noise1);
                        continue;
                    }
                    z = this.zSkipping(z, finalNoise);
                }
            }
        }
        return true;
    }

    private int zSkipping(int z, double noise1) {
        if (noise1 >= 0.8) {
            z += 7;
        } else if (noise1 >= 0.7) {
            z += 6;
        } else if (noise1 >= 0.6) {
            z += 5;
        } else if (noise1 >= 0.5) {
            z += 4;
        } else if (noise1 >= 0.4) {
            z += 3;
        } else if (noise1 >= 0.3) {
            z += 2;
        } else if (noise1 >= 0.2) {
            ++z;
        }
        return z;
    }

    private static void hexagon(WorldGenLevel world, UnsafeBulkSectionAccess bulkSectionAccess, ChunkGenerator generator, BlockPos position, RandomSource random, double noise) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)position);
        int index = (int)((noise * 0.5 + 0.5) * 7.0);
        BlockPos.MutableBlockPos tempMutable = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 14; ++x) {
            for (int z = 0; z < 11; ++z) {
                int posResult = hexagonArray[index][z][x];
                if (posResult == 0) continue;
                mutableBlockPos.set((Vec3i)position).move(x - 7, 0, z - 5);
                BlockState blockState = bulkSectionAccess.getBlockState((BlockPos)mutableBlockPos);
                HoneycombCaves.carveAtBlock(world, bulkSectionAccess, generator, random, (BlockPos)mutableBlockPos, tempMutable, blockState, posResult);
                mutableBlockPos.set((Vec3i)position).move(0, x - 7, z - 5);
                blockState = bulkSectionAccess.getBlockState((BlockPos)mutableBlockPos);
                HoneycombCaves.carveAtBlock(world, bulkSectionAccess, generator, random, (BlockPos)mutableBlockPos, tempMutable, blockState, posResult);
                mutableBlockPos.set((Vec3i)position).move(z - 5, x - 7, 0);
                blockState = bulkSectionAccess.getBlockState((BlockPos)mutableBlockPos);
                HoneycombCaves.carveAtBlock(world, bulkSectionAccess, generator, random, (BlockPos)mutableBlockPos, tempMutable, blockState, posResult);
            }
        }
    }

    private static void carveAtBlock(WorldGenLevel world, UnsafeBulkSectionAccess bulkSectionAccess, ChunkGenerator generator, RandomSource random, BlockPos blockPos, BlockPos.MutableBlockPos mutable, BlockState blockState, int posResult) {
        if (blockState.canOcclude() && !blockState.canBeReplaced() && !blockState.is(BzTags.FORCE_CAVE_TO_NOT_CARVE)) {
            boolean isNextToAir = HoneycombCaves.shouldCloseOff(bulkSectionAccess, blockPos, mutable);
            if (blockPos.getY() >= generator.getSeaLevel() && isNextToAir) {
                return;
            }
            boolean isBlockEntity = blockState.hasBlockEntity();
            if (posResult == 2) {
                if (blockPos.getY() < generator.getSeaLevel()) {
                    if (isNextToAir) {
                        bulkSectionAccess.setBlockState(blockPos, ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).defaultBlockState(), false);
                    } else {
                        bulkSectionAccess.setBlockState(blockPos, ((LiquidBlock)BzFluids.SUGAR_WATER_BLOCK.get()).defaultBlockState(), false);
                    }
                    if (isBlockEntity) {
                        world.getChunk(blockPos).removeBlockEntity(blockPos);
                    }
                } else {
                    bulkSectionAccess.setBlockState(blockPos, Blocks.CAVE_AIR.defaultBlockState(), false);
                    BlockPos abovePos = blockPos.above();
                    BlockState aboveState = bulkSectionAccess.getBlockState(abovePos);
                    if (!aboveState.isAir() && !aboveState.isCollisionShapeFullBlock((BlockGetter)world, abovePos)) {
                        bulkSectionAccess.setBlockState(blockPos, Blocks.CAVE_AIR.defaultBlockState(), false);
                        if (aboveState.getBlock() instanceof DoublePlantBlock && aboveState.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.LOWER) {
                            bulkSectionAccess.setBlockState(abovePos, Blocks.CAVE_AIR.defaultBlockState(), false);
                        }
                        if (isBlockEntity) {
                            world.getChunk(blockPos).removeBlockEntity(blockPos);
                        }
                    }
                }
            } else if (posResult == 1) {
                if (random.nextInt(3) == 0) {
                    bulkSectionAccess.setBlockState(blockPos, Blocks.HONEYCOMB_BLOCK.defaultBlockState(), false);
                } else {
                    bulkSectionAccess.setBlockState(blockPos, ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).defaultBlockState(), false);
                }
                if (isBlockEntity) {
                    world.getChunk(blockPos).removeBlockEntity(blockPos);
                }
            }
        }
    }

    private static boolean shouldCloseOff(UnsafeBulkSectionAccess bulkSectionAccess, BlockPos position, BlockPos.MutableBlockPos mutableBlockPos) {
        for (Direction direction : Direction.values()) {
            mutableBlockPos.set((Vec3i)position).move(direction);
            BlockState blockState = bulkSectionAccess.getBlockState((BlockPos)mutableBlockPos);
            if (!blockState.is(Blocks.AIR)) continue;
            return true;
        }
        return false;
    }

    static {
        hexagon7 = new int[][]{{0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0}, {1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1}, {0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}};
        hexagon6 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon5 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon4 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon3 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon2 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 2, 2, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagon1 = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        hexagonArray = new int[][][]{hexagon1, hexagon2, hexagon3, hexagon4, hexagon5, hexagon6, hexagon7};
    }
}

