/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.GlisteringHoneyCrystal;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GiantHoneyCrystalFeature
extends Feature<NoneFeatureConfiguration> {
    public GiantHoneyCrystalFeature(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockState state;
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        BlockState currentState = level.getBlockState(origin);
        if (currentState.canOcclude() || currentState.is(BzTags.AIR_LIKE)) {
            return false;
        }
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)context.level());
        boolean validSpot = false;
        boolean superSlant = false;
        Direction wallDirection = null;
        for (Direction direction : Direction.Plane.VERTICAL) {
            blockpos$Mutable.set((Vec3i)origin).move(direction, 5);
            state = bulkSectionAccess.getBlockState((BlockPos)blockpos$Mutable);
            if (!state.canOcclude()) continue;
            validSpot = true;
            break;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            blockpos$Mutable.set((Vec3i)origin).move(direction, 1);
            state = bulkSectionAccess.getBlockState((BlockPos)blockpos$Mutable);
            if (!state.canOcclude()) continue;
            superSlant = true;
            wallDirection = direction;
            validSpot = true;
        }
        if (!validSpot) {
            return false;
        }
        blockpos$Mutable.set((Vec3i)origin).move(Direction.UP, 5);
        int directionSign = bulkSectionAccess.getBlockState((BlockPos)blockpos$Mutable).canOcclude() ? -1 : 1;
        int currentY = origin.getY() - directionSign * 5;
        int thickness = random.nextInt(3) + 4;
        int height = random.nextInt(5) + 12;
        int slantAmountX = random.nextInt(10) * (random.nextBoolean() ? -1 : 1);
        int slantAmountZ = random.nextInt(10) * (random.nextBoolean() ? -1 : 1);
        if (random.nextInt(4) == 0) {
            slantAmountX = 0;
        }
        if (random.nextInt(4) == 0) {
            slantAmountZ = 0;
        }
        if (superSlant) {
            slantAmountX = -wallDirection.getStepX() * (random.nextInt(2) + 1);
            slantAmountZ = -wallDirection.getStepZ() * (random.nextInt(2) + 1);
        }
        for (int layer = 0; layer < height; ++layer) {
            int currentZSlant;
            float currentThickness = thickness;
            int currentXSlant = slantAmountX == 0 ? 0 : layer / slantAmountX;
            int n = currentZSlant = slantAmountZ == 0 ? 0 : layer / slantAmountZ;
            if (layer == 0) {
                currentThickness -= 2.0f;
            } else if (layer == 1) {
                currentThickness -= 1.0f;
            } else if (layer == height - 1) {
                currentThickness = 0.5f;
                currentXSlant = slantAmountX == 0 ? 0 : (layer - 1) / slantAmountX;
                currentZSlant = slantAmountZ == 0 ? 0 : (layer - 1) / slantAmountZ;
            } else {
                currentThickness *= Math.max((float)(height - layer) / (float)height, 0.2f);
                currentThickness = Math.max(currentThickness, 1.1f);
            }
            int x = (int)(-currentThickness);
            while ((float)x <= currentThickness) {
                int z = (int)(-currentThickness);
                while ((float)z <= currentThickness) {
                    if ((float)(x * x + z * z) < currentThickness * currentThickness) {
                        blockpos$Mutable.set(origin.getX() + x + currentXSlant, currentY, origin.getZ() + z + currentZSlant);
                        BlockState state2 = bulkSectionAccess.getBlockState((BlockPos)blockpos$Mutable);
                        if (!state2.canOcclude() && !state2.hasBlockEntity()) {
                            BlockState newState = ((Block)BzBlocks.GLISTERING_HONEY_CRYSTAL.get()).defaultBlockState();
                            if (random.nextFloat() < 0.5f) {
                                newState = (BlockState)newState.setValue((Property)GlisteringHoneyCrystal.FACING, (Comparable)Direction.getRandom((RandomSource)random));
                            }
                            bulkSectionAccess.setBlockState((BlockPos)blockpos$Mutable, newState, false);
                        }
                    }
                    ++z;
                }
                ++x;
            }
            currentY += directionSign;
        }
        return false;
    }
}

