/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import java.util.Optional;
import java.util.function.Supplier;

public class LazySupplier<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private boolean initialized;
    private T value;

    public LazySupplier(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static <T> LazySupplier<T> of(Supplier<T> supplier) {
        return new LazySupplier<T>(supplier);
    }

    @Override
    public T get() {
        if (this.value == null) {
            this.value = this.supplier.get();
            this.initialized = true;
        }
        return this.value;
    }

    public Optional<T> getOptional() {
        return this.initialized ? Optional.ofNullable(this.value) : Optional.ofNullable(this.get());
    }
}

