/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.neoforge;

import com.mojang.datafixers.util.Function6;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.blocks.EmptyHoneycombBrood;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntitySpawnEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzAddBuiltinDataPacks;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.DispenserBlockInvoker;
import com.telepathicgrunt.the_bumblezone.modcompat.BroodBlockModdedCompatDispenseBehavior;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.ExpansionBox;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ProductiveBeesCompat
implements ModCompat {
    private static final GeneralUtils.Lazy<List<ResourceLocation>> SPIDER_DUNGEON_HONEYCOMBS = new GeneralUtils.Lazy<List>(() -> BeeReloadListener.INSTANCE.getData().entrySet().stream().filter(e -> {
        CompoundTag tag = (CompoundTag)e.getValue();
        int primary = tag.getInt("primaryColor");
        return BzModCompatibilityConfigs.allowedCombsForDungeons.contains(((ResourceLocation)e.getKey()).toString()) && tag.getBoolean("createComb") && (ProductiveBeesCompat.colorsAreClose(GeneralUtils.colorToInt(106, 127, 0), primary, 150) || ProductiveBeesCompat.colorsAreClose(GeneralUtils.colorToInt(129, 198, 0), primary, 150) || ProductiveBeesCompat.colorsAreClose(GeneralUtils.colorToInt(34, 45, 0), primary, 150));
    }).map(Map.Entry::getKey).toList());
    private static final GeneralUtils.Lazy<List<ResourceLocation>> BEE_DUNGEON_HONEYCOMBS = new GeneralUtils.Lazy<List>(() -> BeeReloadListener.INSTANCE.getData().entrySet().stream().filter(e -> {
        CompoundTag tag = (CompoundTag)e.getValue();
        return BzModCompatibilityConfigs.allowedCombsForDungeons.contains(((ResourceLocation)e.getKey()).toString()) && tag.getBoolean("createComb") && !SPIDER_DUNGEON_HONEYCOMBS.getOrFillFromInternal().contains(e.getKey());
    }).map(Map.Entry::getKey).toList());
    private static final GeneralUtils.Lazy<List<ResourceLocation>> ALL_BEES = new GeneralUtils.Lazy<List>(() -> BeeReloadListener.INSTANCE.getData().keySet().stream().filter(e -> BzModCompatibilityConfigs.allowedBees.contains(e.toString())).toList());
    public static final TagKey<Block> SOLITARY_OVERWORLD_NESTS_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"solitary_overworld_nests"));
    protected static Optional<Item> BEE_CAGE;
    protected static Optional<Item> STURDY_BEE_CAGE;

    public ProductiveBeesCompat() {
        BEE_CAGE = BuiltInRegistries.ITEM.getOptional(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"bee_cage"));
        STURDY_BEE_CAGE = BuiltInRegistries.ITEM.getOptional(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"sturdy_bee_cage"));
        if (BEE_CAGE.isPresent() && BzModCompatibilityConfigs.allowProductiveBeesBeeCageRevivingEmptyBroodBlock) {
            ProductiveBeesCompat.setupDispenserCompat(BEE_CAGE.get());
        }
        if (STURDY_BEE_CAGE.isPresent() && BzModCompatibilityConfigs.allowProductiveBeesBeeCageRevivingEmptyBroodBlock) {
            ProductiveBeesCompat.setupDispenserCompat(STURDY_BEE_CAGE.get());
        }
        Bumblezone.MOD_COMPAT_DATAPACKS.add(addBuiltinDataPacks -> addBuiltinDataPacks.add(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"productive_bees_compat"), (Component)Component.literal((String)"Bumblezone - Productive Bees Compat"), BzAddBuiltinDataPacks.PackMode.FORCE_ENABLED));
        ModChecker.productiveBeesPresent = true;
    }

    private static void setupDispenserCompat(Item containerItem) {
        BroodBlockModdedCompatDispenseBehavior newDispenseBehavior = new BroodBlockModdedCompatDispenseBehavior(DispenserBlockInvoker.getDISPENSER_REGISTRY().get(containerItem), (Function6<DispenseItemBehavior, BlockSource, ItemStack, ServerLevel, BlockPos, BlockState, ItemStack>)((Function6)(originalModdedDispenseBehavior, blockSource, itemStack, serverLevel, blockPos, blockState) -> {
            serverLevel.setBlockAndUpdate(blockPos, (BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_BROOD.get()).defaultBlockState().setValue((Property)HoneycombBrood.FACING, (Comparable)((Direction)blockState.getValue((Property)EmptyHoneycombBrood.FACING)))).setValue((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(ProductiveBeesCompat.isFilledBabyBeeCageItem(itemStack) ? 2 : 3)));
            boolean isSturdy = STURDY_BEE_CAGE.isPresent() && itemStack.is(STURDY_BEE_CAGE.get());
            itemStack.shrink(1);
            if (!itemStack.isEmpty()) {
                if (blockSource.blockEntity() instanceof DispenserBlockEntity) {
                    DispenserBlockEntity dispenser = blockSource.blockEntity();
                    ItemStack emptyCage = ItemStack.EMPTY;
                    if (isSturdy && STURDY_BEE_CAGE.isPresent()) {
                        emptyCage = new ItemStack((ItemLike)STURDY_BEE_CAGE.get());
                    } else if (BEE_CAGE.isPresent()) {
                        emptyCage = new ItemStack((ItemLike)BEE_CAGE.get());
                    }
                    if (!HopperBlockEntity.addItem(null, (Container)dispenser, (ItemStack)emptyCage, null).isEmpty()) {
                        BroodBlockModdedCompatDispenseBehavior.DEFAULT_DROP_ITEM_BEHAVIOR.dispense(blockSource, emptyCage);
                    }
                }
            } else if (isSturdy) {
                itemStack = new ItemStack((ItemLike)STURDY_BEE_CAGE.get());
            } else if (BEE_CAGE.isPresent()) {
                itemStack = new ItemStack((ItemLike)BEE_CAGE.get());
            }
            return itemStack;
        }));
        DispenserBlock.registerBehavior((ItemLike)containerItem, (DispenseItemBehavior)newDispenseBehavior);
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.SPAWNS, new ModCompat.Type[]{ModCompat.Type.COMBS, ModCompat.Type.HIVE_TELEPORT, ModCompat.Type.COMB_ORE, ModCompat.Type.EMPTY_BROOD, ModCompat.Type.BEE_COLOR});
    }

    private static boolean colorsAreClose(int a, int z, int threshold) {
        int b;
        int g;
        int r = GeneralUtils.getRed(a) - GeneralUtils.getRed(z);
        return r * r + (g = GeneralUtils.getGreen(a) - GeneralUtils.getGreen(z)) * g + (b = GeneralUtils.getBlue(a) - GeneralUtils.getBlue(z)) * b <= threshold * threshold;
    }

    @Override
    public boolean isValidBeeHiveForTeleportation(BlockState state) {
        if (state.getBlock() instanceof ExpansionBox && state.getValue((Property)AdvancedBeehive.EXPANDED) != VerticalHive.NONE) {
            return true;
        }
        if (state.is(SOLITARY_OVERWORLD_NESTS_TAG)) {
            return true;
        }
        return state.getBlock() instanceof AdvancedBeehiveAbstract;
    }

    @Override
    public boolean onBeeSpawn(BzEntitySpawnEvent event, boolean isChild) {
        if (!BzModCompatibilityConfigs.spawnProductiveBeesBeesMob) {
            return false;
        }
        if ((double)event.entity().getRandom().nextFloat() >= BzModCompatibilityConfigs.spawnrateOfProductiveBeesMobs) {
            return false;
        }
        if (event.spawnType() == MobSpawnType.DISPENSER && !BzModCompatibilityConfigs.allowProductiveBeesSpawnFromDispenserFedBroodBlock) {
            return false;
        }
        if (ALL_BEES.getOrFillFromInternal().isEmpty()) {
            return false;
        }
        Mob entity = event.entity();
        LevelAccessor world = event.level();
        ConfigurableBee productiveBeeEntity = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).create(entity.level());
        if (productiveBeeEntity == null) {
            return false;
        }
        productiveBeeEntity.moveTo(entity.getX(), entity.getY(), entity.getZ(), productiveBeeEntity.getRandom().nextFloat() * 360.0f, 0.0f);
        productiveBeeEntity.setBaby(isChild);
        CompoundTag newTag = new CompoundTag();
        newTag.putString("type", ALL_BEES.getOrFillFromInternal().get(productiveBeeEntity.getRandom().nextInt(ALL_BEES.getOrFillFromInternal().size())).toString());
        productiveBeeEntity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(productiveBeeEntity.blockPosition()), event.spawnType(), null);
        productiveBeeEntity.setBeeType(newTag.getString("type"));
        world.addFreshEntity((Entity)productiveBeeEntity);
        return true;
    }

    @Override
    public OptionalBoolean validateCombType(CompoundTag tag) {
        CompoundTag productiveBeesData;
        if (tag.contains("type") && (productiveBeesData = (CompoundTag)BeeReloadListener.INSTANCE.getData().get(ResourceLocation.tryParse((String)tag.getString("type")))) != null && productiveBeesData.getBoolean("createComb")) {
            return OptionalBoolean.TRUE;
        }
        return OptionalBoolean.EMPTY;
    }

    @Override
    public boolean checkCombSpawn(BlockPos pos, RandomSource random, LevelReader level, boolean spiderDungeon) {
        if (spiderDungeon) {
            return (double)random.nextFloat() < BzModCompatibilityConfigs.PBOreHoneycombSpawnRateSpiderBeeDungeon;
        }
        return (double)random.nextFloat() < BzModCompatibilityConfigs.PBOreHoneycombSpawnRateBeeDungeon;
    }

    @Override
    public StructureTemplate.StructureBlockInfo getHoneycomb(BlockPos pos, RandomSource random, LevelReader level, boolean spiderDungeon) {
        if (spiderDungeon) {
            return ProductiveBeesCompat.PBGetRottenedHoneycomb(pos, random);
        }
        return ProductiveBeesCompat.PBGetRandomHoneycomb(pos, random);
    }

    public static StructureTemplate.StructureBlockInfo PBGetRottenedHoneycomb(BlockPos worldPos, RandomSource random) {
        if (!BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants || SPIDER_DUNGEON_HONEYCOMBS.getOrFillFromInternal().isEmpty()) {
            return null;
        }
        CompoundTag newTag = new CompoundTag();
        String beeType = SPIDER_DUNGEON_HONEYCOMBS.getOrFillFromInternal().get(random.nextInt(SPIDER_DUNGEON_HONEYCOMBS.getOrFillFromInternal().size())).toString();
        newTag.putString("type", beeType);
        CompoundTag component = new CompoundTag();
        component.putString("productivebees:bee_type", beeType);
        newTag.put("components", (Tag)component);
        return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)ModBlocks.CONFIGURABLE_COMB.get()).defaultBlockState(), newTag);
    }

    public static StructureTemplate.StructureBlockInfo PBGetRandomHoneycomb(BlockPos worldPos, RandomSource random) {
        if (!BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants || BEE_DUNGEON_HONEYCOMBS.getOrFillFromInternal().isEmpty()) {
            return null;
        }
        CompoundTag newTag = new CompoundTag();
        String beeType = BEE_DUNGEON_HONEYCOMBS.getOrFillFromInternal().get(random.nextInt(BEE_DUNGEON_HONEYCOMBS.getOrFillFromInternal().size())).toString();
        newTag.putString("type", beeType);
        CompoundTag component = new CompoundTag();
        component.putString("productivebees:bee_type", beeType);
        newTag.put("components", (Tag)component);
        return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)ModBlocks.CONFIGURABLE_COMB.get()).defaultBlockState(), newTag);
    }

    public static boolean isFilledBeeCageItem(ItemStack stack) {
        return (BEE_CAGE.isPresent() && stack.is(BEE_CAGE.get()) || STURDY_BEE_CAGE.isPresent() && stack.is(STURDY_BEE_CAGE.get())) && !stack.isEmpty() && stack.has(DataComponents.CUSTOM_DATA) && ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).getUnsafe().contains("entity");
    }

    public static boolean isFilledBabyBeeCageItem(ItemStack stack) {
        return ProductiveBeesCompat.isFilledBeeCageItem(stack) && ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).getUnsafe().getInt("Age") < 0;
    }

    @Override
    public InteractionResult onEmptyBroodInteract(ItemStack itemstack, Player playerEntity, InteractionHand playerHand) {
        if (!BzModCompatibilityConfigs.allowProductiveBeesBeeCageRevivingEmptyBroodBlock) {
            return InteractionResult.PASS;
        }
        if (ProductiveBeesCompat.isFilledBeeCageItem(itemstack) && !playerEntity.isCrouching()) {
            if (!playerEntity.getAbilities().instabuild) {
                ItemStack itemToGive = ItemStack.EMPTY;
                if (STURDY_BEE_CAGE.isPresent() && itemstack.is(STURDY_BEE_CAGE.get())) {
                    itemToGive = STURDY_BEE_CAGE.get().getDefaultInstance();
                } else if (BEE_CAGE.isPresent() && itemstack.is(BEE_CAGE.get())) {
                    itemToGive = BEE_CAGE.get().getDefaultInstance();
                }
                GeneralUtils.givePlayerItem(playerEntity, playerHand, itemToGive, true, true);
            }
            return ProductiveBeesCompat.isFilledBabyBeeCageItem(itemstack) ? InteractionResult.CONSUME_PARTIAL : InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public Pair<Integer, Integer> getModdedBeePrimaryAndSecondaryColors(Entity entity) {
        ConfigurableBee configurableBee;
        if (entity instanceof ConfigurableBee && !(configurableBee = (ConfigurableBee)entity).hasBeeTexture()) {
            CompoundTag nbt = configurableBee.getNBTData();
            int primary = 15046912;
            int secondary = 2298112;
            if (nbt.contains("primaryColor")) {
                primary = nbt.getInt("primaryColor");
            }
            if (nbt.contains("secondaryColor")) {
                secondary = nbt.getInt("secondaryColor");
            }
            return Pair.of((Object)primary, (Object)secondary);
        }
        return null;
    }
}

