/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntitySpawnEvent;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.HitResult;

public interface ModCompat {
    default public EnumSet<Type> compatTypes() {
        return EnumSet.noneOf(Type.class);
    }

    default public boolean onBeeSpawn(BzEntitySpawnEvent event, boolean isBaby) {
        return false;
    }

    default public InteractionResult onEmptyBroodInteract(ItemStack itemstack, Player playerEntity, InteractionHand playerHand) {
        return InteractionResult.PASS;
    }

    default public boolean checkCombSpawn(BlockPos pos, RandomSource random, LevelReader level, boolean spiderDungeon) {
        return false;
    }

    default public StructureTemplate.StructureBlockInfo getHoneycomb(BlockPos pos, RandomSource random, LevelReader level, boolean spiderDungeon) {
        return null;
    }

    default public void onEntitySpawnInDimension(Entity entity) {
    }

    default public boolean isValidBeeHiveForTeleportation(BlockState state) {
        return false;
    }

    default public OptionalBoolean validateCombType(CompoundTag tag) {
        return OptionalBoolean.EMPTY;
    }

    default public boolean isHostBee(Entity entity) {
        return false;
    }

    default public InteractionResult isProjectileTeleportHandled(HitResult hitResult, Entity owner, Projectile projectile) {
        return InteractionResult.PASS;
    }

    default public boolean isRightClickTeleportHandled(Entity owner, ItemStack itemStack) {
        return false;
    }

    default public int getNumberOfMatchingEquippedItemsInCustomSlots(Entity entity, Predicate<ItemStack> itemStackPredicate) {
        return 0;
    }

    default public boolean isItemExplicitlyDisallowedFromBeeWearablesBoosting(ItemStack itemStack) {
        return false;
    }

    default public Pair<Integer, Integer> getModdedBeePrimaryAndSecondaryColors(Entity entity) {
        return null;
    }

    default public void restrictFlight(Entity entity, double extraGravity) {
    }

    public static enum Type {
        SPAWNS,
        EMPTY_BROOD,
        COMBS,
        DIMENSION_SPAWN,
        HIVE_TELEPORT,
        COMB_ORE,
        HAS_HOST_BEES,
        PROJECTILE_IMPACT_HANDLED,
        RIGHT_CLICKED_HIVE_HANDLED,
        CUSTOM_EQUIPMENT_SLOTS,
        BEE_WEARABLES_BOOSTING,
        BEE_COLOR,
        HEAVY_AIR_RESTRICTED;

    }
}

