/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.menus;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.items.BuzzingBriefcase;
import com.telepathicgrunt.the_bumblezone.mixin.entities.BeeEntityInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzMenuTypes;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class BuzzingBriefcaseMenu
extends AbstractContainerMenu {
    public static final int RELEASE_ID = 0;
    public static final int HEALTH_ID = 1;
    public static final int STINGER_ID = 2;
    public static final int GROW_UP_ID = 3;
    public static final int POLLEN_ID = 4;
    public static final int NUMBER_OF_BUTTONS = 5;
    public final Player player;
    public final Slot briefcaseSlot;
    private final Container container = new SimpleContainer(this, 1){};

    public BuzzingBriefcaseMenu(int id, Inventory inventory, ItemStack briefcaseItem) {
        super((MenuType)BzMenuTypes.BUZZING_BRIEFCASE.get(), id);
        this.player = inventory.player;
        this.briefcaseSlot = this.addSlot(new Slot(this, this.container, 0, Integer.MIN_VALUE, Integer.MIN_VALUE){});
        this.briefcaseSlot.set(briefcaseItem);
    }

    public BuzzingBriefcaseMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ItemStack.EMPTY);
    }

    public ItemStack quickMoveStack(Player player, int i) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return player.getMainHandItem().is((Item)BzItems.BUZZING_BRIEFCASE.get()) || player.getOffhandItem().is((Item)BzItems.BUZZING_BRIEFCASE.get());
    }

    public boolean clickMenuButton(Player player, int id) {
        Entity entity;
        if (id < 0) {
            return false;
        }
        int numberOfButtons = 5;
        int beeIndex = id / numberOfButtons;
        int buttonPressed = id % numberOfButtons;
        Inventory inventory = player.getInventory();
        ItemStack briefcase = this.container.getItem(0);
        List<Entity> beesStored = BuzzingBriefcase.getBeesStored(player.level(), briefcase, false);
        if (beeIndex < beesStored.size() && (entity = beesStored.get(beeIndex)) instanceof Bee) {
            int pollenSlotIndex;
            ItemStack playerPollenStack;
            Bee bee = (Bee)entity;
            if (buttonPressed == 0) {
                BuzzingBriefcase.dumpBees(player, beeIndex, true);
                this.container.setChanged();
                return true;
            }
            if (buttonPressed == 1 && bee.getHealth() < bee.getMaxHealth()) {
                int honeyBottleSlotIndex = inventory.findSlotMatchingItem(Items.HONEY_BOTTLE.getDefaultInstance());
                ItemStack playerHoneyBottleStack = inventory.getItem(honeyBottleSlotIndex);
                if (!playerHoneyBottleStack.isEmpty()) {
                    bee.heal(2.0f);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ((GenericTrigger)((Object)BzCriterias.BUZZING_BRIEFCASE_HEAL_TRIGGER.get())).trigger(serverPlayer);
                    }
                    if (!player.getAbilities().instabuild) {
                        playerHoneyBottleStack.shrink(1);
                        if (playerHoneyBottleStack.isEmpty()) {
                            inventory.add(honeyBottleSlotIndex, Items.GLASS_BOTTLE.getDefaultInstance());
                        } else if (!inventory.add(Items.GLASS_BOTTLE.getDefaultInstance())) {
                            player.drop(Items.GLASS_BOTTLE.getDefaultInstance(), false);
                        }
                    }
                    BuzzingBriefcase.overrwriteBees(briefcase, beesStored);
                    this.container.setChanged();
                    return true;
                }
            } else if (buttonPressed == 2 && bee.hasStung()) {
                int stingerSlotIndex = inventory.findSlotMatchingItem(((Item)BzItems.BEE_STINGER.get()).getDefaultInstance());
                ItemStack playerStingerStack = inventory.getItem(stingerSlotIndex);
                if (!playerStingerStack.isEmpty()) {
                    ((BeeEntityInvoker)bee).callSetHasStung(false);
                    if (!player.getAbilities().instabuild) {
                        playerStingerStack.shrink(1);
                    }
                    BuzzingBriefcase.overrwriteBees(briefcase, beesStored);
                    this.container.setChanged();
                    return true;
                }
            } else if (buttonPressed == 3 && bee.isBaby()) {
                int honeyBottleSlotIndex = inventory.findSlotMatchingItem(Items.HONEY_BOTTLE.getDefaultInstance());
                ItemStack playerHoneyBottleStack = inventory.getItem(honeyBottleSlotIndex);
                if (!playerHoneyBottleStack.isEmpty()) {
                    bee.setBaby(false);
                    if (!player.getAbilities().instabuild) {
                        playerHoneyBottleStack.shrink(1);
                        if (playerHoneyBottleStack.isEmpty()) {
                            inventory.add(honeyBottleSlotIndex, Items.GLASS_BOTTLE.getDefaultInstance());
                        } else if (!inventory.add(Items.GLASS_BOTTLE.getDefaultInstance())) {
                            player.drop(Items.GLASS_BOTTLE.getDefaultInstance(), false);
                        }
                    }
                    BuzzingBriefcase.overrwriteBees(briefcase, beesStored);
                    this.container.setChanged();
                    return true;
                }
            } else if (buttonPressed == 4 && !bee.hasNectar() && !(playerPollenStack = inventory.getItem(pollenSlotIndex = inventory.findSlotMatchingItem(((Item)BzItems.POLLEN_PUFF.get()).getDefaultInstance()))).isEmpty()) {
                ((BeeEntityInvoker)bee).callSetHasNectar(true);
                if (!player.getAbilities().instabuild) {
                    playerPollenStack.shrink(1);
                }
                BuzzingBriefcase.overrwriteBees(briefcase, beesStored);
                this.container.setItem(0, briefcase);
                return true;
            }
        }
        return false;
    }
}

