/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.recipes;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.PotionCandleBlockEntity;
import com.telepathicgrunt.the_bumblezone.blocks.datamanagers.PotionCandleDataManager;
import com.telepathicgrunt.the_bumblezone.mixin.containers.ShapedRecipePatternAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzRecipes;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.NotImplementedException;

public class PotionCandleRecipe
extends CustomRecipe
implements CraftingRecipe {
    private final String group;
    private final CraftingBookCategory category;
    private final int outputCount;
    private final int maxAllowedPotions;
    private final NonNullList<Ingredient> shapedRecipeItems;
    private final NonNullList<Ingredient> shapelessRecipeItems;
    private final ItemStack result;
    private final int width;
    private final int height;
    private final boolean allowNormalPotions;
    private final boolean allowSplashPotions;
    private final boolean allowLingeringPotions;
    private final int maxLevelCap;

    public PotionCandleRecipe(CraftingBookCategory category, String group, int outputCount, int maxAllowedPotions, NonNullList<Ingredient> shapedRecipeItems, NonNullList<Ingredient> shapelessRecipeItems, int width, int height, boolean allowNormalPotions, boolean allowSplashPotions, boolean allowLingeringPotions, int maxLevelCap) {
        super(category);
        this.group = group;
        this.category = category;
        this.outputCount = outputCount;
        this.maxAllowedPotions = maxAllowedPotions;
        this.shapedRecipeItems = shapedRecipeItems;
        this.shapelessRecipeItems = shapelessRecipeItems;
        this.result = PotionCandleRecipe.getResultStack(outputCount);
        this.width = width;
        this.height = height;
        this.allowNormalPotions = allowNormalPotions;
        this.allowSplashPotions = allowSplashPotions;
        this.allowLingeringPotions = allowLingeringPotions;
        this.maxLevelCap = maxLevelCap;
    }

    public int getMaxAllowedPotions() {
        return this.maxAllowedPotions;
    }

    public boolean getAllowNormalPotions() {
        return this.allowNormalPotions;
    }

    public boolean getAllowSplashPotions() {
        return this.allowSplashPotions;
    }

    public boolean getAllowLingeringPotions() {
        return this.allowLingeringPotions;
    }

    public int getMaxLevelCap() {
        return this.maxLevelCap;
    }

    public NonNullList<Ingredient> getShapedRecipeItems() {
        return this.shapedRecipeItems;
    }

    public NonNullList<Ingredient> getShapelessRecipeItems() {
        return this.shapelessRecipeItems;
    }

    private static ItemStack getResultStack(int outputCountIn) {
        ItemStack stack = ((Item)BzItems.POTION_CANDLE.get()).getDefaultInstance();
        stack.setCount(outputCountIn);
        return stack;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ArrayList effects = new ArrayList();
        AtomicInteger maxDuration = new AtomicInteger();
        AtomicInteger amplifier = new AtomicInteger();
        AtomicInteger potionEffectsFound = new AtomicInteger();
        int splashCount = 0;
        int lingerCount = 0;
        for (int j = 0; j < craftingInput.size(); ++j) {
            ItemStack itemStack = craftingInput.getItem(j);
            if (!itemStack.is(Items.POTION) && !itemStack.is(Items.SPLASH_POTION) && !itemStack.is(Items.LINGERING_POTION)) continue;
            ((PotionContents)itemStack.get(DataComponents.POTION_CONTENTS)).getAllEffects().forEach(me -> {
                effects.add((MobEffect)me.getEffect().value());
                maxDuration.addAndGet(((MobEffect)me.getEffect().value()).isInstantenous() ? 200 : me.getDuration());
                amplifier.addAndGet(me.getAmplifier() + 1);
                potionEffectsFound.getAndIncrement();
            });
            if (itemStack.is(Items.SPLASH_POTION)) {
                ++splashCount;
            }
            if (!itemStack.is(Items.LINGERING_POTION)) continue;
            ++lingerCount;
        }
        if (effects.isEmpty()) {
            return PotionCandleRecipe.getResultStack(this.outputCount);
        }
        HashSet setPicker = new HashSet(effects);
        List<MobEffect> filteredMobEffects = setPicker.stream().filter(e -> !GeneralUtils.isInTag(BuiltInRegistries.MOB_EFFECT, BzTags.DISALLOWED_POTION_CANDLE_EFFECTS, e)).toList();
        MobEffect chosenEffect = filteredMobEffects.get(new Random().nextInt(filteredMobEffects.size()));
        if (chosenEffect == null) {
            return PotionCandleRecipe.getResultStack(this.outputCount);
        }
        PotionCandleRecipe.balanceMainStats(chosenEffect, maxDuration, amplifier, potionEffectsFound);
        amplifier.set(Math.min(amplifier.get(), this.maxLevelCap));
        return PotionCandleRecipe.createTaggedPotionCandle(chosenEffect, maxDuration, amplifier, splashCount, lingerCount, this.outputCount);
    }

    public static void balanceMainStats(MobEffect chosenEffect, AtomicInteger maxDuration, AtomicInteger amplifier, AtomicInteger potionEffectsFound) {
        amplifier.set(amplifier.get() / potionEffectsFound.get());
        if (PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.containsKey(chosenEffect)) {
            PotionCandleDataManager.OverrideData overrideData = PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.get(chosenEffect);
            amplifier.set(GeneralUtils.constrainToRange(amplifier.get(), overrideData.minLevelCap(), overrideData.maxLevelCap()));
        }
        float durationBaseMultiplier = 0.4f / (0.9f * (float)potionEffectsFound.get()) + (float)amplifier.get() * 0.22f;
        float durationAdjustment = (float)potionEffectsFound.get() * durationBaseMultiplier;
        maxDuration.set((int)((float)maxDuration.get() / durationAdjustment));
        if (chosenEffect.isInstantenous()) {
            long thresholdTime = PotionCandleBlockEntity.getInstantEffectThresholdTime(amplifier.intValue());
            int activationAmounts = (int)Math.ceil((double)maxDuration.intValue() / (double)thresholdTime);
            maxDuration.set((int)((long)activationAmounts * thresholdTime));
        }
        if (PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.containsKey(chosenEffect)) {
            PotionCandleDataManager.OverrideData overrideData = PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.get(chosenEffect);
            maxDuration.set(GeneralUtils.constrainToRange(maxDuration.get(), overrideData.minBurnDurationCap() * 20, overrideData.maxBurnDurationCap() * 20));
        }
    }

    public static ItemStack createTaggedPotionCandle(MobEffect chosenEffect, AtomicInteger maxDuration, AtomicInteger amplifier, int splashCount, int lingerCount, int outputCount) {
        ItemStack resultStack = PotionCandleRecipe.getResultStack(outputCount);
        CustomData customData = (CustomData)resultStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
        CompoundTag blockEntityTag = customData.copyTag();
        blockEntityTag.putString("id", BzBlockEntities.POTION_CANDLE.getId().toString());
        blockEntityTag.putInt("color", chosenEffect.getColor());
        blockEntityTag.putInt("amplifier", amplifier.intValue());
        blockEntityTag.putInt("max_duration", maxDuration.intValue());
        blockEntityTag.putString("status", BuiltInRegistries.MOB_EFFECT.getKey((Object)chosenEffect).toString());
        blockEntityTag.putBoolean("infinite", false);
        blockEntityTag.putInt("range", 3 + splashCount * 2);
        if (chosenEffect.isInstantenous()) {
            blockEntityTag.putInt("linger_time", 1);
        } else {
            PotionCandleRecipe.setLingerTime(chosenEffect, lingerCount, blockEntityTag, 60);
        }
        if (PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.containsKey(chosenEffect)) {
            PotionCandleDataManager.OverrideData overrideData = PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.get(chosenEffect);
            overrideData.baseLingerTime().ifPresent(baseLingerTime -> PotionCandleRecipe.setLingerTime(chosenEffect, lingerCount, blockEntityTag, baseLingerTime * 20));
        }
        resultStack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)blockEntityTag));
        return resultStack;
    }

    private static void setLingerTime(MobEffect chosenEffect, int lingerCount, CompoundTag blockEntityTag, int baseLingerTime) {
        int lingerTime = baseLingerTime + lingerCount * baseLingerTime * 2;
        if (PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.containsKey(chosenEffect)) {
            PotionCandleDataManager.OverrideData overrideData = PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.get(chosenEffect);
            lingerTime = Math.min(lingerTime, overrideData.maxBurnDurationCap() * 20);
        }
        blockEntityTag.putInt("linger_time", lingerTime);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        boolean shapedMatch = false;
        for (int column = 0; column <= craftingInput.width() - this.width; ++column) {
            for (int row = 0; row <= craftingInput.height() - this.height; ++row) {
                if (this.matches(craftingInput, column, row, true)) {
                    shapedMatch = true;
                }
                if (!this.matches(craftingInput, column, row, false)) continue;
                shapedMatch = true;
            }
        }
        return shapedMatch;
    }

    private boolean matches(CraftingInput craftingInput, int width, int height, boolean mirrored) {
        int potionCount = 0;
        ArrayList<ItemStack> secondaryIngredientsFound = new ArrayList<ItemStack>();
        ObjectArrayList mobEffects = new ObjectArrayList();
        for (int column = 0; column < craftingInput.width(); ++column) {
            for (int row = 0; row < craftingInput.height(); ++row) {
                ItemStack itemStack = craftingInput.getItem(column + row * craftingInput.width());
                int k = column - width;
                int l = row - height;
                Ingredient ingredient = null;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = mirrored ? (Ingredient)this.shapedRecipeItems.get(this.width - k - 1 + l * this.width) : (Ingredient)this.shapedRecipeItems.get(k + l * this.width);
                }
                if (ingredient == null) {
                    if (itemStack.isEmpty()) continue;
                    if (itemStack.is(Items.POTION) || itemStack.is(Items.SPLASH_POTION) || itemStack.is(Items.LINGERING_POTION)) {
                        if (itemStack.is(Items.POTION) && !this.allowNormalPotions) {
                            return false;
                        }
                        if (itemStack.is(Items.SPLASH_POTION) && !this.allowSplashPotions) {
                            return false;
                        }
                        if (itemStack.is(Items.LINGERING_POTION) && !this.allowLingeringPotions) {
                            return false;
                        }
                        ArrayList currentMobEffects = new ArrayList();
                        ((PotionContents)itemStack.get(DataComponents.POTION_CONTENTS)).getAllEffects().forEach(currentMobEffects::add);
                        mobEffects.addAll(currentMobEffects);
                        if (currentMobEffects.isEmpty()) {
                            return false;
                        }
                        if (++potionCount <= this.maxAllowedPotions) continue;
                        return false;
                    }
                    secondaryIngredientsFound.add(itemStack);
                    continue;
                }
                if (ingredient.test(itemStack)) continue;
                return false;
            }
        }
        if (mobEffects.stream().allMatch(e -> e.getEffect().is(BzTags.DISALLOWED_POTION_CANDLE_EFFECTS))) {
            return false;
        }
        return potionCount > 0 && GeneralUtils.listMatches(secondaryIngredientsFound, this.shapelessRecipeItems);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)BzRecipes.POTION_CANDLE_RECIPE.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.addAll(this.shapelessRecipeItems);
        ingredients.addAll(this.shapedRecipeItems);
        return ingredients;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeType<?> getType() {
        return RecipeType.CRAFTING;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    public static class Serializer
    implements RecipeSerializer<PotionCandleRecipe> {
        private static final MapCodec<PotionCandleRecipe> CODEC = RawPotionRecipe.CODEC.flatXmap(rawShapedRecipe -> {
            String[] strings = ShapedRecipePatternAccessor.callShrink(rawShapedRecipe.shapedPattern);
            int width = strings[0].length();
            int height = strings.length;
            NonNullList shapedRecipeItems = NonNullList.withSize((int)(width * height), (Object)Ingredient.EMPTY);
            HashSet set = Sets.newHashSet(rawShapedRecipe.shapedKey.keySet());
            for (int k = 0; k < strings.length; ++k) {
                String string = strings[k];
                for (int l = 0; l < string.length(); ++l) {
                    Ingredient ingredient;
                    String string2 = string.substring(l, l + 1);
                    Ingredient ingredient2 = ingredient = string2.equals(" ") ? Ingredient.EMPTY : rawShapedRecipe.shapedKey.get(string2);
                    if (ingredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + string2 + "' but it's not defined in the shapedKey");
                    }
                    set.remove(string2);
                    shapedRecipeItems.set(l + width * k, (Object)ingredient);
                }
            }
            if (!set.isEmpty()) {
                return DataResult.error(() -> "Key defines symbols that aren't used in shapedPattern: " + String.valueOf(set));
            }
            PotionCandleRecipe potionCandleRecipe = new PotionCandleRecipe(rawShapedRecipe.category, rawShapedRecipe.group, rawShapedRecipe.resultCount(), rawShapedRecipe.maxAllowedPotions(), (NonNullList<Ingredient>)shapedRecipeItems, rawShapedRecipe.shapelessIngredients(), width, height, rawShapedRecipe.allowNormalPotions(), rawShapedRecipe.allowSplashPotions(), rawShapedRecipe.allowLingeringPotions(), rawShapedRecipe.maxLevelCap());
            return DataResult.success((Object)((Object)potionCandleRecipe));
        }, potionCandleRecipe -> {
            throw new NotImplementedException("Serializing potionCandleRecipe is not implemented yet.");
        });
        public static final StreamCodec<RegistryFriendlyByteBuf, PotionCandleRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<PotionCandleRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PotionCandleRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static PotionCandleRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf(Short.MAX_VALUE);
            String category = buffer.readUtf(Short.MAX_VALUE);
            int width = buffer.readVarInt();
            int height = buffer.readVarInt();
            NonNullList shapedRecipe = NonNullList.withSize((int)(width * height), (Object)Ingredient.EMPTY);
            shapedRecipe.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            int ingredientCount = buffer.readVarInt();
            NonNullList shapelessRecipe = NonNullList.withSize((int)ingredientCount, (Object)Ingredient.EMPTY);
            shapelessRecipe.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            int maxPotionRead = buffer.readVarInt();
            boolean allowNormalPotionsRead = buffer.readBoolean();
            boolean allowSplashPotionsRead = buffer.readBoolean();
            boolean allowLingeringPotionsRead = buffer.readBoolean();
            int maxLevelRead = buffer.readVarInt();
            int resultCountRead = buffer.readVarInt();
            return new PotionCandleRecipe(CraftingBookCategory.valueOf((String)category.toUpperCase(Locale.ROOT)), group, resultCountRead, maxPotionRead, (NonNullList<Ingredient>)shapedRecipe, (NonNullList<Ingredient>)shapelessRecipe, width, height, allowNormalPotionsRead, allowSplashPotionsRead, allowLingeringPotionsRead, maxLevelRead);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, PotionCandleRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeUtf(recipe.category.getSerializedName());
            buffer.writeVarInt(recipe.width);
            buffer.writeVarInt(recipe.height);
            for (Ingredient ingredient : recipe.shapedRecipeItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            buffer.writeVarInt(recipe.shapelessRecipeItems.size());
            for (Ingredient ingredient : recipe.shapelessRecipeItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            buffer.writeVarInt(recipe.maxAllowedPotions);
            buffer.writeBoolean(recipe.allowNormalPotions);
            buffer.writeBoolean(recipe.allowSplashPotions);
            buffer.writeBoolean(recipe.allowLingeringPotions);
            buffer.writeVarInt(recipe.maxLevelCap);
            buffer.writeVarInt(recipe.outputCount);
        }

        record RawPotionRecipe(String group, CraftingBookCategory category, Map<String, Ingredient> shapedKey, List<String> shapedPattern, NonNullList<Ingredient> shapelessIngredients, int maxAllowedPotions, boolean allowNormalPotions, boolean allowSplashPotions, boolean allowLingeringPotions, int maxLevelCap, int resultCount) {
            static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(list -> {
                String string;
                if (list.size() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
                }
                if (list.isEmpty()) {
                    return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
                }
                int length = ((String)list.get(0)).length();
                Iterator var2 = list.iterator();
                do {
                    if (!var2.hasNext()) {
                        return DataResult.success((Object)list);
                    }
                    string = (String)var2.next();
                    if (string.length() <= 3) continue;
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                } while (length == string.length());
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }, Function.identity());
            static final Codec<String> SINGLE_CHARACTER_STRING_CODEC = Codec.STRING.comapFlatMap(string -> {
                if (string.length() != 1) {
                    return DataResult.error(() -> "Invalid key tag: '" + string + "' is an invalid symbol (must be 1 character only).");
                }
                return " ".equals(string) ? DataResult.error(() -> "Invalid key tag: ' ' is a reserved symbol.") : DataResult.success((Object)String.valueOf(string.charAt(0)));
            }, String::valueOf);
            public static final MapCodec<RawPotionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("group").forGetter(potionRecipe -> potionRecipe.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(potionRecipe -> potionRecipe.category), (App)ExtraCodecs.strictUnboundedMap(SINGLE_CHARACTER_STRING_CODEC, (Codec)Ingredient.CODEC_NONEMPTY).fieldOf("shapedKey").forGetter(potionRecipe -> potionRecipe.shapedKey), (App)PATTERN_CODEC.fieldOf("shapedPattern").forGetter(potionRecipe -> potionRecipe.shapedPattern), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("shapelessExtraIngredients").flatXmap(list -> {
                Object[] ingredients = (Ingredient[])list.toArray(Ingredient[]::new);
                if (ingredients.length == 0) {
                    return DataResult.error(() -> "No ingredients for shapeless recipe");
                }
                return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
            }, DataResult::success).forGetter(shapelessRecipe -> shapelessRecipe.shapelessIngredients), (App)Codec.intRange((int)1, (int)6).fieldOf("maxAllowedPotions").forGetter(potionRecipe -> potionRecipe.maxAllowedPotions), (App)Codec.BOOL.fieldOf("allowNormalPotions").forGetter(potionRecipe -> potionRecipe.allowNormalPotions), (App)Codec.BOOL.fieldOf("allowSplashPotions").forGetter(potionRecipe -> potionRecipe.allowSplashPotions), (App)Codec.BOOL.fieldOf("allowLingeringPotions").forGetter(potionRecipe -> potionRecipe.allowLingeringPotions), (App)Codec.intRange((int)1, (int)1000000).fieldOf("maxLevelCap").forGetter(potionRecipe -> potionRecipe.maxLevelCap), (App)Codec.intRange((int)1, (int)64).fieldOf("resultCount").forGetter(potionRecipe -> potionRecipe.resultCount)).apply((Applicative)instance, RawPotionRecipe::new));
        }
    }
}

