/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceActivityData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceCooldownData;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.StemBlockAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LifeEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.lifeEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.lifeEssenceAbilityUse;

    public LifeEssence(Item.Properties properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 5104939;
    }

    @Override
    void addDescriptionComponents(List<Component> components) {
        components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_life_description_1").withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.ITALIC));
        components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_life_description_2").withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.ITALIC));
    }

    @Override
    public void applyAbilityEffects(ItemStack itemStack, Level level, ServerPlayer serverPlayer) {
        if (((long)serverPlayer.tickCount + serverPlayer.getUUID().getLeastSignificantBits()) % 10L == 0L && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (((AbilityEssenceActivityData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get())).isActive()) {
                int radius = 16;
                this.healFriendlyNearby(itemStack, (Level)serverLevel, serverPlayer, radius);
                this.growNearbyPlants(itemStack, serverLevel, serverPlayer, radius);
                this.cureEntityOfEffects(itemStack, serverPlayer, (LivingEntity)serverPlayer);
            }
        }
    }

    private void healFriendlyNearby(ItemStack itemStack, Level level, ServerPlayer serverPlayer, int radius) {
        List entities = level.getEntities((Entity)serverPlayer, new AABB(serverPlayer.getX() - (double)radius, serverPlayer.getY() - (double)radius, serverPlayer.getZ() - (double)radius, serverPlayer.getX() + (double)radius, serverPlayer.getY() + (double)radius, serverPlayer.getZ() + (double)radius));
        for (Entity entity : entities) {
            this.healFriendlyEntity(itemStack, serverPlayer, entity);
            if (!((AbilityEssenceCooldownData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get())).forcedCooldown()) continue;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void healFriendlyEntity(ItemStack stack, ServerPlayer serverPlayer, Entity entity) {
        TamableAnimal tamableAnimal;
        if (entity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).isOwnedBy((LivingEntity)serverPlayer)) {
            this.healHealth(stack, serverPlayer, (LivingEntity)tamableAnimal);
            this.cureEntityOfEffects(stack, serverPlayer, (LivingEntity)tamableAnimal);
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer2 = (ServerPlayer)entity;
            if (!serverPlayer.serverLevel().getServer().isPvpAllowed()) {
                this.healHealth(stack, serverPlayer, (LivingEntity)serverPlayer2);
                this.cureEntityOfEffects(stack, serverPlayer, (LivingEntity)serverPlayer2);
                return;
            }
        }
        if (!(entity instanceof LivingEntity)) return;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!entity.isAlliedTo((Entity)serverPlayer)) return;
        this.healHealth(stack, serverPlayer, livingEntity);
        this.cureEntityOfEffects(stack, serverPlayer, livingEntity);
    }

    private void cureEntityOfEffects(ItemStack stack, ServerPlayer serverPlayer, LivingEntity livingEntity) {
        for (MobEffectInstance effect : new ArrayList(livingEntity.getActiveEffects())) {
            if (!effect.getEffect().is(BzTags.LIFE_CURE_EFFECTS)) continue;
            livingEntity.removeEffect(effect.getEffect());
            this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
        }
    }

    private void healHealth(ItemStack stack, ServerPlayer serverPlayer, LivingEntity livingEntity) {
        if (livingEntity.getHealth() < livingEntity.getMaxHealth() && !livingEntity.isDeadOrDying()) {
            livingEntity.heal(1.0f);
            LifeEssence.spawnParticles(serverPlayer.serverLevel(), serverPlayer.position(), serverPlayer.getRandom());
            this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
        }
    }

    private void growNearbyPlants(ItemStack itemStack, ServerLevel level, ServerPlayer serverPlayer, int radius) {
        if (((AbilityEssenceCooldownData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get())).forcedCooldown()) {
            return;
        }
        BlockPos playerPos = serverPlayer.blockPosition();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        ChunkPos currentCachedChunkPos = new ChunkPos(playerPos);
        LevelChunk cachedChunk = null;
        int minX = playerPos.getX() - radius;
        int maxX = playerPos.getX() + radius;
        int minY = Math.max(level.getMinBuildHeight(), playerPos.getY() - radius);
        int maxY = Math.min(level.getMaxBuildHeight() - 1, playerPos.getY() + radius);
        int minZ = playerPos.getZ() - radius;
        int maxZ = playerPos.getZ() + radius;
        for (int x = minX; x <= maxX; ++x) {
            boolean foundValidXChunkSection = false;
            for (int z = minZ; z <= maxZ; ++z) {
                if (cachedChunk == null || currentCachedChunkPos.x != SectionPos.blockToSectionCoord((int)x) || currentCachedChunkPos.z != SectionPos.blockToSectionCoord((int)z)) {
                    currentCachedChunkPos = new ChunkPos(SectionPos.blockToSectionCoord((int)x), SectionPos.blockToSectionCoord((int)z));
                    cachedChunk = level.getChunk(currentCachedChunkPos.x, currentCachedChunkPos.z);
                }
                boolean foundValidZChunkSection = false;
                for (int y = maxY; y >= minY; --y) {
                    if (cachedChunk.getSection(cachedChunk.getSectionIndex(y)).maybeHas(a -> a.is(BzTags.LIFE_GROW_PLANTS) && !a.is(BzTags.LIFE_FORCE_DISALLOWED_GROW_PLANT))) {
                        foundValidZChunkSection = true;
                        foundValidXChunkSection = true;
                        mutableBlockPos.set(x, y, z);
                        BlockState state = cachedChunk.getBlockState((BlockPos)mutableBlockPos);
                        this.growPlantBlock(itemStack, level, serverPlayer, (BlockPos)mutableBlockPos, state);
                        if (!((AbilityEssenceCooldownData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get())).forcedCooldown()) continue;
                        return;
                    }
                    if (y == minY) continue;
                    y = Math.max(minY, SectionPos.sectionToBlockCoord((int)SectionPos.blockToSectionCoord((int)y)));
                }
                if (foundValidZChunkSection || z == maxZ) continue;
                z = Math.min(maxZ, SectionPos.sectionToBlockCoord((int)(SectionPos.blockToSectionCoord((int)z) + 1)));
            }
            if (foundValidXChunkSection || x == maxX) continue;
            x = Math.min(maxX, SectionPos.sectionToBlockCoord((int)(SectionPos.blockToSectionCoord((int)x) + 1)));
        }
    }

    private void growPlantBlock(ItemStack stack, ServerLevel level, ServerPlayer serverPlayer, BlockPos blockPos, BlockState state) {
        if (state.is(BzTags.LIFE_GROW_PLANTS) && !state.is(BzTags.LIFE_FORCE_DISALLOWED_GROW_PLANT)) {
            BonemealableBlock bonemealableBlock;
            Block block = state.getBlock();
            boolean grewBlock = false;
            if (!GeneralUtils.isPermissionAllowedAtSpot((Level)level, (Entity)serverPlayer, blockPos, true)) {
                return;
            }
            if (state.is(BzTags.LIFE_IS_DEAD_BUSH)) {
                List saplings = GeneralUtils.convertHoldersetToList(BuiltInRegistries.BLOCK.getTag(BzTags.LIFE_DEAD_BUSH_REVIVES_TO));
                saplings.removeIf(sapling -> GeneralUtils.isInTag(BuiltInRegistries.BLOCK, BzTags.LIFE_FORCE_DISALLOWED_DEAD_BUSH_REVIVES_TO, sapling));
                if (saplings.size() > 0) {
                    Block chosenSapling = (Block)saplings.get(level.random.nextInt(saplings.size()));
                    level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 2);
                    if (chosenSapling.defaultBlockState().canSurvive((LevelReader)level, blockPos)) {
                        level.setBlock(blockPos, chosenSapling.defaultBlockState(), 3);
                        grewBlock = true;
                    } else {
                        level.setBlock(blockPos, state, 2);
                    }
                }
            } else if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                if (!cropBlock.isMaxAge(state)) {
                    BlockState newState = cropBlock.getStateForAge(cropBlock.getAge(state) + 1);
                    newState = LifeEssence.copyNonAgeProperties(state, newState);
                    level.setBlock(blockPos, newState, 3);
                    grewBlock = true;
                }
            } else if (block instanceof StemBlock) {
                StemBlock stemBlock = (StemBlock)block;
                int age = (Integer)state.getValue((Property)StemBlock.AGE);
                if (age < 7) {
                    BlockState newState = (BlockState)state.setValue((Property)StemBlock.AGE, (Comparable)Integer.valueOf(age + 1));
                    newState = LifeEssence.copyNonAgeProperties(state, newState);
                    level.setBlock(blockPos, newState, 3);
                    grewBlock = true;
                } else if (age == 7 && this.doesNotHaveFruitNearby(level, stemBlock, blockPos)) {
                    state.randomTick(level, blockPos, level.getRandom());
                    grewBlock = true;
                }
            } else if (block instanceof NetherWartBlock) {
                int age = (Integer)state.getValue((Property)NetherWartBlock.AGE);
                if (age < 3) {
                    BlockState newState = (BlockState)state.setValue((Property)NetherWartBlock.AGE, (Comparable)Integer.valueOf(age + 1));
                    newState = LifeEssence.copyNonAgeProperties(state, newState);
                    level.setBlock(blockPos, newState, 3);
                    grewBlock = true;
                }
            } else if (state.is(Blocks.SWEET_BERRY_BUSH)) {
                int age = (Integer)state.getValue((Property)SweetBerryBushBlock.AGE);
                if (age < 3) {
                    BlockState newState = (BlockState)state.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(age + 1));
                    newState = LifeEssence.copyNonAgeProperties(state, newState);
                    level.setBlock(blockPos, newState, 3);
                    grewBlock = true;
                }
            } else if (block instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, blockPos, state)) {
                bonemealableBlock.performBonemeal(level, level.getRandom(), blockPos, state);
                grewBlock = true;
            } else if (!state.is(BzTags.LIFE_THREE_HIGH_PILLAR_PLANT) || !level.getBlockState(blockPos.above()).is(state.getBlock())) {
                Optional<Property> optionalProperty = state.getProperties().stream().filter(p -> p.getName().equalsIgnoreCase("age")).findAny();
                if (optionalProperty.isPresent()) {
                    Property property = optionalProperty.get();
                    if (property.getValueClass() == Integer.class && property.getPossibleValues().stream().max(Comparable::compareTo).orElse(null) != state.getValue(property)) {
                        BlockState newState = (BlockState)state.setValue(property, (Comparable)Integer.valueOf((Integer)state.getValue(property) + 1));
                        newState = LifeEssence.copyNonAgeProperties(state, newState);
                        level.setBlock(blockPos, newState, 3);
                        grewBlock = true;
                    } else if (state.is(BzTags.LIFE_THREE_HIGH_PILLAR_PLANT)) {
                        grewBlock = LifeEssence.growUpOneToThreeHighLimit(level, blockPos, state);
                    }
                } else if (state.is(BzTags.LIFE_THREE_HIGH_PILLAR_PLANT)) {
                    grewBlock = LifeEssence.growUpOneToThreeHighLimit(level, blockPos, state);
                }
            }
            if (grewBlock) {
                LifeEssence.spawnParticles(serverPlayer.serverLevel(), serverPlayer.position(), serverPlayer.getRandom());
                if (level.getRandom().nextFloat() < 0.4f) {
                    this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
                }
            }
        }
    }

    @NotNull
    private static BlockState copyNonAgeProperties(BlockState oldState, BlockState newState) {
        for (Property property : newState.getProperties()) {
            if (property.getName().equalsIgnoreCase("age")) continue;
            newState = LifeEssence.copyProperty(oldState, newState, property);
        }
        return newState;
    }

    @NotNull
    private static <T extends Comparable<T>> BlockState copyProperty(BlockState state, BlockState newState, Property<T> propertyToCopy) {
        if (newState.hasProperty(propertyToCopy) && state.hasProperty(propertyToCopy)) {
            newState = (BlockState)newState.setValue(propertyToCopy, state.getValue(propertyToCopy));
        }
        return newState;
    }

    private static boolean growUpOneToThreeHighLimit(ServerLevel level, BlockPos blockPos, BlockState state) {
        int aboveOffset;
        int currentHeight = 1;
        for (aboveOffset = 1; level.getBlockState(blockPos.above(aboveOffset)).is(state.getBlock()) && aboveOffset <= 3 && currentHeight <= 3; ++aboveOffset, ++currentHeight) {
        }
        for (int belowOffset = 1; level.getBlockState(blockPos.below(belowOffset)).is(state.getBlock()) && belowOffset <= 3 && currentHeight <= 3; ++belowOffset, ++currentHeight) {
        }
        if (currentHeight < 3 && level.getBlockState(blockPos.above(aboveOffset)).isAir()) {
            level.setBlock(blockPos.above(aboveOffset), state.getBlock().defaultBlockState(), 3);
            return true;
        }
        return false;
    }

    private boolean doesNotHaveFruitNearby(ServerLevel level, StemBlock stemblock, BlockPos blockPos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState neighborState = level.getBlockState(blockPos.relative(direction));
            if (!neighborState.is(((StemBlockAccessor)stemblock).getFruit())) continue;
            return false;
        }
        return true;
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random) {
        world.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, location.x(), location.y() + 1.0, location.z(), 2, random.nextGaussian() * 0.2, random.nextGaussian() * 0.25 + 0.1, random.nextGaussian() * 0.2, (double)random.nextFloat() * 0.2 + (double)0.1f);
    }
}

