/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceActivityData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.KnowingEssenceStructureData;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.mixin.entities.FoxAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public class KnowingEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.knowingEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.knowingEssenceAbilityUse;
    private static final int RED = 0xF90000;
    private static final int ORANGE = 0xFF8800;
    private static final int YELLOW = 0xFFF600;
    private static final int GREEN = 3931904;
    private static final int CYAN = 57564;
    private static final int PURPLE = 13238501;
    private static final int WHITE = 0xFFFCFC;
    private static final int NO_HIGHLIGHT = -1;

    public KnowingEssence(Item.Properties properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (itemStack.get((DataComponentType)BzDataComponents.KNOWING_ESSENCE_STRUCTURE_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.KNOWING_ESSENCE_STRUCTURE_DATA.get(), (Object)new KnowingEssenceStructureData());
        }
        super.verifyComponentsAfterLoad(itemStack);
    }

    @Override
    public int getColor() {
        return 15737343;
    }

    @Override
    void addDescriptionComponents(List<Component> components) {
        components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_knowing_description_1").withStyle(ChatFormatting.DARK_PURPLE).withStyle(ChatFormatting.ITALIC));
        components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_knowing_description_2").withStyle(ChatFormatting.DARK_PURPLE).withStyle(ChatFormatting.ITALIC));
    }

    @Override
    public void rechargeAbilityEntirely(ItemStack stack) {
        this.setAbilityUseRemaining(stack, this.getMaxAbilityUseAmount());
    }

    @Override
    public void applyAbilityEffects(ItemStack itemStack, Level level, ServerPlayer serverPlayer) {
        AbilityEssenceActivityData abilityEssenceActivityData = (AbilityEssenceActivityData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get());
        if (abilityEssenceActivityData.isActive()) {
            if (((long)serverPlayer.tickCount + serverPlayer.getUUID().getLeastSignificantBits()) % 5L == 0L) {
                KnowingEssence.spawnParticles(serverPlayer.serverLevel(), serverPlayer.position(), serverPlayer.getRandom());
            }
            if (((long)serverPlayer.tickCount + serverPlayer.getUUID().getLeastSignificantBits()) % 20L == 0L) {
                this.decrementAbilityUseRemaining(itemStack, serverPlayer, 1);
                if (BzGeneralConfigs.knowingEssenceStructureNameServer) {
                    StructureManager structureManager = ((ServerLevel)level).structureManager();
                    List structureStarts = structureManager.startsForStructure(new ChunkPos(serverPlayer.blockPosition()), s -> true);
                    ArrayList<Structure> structures = new ArrayList<Structure>();
                    Registry structureRegistry = (Registry)level.registryAccess().registry(Registries.STRUCTURE).get();
                    for (StructureStart structureStart : structureStarts) {
                        if (!structureStart.getBoundingBox().isInside((Vec3i)serverPlayer.blockPosition()) || GeneralUtils.isInTag(structureRegistry, BzTags.KNOWING_PREVENT_DISPLAYING_NAME, structureStart.getStructure())) continue;
                        structures.add(structureStart.getStructure());
                    }
                    if (!structures.isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        int structureCount = 0;
                        for (Structure structure : structures) {
                            if (structureCount > 0) {
                                stringBuilder.append(" ");
                            }
                            stringBuilder.append(structureRegistry.getKey((Object)structure));
                            ++structureCount;
                        }
                        itemStack.set((DataComponentType)BzDataComponents.KNOWING_ESSENCE_STRUCTURE_DATA.get(), (Object)new KnowingEssenceStructureData(stringBuilder.toString()));
                    } else {
                        itemStack.set((DataComponentType)BzDataComponents.KNOWING_ESSENCE_STRUCTURE_DATA.get(), (Object)new KnowingEssenceStructureData());
                    }
                } else {
                    itemStack.set((DataComponentType)BzDataComponents.KNOWING_ESSENCE_STRUCTURE_DATA.get(), (Object)new KnowingEssenceStructureData());
                }
            }
        }
    }

    public static String GetAllStructure(ItemStack itemStack) {
        return ((KnowingEssenceStructureData)itemStack.get((DataComponentType)BzDataComponents.KNOWING_ESSENCE_STRUCTURE_DATA.get())).inStructures();
    }

    public static boolean IsKnowingEssenceActive(Player player) {
        if (player != null) {
            ItemStack offHandItem = player.getOffhandItem();
            return offHandItem.is((Item)BzItems.ESSENCE_KNOWING.get()) && ((AbilityEssenceActivityData)offHandItem.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get())).isActive();
        }
        return false;
    }

    public static boolean IsValidEntityToGlow(Entity entity, Player player) {
        return KnowingEssence.GetTeamColor(entity, player) != -1;
    }

    public static int GetTeamColor(Entity entity, Player player) {
        Fox fox;
        OwnableEntity ownableEntity;
        EntityType entityType = entity.getType();
        if (entityType.is(BzTags.KNOWING_ENTITY_PREVENT_HIGHLIGHTING)) {
            return -1;
        }
        if (entityType.is(BzTags.KNOWING_ENTITY_FORCED_WHITE_HIGHLIGHT)) {
            return 0xFFFCFC;
        }
        if (entityType.is(BzTags.KNOWING_ENTITY_FORCED_PURPLE_HIGHLIGHT)) {
            return 13238501;
        }
        if (entityType.is(BzTags.KNOWING_ENTITY_FORCED_CYAN_HIGHLIGHT)) {
            return 57564;
        }
        if (entityType.is(BzTags.KNOWING_ENTITY_FORCED_GREEN_HIGHLIGHT)) {
            return 3931904;
        }
        if (entityType.is(BzTags.KNOWING_ENTITY_FORCED_YELLOW_HIGHLIGHT)) {
            return 0xFFF600;
        }
        if (entityType.is(BzTags.KNOWING_ENTITY_FORCED_ORANGE_HIGHLIGHT)) {
            return 0xFF8800;
        }
        if (entityType.is(BzTags.KNOWING_ENTITY_FORCED_RED_HIGHLIGHT)) {
            return 0xF90000;
        }
        if (entityType.is(BzTags.BOSSES)) {
            if (BzClientConfigs.knowingEssenceHighlightBosses) {
                return 13238501;
            }
        } else if (entity instanceof Enemy) {
            if (BzClientConfigs.knowingEssenceHighlightMonsters) {
                return 0xF90000;
            }
        } else if (entity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)entity).getOwnerUUID() != null && ownableEntity.getOwnerUUID().equals(player.getUUID())) {
            if (BzClientConfigs.knowingEssenceHighlightTamed) {
                return 3931904;
            }
        } else if (entity instanceof Fox && ((FoxAccessor)(fox = (Fox)entity)).callTrusts(player.getUUID())) {
            if (BzClientConfigs.knowingEssenceHighlightTamed) {
                return 3931904;
            }
        } else if (entity instanceof LivingEntity) {
            if (BzClientConfigs.knowingEssenceHighlightLivingEntities) {
                return 0xFF8800;
            }
        } else if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack itemStack = itemEntity.getItem();
            if (itemStack.getRarity() == Rarity.COMMON) {
                if (BzClientConfigs.knowingEssenceHighlightCommonItems) {
                    return 0xFFFCFC;
                }
            } else if (itemStack.getRarity() == Rarity.UNCOMMON) {
                if (BzClientConfigs.knowingEssenceHighlightUncommonItems) {
                    return 0xFFF600;
                }
            } else if (itemStack.getRarity() == Rarity.RARE) {
                if (BzClientConfigs.knowingEssenceHighlightRareItems) {
                    return 57564;
                }
            } else if (itemStack.getRarity() == Rarity.EPIC && BzClientConfigs.knowingEssenceHighlightEpicItems) {
                return 13238501;
            }
        }
        return -1;
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random) {
        world.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, location.x(), location.y() + 1.0, location.z(), 1, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1 + 0.1, random.nextGaussian() * 0.1, (double)random.nextFloat() * 0.3 + (double)0.1f);
    }
}

