/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceAbilityData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceActivityData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceCooldownData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceLastChargeData;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.mixin.gameplay.CooldownInstanceAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.gameplay.ItemCooldownsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class AbilityEssenceItem
extends Item
implements ItemExtension {
    private final Supplier<Integer> cooldownTickLength;
    private final Supplier<Integer> abilityUseAmount;

    public AbilityEssenceItem(Item.Properties properties, Supplier<Integer> cooldownTickLength, Supplier<Integer> abilityUseAmount) {
        super(properties.component((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ABILITY_DATA.get(), (Object)new AbilityEssenceAbilityData()).component((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get(), (Object)new AbilityEssenceCooldownData()).component((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get(), (Object)new AbilityEssenceActivityData()).component((DataComponentType)BzDataComponents.ABILITY_ESSENCE_LAST_CHARGE_DATA.get(), (Object)new AbilityEssenceLastChargeData()));
        this.cooldownTickLength = cooldownTickLength;
        this.abilityUseAmount = abilityUseAmount;
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ABILITY_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ABILITY_DATA.get(), (Object)new AbilityEssenceAbilityData());
        }
        if (itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get(), (Object)new AbilityEssenceCooldownData());
        }
        if (itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get(), (Object)new AbilityEssenceActivityData());
        }
        if (itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_LAST_CHARGE_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_LAST_CHARGE_DATA.get(), (Object)new AbilityEssenceLastChargeData());
        }
    }

    public abstract int getColor();

    public int getCooldownTickLength() {
        return this.cooldownTickLength.get();
    }

    public void incrementCooldownTime(ItemStack itemStack) {
        AbilityEssenceCooldownData abilityEssenceCooldownData = (AbilityEssenceCooldownData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get());
        if (abilityEssenceCooldownData.forcedCooldown()) {
            int currentCooldownTime = abilityEssenceCooldownData.cooldownTime();
            if (currentCooldownTime < this.cooldownTickLength.get()) {
                itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get(), (Object)new AbilityEssenceCooldownData(currentCooldownTime + 1, true));
            } else {
                itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get(), (Object)new AbilityEssenceCooldownData(0, false));
                this.rechargeAbilityEntirely(itemStack);
            }
        }
    }

    public void setDepleted(ItemStack itemStack, ServerPlayer serverPlayer, boolean vanillaItemCooldown) {
        itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get(), (Object)new AbilityEssenceCooldownData(0, true));
        AbilityEssenceActivityData abilityEssenceAbilityData = (AbilityEssenceActivityData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get());
        itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get(), (Object)new AbilityEssenceActivityData(abilityEssenceAbilityData.isInInventory(), false, abilityEssenceAbilityData.isLocked()));
        if (vanillaItemCooldown) {
            serverPlayer.getCooldowns().addCooldown((Item)this, this.getCooldownTickLength());
        }
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int i, boolean bl) {
        if (itemStack.is(BzTags.ABILITY_ESSENCE_ITEMS) && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            AbilityEssenceActivityData abilityEssenceActivityData = (AbilityEssenceActivityData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get());
            boolean isInInventory = abilityEssenceActivityData.isInInventory();
            boolean isLocked = abilityEssenceActivityData.isLocked();
            boolean isActive = abilityEssenceActivityData.isActive();
            AbilityEssenceCooldownData abilityEssenceCooldownData = (AbilityEssenceCooldownData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get());
            int cooldownTime = abilityEssenceCooldownData.cooldownTime();
            boolean forcedCooldown = abilityEssenceCooldownData.forcedCooldown();
            if (!isInInventory) {
                isInInventory = true;
            }
            if (!EssenceOfTheBees.hasEssence(serverPlayer)) {
                itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get(), (Object)new AbilityEssenceActivityData(isInInventory, false, true));
                return;
            }
            if (isLocked) {
                isLocked = false;
            }
            if (forcedCooldown) {
                if (!serverPlayer.getCooldowns().isOnCooldown(itemStack.getItem())) {
                    serverPlayer.getCooldowns().addCooldown(itemStack.getItem(), this.getCooldownTickLength() - cooldownTime);
                }
                this.incrementCooldownTime(itemStack);
            } else if (serverPlayer.getCooldowns().isOnCooldown(itemStack.getItem())) {
                ItemCooldowns.CooldownInstance cooldownInstance = ((ItemCooldownsAccessor)serverPlayer.getCooldowns()).getCooldowns().get(itemStack.getItem());
                int tempCooldownTime = ((ItemCooldownsAccessor)serverPlayer.getCooldowns()).getTickCount() - ((CooldownInstanceAccessor)cooldownInstance).getStartTime();
                if (tempCooldownTime > 5) {
                    forcedCooldown = true;
                    cooldownTime = tempCooldownTime;
                    isActive = false;
                }
            } else if (serverPlayer.getOffhandItem() == itemStack) {
                if (!isActive) {
                    isActive = true;
                }
                this.applyAbilityEffects(itemStack, level, serverPlayer);
            } else {
                this.rechargeAbilitySlowly(itemStack, serverPlayer);
                if (isActive) {
                    isActive = false;
                }
            }
            if (abilityEssenceActivityData.isDifferent(isInInventory, isActive, isLocked)) {
                itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get(), (Object)new AbilityEssenceActivityData(isInInventory, isActive, isLocked));
            }
            if (abilityEssenceCooldownData.isDifferent(cooldownTime, forcedCooldown)) {
                itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get(), (Object)new AbilityEssenceCooldownData(cooldownTime, forcedCooldown));
            }
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> components, TooltipFlag tooltipFlag) {
        AbilityEssenceActivityData abilityEssenceActivityData = (AbilityEssenceActivityData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get());
        if (abilityEssenceActivityData.isLocked()) {
            components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_locked").withStyle(ChatFormatting.DARK_RED));
            components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_locked_description_1").withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_locked_description_2").withStyle(ChatFormatting.GRAY));
        } else if (abilityEssenceActivityData.isActive()) {
            components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_active").withStyle(ChatFormatting.RED));
            components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_usage", (Object[])new Object[]{this.getAbilityUseRemaining(itemStack), this.getMaxAbilityUseAmount()}).withStyle(ChatFormatting.YELLOW));
            components.add((Component)Component.empty());
            this.addDescriptionComponents(components);
            return;
        }
        AbilityEssenceCooldownData abilityEssenceCooldownData = (AbilityEssenceCooldownData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get());
        int cooldownTime = abilityEssenceCooldownData.cooldownTime();
        boolean forcedCooldown = abilityEssenceCooldownData.forcedCooldown();
        if (forcedCooldown) {
            components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_depleted").withStyle(ChatFormatting.DARK_RED));
            components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_cooldown", (Object[])new Object[]{GeneralUtils.formatTickDurationNoMilliseconds(this.getCooldownTickLength() - cooldownTime, tooltipContext.tickRate())}).withStyle(ChatFormatting.DARK_RED));
            components.add((Component)Component.empty());
            this.addDescriptionComponents(components);
        } else {
            components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_ready").withStyle(ChatFormatting.GREEN));
            components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_usage", (Object[])new Object[]{this.getAbilityUseRemaining(itemStack), this.getMaxAbilityUseAmount()}).withStyle(ChatFormatting.YELLOW));
            components.add((Component)Component.empty());
            this.addDescriptionComponents(components);
        }
    }

    abstract void addDescriptionComponents(List<Component> var1);

    abstract void applyAbilityEffects(ItemStack var1, Level var2, ServerPlayer var3);

    public int getAbilityUseRemaining(ItemStack itemStack) {
        AbilityEssenceAbilityData abilityEssenceAbilityData = (AbilityEssenceAbilityData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ABILITY_DATA.get());
        if (abilityEssenceAbilityData.abilityUseRemaining() < 0) {
            return this.getMaxAbilityUseAmount();
        }
        return abilityEssenceAbilityData.abilityUseRemaining();
    }

    public int getMaxAbilityUseAmount() {
        return this.abilityUseAmount.get();
    }

    public void setAbilityUseRemaining(ItemStack itemStack, int abilityUseRemaining) {
        itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ABILITY_DATA.get(), (Object)new AbilityEssenceAbilityData(abilityUseRemaining));
    }

    public boolean decrementAbilityUseRemaining(ItemStack stack, ServerPlayer serverPlayer, int decreaseAmount) {
        if (serverPlayer.isCreative() || serverPlayer.isSpectator()) {
            return false;
        }
        int getRemainingUse = Math.max(this.getAbilityUseRemaining(stack) - decreaseAmount, 0);
        this.setAbilityUseRemaining(stack, getRemainingUse);
        if (getRemainingUse == 0) {
            this.setDepleted(stack, serverPlayer, false);
            return true;
        }
        return false;
    }

    public void rechargeAbilityEntirely(ItemStack stack) {
        this.setAbilityUseRemaining(stack, this.getMaxAbilityUseAmount());
    }

    public void rechargeAbilitySlowly(ItemStack itemStack, ServerPlayer serverPlayer) {
        int abilityUseRemaining = this.getAbilityUseRemaining(itemStack);
        if (abilityUseRemaining < this.getMaxAbilityUseAmount()) {
            AbilityEssenceLastChargeData abilityEssenceLastChargeData = (AbilityEssenceLastChargeData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_LAST_CHARGE_DATA.get());
            long lastChargeTime = abilityEssenceLastChargeData.lastChargeTime();
            if (lastChargeTime == 0L || (long)serverPlayer.tickCount < lastChargeTime) {
                itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_LAST_CHARGE_DATA.get(), (Object)new AbilityEssenceLastChargeData(serverPlayer.tickCount));
            } else {
                long timeFromLastCharge = (long)serverPlayer.tickCount - lastChargeTime;
                int chargeTimeIncrement = Math.max(this.getCooldownTickLength() / this.getMaxAbilityUseAmount(), 1);
                if (timeFromLastCharge % (long)chargeTimeIncrement == 0L) {
                    this.setAbilityUseRemaining(itemStack, abilityUseRemaining + 1);
                }
            }
            itemStack.set((DataComponentType)BzDataComponents.ABILITY_ESSENCE_LAST_CHARGE_DATA.get(), (Object)new AbilityEssenceLastChargeData(serverPlayer.tickCount));
        }
    }

    @Override
    public EquipmentSlot bz$getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.OFFHAND;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return this.bz$getEquipmentSlot(stack);
    }

    public boolean isBarVisible(ItemStack itemStack) {
        int remainingUse = this.getAbilityUseRemaining(itemStack);
        return remainingUse != 0 && this.getMaxAbilityUseAmount() != remainingUse;
    }

    public int getBarWidth(ItemStack itemStack) {
        float remainingUse = this.getAbilityUseRemaining(itemStack);
        float maxAmount = this.getMaxAbilityUseAmount();
        return Math.round(remainingUse / maxAmount * 13.0f);
    }

    public int getBarColor(ItemStack itemStack) {
        float remainingUse = this.getAbilityUseRemaining(itemStack);
        float maxAmount = this.getMaxAbilityUseAmount();
        float redValue = Math.max(0.0f, remainingUse / maxAmount);
        return Mth.hsvToRgb((float)(redValue / 3.0f), (float)1.0f, (float)1.0f);
    }
}

