/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.dispenserbehavior;

import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluidBlock;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.DefaultDispenseItemBehaviorInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;

public class GlassBottleDispenseBehavior
extends DefaultDispenseItemBehavior {
    public static DispenseItemBehavior DEFAULT_GLASS_BOTTLE_DISPENSE_BEHAVIOR;
    public static final DefaultDispenseItemBehavior DROP_ITEM_BEHAVIOR;

    public ItemStack execute(BlockSource source, ItemStack stack) {
        Position dispensePosition;
        BlockPos dispenseBlockPos;
        ServerLevel world = source.level();
        BlockState blockstate = world.getBlockState(dispenseBlockPos = BlockPos.containing((Position)(dispensePosition = DispenserBlock.getDispensePosition((BlockSource)source))));
        if (blockstate.getBlock() == BzBlocks.HONEYCOMB_BROOD.get()) {
            boolean deniedBeeSpawn = false;
            int stage = (Integer)blockstate.getValue((Property)HoneycombBrood.STAGE);
            if (stage == 3) {
                BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos().set((Vec3i)dispenseBlockPos);
                blockpos.move(((Direction)blockstate.getValue((Property)HoneycombBrood.FACING)).getOpposite());
                if (!world.getBlockState((BlockPos)blockpos).isSolid()) {
                    Mob beeEntity = (Mob)EntityType.BEE.create((Level)world);
                    beeEntity.moveTo((double)((float)blockpos.getX() + 0.5f), (double)blockpos.getY(), (double)((float)blockpos.getZ() + 0.5f), beeEntity.getRandom().nextFloat() * 360.0f, 0.0f);
                    beeEntity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(BlockPos.containing((Position)beeEntity.position())), MobSpawnType.TRIGGERED, null);
                    beeEntity.setBaby(true);
                    PlatformHooks.finalizeSpawn(beeEntity, (ServerLevelAccessor)world, null, MobSpawnType.DISPENSER);
                    boolean bl = deniedBeeSpawn = !world.addFreshEntity((Entity)beeEntity);
                }
            }
            if (!deniedBeeSpawn) {
                world.setBlockAndUpdate(dispenseBlockPos, (BlockState)((Block)BzBlocks.EMPTY_HONEYCOMB_BROOD.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)blockstate.getValue((Property)BlockStateProperties.FACING))));
                stack.shrink(1);
                if (!stack.isEmpty()) {
                    GlassBottleDispenseBehavior.addHoneyBottleToDispenser(source, Items.HONEY_BOTTLE);
                } else {
                    stack = new ItemStack((ItemLike)Items.HONEY_BOTTLE);
                }
            }
        } else if (blockstate.getBlock() == BzBlocks.FILLED_POROUS_HONEYCOMB.get()) {
            world.setBlockAndUpdate(dispenseBlockPos, ((Block)BzBlocks.POROUS_HONEYCOMB.get()).defaultBlockState());
            stack.shrink(1);
            if (!stack.isEmpty()) {
                GlassBottleDispenseBehavior.addHoneyBottleToDispenser(source, Items.HONEY_BOTTLE);
            } else {
                stack = new ItemStack((ItemLike)Items.HONEY_BOTTLE);
            }
        } else if (blockstate.getBlock() == BzFluids.SUGAR_WATER_BLOCK.get() || blockstate.getBlock() == BzBlocks.HONEY_CRYSTAL.get() && ((Boolean)blockstate.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            stack.shrink(1);
            if (!stack.isEmpty()) {
                GlassBottleDispenseBehavior.addHoneyBottleToDispenser(source, (Item)BzItems.SUGAR_WATER_BOTTLE.get());
            } else {
                stack = new ItemStack((ItemLike)BzItems.SUGAR_WATER_BOTTLE.get());
            }
        } else if (blockstate.getBlock() == BzFluids.HONEY_FLUID_BLOCK.get() && blockstate.getFluidState().isSource()) {
            world.setBlockAndUpdate(dispenseBlockPos, (BlockState)((FlowingFluid)BzFluids.HONEY_FLUID_FLOWING.get()).defaultFluidState().createLegacyBlock().setValue((Property)HoneyFluidBlock.LEVEL, (Comparable)Integer.valueOf(5)));
            stack.shrink(1);
            if (!stack.isEmpty()) {
                GlassBottleDispenseBehavior.addHoneyBottleToDispenser(source, Items.HONEY_BOTTLE);
            } else {
                stack = new ItemStack((ItemLike)Items.HONEY_BOTTLE);
            }
        } else {
            if (DEFAULT_GLASS_BOTTLE_DISPENSE_BEHAVIOR instanceof DefaultDispenseItemBehavior) {
                return ((DefaultDispenseItemBehaviorInvoker)DEFAULT_GLASS_BOTTLE_DISPENSE_BEHAVIOR).invokeExecute(source, stack);
            }
            return DEFAULT_GLASS_BOTTLE_DISPENSE_BEHAVIOR.dispense(source, stack);
        }
        return stack;
    }

    protected void playSound(BlockSource source) {
        source.level().levelEvent(1002, source.pos(), 0);
    }

    private static void addHoneyBottleToDispenser(BlockSource source, Item item) {
        ItemStack honeyBottle;
        DispenserBlockEntity dispenser;
        if (source.blockEntity() instanceof DispenserBlockEntity && !HopperBlockEntity.addItem(null, (Container)(dispenser = source.blockEntity()), (ItemStack)(honeyBottle = new ItemStack((ItemLike)item)), null).isEmpty()) {
            DROP_ITEM_BEHAVIOR.dispense(source, honeyBottle);
        }
    }

    static {
        DROP_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior();
    }
}

