/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.CarpenterBeeBootsHangingData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.CarpenterBeeBootsMiningData;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CarpenterBeeBoots
extends BeeArmor
implements ItemExtension {
    private static final int HANGING_COOLDOWN_IN_TICKS = 10;

    public CarpenterBeeBoots(Holder<ArmorMaterial> material, ArmorItem.Type armorType, Item.Properties properties, int variant) {
        super(material, armorType, properties.component((DataComponentType)BzDataComponents.CARPENTER_BEE_BOOTS_MINING_DATA.get(), (Object)new CarpenterBeeBootsMiningData()).component((DataComponentType)BzDataComponents.CARPENTER_BEE_BOOTS_HANGING_DATA.get(), (Object)new CarpenterBeeBootsHangingData()), variant, false);
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (itemStack.get((DataComponentType)BzDataComponents.CARPENTER_BEE_BOOTS_MINING_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.CARPENTER_BEE_BOOTS_MINING_DATA.get(), (Object)new CarpenterBeeBootsMiningData());
        }
        if (itemStack.get((DataComponentType)BzDataComponents.CARPENTER_BEE_BOOTS_HANGING_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.CARPENTER_BEE_BOOTS_HANGING_DATA.get(), (Object)new CarpenterBeeBootsHangingData());
        }
    }

    @Override
    public void bz$onArmorTick(ItemStack itemStack, Level level, Player player) {
        if (player.isSpectator()) {
            return;
        }
        if (player.getCooldowns().isOnCooldown(itemStack.getItem())) {
            return;
        }
        RandomSource random = player.getRandom();
        int beeWearablesCount = BeeArmor.getBeeThemedWearablesCount((Entity)player);
        if (!level.isClientSide()) {
            CarpenterBeeBootsMiningData carpenterBeeBootsMiningData = (CarpenterBeeBootsMiningData)itemStack.get((DataComponentType)BzDataComponents.CARPENTER_BEE_BOOTS_MINING_DATA.get());
            int itemId = CarpenterBeeBoots.generateUniqueItemId(level, random, carpenterBeeBootsMiningData.itemStackId());
            int lastSentState = carpenterBeeBootsMiningData.lastSentState();
            int miningStartTime = carpenterBeeBootsMiningData.miningStartTime();
            double xInBlock = Math.abs(player.position().x()) % 1.0;
            double zInBlock = Math.abs(player.position().z()) % 1.0;
            if (player.isShiftKeyDown() && player.getLookAngle().y() < -0.9 && xInBlock > 0.2 && xInBlock < 0.8 && zInBlock > 0.2 && zInBlock < 0.8 && GeneralUtils.isPermissionAllowedAtSpot(level, (Entity)player, player.blockPosition().below(), false)) {
                belowBlockPos = BlockPos.containing((Position)player.position().add(0.0, -0.1, 0.0));
                BlockState belowBlockState = level.getBlockState(belowBlockPos);
                if (belowBlockState.is(BzTags.CARPENTER_BEE_BOOTS_MINEABLES)) {
                    if (miningStartTime == 0) {
                        miningStartTime = (int)level.getGameTime();
                    }
                    int timeDiff = (int)level.getGameTime() - miningStartTime;
                    float miningProgress = timeDiff + 1;
                    float blockDestroyTime = belowBlockState.getDestroySpeed((BlockGetter)level, belowBlockPos);
                    float playerMiningSpeed = CarpenterBeeBoots.getPlayerDestroySpeed(player, (float)(beeWearablesCount - 1) * 0.1f + 0.3f);
                    int finalMiningProgress = (int)(miningProgress * playerMiningSpeed / blockDestroyTime);
                    if (!(finalMiningProgress == 0 && playerMiningSpeed < 0.001f || finalMiningProgress == lastSentState)) {
                        level.destroyBlockProgress(itemId, belowBlockPos, finalMiningProgress);
                        lastSentState = finalMiningProgress;
                    }
                    if (finalMiningProgress >= 10) {
                        level.destroyBlockProgress(itemId, belowBlockPos, -1);
                        BlockState state = level.getBlockState(belowBlockPos);
                        BlockEntity entity = level.getBlockEntity(belowBlockPos);
                        if (PlatformHooks.sendBlockBreakEvent(level, belowBlockPos, state, entity, player)) {
                            return;
                        }
                        boolean blockBroken = level.destroyBlock(belowBlockPos, false, (Entity)player);
                        if (blockBroken) {
                            BlockEntity blockEntity = belowBlockState.hasBlockEntity() ? level.getBlockEntity(belowBlockPos) : null;
                            belowBlockState.getBlock().playerDestroy(level, player, belowBlockPos, belowBlockState, blockEntity, itemStack);
                            if ((double)random.nextFloat() < 0.045) {
                                itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.FEET);
                            }
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                serverPlayer.awardStat((ResourceLocation)BzStats.CARPENTER_BEE_BOOTS_MINED_BLOCKS_RL.get());
                                if (serverPlayer.getStats().getValue(Stats.CUSTOM.get((Object)((ResourceLocation)BzStats.CARPENTER_BEE_BOOTS_MINED_BLOCKS_RL.get()), StatFormatter.DEFAULT)) >= 64) {
                                    ((GenericTrigger)((Object)BzCriterias.CARPENTER_BEE_BOOTS_MINED_BLOCKS_TRIGGER.get())).trigger(serverPlayer);
                                }
                            }
                            PlatformHooks.afterBlockBreakEvent(level, belowBlockPos, state, entity, player);
                        }
                        lastSentState = -1;
                        miningStartTime = 0;
                    }
                } else {
                    level.destroyBlockProgress(itemId, belowBlockPos, -1);
                    lastSentState = -1;
                    miningStartTime = 0;
                }
            } else if (lastSentState != -1) {
                belowBlockPos = BlockPos.containing((Position)player.position().add(0.0, -0.1, 0.0));
                level.destroyBlockProgress(itemId, belowBlockPos, -1);
                lastSentState = -1;
                miningStartTime = 0;
            }
            if (carpenterBeeBootsMiningData.isDifferent(itemId, lastSentState, miningStartTime)) {
                itemStack.set((DataComponentType)BzDataComponents.CARPENTER_BEE_BOOTS_MINING_DATA.get(), (Object)new CarpenterBeeBootsMiningData(itemId, lastSentState, miningStartTime));
            }
        }
        CarpenterBeeBootsHangingData carpenterBeeBootsHangingData = (CarpenterBeeBootsHangingData)itemStack.get((DataComponentType)BzDataComponents.CARPENTER_BEE_BOOTS_HANGING_DATA.get());
        long hangStartTime = carpenterBeeBootsHangingData.hangStartTime();
        long hangCooldownStartTime = carpenterBeeBootsHangingData.hangCooldownStartTime();
        if (!level.isClientSide() && hangStartTime != -1L && player.onGround()) {
            hangStartTime = -1L;
        }
        double playerDeltaY = player.getDeltaMovement().y();
        int maxHangTime = (beeWearablesCount - 1) * 22 + 35;
        if (!(player.getAbilities().flying || player.isPassenger() || player.onClimbable() || player.onGround() || player.isInWater() || player.isShiftKeyDown() || !(playerDeltaY <= 0.0) || !(playerDeltaY >= (double)-1.2f) || hangCooldownStartTime != -1L)) {
            for (float xOffset = -0.45f; xOffset <= 0.45f; xOffset += 0.45f) {
                for (float zOffset = -0.45f; zOffset <= 0.45f; zOffset += 0.45f) {
                    BlockPos posToCheck;
                    BlockState sideBlockState;
                    if (xOffset == 0.0f || zOffset == 0.0f || !(sideBlockState = level.getBlockState(posToCheck = BlockPos.containing((Position)player.position().add((double)xOffset, (double)0.057f, (double)zOffset)))).is(BzTags.CARPENTER_BEE_BOOTS_CLIMBABLES)) continue;
                    double newDeltaY = Math.min(playerDeltaY * 0.9 + 0.07, -0.0055);
                    player.setDeltaMovement(new Vec3(player.getDeltaMovement().x(), newDeltaY, player.getDeltaMovement().z()));
                    if (newDeltaY >= (double)-0.0135f) {
                        player.setJumping(false);
                        player.setOnGround(true);
                    }
                    if (newDeltaY >= (double)-0.4f) {
                        player.fallDistance = 0.0f;
                    }
                    if (!level.isClientSide()) {
                        if (hangStartTime == -1L) {
                            hangStartTime = level.getGameTime();
                        }
                        if (level.getGameTime() - hangStartTime >= (long)maxHangTime) {
                            hangCooldownStartTime = 10L;
                            hangStartTime = 0L;
                        } else if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            serverPlayer.awardStat((ResourceLocation)BzStats.CARPENTER_BEE_BOOTS_WALL_HANG_TIME_RL.get());
                            if (serverPlayer.getStats().getValue(Stats.CUSTOM.get((Object)((ResourceLocation)BzStats.CARPENTER_BEE_BOOTS_WALL_HANG_TIME_RL.get()), StatFormatter.DEFAULT)) >= 4000) {
                                ((GenericTrigger)((Object)BzCriterias.CARPENTER_BEE_BOOTS_WALL_HANGING_TRIGGER.get())).trigger(serverPlayer);
                            }
                        }
                    }
                    if (!((double)random.nextFloat() < 0.001)) continue;
                    itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.FEET);
                }
            }
        } else if (!level.isClientSide() && hangCooldownStartTime != -1L && hangCooldownStartTime + 10L > level.getGameTime()) {
            hangCooldownStartTime = -1L;
        }
        if (carpenterBeeBootsHangingData.isDifferent(hangStartTime, hangCooldownStartTime)) {
            itemStack.set((DataComponentType)BzDataComponents.CARPENTER_BEE_BOOTS_HANGING_DATA.get(), (Object)new CarpenterBeeBootsHangingData(hangStartTime, hangCooldownStartTime));
        }
    }

    public static float getPlayerDestroySpeed(Player player, float currentSpeed) {
        if (currentSpeed > 1.0f) {
            currentSpeed += (float)player.getAttributeValue(Attributes.MINING_EFFICIENCY);
        }
        if (MobEffectUtil.hasDigSpeed((LivingEntity)player)) {
            currentSpeed *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.hasEffect(BzEffects.BEENERGIZED.holder())) {
            currentSpeed *= 1.0f + (float)(player.getEffect(BzEffects.BEENERGIZED.holder()).getAmplifier() + 1);
        }
        if (player.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            float miningDecrease = switch (player.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            currentSpeed *= miningDecrease;
        }
        currentSpeed *= (float)player.getAttributeValue(Attributes.BLOCK_BREAK_SPEED);
        if (player.isEyeInFluid(FluidTags.WATER)) {
            currentSpeed *= (float)player.getAttribute(Attributes.SUBMERGED_MINING_SPEED).getValue();
        }
        if (!player.onGround()) {
            currentSpeed /= 5.0f;
        }
        return currentSpeed;
    }

    private static int generateUniqueItemId(Level world, RandomSource random, int itemId) {
        block2: {
            boolean anymatch;
            if (itemId != 0 || world.isClientSide()) break block2;
            block0: do {
                anymatch = false;
                itemId = random.nextInt(Integer.MAX_VALUE);
                for (Player worldPlayer : world.players()) {
                    if (worldPlayer.getId() != itemId) continue;
                    anymatch = true;
                    continue block0;
                }
            } while (anymatch);
        }
        return itemId;
    }

    public static ItemStack getEntityBeeBoots(LivingEntity entity) {
        for (ItemStack armor : entity.getArmorSlots()) {
            if (!(armor.getItem() instanceof CarpenterBeeBoots)) continue;
            return armor;
        }
        return ItemStack.EMPTY;
    }
}

