/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.teleportation;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.entities.teleportation.BzWorldSavedData;
import com.telepathicgrunt.the_bumblezone.entities.teleportation.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityTickEvent;
import com.telepathicgrunt.the_bumblezone.events.player.BzPlayerTickEvent;
import com.telepathicgrunt.the_bumblezone.mixin.entities.PlayerAdvancementsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.EntityPosAndDimModule;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityTeleportationHookup {
    public static void playerTick(BzPlayerTickEvent event) {
        Player player = event.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (event.end()) {
                List poiInRange;
                ServerLevel serverLevel;
                Level level = serverPlayer.level();
                AdvancementHolder advancementHolder = serverPlayer.server.getAdvancements().get(BzCriterias.IS_NEAR_BEEHIVE_ADVANCEMENT);
                if (advancementHolder == null) {
                    return;
                }
                Map<AdvancementHolder, AdvancementProgress> advancementsProgressMap = ((PlayerAdvancementsAccessor)serverPlayer.getAdvancements()).getProgress();
                if (advancementsProgressMap.containsKey(advancementHolder) && advancementsProgressMap.get(advancementHolder).isDone()) {
                    return;
                }
                if (level instanceof ServerLevel && ((serverLevel = (ServerLevel)level).getGameTime() + serverPlayer.getUUID().getLeastSignificantBits()) % 100L == 0L && !serverLevel.dimension().equals(BzDimension.BZ_WORLD_KEY) && !(poiInRange = serverLevel.getPoiManager().getInSquare(pointOfInterestType -> pointOfInterestType.is(BzTags.IS_NEAR_BEEHIVE_ADVANCEMENT_TRIGGER_POI), serverPlayer.blockPosition(), 8, PoiManager.Occupancy.ANY).toList()).isEmpty()) {
                    ((GenericTrigger)((Object)BzCriterias.IS_NEAR_BEEHIVE_TRIGGER.get())).trigger(serverPlayer);
                    if (BzDimensionConfigs.enableInitialWelcomeMessage) {
                        ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(playerData -> {
                            if (!playerData.gottenWelcomed) {
                                playerData.gottenWelcomed = true;
                                serverPlayer.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.advancement_hint"), false);
                            }
                        });
                    }
                }
            }
        }
    }

    public static void entityTick(BzEntityTickEvent event) {
        LivingEntity livingEntity = event.entity();
        if (livingEntity.level().dimension().location().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            if (livingEntity.getY() < -2.0) {
                if (BzDimensionConfigs.enableExitTeleportation) {
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                        ((GenericTrigger)((Object)BzCriterias.TELEPORT_OUT_OF_BUMBLEZONE_TRIGGER.get())).trigger(serverPlayer);
                    }
                    if (livingEntity.getY() < -4.0) {
                        livingEntity.moveTo(livingEntity.getX(), -4.0, livingEntity.getZ());
                        livingEntity.absMoveTo(livingEntity.getX(), -4.0, livingEntity.getZ());
                        livingEntity.setDeltaMovement(0.0, 0.0, 0.0);
                        if (!livingEntity.level().isClientSide()) {
                            livingEntity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 12, 1, false, false, true));
                        }
                    }
                    livingEntity.fallDistance = 0.0f;
                    if (!livingEntity.level().isClientSide()) {
                        EntityTeleportationHookup.teleportOutOfBz(livingEntity);
                    }
                }
            } else if (livingEntity.getY() > 255.0 && BzDimensionConfigs.enableExitTeleportation) {
                if (livingEntity instanceof ServerPlayer) {
                    ((GenericTrigger)((Object)BzCriterias.TELEPORT_OUT_OF_BUMBLEZONE_TRIGGER.get())).trigger((ServerPlayer)livingEntity);
                }
                if (livingEntity.getY() > 257.0) {
                    livingEntity.moveTo(livingEntity.getX(), 257.0, livingEntity.getZ());
                    livingEntity.absMoveTo(livingEntity.getX(), 257.0, livingEntity.getZ());
                }
                if (!livingEntity.level().isClientSide()) {
                    EntityTeleportationHookup.teleportOutOfBz(livingEntity);
                }
            }
        }
    }

    public static void teleportOutOfBz(LivingEntity livingEntity) {
        if (!livingEntity.level().isClientSide()) {
            ServerLevel serverWorld;
            EntityTeleportationHookup.checkAndCorrectStoredDimension(livingEntity);
            MinecraftServer minecraftServer = livingEntity.getServer();
            ResourceKey worldKey = null;
            if (livingEntity.getControllingPassenger() == null) {
                capOptional = ModuleHelper.getModule((Entity)livingEntity, ModuleRegistry.ENTITY_POS_AND_DIM);
                if (capOptional.isPresent()) {
                    EntityPosAndDimModule capability = capOptional.orElseThrow(RuntimeException::new);
                    worldKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)capability.getNonBZDim());
                }
            } else {
                EntityTeleportationHookup.checkAndCorrectStoredDimension(livingEntity.getControllingPassenger());
                capOptional = ModuleHelper.getModule((Entity)livingEntity, ModuleRegistry.ENTITY_POS_AND_DIM);
                if (capOptional.isPresent()) {
                    EntityPosAndDimModule capability = capOptional.orElseThrow(RuntimeException::new);
                    worldKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)capability.getNonBZDim());
                }
            }
            ServerLevel serverLevel = serverWorld = worldKey == null ? null : minecraftServer.getLevel(worldKey);
            if (serverWorld == null) {
                serverWorld = minecraftServer.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.tryParse((String)BzDimensionConfigs.defaultDimension)));
            }
            BzWorldSavedData.queueEntityToTeleport((Entity)livingEntity, (ResourceKey<Level>)serverWorld.dimension());
        }
    }

    public static boolean runTeleportProjectileImpact(HitResult hitResult, Entity thrower, Entity projectile) {
        if (thrower == null || thrower.level() == null) {
            return false;
        }
        Level level = thrower.level();
        if (EntityTeleportationHookup.isTeleportAllowedInDimension(level, thrower)) {
            BlockHitResult blockHitResult;
            BlockState block;
            BlockPos hivePos = null;
            if (hitResult instanceof BlockHitResult && EntityTeleportationBackend.isValidBeeHive(block = level.getBlockState((blockHitResult = (BlockHitResult)hitResult).getBlockPos()))) {
                hivePos = blockHitResult.getBlockPos();
            }
            if (hivePos == null) {
                hivePos = EntityTeleportationHookup.getNearbyHivePos(hitResult.getLocation(), level);
            }
            if (hivePos == null && projectile != null) {
                hivePos = EntityTeleportationHookup.getNearbyHivePos(hitResult.getLocation().add(projectile.getDeltaMovement()), level);
            }
            if (hivePos == null) {
                return false;
            }
            boolean validBelowBlock = EntityTeleportationHookup.isValidBelowBlock(level, thrower, hivePos);
            if (validBelowBlock) {
                EntityTeleportationHookup.performProjectileBasedTeleportation(thrower, projectile);
                return true;
            }
        }
        return false;
    }

    public static boolean runEntityHitCheck(HitResult hitResult, Entity thrower, Projectile projectile) {
        if (thrower == null || thrower.level() == null) {
            return false;
        }
        Level level = thrower.level();
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            if (EntityTeleportationHookup.isTeleportAllowedInDimension(level, thrower)) {
                Entity hitEntity = entityHitResult.getEntity();
                boolean passedCheck = false;
                if (hitEntity.getType().is(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_ANYWHERE) || hitEntity.getType().is(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_HIGH) || hitEntity.getType().is(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_LOW)) {
                    Vec3 hitPos = hitResult.getLocation();
                    AABB boundBox = entityHitResult.getEntity().getBoundingBox();
                    double relativeHitY = hitPos.y() - boundBox.minY;
                    double entityBoundHeight = boundBox.maxY - boundBox.minY;
                    double minYThreshold = -2.147483648E9;
                    double maxYThreshold = 2.147483647E9;
                    if (hitEntity.getType().is(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_HIGH)) {
                        minYThreshold = entityBoundHeight / 2.0;
                    }
                    if (hitEntity.getType().is(BzTags.TARGET_ENTITY_HIT_BY_TELEPORT_PROJECTILE_HIGH)) {
                        maxYThreshold = entityBoundHeight / 2.0;
                    }
                    if (minYThreshold != maxYThreshold && (relativeHitY > maxYThreshold || relativeHitY < minYThreshold)) {
                        return false;
                    }
                    passedCheck = true;
                }
                if (hitEntity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)hitEntity;
                    for (ItemStack stack : livingEntity.getHandSlots()) {
                        if (stack == null || !stack.is(BzTags.TARGET_WITH_HELD_ITEM_HIT_BY_TELEPORT_PROJECTILE)) continue;
                        passedCheck = true;
                        break;
                    }
                    for (ItemStack stack : livingEntity.getArmorSlots()) {
                        if (stack == null || !stack.is(BzTags.TARGET_ARMOR_HIT_BY_TELEPORT_PROJECTILE)) continue;
                        passedCheck = true;
                    }
                }
                if (!passedCheck) {
                    return false;
                }
                BlockPos hivePos = entityHitResult.getEntity().blockPosition();
                boolean validBelowBlock = EntityTeleportationHookup.isValidBelowBlock(level, thrower, hivePos);
                if (validBelowBlock) {
                    EntityTeleportationHookup.performProjectileBasedTeleportation(thrower, (Entity)projectile);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean runItemUseOn(Player user, BlockPos clickedPos, ItemStack usingStack) {
        Level level = user.level();
        if (EntityTeleportationHookup.isTeleportAllowedInDimension(level, (Entity)user)) {
            ItemEnchantments enchantments;
            boolean isAllowTeleportItem;
            if (!EntityTeleportationBackend.isValidBeeHive(level.getBlockState(clickedPos))) {
                return false;
            }
            boolean bl = isAllowTeleportItem = usingStack.is(BzTags.TELEPORT_ITEM_RIGHT_CLICKED_BEEHIVE) || usingStack.is(BzTags.TELEPORT_ITEM_RIGHT_CLICKED_BEEHIVE_CROUCHING) && user.isShiftKeyDown();
            if (!isAllowTeleportItem && usingStack.has(DataComponents.ENCHANTMENTS) && (enchantments = (ItemEnchantments)usingStack.get(DataComponents.ENCHANTMENTS)) != null) {
                for (Holder enchantment : enchantments.keySet()) {
                    if (enchantment.is(BzTags.ITEM_WITH_TELEPORT_ENCHANT)) {
                        isAllowTeleportItem = true;
                        break;
                    }
                    if (!user.isShiftKeyDown() || !enchantment.is(BzTags.ITEM_WITH_TELEPORT_ENCHANT_CROUCHING)) continue;
                    isAllowTeleportItem = true;
                    break;
                }
            }
            if (!isAllowTeleportItem) {
                return false;
            }
            boolean validBelowBlock = EntityTeleportationHookup.isValidBelowBlock(level, (Entity)user, clickedPos);
            if (validBelowBlock) {
                if (user instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)user;
                    BzWorldSavedData.queueEntityToTeleport((Entity)serverPlayer, BzDimension.BZ_WORLD_KEY);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean runGenericTeleport(Player user, BlockPos targetPosition) {
        Level level = user.level();
        if (EntityTeleportationHookup.isTeleportAllowedInDimension(level, (Entity)user)) {
            if (!EntityTeleportationBackend.isValidBeeHive(level.getBlockState(targetPosition))) {
                return false;
            }
            boolean validBelowBlock = EntityTeleportationHookup.isValidBelowBlock(level, (Entity)user, targetPosition);
            if (validBelowBlock) {
                if (user instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)user;
                    BzWorldSavedData.queueEntityToTeleport((Entity)serverPlayer, BzDimension.BZ_WORLD_KEY);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isTeleportAllowedInDimension(Level level, Entity entity) {
        if (entity.isOnPortalCooldown()) {
            return false;
        }
        if (!BzDimensionConfigs.enableEntranceTeleportation || level.dimension().location().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            return false;
        }
        if (BzDimensionConfigs.onlyOverworldHivesTeleports) {
            ResourceLocation defaultDimRL = ResourceLocation.tryParse((String)BzDimensionConfigs.defaultDimension);
            ResourceKey worldKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)defaultDimRL);
            return level.dimension().equals(worldKey);
        }
        return true;
    }

    private static void performProjectileBasedTeleportation(Entity thrower, Entity projectile) {
        if (thrower instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)thrower;
            if (projectile != null) {
                if (BuiltInRegistries.ENTITY_TYPE.getKey((Object)projectile.getType()).getPath().contains("pearl")) {
                    ((GenericTrigger)((Object)BzCriterias.TELEPORT_TO_BUMBLEZONE_PEARL_TRIGGER.get())).trigger(serverPlayer);
                }
                projectile.remove(Entity.RemovalReason.DISCARDED);
            }
            BzWorldSavedData.queueEntityToTeleport(thrower, BzDimension.BZ_WORLD_KEY);
        }
    }

    private static boolean isValidBelowBlock(Level world, Entity entity, BlockPos hivePos) {
        Optional blockTag = BuiltInRegistries.BLOCK.getTag(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT);
        if (blockTag.isPresent() && !GeneralUtils.convertHoldersetToList(blockTag).isEmpty()) {
            if (world.getBlockState(hivePos.below()).is(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT)) {
                return true;
            }
            if (BzDimensionConfigs.warnPlayersOfWrongBlockUnderHive && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                Bumblezone.LOGGER.error("Bumblezone: The attempt to teleport to Bumblezone failed due to not having a block from the following block tag below the hive: the_bumblezone:required_blocks_under_hive_to_teleport");
                MutableComponent message = Component.translatable((String)"system.the_bumblezone.require_hive_blocks_failed");
                serverPlayer.displayClientMessage((Component)message, true);
            }
        } else {
            return true;
        }
        return false;
    }

    private static BlockPos getNearbyHivePos(Vec3 hitBlockPos, Level world) {
        double checkRadius = 0.5;
        for (double offset = -checkRadius; offset <= checkRadius; offset += checkRadius) {
            for (double offset2 = -checkRadius; offset2 <= checkRadius; offset2 += checkRadius) {
                for (double offset3 = -checkRadius; offset3 <= checkRadius; offset3 += checkRadius) {
                    BlockPos offsettedHitPos = BlockPos.containing((Position)hitBlockPos.add(offset, offset2, offset3));
                    BlockState block = world.getBlockState(offsettedHitPos);
                    if (!EntityTeleportationBackend.isValidBeeHive(block)) continue;
                    return offsettedHitPos;
                }
            }
        }
        return null;
    }

    public static void runPistonPushed(Direction direction, LivingEntity pushedEntity) {
        ServerLevel world = (ServerLevel)pushedEntity.level();
        if (EntityTeleportationHookup.isTeleportAllowedInDimension((Level)world, (Entity)pushedEntity)) {
            if (BzWorldSavedData.isEntityQueuedToTeleportAlready((Entity)pushedEntity)) {
                return;
            }
            BlockPos.MutableBlockPos entityPos = new BlockPos.MutableBlockPos().set((Vec3i)pushedEntity.blockPosition());
            BlockPos[] blockPositions = new BlockPos[]{entityPos, entityPos.relative(direction), entityPos.relative(Direction.UP), entityPos.relative(Direction.UP).relative(direction)};
            ArrayList<BlockState> belowHiveBlocks = new ArrayList<BlockState>();
            boolean isPushedIntoBeehive = false;
            for (BlockPos pos : blockPositions) {
                if (!EntityTeleportationBackend.isValidBeeHive(world.getBlockState(pos))) continue;
                isPushedIntoBeehive = true;
                belowHiveBlocks.add(world.getBlockState(pos.below()));
                break;
            }
            if (isPushedIntoBeehive) {
                boolean validBelowBlock = false;
                Optional blockTag = BuiltInRegistries.BLOCK.getTag(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT);
                if (blockTag.isPresent() && !GeneralUtils.convertHoldersetToList(blockTag).isEmpty()) {
                    for (BlockState belowBlock : belowHiveBlocks) {
                        if (!belowBlock.is(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT)) continue;
                        validBelowBlock = true;
                        break;
                    }
                    if (!validBelowBlock && BzDimensionConfigs.warnPlayersOfWrongBlockUnderHive) {
                        if (pushedEntity instanceof Player) {
                            Player playerEntity = (Player)pushedEntity;
                            Bumblezone.LOGGER.info("Bumblezone: The attempt to teleport to Bumblezone failed due to not having a block from the following block tag below the hive: the_bumblezone:required_blocks_under_hive_to_teleport");
                            MutableComponent message = Component.translatable((String)"system.the_bumblezone.require_hive_blocks_failed");
                            playerEntity.displayClientMessage((Component)message, true);
                        }
                        return;
                    }
                } else {
                    validBelowBlock = true;
                }
                if (validBelowBlock) {
                    if (pushedEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)pushedEntity;
                        ((GenericTrigger)((Object)BzCriterias.TELEPORT_TO_BUMBLEZONE_PISTON_TRIGGER.get())).trigger(serverPlayer);
                    }
                    BzWorldSavedData.queueEntityToTeleport((Entity)pushedEntity, BzDimension.BZ_WORLD_KEY);
                }
            }
        }
    }

    private static void checkAndCorrectStoredDimension(LivingEntity livingEntity) {
        ModuleHelper.getModule((Entity)livingEntity, ModuleRegistry.ENTITY_POS_AND_DIM).ifPresent(capability -> {
            if (capability.getNonBZDim().equals((Object)Bumblezone.MOD_DIMENSION_ID) || BzDimensionConfigs.forceExitToOverworld) {
                capability.setNonBZDim(ResourceLocation.tryParse((String)BzDimensionConfigs.defaultDimension));
            }
        });
    }
}

