/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.teleportation;

import com.google.common.primitives.Doubles;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityTravelingToDimensionEvent;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.EntityPosAndDimModule;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.utils.BzPlacingUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class EntityTeleportationBackend {
    public static Vec3 destPostFromOutOfBoundsTeleport(Entity entity, ServerLevel destination) {
        Entity player = entity.getPassengers().stream().filter(e -> e instanceof Player).findFirst().orElse(null);
        if (player != null) {
            entity = player;
        }
        Optional<EntityPosAndDimModule> capOptional = ModuleHelper.getModule(entity, ModuleRegistry.ENTITY_POS_AND_DIM);
        if (BzDimensionConfigs.forceBumblezoneOriginMobToOverworldCenter && capOptional.isPresent() && capOptional.orElseThrow(RuntimeException::new).getNonBZPos() == null) {
            destination.getChunk(BlockPos.ZERO);
            int heightMapY = destination.getHeight(Heightmap.Types.MOTION_BLOCKING, 0, 0);
            ChunkGenerator chunkGenerator = destination.getChunkSource().getGenerator();
            if (heightMapY > destination.getMinBuildHeight() && heightMapY < chunkGenerator.getMinY() + chunkGenerator.getGenDepth()) {
                return new Vec3(0.5, (double)heightMapY + 0.5, 0.5);
            }
            return new Vec3(0.5, (double)(chunkGenerator.getMinY() + chunkGenerator.getGenDepth()) / 2.0, 0.5);
        }
        Vec3 entitySavedPastPos = null;
        if (capOptional.isPresent()) {
            EntityPosAndDimModule capability = capOptional.orElseThrow(RuntimeException::new);
            entitySavedPastPos = capability.getNonBZPos().orElse(null);
        }
        BlockPos finalSpawnPos = entity.blockPosition();
        if (entitySavedPastPos != null) {
            finalSpawnPos = BlockPos.containing(entitySavedPastPos);
        }
        return new Vec3((double)finalSpawnPos.getX() + 0.5, (double)(finalSpawnPos.getY() + 1), (double)finalSpawnPos.getZ() + 0.5);
    }

    public static Vec3 getBzCoordinate(Entity entity, ServerLevel originalWorld, ServerLevel bumblezoneWorld) {
        int heightCheck;
        double coordinateScale = originalWorld.dimensionType().coordinateScale() / bumblezoneWorld.dimensionType().coordinateScale();
        BlockPos blockpos = BlockPos.containing((double)Doubles.constrainToRange((double)(entity.position().x() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), (double)Doubles.constrainToRange((double)entity.position().y(), (double)45.0, (double)200.0), (double)Doubles.constrainToRange((double)(entity.position().z() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7));
        Object validBlockPos = EntityTeleportationBackend.validPlayerSpawnLocation((Level)bumblezoneWorld, blockpos, 32);
        if (validBlockPos == null) {
            validBlockPos = new BlockPos(blockpos.getX(), BzPlacingUtils.topOfSurfaceBelowHeightThroughWater((LevelAccessor)bumblezoneWorld, blockpos.getY(), 0, blockpos) + 1, blockpos.getZ());
            if (validBlockPos.getY() == 0) {
                validBlockPos = blockpos;
            } else if (bumblezoneWorld.getBlockState(validBlockPos).getFluidState().is(FluidTags.WATER) && bumblezoneWorld.getBlockState(validBlockPos.above()).getFluidState().is(FluidTags.WATER)) {
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(validBlockPos.getX(), validBlockPos.getY(), validBlockPos.getZ());
                while (mutable.getY() < 255 && !bumblezoneWorld.isEmptyBlock((BlockPos)mutable) || bumblezoneWorld.getBlockState((BlockPos)mutable).getFluidState().is(FluidTags.WATER)) {
                    mutable.move(Direction.UP);
                }
                validBlockPos = !bumblezoneWorld.getBlockState((BlockPos)mutable).isAir() ? blockpos : mutable;
            } else if (!bumblezoneWorld.isEmptyBlock(validBlockPos) && bumblezoneWorld.getBlockState(validBlockPos).getFluidState().is(FluidTags.WATER) && !bumblezoneWorld.getBlockState(validBlockPos.above()).isAir()) {
                validBlockPos = blockpos;
            }
        }
        for (heightCheck = 0; heightCheck <= validBlockPos.getY() && bumblezoneWorld.getBlockState(validBlockPos.below(heightCheck)).isAir(); ++heightCheck) {
        }
        if (heightCheck >= validBlockPos.getY()) {
            bumblezoneWorld.setBlockAndUpdate(validBlockPos.getY() == 0 ? validBlockPos : validBlockPos.below(), Blocks.HONEYCOMB_BLOCK.defaultBlockState());
        }
        return new Vec3((double)validBlockPos.getX() + 0.5, (double)validBlockPos.getY(), (double)validBlockPos.getZ() + 0.5);
    }

    private static BlockPos validPlayerSpawnLocation(Level world, BlockPos position, int maximumRange) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(position.getX(), position.getY(), position.getZ());
        ChunkAccess chunk = null;
        for (int range = 0; range <= maximumRange; ++range) {
            int radius = range * range;
            int outerRadius = (range + 1) * (range + 1);
            for (int y = -range; y <= range; y += 4) {
                for (int x = -range; x <= range; x += 4) {
                    for (int z = -range; z <= range; z += 4) {
                        boolean isCurrentPosAir;
                        int distanceSq = x * x + z * z + y * y;
                        if (distanceSq < radius || distanceSq >= outerRadius) continue;
                        currentPos.set((Vec3i)position.offset(x, y, z));
                        if (currentPos.getY() > 250 || currentPos.getY() < 45 || !(isCurrentPosAir = (chunk = EntityTeleportationBackend.getChunkForSpot(world, chunk, (BlockPos)currentPos)).getBlockState((BlockPos)currentPos).isAir())) continue;
                        boolean isBelowSolid = chunk.getBlockState(currentPos.below()).canOcclude();
                        if (isBelowSolid) {
                            if (!chunk.getBlockState(currentPos.above()).isAir()) continue;
                            return currentPos;
                        }
                        while (!isBelowSolid && currentPos.getY() >= 45) {
                            currentPos.move(Direction.DOWN);
                            BlockState belowState = chunk.getBlockState(currentPos.below());
                            isBelowSolid = belowState.canOcclude() || !belowState.getFluidState().isEmpty();
                        }
                        if (!isBelowSolid) continue;
                        return currentPos;
                    }
                }
            }
        }
        return null;
    }

    private static ChunkAccess getChunkForSpot(Level world, ChunkAccess chunkAccess, BlockPos blockPos) {
        if (chunkAccess == null || chunkAccess.getPos().x != blockPos.getX() >> 4 || chunkAccess.getPos().z != blockPos.getZ() >> 4) {
            return world.getChunk(blockPos);
        }
        return chunkAccess;
    }

    public static boolean isValidBeeHive(BlockState blockState) {
        if (blockState.is(BzTags.FORCED_ALLOWED_TELEPORTABLE_BLOCK)) {
            return true;
        }
        if (blockState.is(BzTags.DISALLOWED_TELEPORTABLE_BEEHIVE)) {
            return false;
        }
        if ((blockState.is(BlockTags.BEEHIVES) || blockState.getBlock() instanceof BeehiveBlock) && (BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).getNamespace().equals("minecraft") || BzDimensionConfigs.allowTeleportationWithModdedBeehives)) {
            return true;
        }
        if (BzDimensionConfigs.allowTeleportationWithModdedBeehives) {
            for (ModCompat compat : ModChecker.HIVE_TELEPORT_COMPATS) {
                if (!compat.isValidBeeHiveForTeleportation(blockState)) continue;
                return true;
            }
        }
        return false;
    }

    public static void entityChangingDimension(BzEntityTravelingToDimensionEvent event) {
        Entity entity = event.entity();
        if (!(entity instanceof LivingEntity) || entity.level().isClientSide() || event.dimension().equals((Object)entity.level().dimension())) {
            return;
        }
        if (event.dimension().location().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            Optional<EntityPosAndDimModule> lazyOptional = ModuleHelper.getModule(entity, ModuleRegistry.ENTITY_POS_AND_DIM);
            if (lazyOptional.isPresent()) {
                EntityPosAndDimModule capability = lazyOptional.orElseThrow(RuntimeException::new);
                capability.setNonBZDim(entity.level().dimension().location());
                capability.setNonBZPos(Optional.of(entity.position()));
            } else {
                String string;
                Object[] objectArray = new Object[7];
                objectArray[0] = entity.getType();
                objectArray[1] = entity.getClass().getName();
                Component component = entity.getDisplayName();
                if (component instanceof MutableComponent) {
                    MutableComponent mutableComponent = (MutableComponent)component;
                    string = mutableComponent.toString();
                } else {
                    string = "N/A";
                }
                objectArray[2] = string;
                objectArray[3] = entity.getUUID();
                objectArray[4] = entity.position();
                objectArray[5] = entity.level().dimension();
                objectArray[6] = event.dimension();
                Bumblezone.LOGGER.error("Bumblezone entity pos/dim cap was not found for given entity: {}, {}, {}, {}, at {} which has the internal dimension of: {} and is coming from: {}", objectArray);
            }
        }
    }
}

