/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.mojang.authlib.GameProfile;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.pollenpuffentityflowers.PollenPuffEntityPollinateManager;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.FallingBlockEntityAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.VineBlockAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.BeeEntityInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.PlayerDataHandler;
import com.telepathicgrunt.the_bumblezone.packets.UpdateFallingBlockPacket;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PollenPuffEntity
extends ThrowableItemProjectile {
    private boolean consumed = false;

    public PollenPuffEntity(EntityType<? extends PollenPuffEntity> entityType, Level world) {
        super(entityType, world);
    }

    public PollenPuffEntity(Level world, LivingEntity livingEntity) {
        super((EntityType)BzEntities.POLLEN_PUFF_ENTITY.get(), livingEntity, world);
    }

    public PollenPuffEntity(Level world, double x, double y, double z) {
        super((EntityType)BzEntities.POLLEN_PUFF_ENTITY.get(), x, y, z, world);
    }

    public void consumed() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    protected Item getDefaultItem() {
        return (Item)BzItems.POLLEN_PUFF.get();
    }

    public void tick() {
        BlockHitResult raytraceresult;
        super.tick();
        if (this.level().isClientSide() && (!this.isInWater() || this.random.nextFloat() < 0.06f)) {
            for (int i = 0; i < 10; ++i) {
                PileOfPollen.spawnParticles((LevelAccessor)this.level(), this.position(), this.random, 0.015, 0.015, -0.001);
            }
        }
        if ((raytraceresult = this.level().clip(new ClipContext(this.position(), this.position().add(this.getDeltaMovement().multiply(1.0, 1.0, 1.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this))).getType() == HitResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.getBlockPos();
            BlockState blockstate = this.level().getBlockState(blockpos);
            if (blockstate.is(BzTags.FLOWERS_ALLOWED_BY_POLLEN_PUFF) && !blockstate.is(BzTags.FLOWERS_FORCED_DISALLOWED_FROM_POLLEN_PUFF)) {
                this.onHit((HitResult)raytraceresult);
            } else if (blockstate.getFluidState().is(FluidTags.WATER)) {
                this.onHit((HitResult)raytraceresult);
            }
        }
    }

    protected void onHit(HitResult rayTraceResult) {
        super.onHit(rayTraceResult);
        if (!this.level().isClientSide()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        } else {
            for (int i = 0; i < 150; ++i) {
                PileOfPollen.spawnParticles((LevelAccessor)this.level(), this.position(), this.random, 0.04, 0.04, -0.001);
            }
        }
    }

    protected void onHitEntity(EntityHitResult entityRayTraceResult) {
        FallingBlockEntity fallingBlockEntity;
        Fireball fireball;
        ServerPlayer serverPlayer;
        if (this.level().isClientSide() || this.consumed) {
            return;
        }
        super.onHitEntity(entityRayTraceResult);
        Entity entity = entityRayTraceResult.getEntity();
        if (entity instanceof Bee && entity.getType().is(BzTags.POLLEN_PUFF_CAN_POLLINATE)) {
            ((BeeEntityInvoker)entity).callSetHasNectar(true);
            ((Bee)entity).resetTicksWithoutNectarSinceExitingHive();
            Entity entity2 = this.getOwner();
            if (entity2 instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)entity2;
                ((GenericTrigger)((Object)BzCriterias.POLLEN_PUFF_POLLINATED_BEE_TRIGGER.get())).trigger(serverPlayer);
            }
        } else if (entity instanceof Panda) {
            Panda panda = (Panda)entity;
            panda.sneeze(true);
            Entity entity3 = this.getOwner();
            if (entity3 instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)entity3;
                ((GenericTrigger)((Object)BzCriterias.POLLEN_PUFF_PANDA_TRIGGER.get())).trigger(serverPlayer);
            }
        } else if (entity instanceof Fireball && (fireball = (Fireball)entity).getOwner() instanceof Ghast) {
            Entity entity4 = this.getOwner();
            if (entity4 instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)entity4;
                ((GenericTrigger)((Object)BzCriterias.POLLEN_PUFF_FIREBALL_TRIGGER.get())).trigger(serverPlayer);
            }
        } else if (entity instanceof FallingBlockEntity && (fallingBlockEntity = (FallingBlockEntity)entity).getBlockState().is((Block)BzBlocks.PILE_OF_POLLEN.get())) {
            BlockState fallingState = fallingBlockEntity.getBlockState();
            int newLayer = Math.min(8, (Integer)fallingState.getValue((Property)PileOfPollen.LAYERS) + 1);
            ((FallingBlockEntityAccessor)fallingBlockEntity).setBlockState((BlockState)fallingState.setValue((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(newLayer)));
            UpdateFallingBlockPacket.sendToClient((Entity)fallingBlockEntity, fallingBlockEntity.getId(), (short)newLayer);
        }
        if (entity instanceof LivingEntity && (fireball = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer2 = (ServerPlayer)fireball;
            PlayerDataHandler.onPollenHit((Player)serverPlayer2);
        }
        if (entity instanceof RootminEntity) {
            RootminEntity rootminEntity = (RootminEntity)entity;
            BlockState blockstate = rootminEntity.getFlowerBlock();
            if (blockstate != null && blockstate.is(BzTags.FLOWERS_ALLOWED_BY_POLLEN_PUFF) && !blockstate.is(BzTags.FLOWERS_FORCED_DISALLOWED_FROM_POLLEN_PUFF)) {
                this.spawnPlants(rootminEntity.blockPosition(), (r, b) -> blockstate);
            }
        } else {
            WeightedStateProvider possiblePlants = PollenPuffEntityPollinateManager.POLLEN_PUFF_ENTITY_POLLINATE_MANAGER.getPossiblePlants(entity);
            if (possiblePlants != null && GeneralUtils.isPermissionAllowedAtSpot(this.level(), this.getOwner(), BlockPos.containing((Position)entityRayTraceResult.getLocation()), true)) {
                boolean spawnedBlock = this.spawnPlants(entity.blockPosition(), (arg_0, arg_1) -> ((WeightedStateProvider)possiblePlants).getState(arg_0, arg_1));
                Entity entity5 = this.getOwner();
                if (entity5 instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)entity5;
                    if (spawnedBlock && entity.getType() == EntityType.MOOSHROOM) {
                        ((GenericTrigger)((Object)BzCriterias.POLLEN_PUFF_MOOSHROOM_TRIGGER.get())).trigger(serverPlayer);
                    }
                }
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack beeLeggings = HoneyBeeLeggings.getEntityBeeLegging(livingEntity);
            if (!entity.isShiftKeyDown() && !beeLeggings.isEmpty()) {
                HoneyBeeLeggings.setPollinated(beeLeggings);
            }
        }
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        if (this.level().isClientSide() || this.consumed || !GeneralUtils.isPermissionAllowedAtSpot(this.level(), this.getOwner(), blockHitResult.getBlockPos(), true)) {
            return;
        }
        BlockState blockstate = this.level().getBlockState(blockHitResult.getBlockPos());
        blockstate.onProjectileHit(this.level(), blockstate, blockHitResult, (Projectile)this);
        if (blockstate.is(BzTags.FLOWERS_ALLOWED_BY_POLLEN_PUFF) && !blockstate.is(BzTags.FLOWERS_FORCED_DISALLOWED_FROM_POLLEN_PUFF)) {
            this.spawnPlants(blockHitResult.getBlockPos(), (r, b) -> blockstate);
        } else if (blockstate.is(Blocks.HONEY_BLOCK) || blockstate.is(Blocks.SOUL_SAND) || blockstate.isFaceSturdy((BlockGetter)this.level(), blockHitResult.getBlockPos(), blockHitResult.getDirection())) {
            boolean belowSideStateHasCollision;
            BlockState pileOfPollen = ((Block)BzBlocks.PILE_OF_POLLEN.get()).defaultBlockState();
            BlockPos impactSide = blockHitResult.getBlockPos().relative(blockHitResult.getDirection());
            BlockState sideState = this.level().getBlockState(impactSide);
            BlockState belowSideState = this.level().getBlockState(impactSide.below());
            boolean bl = belowSideStateHasCollision = !belowSideState.getCollisionShape((BlockGetter)this.level(), impactSide.below()).isEmpty();
            if (sideState.is(pileOfPollen.getBlock())) {
                PileOfPollen.stackPollen(sideState, this.level(), impactSide, pileOfPollen);
                this.consumed = true;
            } else if (!belowSideStateHasCollision && (sideState.isAir() || sideState.is(BlockTags.FIRE)) || belowSideStateHasCollision && pileOfPollen.canSurvive((LevelReader)this.level(), impactSide) && sideState.canBeReplaced()) {
                this.level().setBlock(impactSide, pileOfPollen, 3);
                this.consumed = true;
            }
        }
    }

    private boolean spawnPlants(BlockPos pos, BiFunction<RandomSource, BlockPos, BlockState> blockStateGetter) {
        boolean spawnedPlant = false;
        int flowerAttempts = 2 + this.random.nextInt(3);
        for (int i = 0; i < flowerAttempts; ++i) {
            BlockState belowState;
            boolean isWaterBased;
            BlockState targetBlock;
            boolean isTallPlant = false;
            BlockPos newPos = pos.offset(this.random.nextInt(5) - 2, this.random.nextInt(3) - 1, this.random.nextInt(5) - 2);
            BlockState blockstate = blockStateGetter.apply(this.random, newPos);
            if (blockstate == null || blockstate.is(Blocks.AIR)) {
                return false;
            }
            GameProfile gameProfile = null;
            Entity entity = this.getOwner();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                gameProfile = serverPlayer.getGameProfile();
            }
            ServerPlayer fakePlayer = PlatformHooks.getFakePlayer((ServerLevel)this.level(), gameProfile);
            if (blockstate.getBlock() instanceof DoublePlantBlock) {
                blockstate = (BlockState)blockstate.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
                isTallPlant = true;
            } else {
                Block block = blockstate.getBlock();
                if (block instanceof VineBlock) {
                    VineBlock vineBlock = (VineBlock)block;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        BooleanProperty faceProperty = VineBlock.getPropertyForFace((Direction)direction);
                        boolean flag = ((VineBlockAccessor)vineBlock).callCanSupportAtFace((BlockGetter)this.level(), newPos, direction);
                        blockstate = (BlockState)blockstate.setValue((Property)faceProperty, (Comparable)Boolean.valueOf(flag));
                    }
                } else {
                    try {
                        BlockPlaceContext blockPlaceContext = new BlockPlaceContext((Player)fakePlayer, InteractionHand.MAIN_HAND, ItemStack.EMPTY, new BlockHitResult(Vec3.atCenterOf((Vec3i)newPos.above()), Direction.UP, newPos, false));
                        blockstate = blockstate.getBlock().getStateForPlacement(blockPlaceContext);
                    }
                    catch (Exception e) {
                        Bumblezone.LOGGER.error("Pollen Puff: Unable to call getStateForPlacement for the following block: {} - Will use original default blockstate instead.", (Object)blockstate);
                    }
                    if (blockstate == null || blockstate.is(Blocks.AIR)) {
                        return false;
                    }
                }
            }
            boolean isFlowerAmount = false;
            if (blockstate.hasProperty((Property)BlockStateProperties.FLOWER_AMOUNT) && (targetBlock = this.level().getBlockState(newPos)).is(blockstate.getBlock()) && (Integer)targetBlock.getValue((Property)BlockStateProperties.FLOWER_AMOUNT) < 4) {
                blockstate = (BlockState)blockstate.setValue((Property)BlockStateProperties.FLOWER_AMOUNT, (Comparable)Integer.valueOf((Integer)targetBlock.getValue((Property)BlockStateProperties.FLOWER_AMOUNT) + 1));
                isFlowerAmount = true;
            }
            if (!((isWaterBased = blockstate.getFluidState().is(FluidTags.WATER)) ? this.level().getBlockState(newPos).is(Blocks.WATER) : (isFlowerAmount || this.level().isEmptyBlock(newPos)) && blockstate.canSurvive((LevelReader)this.level(), newPos)) || blockstate.is(Blocks.MOSS_CARPET) && (BuiltInRegistries.BLOCK.getKey((Object)(belowState = this.level().getBlockState(newPos.below())).getBlock()).getPath().contains("carpet") || belowState.is(BlockTags.UNSTABLE_BOTTOM_CENTER) || !belowState.isFaceSturdy((BlockGetter)this.level(), newPos.below(), Direction.DOWN, SupportType.FULL)) || blockstate.is(Blocks.BAMBOO_SAPLING) && ((belowState = this.level().getBlockState(newPos.below())).is(Blocks.BAMBOO_SAPLING) || belowState.is(Blocks.BAMBOO))) continue;
            this.level().setBlock(newPos, blockstate, 3);
            blockstate.getBlock().setPlacedBy(this.level(), newPos, blockstate, (LivingEntity)fakePlayer, ItemStack.EMPTY);
            Entity entity2 = this.getOwner();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity2;
                if (blockstate.is(BlockTags.FLOWERS)) {
                    PlayerDataHandler.onFlowerSpawned((Player)serverPlayer);
                    if (isTallPlant) {
                        ((GenericTrigger)((Object)BzCriterias.POLLEN_PUFF_POLLINATED_TALL_FLOWER_TRIGGER.get())).trigger(serverPlayer);
                    }
                }
            }
            spawnedPlant = true;
        }
        return spawnedPlant;
    }
}

