/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RootminRangedAttackGoal
extends Goal {
    private final RootminEntity rootminEntity;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float attackRadiusSqr;

    public RootminRangedAttackGoal(RootminEntity rootminEntity, double speedModifier, int attackIntervalMax, int attackIntervalMin, float attackRadius) {
        this.rootminEntity = rootminEntity;
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMax;
        this.attackIntervalMax = attackIntervalMin;
        this.attackRadius = attackRadius;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity livingEntity = this.rootminEntity.getTarget();
        if (livingEntity == null || !livingEntity.isAlive() || this.rootminEntity.disableAttackGoals) {
            return false;
        }
        if (this.rootminEntity.isOwnedBy(livingEntity)) {
            return false;
        }
        if (!this.rootminEntity.canTarget(livingEntity)) {
            this.rootminEntity.setTarget(null);
            this.rootminEntity.setAggressive(false);
            return false;
        }
        this.target = livingEntity;
        return true;
    }

    public boolean canContinueToUse() {
        return this.canUse() || this.target != null && this.target.isAlive() && !this.rootminEntity.getNavigation().isDone();
    }

    public void stop() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.target == null) {
            return;
        }
        Level level = this.rootminEntity.level();
        BlockPos posInFront = this.rootminEntity.blockPosition().relative(this.rootminEntity.getDirection());
        double distToTarget = this.rootminEntity.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        boolean blockBlockingInFront = level.getBlockState(posInFront).isCollisionShapeFullBlock((BlockGetter)level, posInFront);
        boolean lineOfSight = !blockBlockingInFront && this.rootminEntity.getSensing().hasLineOfSight((Entity)this.target);
        int n = this.seeTime = lineOfSight ? (this.seeTime = this.seeTime + 1) : 0;
        if (distToTarget > (double)this.attackRadiusSqr || this.seeTime < 5) {
            this.rootminEntity.getNavigation().moveTo((Entity)this.target, this.speedModifier);
        } else {
            this.rootminEntity.getNavigation().stop();
        }
        this.rootminEntity.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!lineOfSight) {
                return;
            }
            float f = (float)Math.sqrt(distToTarget) / this.attackRadius;
            this.rootminEntity.runShoot(this.target, 1.0f, false);
            this.rootminEntity.exposedTimer = 0;
            this.attackTime = Mth.floor((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.floor((double)Mth.lerp((double)(Math.sqrt(distToTarget) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
        }
    }
}

