/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.effects;

import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.effects.BzEffect;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityVisibilityEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bee;

public class HiddenEffect
extends BzEffect {
    private static final TargetingConditions SEE_THROUGH_WALLS = TargetingConditions.forCombat().ignoreLineOfSight();

    public HiddenEffect(MobEffectCategory type, int potionColor) {
        super(type, potionColor);
    }

    public boolean isInstantenous() {
        return false;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration >= 1;
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        super.applyEffectTick(livingEntity, amplifier);
        Registry mobEffects = livingEntity.level().registryAccess().registryOrThrow(Registries.MOB_EFFECT);
        Holder.Reference hiddenEffectReference = (Holder.Reference)mobEffects.getHolder(BzEffects.HIDDEN.getId()).get();
        MobEffectInstance effect = livingEntity.getEffect((Holder)hiddenEffectReference);
        if (effect != null && effect.getDuration() <= 1) {
            PileOfPollen.reapplyHiddenEffectIfInsidePollenPile(livingEntity);
        }
        return true;
    }

    public void onEffectStarted(LivingEntity livingEntity, int amplifier) {
        if (amplifier >= 1) {
            SEE_THROUGH_WALLS.range((double)BzBeeAggressionConfigs.aggressionTriggerRadius * 0.5);
            List beeList = livingEntity.level().getNearbyEntities(Bee.class, SEE_THROUGH_WALLS, livingEntity, livingEntity.getBoundingBox().inflate((double)BzBeeAggressionConfigs.aggressionTriggerRadius * 0.5));
            for (Bee bee : beeList) {
                if (bee.getTarget() != livingEntity) continue;
                bee.setTarget(null);
                bee.setPersistentAngerTarget(null);
                bee.setRemainingPersistentAngerTime(0);
            }
        }
        super.onEffectStarted(livingEntity, amplifier);
    }

    public static void hideEntity(BzEntityVisibilityEvent event) {
        Registry mobEffects = event.entity().level().registryAccess().registryOrThrow(Registries.MOB_EFFECT);
        Holder.Reference hiddenEffectReference = (Holder.Reference)mobEffects.getHolder(BzEffects.HIDDEN.getId()).get();
        MobEffectInstance hiddenEffect = event.entity().getEffect((Holder)hiddenEffectReference);
        if (hiddenEffect != null) {
            event.modify(0.0);
        }
    }
}

