/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class GeneralUtilsClient {
    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public static Level getClientLevel() {
        return Minecraft.getInstance().level;
    }

    public static RegistryAccess getClientRegistryAccess() {
        return Minecraft.getInstance().getConnection().registryAccess();
    }

    public static List<MutableComponent> autoWrappedTooltip(int lengthText, String wrappingText) {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        if (lengthText > 10) {
            String translatedWrapString = Language.getInstance().getOrDefault(wrappingText);
            if (translatedWrapString.length() > lengthText) {
                list.add(Component.literal((String)translatedWrapString.substring(0, lengthText)));
                list.add(Component.literal((String)translatedWrapString.substring(lengthText)));
            } else {
                list.add(Component.translatable((String)wrappingText));
            }
        } else {
            list.add(Component.translatable((String)wrappingText));
        }
        return list;
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component component, int minX, int minY, int maxX, int maxY, int color) {
        int n = font.width((FormattedText)component);
        Objects.requireNonNull(font);
        int o = (minY + maxY - 9) / 2 + 1;
        int p = maxX - minX;
        if (n > p) {
            int q = n - p;
            double d = (double)Util.getMillis() / 1000.0;
            double e = Math.max((double)q * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = Mth.lerp((double)f, (double)0.0, (double)q);
            guiGraphics.enableScissor(minX, minY, maxX, maxY);
            guiGraphics.drawString(font, component, minX - (int)g, o, color, true);
            guiGraphics.disableScissor();
        } else {
            guiGraphics.drawString(font, component, minX, o, color);
        }
    }

    public static boolean isAdvancedToolTipActive() {
        Minecraft minecraft = Minecraft.getInstance();
        return minecraft != null && minecraft.options.advancedItemTooltips;
    }
}

