/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.telepathicgrunt.the_bumblezone.blocks.CrystallineFlower;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.menus.CrystallineFlowerMenu;
import com.telepathicgrunt.the_bumblezone.menus.EnchantmentSkeleton;
import com.telepathicgrunt.the_bumblezone.packets.CrystallineFlowerClickedEnchantmentButtonPacket;
import com.telepathicgrunt.the_bumblezone.platform.ModInfo;
import com.telepathicgrunt.the_bumblezone.utils.EnchantmentUtils;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CrystallineFlowerScreen
extends AbstractContainerScreen<CrystallineFlowerMenu> {
    private static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/container/crystallized_flower.png");
    private static final Pattern SPLIT_WITH_COMBINING_CHARS = Pattern.compile("(\\p{M}+|\\P{M}\\p{M}*)");
    private static final int MENU_HEIGHT = 126;
    private static final int INVENTORY_LABEL_Y_OFFSET = -60;
    private static final int TITLE_LABEL_Y_OFFSET = -1;
    private static final int ENCHANTMENT_AREA_X_OFFSET = 76;
    private static final int ENCHANTMENT_AREA_Y_OFFSET = 52;
    private static final int ENCHANTMENT_SECTION_WIDTH = 88;
    private static final int ENCHANTMENT_SECTION_HEIGHT = 19;
    private static final int ENCHANTMENT_SCROLLBAR_X_OFFSET = 164;
    private static final int ENCHANTMENT_SCROLLBAR_Y_OFFSET = 50;
    private static final int ENCHANTMENT_SCROLLBAR_Y_RANGE = 50;
    private static final float ENCHANTMENT_SCROLLBAR_U_TEXTURE = 230.0f;
    private static final float ENCHANTMENT_SCROLLBAR_V_TEXTURE = 182.0f;
    private static final int ENCHANTMENT_SORT_X_OFFSET = 163;
    private static final int ENCHANTMENT_SORT_Y_OFFSET = 41;
    private static final float ENCHANTMENT_SORT_U_OFFSET = 92.0f;
    private static final float ENCHANTMENT_SORT_V_OFFSET = 197.0f;
    private static final float ENCHANTMENT_SELECTED_U_TEXTURE = 0.0f;
    private static final float ENCHANTMENT_SELECTED_V_TEXTURE = 197.0f;
    private static final float ENCHANTMENT_UNSELECTED_U_TEXTURE = 0.0f;
    private static final float ENCHANTMENT_UNSELECTED_V_TEXTURE = 216.0f;
    private static final float ENCHANTMENT_HIGHLIGHTED_U_TEXTURE = 0.0f;
    private static final float ENCHANTMENT_HIGHLIGHTED_V_TEXTURE = 235.0f;
    private static final int XP_BAR_X_OFFSET = 11;
    private static final int XP_BAR_Y_OFFSET = 99;
    private static final float XP_BAR_U_TEXTURE = 176.0f;
    private static final float XP_BAR_V_TEXTURE = 187.0f;
    private static final int XP_CONSUME_1_X_OFFSET = 46;
    private static final int XP_CONSUME_1_Y_OFFSET = 14;
    private static final int XP_CONSUME_2_X_OFFSET = 46;
    private static final int XP_CONSUME_2_Y_OFFSET = 34;
    private static final int XP_CONSUME_3_X_OFFSET = 46;
    private static final int XP_CONSUME_3_Y_OFFSET = 54;
    private static final float XP_CONSUME_1_U_OFFSET = 108.0f;
    private static final float XP_CONSUME_1_V_OFFSET = 197.0f;
    private static final float XP_CONSUME_2_U_OFFSET = 126.0f;
    private static final float XP_CONSUME_2_V_OFFSET = 197.0f;
    private static final float XP_CONSUME_3_U_OFFSET = 144.0f;
    private static final float XP_CONSUME_3_V_OFFSET = 197.0f;
    private static final int CONSUME_CONFIRMATION_X_OFFSET = 25;
    private static final int CONSUME_CONFIRMATION_Y_OFFSET = 62;
    private static final float CONSUME_CONFIRMATION_U_OFFSET = 162.0f;
    private static final float CONSUME_CONFIRMATION_V_OFFSET = 197.0f;
    private static final int CONSUME_ARROW_X_OFFSET = 26;
    private static final int CONSUME_ARROW_Y_OFFSET = 82;
    private static final float CONSUME_ARROW_U_OFFSET = 180.0f;
    private static final float CONSUME_ARROW_V_OFFSET = 197.0f;
    private static final int TIER_X_OFFSET = 11;
    private static final int TIER_Y_OFFSET = 15;
    private static final float TIER_FLOWER_U_TEXTURE = 195.0f;
    private static final float TIER_FLOWER_V_TEXTURE = 197.0f;
    private static final float TIER_BODY_U_TEXTURE = 195.0f;
    private static final float TIER_BODY_V_TEXTURE = 207.0f;
    private static final float TIER_BLOCK_U_TEXTURE = 195.0f;
    private static final float TIER_BLOCK_V_TEXTURE = 217.0f;
    private static final int BUTTON_PRESSED_TIMER_VISUAL = 25;
    private float scrollOff;
    private boolean scrolling;
    private int startIndex;
    private int pressedXp1Timer = 0;
    private int pressedXp2Timer = 0;
    private int pressedXp3Timer = 0;
    private int pressedConsumeTimer = 0;
    private int pressedSortTimer = 0;
    private List<Boolean> cachedObstructions = new ArrayList<Boolean>();
    private int cachedObstructionsTimer = 0;
    private int prevXpTier = 0;
    private boolean prevBookSlotEmpty = true;
    public static Map<ResourceLocation, EnchantmentSkeleton> enchantmentsAvailable = new HashMap<ResourceLocation, EnchantmentSkeleton>();
    public static List<ResourceLocation> enchantmentsAvailableSortedList = new ArrayList<ResourceLocation>();
    public static SORT_STATE sortState = SORT_STATE.ALPHABETICAL;
    private static final Comparator<Map.Entry<ResourceLocation, EnchantmentSkeleton>> compareByNamespace = Comparator.comparing(e -> ((ResourceLocation)e.getKey()).getNamespace());
    private static final Comparator<Map.Entry<ResourceLocation, EnchantmentSkeleton>> compareByLang = Comparator.comparing(e -> Language.getInstance().getOrDefault(Util.makeDescriptionId((String)"enchantment", (ResourceLocation)((ResourceLocation)e.getKey())), ((ResourceLocation)e.getKey()).getPath().replace("_", " ")), String.CASE_INSENSITIVE_ORDER);
    private static final Comparator<Map.Entry<ResourceLocation, EnchantmentSkeleton>> compareByLevel = Comparator.comparingInt(e -> ((EnchantmentSkeleton)e.getValue()).level);
    private static final Comparator<Map.Entry<ResourceLocation, EnchantmentSkeleton>> compareByTreasure = Comparator.comparing(e -> !((EnchantmentSkeleton)e.getValue()).isTreasure || ((EnchantmentSkeleton)e.getValue()).isCurse);
    private static final Comparator<Map.Entry<ResourceLocation, EnchantmentSkeleton>> compareByCurse = Comparator.comparing(e -> !((EnchantmentSkeleton)e.getValue()).isCurse);
    private static final Comparator<Map.Entry<ResourceLocation, EnchantmentSkeleton>> compareByNamespaceAndLang = compareByNamespace.thenComparing(compareByLang);
    private static final Comparator<Map.Entry<ResourceLocation, EnchantmentSkeleton>> compareByLevelAndLang = compareByLevel.reversed().thenComparing(compareByLang);
    private static final Comparator<Map.Entry<ResourceLocation, EnchantmentSkeleton>> compareByTreasureCurseAndLang = compareByTreasure.thenComparing(compareByCurse).thenComparing(compareByLang);

    public CrystallineFlowerScreen(CrystallineFlowerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.inventoryLabelY = this.imageHeight + -60;
        this.titleLabelY += -1;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.enableDepthTest();
        ItemStack book = ((CrystallineFlowerMenu)this.menu).bookSlot.getItem();
        if (book.isEmpty() != this.prevBookSlotEmpty || ((CrystallineFlowerMenu)this.menu).xpTier.get() != this.prevXpTier) {
            this.populateAvailableEnchants();
            this.prevXpTier = ((CrystallineFlowerMenu)this.menu).xpTier.get();
            this.prevBookSlotEmpty = book.isEmpty();
        }
        int startX = (this.width - this.imageWidth) / 2;
        int startY = (this.height - this.imageHeight) / 2;
        int rowStartX = startX + 76;
        int rowStartY = startY + 52;
        this.renderScroller(guiGraphics, startX + 164, startY + 50);
        this.handleEnchantmentAreaRow(mouseX, mouseY, selectedIndex -> {
            if (selectedIndex > enchantmentsAvailableSortedList.size()) {
                return false;
            }
            ResourceLocation selectedEnchant = enchantmentsAvailableSortedList.get((int)selectedIndex);
            EnchantmentSkeleton enchantmentSkeleton = enchantmentsAvailable.get(selectedEnchant);
            boolean isCurse = enchantmentSkeleton.isCurse;
            boolean isTreasure = enchantmentSkeleton.isTreasure;
            int row = enchantmentsAvailableSortedList.indexOf(selectedEnchant) - this.startIndex;
            if (ResourceLocation.fromNamespaceAndPath((String)enchantmentSkeleton.namespace, (String)enchantmentSkeleton.path).equals((Object)((CrystallineFlowerMenu)this.menu).selectedEnchantment)) {
                RenderSystem.enableDepthTest();
                guiGraphics.blit(CONTAINER_BACKGROUND, rowStartX - 2, rowStartY - 2 + row * 19, 0.0f, 197.0f, 89, 19, 256, 256);
                this.drawEnchantmentText(guiGraphics, rowStartX, rowStartY + row * 19, enchantmentSkeleton, isCurse ? 0x990000 : (isTreasure ? 0xFFF000 : 0xFFD000), 0xC0FF00, true);
            } else {
                RenderSystem.enableDepthTest();
                guiGraphics.blit(CONTAINER_BACKGROUND, rowStartX - 2, rowStartY - 2 + row * 19, 0.0f, 235.0f, 89, 19, 256, 256);
                this.drawEnchantmentText(guiGraphics, rowStartX, rowStartY + row * 19, enchantmentSkeleton, isCurse ? 0x800000 : (isTreasure ? 0xFFFF50 : 0x402020), 0x304000, false);
            }
            return true;
        }, selectedIndex -> {
            if (selectedIndex > enchantmentsAvailableSortedList.size()) {
                return;
            }
            ResourceLocation selectedEnchant = enchantmentsAvailableSortedList.get((int)selectedIndex);
            EnchantmentSkeleton enchantmentEntry = enchantmentsAvailable.get(selectedEnchant);
            boolean isCurse = enchantmentEntry.isCurse;
            boolean isTreasure = enchantmentEntry.isTreasure;
            int row = selectedIndex - this.startIndex;
            if (selectedEnchant.equals((Object)((CrystallineFlowerMenu)this.menu).selectedEnchantment)) {
                RenderSystem.enableDepthTest();
                guiGraphics.blit(CONTAINER_BACKGROUND, rowStartX - 2, rowStartY - 2 + row * 19, 0.0f, 197.0f, 89, 19, 256, 256);
                this.drawEnchantmentText(guiGraphics, rowStartX, rowStartY + row * 19, enchantmentEntry, isCurse ? 0x990000 : (isTreasure ? 0xFFF000 : 0xFFD000), 0xC0FF00, true);
            } else {
                RenderSystem.enableDepthTest();
                guiGraphics.blit(CONTAINER_BACKGROUND, rowStartX - 2, rowStartY - 2 + row * 19, 0.0f, 216.0f, 89, 19, 256, 256);
                this.drawEnchantmentText(guiGraphics, rowStartX, rowStartY + row * 19, enchantmentEntry, isCurse ? 0xFF2000 : (isTreasure ? 0xFFF000 : 13676784), 56640, true);
            }
        });
        if (((CrystallineFlowerMenu)this.menu).tooManyEnchantmentsOnInput.get() == 1) {
            MutableComponent mutableComponent = Component.translatable((String)"container.the_bumblezone.crystalline_flower.too_many_enchants").withStyle(ChatFormatting.BOLD);
            guiGraphics.drawCenteredString(this.font, (Component)mutableComponent, rowStartX + 45, rowStartY - 36, 13643792);
        } else if (((CrystallineFlowerMenu)this.menu).selectedEnchantment != null && ((CrystallineFlowerMenu)this.menu).enchantedSlot.hasItem()) {
            EnchantmentSkeleton enchantment = enchantmentsAvailable.get(((CrystallineFlowerMenu)this.menu).selectedEnchantment);
            int tierCost = EnchantmentUtils.getEnchantmentTierCost(enchantment.level, enchantment.minCost, enchantment.isTreasure, enchantment.isCurse);
            MutableComponent mutableComponent = Component.translatable((String)"container.the_bumblezone.crystalline_flower.tier_cost_arrow", (Object[])new Object[]{tierCost}).withStyle(ChatFormatting.BOLD);
            guiGraphics.drawCenteredString(this.font, (Component)mutableComponent, rowStartX + 45, rowStartY - 36, 13643792);
        }
        this.drawPushableButtons(guiGraphics, startX, startY, mouseX, mouseY);
        this.drawTierState(guiGraphics, startX, startY);
        this.renderXPBar(guiGraphics, startX, startY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void drawTierState(GuiGraphics guiGraphics, int startX, int startY) {
        int xOffset = startX + 11;
        int yOffset = startY + 15;
        if (this.cachedObstructionsTimer <= 0) {
            BlockPos flowerPos = new BlockPos(GeneralUtils.merge(((CrystallineFlowerMenu)this.menu).bottomBlockPosXUpper.get(), ((CrystallineFlowerMenu)this.menu).bottomBlockPosXLower.get()), GeneralUtils.merge(((CrystallineFlowerMenu)this.menu).bottomBlockPosYUpper.get(), ((CrystallineFlowerMenu)this.menu).bottomBlockPosYLower.get()), GeneralUtils.merge(((CrystallineFlowerMenu)this.menu).bottomBlockPosZUpper.get(), ((CrystallineFlowerMenu)this.menu).bottomBlockPosZLower.get()));
            this.cachedObstructions = CrystallineFlower.getObstructions(7, this.minecraft.player.level(), flowerPos);
            this.cachedObstructionsTimer = 100;
        }
        --this.cachedObstructionsTimer;
        for (int i = 0; i < 7; ++i) {
            if (i >= ((CrystallineFlowerMenu)this.menu).xpTier.get()) {
                if (i >= this.cachedObstructions.size() || !this.cachedObstructions.get(i).booleanValue()) continue;
                RenderSystem.enableDepthTest();
                guiGraphics.blit(CONTAINER_BACKGROUND, xOffset, yOffset + (72 - i * 12), 195.0f, 217.0f, 10, 10, 256, 256);
                continue;
            }
            float textureU = 195.0f;
            float textureV = 207.0f;
            if (i + 1 == ((CrystallineFlowerMenu)this.menu).xpTier.get()) {
                textureU = 195.0f;
                textureV = 197.0f;
            }
            RenderSystem.enableDepthTest();
            guiGraphics.blit(CONTAINER_BACKGROUND, xOffset, yOffset + (72 - i * 12), textureU, textureV, 10, 10, 256, 256);
        }
    }

    private void drawPushableButtons(GuiGraphics guiGraphics, int startX, int startY, int mouseX, int mouseY) {
        int yOffset;
        int xOffset;
        if (this.pressedSortTimer > 0) {
            --this.pressedSortTimer;
            RenderSystem.enableDepthTest();
            guiGraphics.blit(CONTAINER_BACKGROUND, startX + 163, startY + 41, 92.0f + (float)CrystallineFlowerScreen.sortState.offsetU, 197.0f + (float)CrystallineFlowerScreen.sortState.offsetV + 8.0f, 8, 8, 256, 256);
        } else {
            xOffset = startX + 163;
            yOffset = startY + 41;
            if ((double)(mouseX - xOffset) >= 0.0 && (double)(mouseX - xOffset) < 8.0 && (double)(mouseY - yOffset) >= 0.0 && (double)(mouseY - yOffset) < 8.0) {
                RenderSystem.enableDepthTest();
                guiGraphics.blit(CONTAINER_BACKGROUND, xOffset, yOffset, 92.0f + (float)CrystallineFlowerScreen.sortState.offsetU, 197.0f + (float)CrystallineFlowerScreen.sortState.offsetV + 16.0f, 8, 8, 256, 256);
            } else {
                RenderSystem.enableDepthTest();
                guiGraphics.blit(CONTAINER_BACKGROUND, xOffset, yOffset, 92.0f + (float)CrystallineFlowerScreen.sortState.offsetU, 197.0f + (float)CrystallineFlowerScreen.sortState.offsetV, 8, 8, 256, 256);
            }
        }
        if (BzGeneralConfigs.crystallineFlowerConsumeExperienceUI) {
            if (this.pressedXp1Timer > 0 || ((CrystallineFlowerMenu)this.menu).xpTier.get() == 7 || this.isPathObstructed(1).booleanValue() || !this.canPlayerBuyTier(1).booleanValue()) {
                --this.pressedXp1Timer;
                RenderSystem.enableDepthTest();
                guiGraphics.blit(CONTAINER_BACKGROUND, startX + 46, startY + 14, 108.0f, 215.0f, 18, 18, 256, 256);
            } else {
                xOffset = startX + 46;
                yOffset = startY + 14;
                if ((double)(mouseX - xOffset) >= 0.0 && (double)(mouseX - xOffset) < 18.0 && (double)(mouseY - yOffset) >= 0.0 && (double)(mouseY - yOffset) < 18.0) {
                    RenderSystem.enableDepthTest();
                    guiGraphics.blit(CONTAINER_BACKGROUND, xOffset, yOffset, 108.0f, 233.0f, 18, 18, 256, 256);
                } else {
                    RenderSystem.enableDepthTest();
                    guiGraphics.blit(CONTAINER_BACKGROUND, xOffset, yOffset, 108.0f, 197.0f, 18, 18, 256, 256);
                }
            }
        }
        if (BzGeneralConfigs.crystallineFlowerConsumeExperienceUI) {
            if (this.pressedXp2Timer > 0 || ((CrystallineFlowerMenu)this.menu).xpTier.get() == 7 || this.isPathObstructed(2).booleanValue() || !this.canPlayerBuyTier(2).booleanValue()) {
                --this.pressedXp2Timer;
                RenderSystem.enableDepthTest();
                guiGraphics.blit(CONTAINER_BACKGROUND, startX + 46, startY + 34, 126.0f, 215.0f, 18, 18, 256, 256);
            } else {
                xOffset = startX + 46;
                yOffset = startY + 34;
                if ((double)(mouseX - xOffset) >= 0.0 && (double)(mouseX - xOffset) < 18.0 && (double)(mouseY - yOffset) >= 0.0 && (double)(mouseY - yOffset) < 18.0) {
                    RenderSystem.enableDepthTest();
                    guiGraphics.blit(CONTAINER_BACKGROUND, xOffset, yOffset, 126.0f, 233.0f, 18, 18, 256, 256);
                } else {
                    RenderSystem.enableDepthTest();
                    guiGraphics.blit(CONTAINER_BACKGROUND, xOffset, yOffset, 126.0f, 197.0f, 18, 18, 256, 256);
                }
            }
        }
        if (BzGeneralConfigs.crystallineFlowerConsumeExperienceUI) {
            if (this.pressedXp3Timer > 0 || ((CrystallineFlowerMenu)this.menu).xpTier.get() == 7 || this.isPathObstructed(3).booleanValue() || !this.canPlayerBuyTier(3).booleanValue()) {
                --this.pressedXp3Timer;
                RenderSystem.enableDepthTest();
                guiGraphics.blit(CONTAINER_BACKGROUND, startX + 46, startY + 54, 144.0f, 215.0f, 18, 18, 256, 256);
            } else {
                xOffset = startX + 46;
                yOffset = startY + 54;
                if ((double)(mouseX - xOffset) >= 0.0 && (double)(mouseX - xOffset) < 18.0 && (double)(mouseY - yOffset) >= 0.0 && (double)(mouseY - yOffset) < 18.0) {
                    RenderSystem.enableDepthTest();
                    guiGraphics.blit(CONTAINER_BACKGROUND, xOffset, yOffset, 144.0f, 233.0f, 18, 18, 256, 256);
                } else {
                    RenderSystem.enableDepthTest();
                    guiGraphics.blit(CONTAINER_BACKGROUND, xOffset, yOffset, 144.0f, 197.0f, 18, 18, 256, 256);
                }
            }
        }
        if (!BzGeneralConfigs.crystallineFlowerConsumeExperienceUI) {
            xOffset = startX + 26;
            yOffset = startY + 14;
            RenderSystem.enableDepthTest();
            guiGraphics.blit(CONTAINER_BACKGROUND, xOffset, yOffset, 176.0f, 0.0f, 48, 58, 256, 256);
        }
        if (this.pressedConsumeTimer > 0) {
            --this.pressedConsumeTimer;
        }
        if (((CrystallineFlowerMenu)this.menu).consumeSlotFullyObstructed.get() != 1 && BzGeneralConfigs.crystallineFlowerConsumeItemUI) {
            if (this.pressedConsumeTimer > 0) {
                RenderSystem.enableDepthTest();
                guiGraphics.blit(CONTAINER_BACKGROUND, startX + 25, startY + 62, 162.0f, 215.0f, 18, 18, 256, 256);
                guiGraphics.blit(CONTAINER_BACKGROUND, startX + 26, startY + 82, 180.0f, 215.0f, 15, 11, 256, 256);
            } else if (((CrystallineFlowerMenu)this.menu).consumeSlot.hasItem() && ((CrystallineFlowerMenu)this.menu).xpTier.get() < 7) {
                xOffset = startX + 25;
                yOffset = startY + 62;
                if ((double)(mouseX - xOffset) >= 0.0 && (double)(mouseX - xOffset) < 18.0 && (double)(mouseY - yOffset) >= 0.0 && (double)(mouseY - yOffset) < 18.0) {
                    RenderSystem.enableDepthTest();
                    guiGraphics.blit(CONTAINER_BACKGROUND, startX + 25, startY + 62, 162.0f, 233.0f, 18, 18, 256, 256);
                } else {
                    RenderSystem.enableDepthTest();
                    guiGraphics.blit(CONTAINER_BACKGROUND, startX + 25, startY + 62, 162.0f, 197.0f, 18, 18, 256, 256);
                }
                RenderSystem.enableDepthTest();
                guiGraphics.blit(CONTAINER_BACKGROUND, startX + 26, startY + 82, 180.0f, 197.0f, 15, 11, 256, 256);
            }
        }
        if (!BzGeneralConfigs.crystallineFlowerConsumeItemUI) {
            xOffset = startX + 26;
            yOffset = startY + 78;
            RenderSystem.enableDepthTest();
            guiGraphics.blit(CONTAINER_BACKGROUND, xOffset, yOffset, 176.0f, 59.0f, 48, 19, 256, 256);
        }
    }

    private void drawEnchantmentText(GuiGraphics guiGraphics, int rowStartX, int currentRowStartY, EnchantmentSkeleton enchantmentEntry, int enchantmentNameColor, int enchantmentLevelColor, boolean shadow) {
        String translatedEnchantmentName = this.getTruncatedString(enchantmentEntry.namespace, enchantmentEntry.path, 88);
        MutableComponent mutableComponent = Component.literal((String)translatedEnchantmentName);
        MutableComponent mutableComponent2 = Component.translatable((String)"container.the_bumblezone.crystalline_flower.level", (Object[])new Object[]{enchantmentEntry.level});
        if (enchantmentEntry.isMaxLevel) {
            mutableComponent2.append((Component)Component.translatable((String)"container.the_bumblezone.crystalline_flower.level_star"));
        }
        guiGraphics.drawString(this.font, (Component)mutableComponent, rowStartX, currentRowStartY, enchantmentNameColor, shadow);
        guiGraphics.drawString(this.font, (Component)mutableComponent2, rowStartX + 5, currentRowStartY + 8, enchantmentLevelColor, shadow);
    }

    @NotNull
    private String getTruncatedString(String namespace, String path, int maxSize) {
        StringBuilder translatedEnchantmentName = new StringBuilder(Language.getInstance().getOrDefault("enchantment.%s.%s".formatted(namespace, path)));
        String originalNameOutput = translatedEnchantmentName.toString();
        if (originalNameOutput.contains("enchantment.")) {
            translatedEnchantmentName = new StringBuilder(Arrays.stream(path.split("_")).map(word -> word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" ")));
        }
        boolean hasTruncated = false;
        while (this.font.width(translatedEnchantmentName.toString()) > maxSize) {
            int nameLength = translatedEnchantmentName.length();
            if (hasTruncated) {
                translatedEnchantmentName.delete(nameLength - 3, nameLength);
            }
            nameLength = translatedEnchantmentName.length();
            Matcher matcher = SPLIT_WITH_COMBINING_CHARS.matcher(translatedEnchantmentName);
            if (!matcher.find()) break;
            List<MatchResult> matchResults = matcher.results().toList();
            MatchResult match = matchResults.get(matchResults.size() - 1);
            String lastCharacter = match.group();
            if (translatedEnchantmentName.toString().endsWith(lastCharacter)) {
                translatedEnchantmentName.delete(nameLength - lastCharacter.length(), nameLength);
            }
            translatedEnchantmentName.append("...");
            hasTruncated = true;
        }
        return translatedEnchantmentName.toString();
    }

    private void populateAvailableEnchants() {
        ItemStack book = ((CrystallineFlowerMenu)this.menu).bookSlot.getItem();
        if (!book.isEmpty() && ((CrystallineFlowerMenu)this.menu).xpTier.get() > 1 && ((CrystallineFlowerMenu)this.menu).tooManyEnchantmentsOnInput.get() != 1) {
            ItemStack tempBook = book.copy();
            tempBook.setCount(1);
        } else {
            enchantmentsAvailable.clear();
            enchantmentsAvailableSortedList.clear();
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialtick, int x, int y) {
        int startX = (this.width - this.imageWidth) / 2;
        int startY = (this.height - this.imageHeight) / 2;
        RenderSystem.enableDepthTest();
        guiGraphics.blit(CONTAINER_BACKGROUND, startX, startY, 0, 0, this.imageWidth, 126);
        guiGraphics.blit(CONTAINER_BACKGROUND, startX, startY + 126, 0, 126, this.imageWidth, 71);
    }

    private void renderXPBar(GuiGraphics guiGraphics, int startX, int startY) {
        if (((CrystallineFlowerMenu)this.menu).xpTier.get() == 7) {
            RenderSystem.enableDepthTest();
            guiGraphics.blit(CONTAINER_BACKGROUND, startX + 11, startY + 99, 176.0f, 182.0f, 54, 5, 256, 256);
        } else {
            RenderSystem.enableDepthTest();
            guiGraphics.blit(CONTAINER_BACKGROUND, startX + 11, startY + 99, 176.0f, 187.0f, 54, 5, 256, 256);
            if (((CrystallineFlowerMenu)this.menu).xpBarPercent.get() > 0) {
                RenderSystem.enableDepthTest();
                guiGraphics.blit(CONTAINER_BACKGROUND, startX + 11, startY + 99, 176.0f, 192.0f, (int)(54.0f * ((float)((CrystallineFlowerMenu)this.menu).xpBarPercent.get() / 100.0f)), 5, 256, 256);
            }
        }
    }

    private void renderScroller(GuiGraphics guiGraphics, int posX, int posY) {
        int rowCount = enchantmentsAvailableSortedList.size() + 1 - 3;
        if (rowCount > 1) {
            if (this.startIndex > rowCount) {
                this.scrollOff = 1.0f;
            }
            this.startIndex = (int)((double)(this.scrollOff * (float)this.getOffscreenRows()) + 0.5);
            int scrollPosition = (int)(this.scrollOff * 42.0f);
            RenderSystem.enableDepthTest();
            guiGraphics.blit(CONTAINER_BACKGROUND, posX, posY + scrollPosition, 230.0f, 182.0f, 6, 17, 256, 256);
        } else {
            RenderSystem.enableDepthTest();
            guiGraphics.blit(CONTAINER_BACKGROUND, posX, posY, 236.0f, 182.0f, 6, 17, 256, 256);
        }
    }

    private boolean canScroll(int numOffers) {
        return numOffers > 3;
    }

    private boolean handleEnchantmentAreaRow(double mouseX, double mouseY, Function<Integer, Boolean> targetedSectionTask, Consumer<Integer> untargetedSectionTask) {
        int startX = this.leftPos + 76 - 2;
        int startY = this.topPos + 52 - 2;
        int selectableSections = this.startIndex + Math.min(enchantmentsAvailableSortedList.size(), 3);
        boolean targetedSectionTaskSuccess = false;
        for (int currentSection = this.startIndex; currentSection < selectableSections; ++currentSection) {
            int sectionOffset = currentSection - this.startIndex;
            double sectionMouseX = mouseX - (double)startX;
            double sectionMouseY = mouseY - (double)(startY + sectionOffset * 19);
            if (sectionMouseX >= 0.0 && sectionMouseX < 88.0 && sectionMouseY >= 0.0 && sectionMouseY < 19.0) {
                targetedSectionTaskSuccess = targetedSectionTask.apply(currentSection);
                continue;
            }
            untargetedSectionTask.accept(currentSection);
        }
        return targetedSectionTaskSuccess;
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        int xOffset = this.leftPos + 163;
        int yOffset = this.topPos + 41;
        if ((double)(x - xOffset) >= 0.0 && (double)(x - xOffset) < 8.0 && (double)(y - yOffset) >= 0.0 && (double)(y - yOffset) < 8.0) {
            guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)("container.the_bumblezone.crystalline_flower." + CrystallineFlowerScreen.sortState.langKey))), Optional.empty(), x, y);
            return;
        }
        int startX = this.leftPos + 76 - 2;
        int startY = this.topPos + 52 - 2;
        int selectableSections = this.startIndex + Math.min(enchantmentsAvailableSortedList.size(), 3);
        for (int currentSection = this.startIndex; currentSection < selectableSections; ++currentSection) {
            MutableComponent mutableComponent4;
            if (currentSection >= enchantmentsAvailableSortedList.size()) continue;
            int sectionOffset = currentSection - this.startIndex;
            double sectionMouseX = (double)x - (double)startX;
            double sectionMouseY = (double)y - (double)(startY + sectionOffset * 19);
            if (!(sectionMouseX >= 0.0) || !(sectionMouseX < 88.0) || !(sectionMouseY >= 0.0) || !(sectionMouseY < 19.0)) continue;
            EnchantmentSkeleton enchantment = enchantmentsAvailable.get(enchantmentsAvailableSortedList.get(currentSection));
            int tierCost = EnchantmentUtils.getEnchantmentTierCost(enchantment.level, enchantment.minCost, enchantment.isTreasure, enchantment.isCurse);
            String translatedEnchantmentName = Language.getInstance().getOrDefault("enchantment.%s.%s".formatted(enchantment.namespace, enchantment.path));
            if (translatedEnchantmentName.contains("enchantment.")) {
                translatedEnchantmentName = Arrays.stream(enchantment.path.split("_")).map(word -> word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
            }
            MutableComponent mutableComponent = Component.literal((String)translatedEnchantmentName).withStyle(ChatFormatting.GOLD);
            MutableComponent mutableComponent2 = Component.translatable((String)"container.the_bumblezone.crystalline_flower.level", (Object[])new Object[]{enchantment.level}).withStyle(ChatFormatting.GREEN);
            if (enchantment.isMaxLevel) {
                mutableComponent2.append((Component)Component.translatable((String)"container.the_bumblezone.crystalline_flower.level_star"));
            }
            MutableComponent mutableComponent3 = Component.translatable((String)"container.the_bumblezone.crystalline_flower.tier_cost", (Object[])new Object[]{tierCost}).withStyle(ChatFormatting.RED);
            if (GeneralUtilsClient.isAdvancedToolTipActive()) {
                mutableComponent4 = Component.literal((String)(enchantment.namespace + ":" + enchantment.path)).withStyle(ChatFormatting.DARK_GRAY);
            } else {
                ModInfo info = PlatformHooks.getModInfo(enchantment.namespace);
                if (info == null) {
                    String formattedModid = Arrays.stream(enchantment.namespace.split("_")).map(word -> word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
                    mutableComponent4 = Component.literal((String)formattedModid).withStyle(ChatFormatting.BLUE);
                } else {
                    mutableComponent4 = Component.literal((String)info.displayName()).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC);
                }
            }
            guiGraphics.renderTooltip(this.font, List.of(mutableComponent, mutableComponent2, mutableComponent3, mutableComponent4), Optional.empty(), x, y);
            return;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.handleEnchantmentAreaRow(mouseX, mouseY, sectionId -> {
            if (((CrystallineFlowerMenu)this.menu).clickMenuEnchantment((Player)this.minecraft.player, enchantmentsAvailableSortedList.get((int)sectionId))) {
                this.sendButtonPressToMenu((Integer)sectionId);
                return true;
            }
            return false;
        }, i -> {})) {
            return true;
        }
        int startX = this.leftPos + 164;
        int startY = this.topPos + 50;
        if (mouseX >= (double)startX && mouseX < (double)(startX + 6) && mouseY >= (double)startY && mouseY < (double)(startY + 50)) {
            this.scrolling = true;
        }
        if (mouseX >= (double)(this.leftPos + 163) && mouseX < (double)(this.leftPos + 163 + 8) && mouseY >= (double)(this.topPos + 41) && mouseY < (double)(this.topPos + 41 + 8)) {
            this.pressedSortTimer = 25;
            sortState = sortState.next();
            CrystallineFlowerScreen.SortAndAssignAvailableEnchants();
            this.startIndex = 0;
            this.scrollOff = 0.0f;
        }
        if (((CrystallineFlowerMenu)this.menu).xpTier.get() != 7) {
            if (BzGeneralConfigs.crystallineFlowerConsumeExperienceUI && this.canPlayerBuyTier(1).booleanValue() && !this.isPathObstructed(1).booleanValue() && mouseX >= (double)(this.leftPos + 46) && mouseX < (double)(this.leftPos + 46 + 18) && mouseY >= (double)(this.topPos + 14) && mouseY < (double)(this.topPos + 14 + 18)) {
                this.pressedXp1Timer = 25;
                this.sendButtonPressToMenu(-2);
            } else if (BzGeneralConfigs.crystallineFlowerConsumeExperienceUI && this.canPlayerBuyTier(2).booleanValue() && !this.isPathObstructed(2).booleanValue() && mouseX >= (double)(this.leftPos + 46) && mouseX < (double)(this.leftPos + 46 + 18) && mouseY >= (double)(this.topPos + 34) && mouseY < (double)(this.topPos + 34 + 18)) {
                this.pressedXp2Timer = 25;
                this.sendButtonPressToMenu(-3);
            } else if (BzGeneralConfigs.crystallineFlowerConsumeExperienceUI && this.canPlayerBuyTier(3).booleanValue() && !this.isPathObstructed(3).booleanValue() && mouseX >= (double)(this.leftPos + 46) && mouseX < (double)(this.leftPos + 46 + 18) && mouseY >= (double)(this.topPos + 54) && mouseY < (double)(this.topPos + 54 + 18)) {
                this.pressedXp3Timer = 25;
                this.sendButtonPressToMenu(-4);
            } else if (BzGeneralConfigs.crystallineFlowerConsumeItemUI && ((CrystallineFlowerMenu)this.menu).consumeSlotFullyObstructed.get() != 1 && mouseX >= (double)(this.leftPos + 25) && mouseX < (double)(this.leftPos + 25 + 18) && mouseY >= (double)(this.topPos + 62) && mouseY < (double)(this.topPos + 62 + 18)) {
                this.pressedConsumeTimer = 25;
                this.sendButtonPressToMenu(-5);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private Boolean canPlayerBuyTier(int xpTiersToCheck) {
        return xpTiersToCheck <= ((CrystallineFlowerMenu)this.menu).playerHasXPForTier.get();
    }

    private Boolean isPathObstructed(int xpTiersToCheck) {
        for (int i = 0; i < xpTiersToCheck; ++i) {
            if (((CrystallineFlowerMenu)this.menu).xpTier.get() + i >= this.cachedObstructions.size() || !this.cachedObstructions.get(((CrystallineFlowerMenu)this.menu).xpTier.get() + i).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void sendButtonPressToMenu(Integer sectionId) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
        if (sectionId >= 0 && sectionId < enchantmentsAvailableSortedList.size()) {
            CrystallineFlowerClickedEnchantmentButtonPacket.sendToServer(((CrystallineFlowerMenu)this.menu).containerId, enchantmentsAvailableSortedList.get(sectionId));
        } else {
            this.minecraft.gameMode.handleInventoryButtonClick(((CrystallineFlowerMenu)this.menu).containerId, sectionId.intValue());
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.canScroll(enchantmentsAvailableSortedList.size())) {
            int topY = this.topPos + 50;
            int bottomY = topY + 50;
            this.scrollOff = ((float)mouseY - (float)topY - 7.5f) / ((float)(bottomY - topY) - 15.0f);
            this.scrollOff = Mth.clamp((float)this.scrollOff, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOff * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double delta) {
        if (this.canScroll(enchantmentsAvailableSortedList.size())) {
            int offscreenRows = this.getOffscreenRows();
            float percentage = (float)delta / (float)offscreenRows;
            this.scrollOff = Mth.clamp((float)(this.scrollOff - percentage), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOff * (float)offscreenRows) + 0.5);
        }
        return true;
    }

    protected int getOffscreenRows() {
        return Math.max(enchantmentsAvailableSortedList.size() - 3, 0);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int left, int top, int button) {
        return mouseX < (double)left || mouseY < (double)top || mouseX >= (double)(left + this.imageWidth) || mouseY >= (double)(top + this.imageHeight + 32);
    }

    public void onClose() {
        enchantmentsAvailable.clear();
        enchantmentsAvailableSortedList.clear();
        super.onClose();
    }

    public static void SortAndAssignAvailableEnchants() {
        enchantmentsAvailableSortedList = enchantmentsAvailable.entrySet().stream().sorted((e1, e2) -> {
            switch (sortState.ordinal()) {
                case 1: {
                    return compareByNamespaceAndLang.compare((Map.Entry<ResourceLocation, EnchantmentSkeleton>)e1, (Map.Entry<ResourceLocation, EnchantmentSkeleton>)e2);
                }
                case 2: {
                    return compareByTreasureCurseAndLang.compare((Map.Entry<ResourceLocation, EnchantmentSkeleton>)e1, (Map.Entry<ResourceLocation, EnchantmentSkeleton>)e2);
                }
                case 3: {
                    return compareByLevelAndLang.compare((Map.Entry<ResourceLocation, EnchantmentSkeleton>)e1, (Map.Entry<ResourceLocation, EnchantmentSkeleton>)e2);
                }
            }
            return compareByLang.compare((Map.Entry<ResourceLocation, EnchantmentSkeleton>)e1, (Map.Entry<ResourceLocation, EnchantmentSkeleton>)e2);
        }).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static enum SORT_STATE {
        ALPHABETICAL(0, 0, "sort_alphabetically"),
        MODID(8, 0, "sort_namespace"),
        TREASURE_AND_CURSE(0, 24, "sort_treasure_curse"),
        LEVEL(8, 24, "sort_level");

        private static final SORT_STATE[] vals;
        private final int offsetU;
        private final int offsetV;
        private final String langKey;

        private SORT_STATE(int offsetU, int offsetV, String langKey) {
            this.offsetU = offsetU;
            this.offsetV = offsetV;
            this.langKey = langKey;
        }

        public SORT_STATE next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = SORT_STATE.values();
        }
    }
}

