/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.beequeen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.telepathicgrunt.the_bumblezone.client.rendering.beequeen.BeeQueenModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.transparentitem.TranslucentItemRenderTypeBuffer;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.entities.mobs.BeeQueenEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;

public class BeeQueenRenderer
extends MobRenderer<BeeQueenEntity, BeeQueenModel> {
    private static final ResourceLocation SKIN = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/entity/bee_queen.png");
    private static final ResourceLocation ANGRY_SKIN = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/entity/bee_queen_angry.png");
    private final ItemInHandRenderer itemRenderer;

    public BeeQueenRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new BeeQueenModel(context.bakeLayer(BeeQueenModel.LAYER_LOCATION)), 1.2f);
        this.itemRenderer = context.getItemInHandRenderer();
    }

    public void render(BeeQueenEntity beeQueenEntity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        super.render((LivingEntity)beeQueenEntity, entityYaw, partialTicks, stack, buffer, packedLight);
        stack.popPose();
        if (!beeQueenEntity.isAngry() && BzClientConfigs.renderBeeQueenBonusTradeItem && !beeQueenEntity.getBonusTradeItem().isEmpty()) {
            stack.pushPose();
            float scale = 2.6f;
            stack.scale(scale, scale, scale);
            float rotYaw = Mth.rotLerp((float)partialTicks, (float)beeQueenEntity.yBodyRotO, (float)beeQueenEntity.yBodyRot);
            stack.mulPose(Axis.YP.rotationDegrees(180.0f - rotYaw + 180.0f));
            ((BeeQueenModel)this.getModel()).root().translateAndRotate(stack);
            ((BeeQueenModel)this.getModel()).root().getChild("segment3").translateAndRotate(stack);
            stack.translate(-0.15f, -1.25f, -0.22f);
            stack.mulPose(Axis.YP.rotationDegrees(-75.0f));
            stack.mulPose(Axis.XP.rotationDegrees(-20.0f));
            stack.scale(0.6f, 0.6f, 0.6f);
            int alpha = 180;
            TranslucentItemRenderTypeBuffer bufferToUse = new TranslucentItemRenderTypeBuffer(buffer, alpha);
            this.itemRenderer.renderItem((LivingEntity)beeQueenEntity, beeQueenEntity.getBonusTradeItem(), ItemDisplayContext.GROUND, false, stack, (MultiBufferSource)bufferToUse, packedLight);
            stack.popPose();
        }
    }

    public ResourceLocation getTextureLocation(BeeQueenEntity bee) {
        return bee.isAngry() ? ANGRY_SKIN : SKIN;
    }
}

