/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.beehemoth;

import com.mojang.blaze3d.vertex.PoseStack;
import com.telepathicgrunt.the_bumblezone.client.rendering.beehemoth.BeehemothModel;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix4f;

public class BeehemothRenderer
extends MobRenderer<BeehemothEntity, BeehemothModel> {
    private static final ResourceLocation SKIN = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/entity/beehemoth.png");

    public BeehemothRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new BeehemothModel(context.bakeLayer(BeehemothModel.LAYER_LOCATION)), 0.4f);
    }

    public void render(BeehemothEntity beehemothEntity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        super.render((LivingEntity)beehemothEntity, entityYaw, partialTicks, stack, buffer, packedLight);
        stack.popPose();
        if (beehemothEntity == this.entityRenderDispatcher.crosshairPickEntity && !beehemothEntity.isQueen() && beehemothEntity.isTame() && beehemothEntity.isOwnedBy((LivingEntity)GeneralUtilsClient.getClientPlayer())) {
            this.renderFriendshipProgress(beehemothEntity, (Component)Component.translatable((String)"entity.the_bumblezone.beehemoth_friendship_progress", (Object[])new Object[]{beehemothEntity.getFriendship()}), stack, buffer, packedLight);
        }
    }

    protected void renderFriendshipProgress(BeehemothEntity entity, Component component, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        if (this.entityRenderDispatcher.distanceToSqr((Entity)entity) > 100.0) {
            return;
        }
        float f = entity.getBbHeight() + 0.75f;
        poseStack.pushPose();
        poseStack.translate(0.0f, f, 0.0f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        Font font = this.getFont();
        float h = (float)(-font.width((FormattedText)component)) / 2.0f;
        font.drawInBatch(component, h, 0.0f, -1, false, matrix4f, multiBufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(BeehemothEntity bee) {
        return SKIN;
    }
}

