/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.datamanagers;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzTagsUpdatedEvent;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;

public class CrystallineFlowerDataManager
extends SimpleJsonResourceReloadListener {
    public static final CrystallineFlowerDataManager CRYSTALLINE_FLOWER_DATA_MANAGER = new CrystallineFlowerDataManager();
    public final List<FlowerData> cachedFlowerData = new ArrayList<FlowerData>();
    public final Map<Item, Pair<Integer, Boolean>> itemToXp = new Object2ObjectArrayMap();
    public Set<Item> disallowConsume = new HashSet<Item>();
    public boolean allowNormalConsumption = true;

    public CrystallineFlowerDataManager() {
        super(Bumblezone.GSON, "bz_crystalline_flower_data");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        this.itemToXp.clear();
        this.disallowConsume.clear();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                DataResult mapDataResult = FlowerData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement);
                mapDataResult.resultOrPartial(s -> {}).ifPresent(this.cachedFlowerData::add);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Bumblezone Error: Couldn't parse crystalline flower data file: {}", fileIdentifier, (Object)e);
            }
        });
    }

    public void resolveFlowerData(BzTagsUpdatedEvent event) {
        for (FlowerData flowerData : this.cachedFlowerData) {
            flowerData.allowNormalConsumption().ifPresent(b -> {
                this.allowNormalConsumption = b;
            });
            flowerData.disallowTag().flatMap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getTag(arg_0)).ifPresent(tagItems -> tagItems.forEach(itemHolder -> this.disallowConsume.add((Item)itemHolder.value())));
            flowerData.itemConsumeData().forEach(itemConsumeData -> BuiltInRegistries.ITEM.getTag(itemConsumeData.tag()).ifPresent(tagItems -> {
                for (Holder itemHolder : tagItems) {
                    if (itemConsumeData.maxXp) {
                        this.itemToXp.put((Item)itemHolder.value(), (Pair<Integer, Boolean>)Pair.of((Object)itemConsumeData.xp, (Object)true));
                        break;
                    }
                    Pair<Integer, Boolean> pair = this.itemToXp.get(itemHolder.value());
                    if (pair != null && ((Integer)pair.getFirst() >= itemConsumeData.xp || ((Boolean)pair.getSecond()).booleanValue())) continue;
                    this.itemToXp.put((Item)itemHolder.value(), (Pair<Integer, Boolean>)Pair.of((Object)itemConsumeData.xp, (Object)false));
                    break;
                }
            }));
        }
        this.cachedFlowerData.clear();
    }

    public record FlowerData(List<ItemConsumeData> itemConsumeData, Optional<TagKey<Item>> disallowTag, Optional<Boolean> allowNormalConsumption) {
        public static final Codec<FlowerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemConsumeData.ENTRY_CODEC.listOf().fieldOf("item_consume_data").orElse(new ArrayList()).forGetter(e -> e.itemConsumeData), (App)TagKey.codec((ResourceKey)Registries.ITEM).optionalFieldOf("do_not_consume_items_override").forGetter(e -> e.disallowTag), (App)Codec.BOOL.optionalFieldOf("allow_default_1_xp_item_consuming").forGetter(i -> i.allowNormalConsumption)).apply((Applicative)instance, instance.stable(FlowerData::new)));
    }

    public record ItemConsumeData(TagKey<Item> tag, int xp, boolean maxXp) {
        public static final Codec<ItemConsumeData> ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(i -> i.tag), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("xp_granted").orElse((Object)1).forGetter(i -> i.xp), (App)Codec.BOOL.fieldOf("max_xp_granted").orElse((Object)false).forGetter(i -> i.maxXp)).apply((Applicative)instance, instance.stable(ItemConsumeData::new)));
    }
}

