/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.blockentities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.advancements.ItemSpecificTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EssenceBlockEntity
extends BlockEntity {
    private static final String UUID_TAG = "uuid";
    private static final String EVENT_TIMER_TAG = "eventTimer";
    private static final String PROGRESS_TAG = "eventBarProgress";
    private static final String PLAYERS_IN_ARENA_TAG = "playersInArena";
    private static final String EVENT_ENTITIES_IN_ARENA_TAG = "eventEntitiesInArena";
    private static final String EXTRA_EVENT_TRACKING_PROGRESS_TAG = "extraEventTrackingProgress";
    private static final String ARENA_SIZE_TAG = "arenaSize";
    private static final String BEATEN_TAG = "beaten";
    private UUID uuid = null;
    private int eventTimer = 0;
    private List<UUID> playerInArena = new ArrayList<UUID>();
    private ServerEssenceEvent eventBar = null;
    private List<EventEntities> eventEntitiesInArena = Collections.synchronizedList(new ArrayList());
    private int extraEventTrackingProgress = 0;
    private BlockPos arenaSize = BlockPos.ZERO;
    private boolean beaten = false;

    protected EssenceBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        Block block = blockState.getBlock();
        if (block instanceof EssenceBlock) {
            EssenceBlock essenceBlock = (EssenceBlock)block;
            this.eventBar = essenceBlock.getServerEssenceEvent();
        }
    }

    public EssenceBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)BzBlockEntities.ESSENCE_BLOCK.get(), blockPos, blockState);
        Block block = blockState.getBlock();
        if (block instanceof EssenceBlock) {
            EssenceBlock essenceBlock = (EssenceBlock)block;
            this.eventBar = essenceBlock.getServerEssenceEvent();
        }
    }

    public int getEventTimer() {
        return this.eventTimer;
    }

    public void setEventTimer(int eventTimer) {
        this.eventTimer = eventTimer;
    }

    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    public List<UUID> getPlayerInArena() {
        return this.playerInArena;
    }

    public void setPlayerInArena(List<UUID> playerInArena) {
        this.playerInArena = playerInArena;
    }

    public ServerEssenceEvent getEventBar() {
        return this.eventBar;
    }

    public void setEventBar(ServerEssenceEvent eventBar) {
        this.eventBar = eventBar;
    }

    public List<EventEntities> getEventEntitiesInArena() {
        return this.eventEntitiesInArena;
    }

    public void setEventEntitiesInArena(List<EventEntities> eventEntitiesInArena) {
        this.eventEntitiesInArena = eventEntitiesInArena;
    }

    public int getExtraEventTrackingProgress() {
        return this.extraEventTrackingProgress;
    }

    public void setExtraEventTrackingProgress(int extraEventTrackingProgress) {
        this.extraEventTrackingProgress = extraEventTrackingProgress;
    }

    public BlockPos getArenaSize() {
        return this.arenaSize;
    }

    public void setArenaSize(BlockPos arenaSize) {
        this.arenaSize = arenaSize;
    }

    public boolean isBeaten() {
        return this.beaten;
    }

    public void setBeaten(boolean beaten) {
        this.beaten = beaten;
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        if (compoundTag != null) {
            this.beaten = compoundTag.getBoolean(BEATEN_TAG);
            this.eventBar.setProgress(compoundTag.getFloat(PROGRESS_TAG));
            this.extraEventTrackingProgress = compoundTag.getInt(EXTRA_EVENT_TRACKING_PROGRESS_TAG);
            this.eventTimer = compoundTag.getInt(EVENT_TIMER_TAG);
            this.eventBar.setEndEventTimer(this.eventTimer, this.getLevel() == null ? 1.0f : this.getLevel().tickRateManager().tickrate());
            this.uuid = compoundTag.contains(UUID_TAG) ? compoundTag.getUUID(UUID_TAG) : UUID.randomUUID();
            if (compoundTag.contains(PLAYERS_IN_ARENA_TAG)) {
                this.playerInArena.clear();
                for (Tag tag : compoundTag.getList(PLAYERS_IN_ARENA_TAG, 11)) {
                    this.playerInArena.add(NbtUtils.loadUUID((Tag)tag));
                }
            }
            if (compoundTag.contains(EVENT_ENTITIES_IN_ARENA_TAG)) {
                this.eventEntitiesInArena.clear();
                for (Tag tag : compoundTag.getList(EVENT_ENTITIES_IN_ARENA_TAG, 11)) {
                    this.eventEntitiesInArena.add(new EventEntities(NbtUtils.loadUUID((Tag)tag)));
                }
            }
            this.arenaSize = NbtUtils.readBlockPos((CompoundTag)compoundTag.getCompound(ARENA_SIZE_TAG), (String)ARENA_SIZE_TAG).orElse(BlockPos.ZERO);
        }
        if (this.level != null && this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 8);
        }
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        this.saveFieldsToTag(compoundTag);
        if (this.getLevel() != null) {
            for (int i = this.getPlayerInArena().size() - 1; i >= 0; --i) {
                UUID playerUUID = this.getPlayerInArena().get(i);
                ServerPlayer serverPlayer = this.getLevel().getServer().getPlayerList().getPlayer(playerUUID);
                if (serverPlayer == null || !serverPlayer.isDeadOrDying() && Math.abs(serverPlayer.blockPosition().getX() - this.getBlockPos().getX()) <= (this.getArenaSize().getX() + 1) / 2 && Math.abs(serverPlayer.blockPosition().getY() - this.getBlockPos().getY()) <= (this.getArenaSize().getY() + 1) / 2 && Math.abs(serverPlayer.blockPosition().getZ() - this.getBlockPos().getZ()) <= (this.getArenaSize().getZ() + 1) / 2) continue;
                Block block = this.getBlockState().getBlock();
                if (block instanceof EssenceBlock) {
                    EssenceBlock essenceBlock = (EssenceBlock)block;
                    essenceBlock.onPlayerLeave(serverPlayer.serverLevel(), serverPlayer, this);
                }
                this.getPlayerInArena().remove(playerUUID);
                this.getEventBar().removePlayer(serverPlayer);
                this.setChanged();
            }
        }
    }

    private void saveFieldsToTag(CompoundTag compoundTag) {
        compoundTag.putBoolean(BEATEN_TAG, this.beaten);
        compoundTag.put(UUID_TAG, (Tag)NbtUtils.createUUID((UUID)this.getUUID()));
        compoundTag.putInt(EVENT_TIMER_TAG, this.eventTimer);
        compoundTag.putInt(EXTRA_EVENT_TRACKING_PROGRESS_TAG, this.extraEventTrackingProgress);
        compoundTag.putFloat(PROGRESS_TAG, this.eventBar.getProgress());
        ListTag players = new ListTag();
        for (UUID target : this.playerInArena) {
            players.add((Object)NbtUtils.createUUID((UUID)target));
        }
        compoundTag.put(PLAYERS_IN_ARENA_TAG, (Tag)players);
        ListTag eventEntities = new ListTag();
        for (EventEntities target : this.eventEntitiesInArena) {
            eventEntities.add((Object)NbtUtils.createUUID((UUID)target.uuid()));
        }
        compoundTag.put(EVENT_ENTITIES_IN_ARENA_TAG, (Tag)eventEntities);
        compoundTag.put(ARENA_SIZE_TAG, NbtUtils.writeBlockPos((BlockPos)this.arenaSize));
    }

    public ResourceLocation getSavedNbtLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)("essence/saved_area/" + this.getBlockPos().getX() + "_" + this.getBlockPos().getY() + "_" + this.getBlockPos().getZ() + "_" + this.getUUID().toString().toLowerCase(Locale.ROOT)));
    }

    public String getSavedNbtLocationAsString() {
        return "the_bumblezone:essence/saved_area/" + this.getBlockPos().getX() + "_" + this.getBlockPos().getY() + "_" + this.getBlockPos().getZ() + "_" + this.getUUID().toString().toLowerCase(Locale.ROOT);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveFieldsToTag(tag);
        return tag;
    }

    public boolean shouldDrawSide(Direction direction) {
        return Block.shouldRenderFace((BlockState)this.getBlockState(), (BlockGetter)this.getLevel(), (BlockPos)this.getBlockPos(), (Direction)direction, (BlockPos)this.getBlockPos().relative(direction));
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!essenceBlockEntity.getPlayerInArena().isEmpty()) {
                EssenceBlockEntity.performArenaTick(serverLevel, blockPos, blockState, essenceBlockEntity);
            } else if (essenceBlockEntity.getEventTimer() > 0) {
                EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, false);
            }
        }
    }

    private static void performArenaTick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        boolean endEvent = false;
        if (serverLevel.getGameTime() % 20L == 1L) {
            for (int i = essenceBlockEntity.getPlayerInArena().size() - 1; i >= 0; --i) {
                UUID playerUUID = essenceBlockEntity.getPlayerInArena().get(i);
                ServerPlayer serverPlayer = (ServerPlayer)serverLevel.getPlayerByUUID(playerUUID);
                if (serverPlayer != null && !PlatformHooks.isFakePlayer(serverPlayer)) {
                    EssenceBlock essenceBlock;
                    Block block;
                    if (serverPlayer.isDeadOrDying() || Math.abs(serverPlayer.blockPosition().getX() - blockPos.getX()) > essenceBlockEntity.getArenaSize().getX() / 2 || Math.abs(serverPlayer.blockPosition().getY() - blockPos.getY()) > essenceBlockEntity.getArenaSize().getY() / 2 || Math.abs(serverPlayer.blockPosition().getZ() - blockPos.getZ()) > essenceBlockEntity.getArenaSize().getZ() / 2) {
                        block = essenceBlockEntity.getBlockState().getBlock();
                        if (block instanceof EssenceBlock) {
                            essenceBlock = (EssenceBlock)block;
                            essenceBlock.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
                        }
                        essenceBlockEntity.getPlayerInArena().remove(playerUUID);
                        essenceBlockEntity.getEventBar().removePlayer(serverPlayer);
                        essenceBlockEntity.setChanged();
                        continue;
                    }
                    block = essenceBlockEntity.getBlockState().getBlock();
                    if (!(block instanceof EssenceBlock)) continue;
                    essenceBlock = (EssenceBlock)block;
                    if (!essenceBlockEntity.getEventBar().getPlayers().contains(serverPlayer)) {
                        essenceBlockEntity.getEventBar().addPlayer(serverPlayer);
                        essenceBlock.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
                    }
                    if (!essenceBlock.hasMiningFatigue()) continue;
                    if (serverPlayer.hasEffect(MobEffects.DIG_SLOWDOWN) && serverPlayer.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier() >= 0) {
                        serverPlayer.removeEffect(MobEffects.DIG_SLOWDOWN);
                    }
                    serverPlayer.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, essenceBlockEntity.getEventTimer(), -1, false, false));
                    continue;
                }
                essenceBlockEntity.getPlayerInArena().remove(playerUUID);
                essenceBlockEntity.getEventBar().removePlayer(serverPlayer);
                essenceBlockEntity.setChanged();
            }
            if (essenceBlockEntity.getPlayerInArena().isEmpty()) {
                endEvent = true;
            }
        }
        if (essenceBlockEntity.getEventTimer() <= 0) {
            endEvent = true;
        }
        if (endEvent) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, false);
        } else {
            essenceBlockEntity.setEventTimer(essenceBlockEntity.getEventTimer() - 1);
            essenceBlockEntity.getEventBar().setEndEventTimer(essenceBlockEntity.getEventTimer(), serverLevel.tickRateManager().tickrate());
            Block block = blockState.getBlock();
            if (block instanceof EssenceBlock) {
                EssenceBlock essenceBlock = (EssenceBlock)block;
                essenceBlock.performUniqueArenaTick(serverLevel, blockPos, blockState, essenceBlockEntity);
            }
            essenceBlockEntity.setChanged();
        }
    }

    public static void EndEvent(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity, boolean won) {
        Optional optionalStructureTemplate = serverLevel.getStructureManager().get(essenceBlockEntity.getSavedNbtLocation());
        optionalStructureTemplate.ifPresentOrElse(structureTemplate -> {
            Vec3i size = structureTemplate.getSize();
            BlockPos negativeHalfLengths = new BlockPos(-size.getX() / 2, -size.getY() / 2, -size.getZ() / 2);
            structureTemplate.placeInWorld((ServerLevelAccessor)serverLevel, blockPos.offset((Vec3i)negativeHalfLengths), blockPos.offset((Vec3i)negativeHalfLengths), EssenceBlock.PLACEMENT_SETTINGS.getOrFillFromInternal(), serverLevel.getRandom(), 2);
            for (UUID playerUUID : essenceBlockEntity.getPlayerInArena()) {
                Block patt1$temp;
                ServerPlayer serverPlayer = (ServerPlayer)serverLevel.getPlayerByUUID(playerUUID);
                if (serverPlayer == null) continue;
                Block patt0$temp = essenceBlockEntity.getBlockState().getBlock();
                if (patt0$temp instanceof EssenceBlock) {
                    EssenceBlock essenceBlock = (EssenceBlock)patt0$temp;
                    essenceBlock.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
                }
                if (blockPos.getX() + size.getX() <= serverPlayer.blockPosition().getX() || blockPos.getY() + size.getY() <= serverPlayer.blockPosition().getY() || blockPos.getZ() + size.getZ() <= serverPlayer.blockPosition().getZ() || blockPos.getX() - size.getX() >= serverPlayer.blockPosition().getX() || blockPos.getY() - size.getY() >= serverPlayer.blockPosition().getY() || blockPos.getZ() - size.getZ() >= serverPlayer.blockPosition().getZ()) continue;
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(serverLevel.getRandom());
                serverPlayer.setDeltaMovement(0.0, 0.0, 0.0);
                serverPlayer.teleportTo((double)((float)blockPos.getX() + (float)direction.getStepX() * ((float)(negativeHalfLengths.getX() + 1) / -2.0f) + 0.5f), (double)(blockPos.getY() + negativeHalfLengths.getY() + 2), (double)((float)blockPos.getZ() + (float)direction.getStepZ() * ((float)(negativeHalfLengths.getZ() + 1) / -2.0f) + 0.5f));
                serverPlayer.lookAt(EntityAnchorArgument.Anchor.EYES, Vec3.atCenterOf((Vec3i)blockPos));
                EssenceBlock.spawnParticles(serverLevel, serverPlayer.position(), serverPlayer.getRandom());
                if (!won || !((patt1$temp = blockState.getBlock()) instanceof EssenceBlock)) continue;
                EssenceBlock essenceBlock = (EssenceBlock)patt1$temp;
                LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)essenceBlock.getEssenceItemReward()));
                if (lootTable != null) {
                    LootParams.Builder lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)blockPos)).withParameter(LootContextParams.THIS_ENTITY, (Object)serverPlayer);
                    ObjectArrayList newItems = new ObjectArrayList();
                    lootTable.getRandomItems(lootParams.create(LootContextParamSets.ADVANCEMENT_REWARD), arg_0 -> ((ObjectArrayList)newItems).add(arg_0));
                    for (ItemStack reward : newItems) {
                        ((ItemSpecificTrigger)((Object)((Object)BzCriterias.ESSENCE_EVENT_REWARD_TRIGGER.get()))).trigger(serverPlayer, reward);
                        if (serverPlayer.addItem(reward)) continue;
                        serverPlayer.drop(reward, false);
                    }
                }
                int xpReward = essenceBlock.getEssenceXpReward();
                if (essenceBlockEntity.isBeaten()) {
                    xpReward = (int)((double)xpReward * 0.1);
                }
                serverPlayer.giveExperiencePoints(xpReward);
                essenceBlock.awardPlayerWinStat(serverPlayer);
            }
            List entities = serverLevel.getEntities(null, new AABB((double)(blockPos.getX() + size.getX()), (double)(blockPos.getY() + size.getY()), (double)(blockPos.getZ() + size.getZ()), (double)(blockPos.getX() - size.getX()), (double)(blockPos.getY() - size.getY()), (double)(blockPos.getZ() - size.getZ())));
            for (Entity entity : entities) {
                Mob mob;
                NeutralMob neutralMob;
                if ((!(entity instanceof NeutralMob) || !((neutralMob = (NeutralMob)entity).getTarget() instanceof Player)) && (!(entity instanceof Mob) || !((mob = (Mob)entity).getTarget() instanceof Player))) continue;
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
            for (EventEntities eventEntities : essenceBlockEntity.getEventEntitiesInArena()) {
                Entity entity = serverLevel.getEntity(eventEntities.uuid());
                if (entity == null) continue;
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
            if (!essenceBlockEntity.getPlayerInArena().isEmpty() && won && !BzGeneralConfigs.repeatableEssenceEvents) {
                serverLevel.setBlock(blockPos, ((Block)BzBlocks.HEAVY_AIR.get()).defaultBlockState(), 3);
            }
        }, () -> Bumblezone.LOGGER.error("Bumblezone Essence Block failed to restore area from saved NBT - {} - {} - Location: {}", new Object[]{essenceBlockEntity, blockState, essenceBlockEntity.getSavedNbtLocationAsString()}));
        essenceBlockEntity.getEventBar().removeAllPlayers();
        essenceBlockEntity.getPlayerInArena().clear();
        essenceBlockEntity.getEventEntitiesInArena().clear();
        essenceBlockEntity.setExtraEventTrackingProgress(0);
        essenceBlockEntity.setEventTimer(0);
        essenceBlockEntity.setArenaSize(BlockPos.ZERO);
        essenceBlockEntity.setChanged();
    }

    public void setRemoved() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (UUID playerUUID : this.getPlayerInArena()) {
                Block block;
                ServerPlayer serverPlayer = (ServerPlayer)serverLevel.getPlayerByUUID(playerUUID);
                if (serverPlayer == null || !((block = this.getBlockState().getBlock()) instanceof EssenceBlock)) continue;
                EssenceBlock essenceBlock = (EssenceBlock)block;
                essenceBlock.onPlayerLeave(serverLevel, serverPlayer, this);
            }
        }
        this.getEventBar().removeAllPlayers();
        super.setRemoved();
    }

    public static EssenceBlockEntity getEssenceBlockAtLocation(Level level, ResourceKey<Level> targetLevel, BlockPos targetBlockPos, UUID targetEssenceUUID) {
        EssenceBlockEntity essenceBlockEntity;
        BlockEntity blockEntity;
        if (targetEssenceUUID != null && level != null && targetBlockPos != null && level.dimension().equals(targetLevel) && (blockEntity = level.getBlockEntity(targetBlockPos)) instanceof EssenceBlockEntity && (essenceBlockEntity = (EssenceBlockEntity)blockEntity).getEventTimer() > 0 && essenceBlockEntity.getUUID().equals(targetEssenceUUID)) {
            return essenceBlockEntity;
        }
        return null;
    }

    public record EventEntities(UUID uuid) {
    }
}

