/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.blockentities;

import com.telepathicgrunt.the_bumblezone.blocks.CrystallineFlower;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.HoneyCrystalShards;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.CrystallineFlowerData;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CrystallineFlowerBlockEntity
extends BlockEntity {
    public static final String TIER_TAG = "tier";
    public static final String XP_TAG = "xp";
    public static final String UUID_TAG = "guid";
    private int xpTier = 1;
    private int currentXp = 0;
    private UUID uuid = UUID.randomUUID();
    public static final String BOOK_SLOT_ITEMS = "bookItems";
    public static final String CONSUME_SLOT_ITEMS = "consumeItems";
    private ItemStack bookSlotItems = ItemStack.EMPTY;
    private ItemStack consumeSlotItems = ItemStack.EMPTY;

    protected CrystallineFlowerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public CrystallineFlowerBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)BzBlockEntities.CRYSTALLINE_FLOWER.get(), blockPos, blockState);
    }

    public int getXpTier() {
        return this.xpTier;
    }

    public void setXpTier(int xpTier) {
        this.xpTier = xpTier;
    }

    public int getCurrentXp() {
        return this.currentXp;
    }

    public void setCurrentXp(int currentXp) {
        this.currentXp = currentXp;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setGUID(UUID uuid) {
        this.uuid = uuid;
    }

    public ItemStack getBookSlotItems() {
        return this.bookSlotItems;
    }

    public void setBookSlotItems(ItemStack bookSlotItems) {
        this.bookSlotItems = bookSlotItems;
    }

    public ItemStack getConsumeSlotItems() {
        return this.consumeSlotItems;
    }

    public void setConsumeSlotItems(ItemStack consumeSlotItems) {
        this.consumeSlotItems = consumeSlotItems;
        this.setPillar(0);
    }

    public void syncPillar() {
        this.setPillar(0);
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.xpTier = compoundTag.getInt(TIER_TAG);
        this.currentXp = Math.min(compoundTag.getInt(XP_TAG), this.getMaxXpForTier(this.xpTier));
        if (compoundTag.contains(UUID_TAG)) {
            this.uuid = compoundTag.getTagType(UUID_TAG) == 8 ? UUID.fromString(compoundTag.getString(UUID_TAG)) : compoundTag.getUUID(UUID_TAG);
            if (this.uuid.compareTo(CrystallineFlowerData.DEFAULT_UUID) == 0) {
                this.uuid = UUID.randomUUID();
            }
        } else {
            this.uuid = UUID.randomUUID();
        }
        if (compoundTag.contains(BOOK_SLOT_ITEMS)) {
            this.bookSlotItems = ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundTag.getCompound(BOOK_SLOT_ITEMS)).orElse(ItemStack.EMPTY);
        }
        if (compoundTag.contains(CONSUME_SLOT_ITEMS)) {
            this.consumeSlotItems = ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundTag.getCompound(CONSUME_SLOT_ITEMS)).orElse(ItemStack.EMPTY);
        }
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        this.saveFieldsToTag(compoundTag, provider);
    }

    private void saveFieldsToTag(CompoundTag compoundTag, HolderLookup.Provider provider) {
        compoundTag.putInt(TIER_TAG, this.xpTier);
        compoundTag.putInt(XP_TAG, this.currentXp);
        compoundTag.putUUID(UUID_TAG, this.uuid);
        if (!this.bookSlotItems.isEmpty()) {
            compoundTag.put(BOOK_SLOT_ITEMS, this.bookSlotItems.save(provider));
        }
        if (!this.consumeSlotItems.isEmpty()) {
            compoundTag.put(CONSUME_SLOT_ITEMS, this.consumeSlotItems.save(provider));
        }
    }

    public void saveToItem(ItemStack stack, HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)this.getType(), (CompoundTag)compoundTag);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveFieldsToTag(tag, provider);
        return tag;
    }

    public void addXpAndTier(int xpChange) {
        this.currentXp += xpChange;
        int tierChange = 0;
        while (this.currentXp >= this.getMaxXpForTier(this.xpTier) && !this.isMaxTier()) {
            this.currentXp -= this.getMaxXpForTier(this.xpTier);
            ++tierChange;
            ++this.xpTier;
        }
        while (this.currentXp < 0 && !this.isMinTier()) {
            this.currentXp += this.getMaxXpForTier(this.xpTier);
            --tierChange;
            --this.xpTier;
        }
        if (this.isMaxTier()) {
            this.currentXp = 0;
        }
        if (this.currentXp >= this.getMaxXpForTier(this.xpTier)) {
            this.currentXp = this.getMaxXpForTier(this.xpTier);
        } else if (this.currentXp < 0) {
            this.currentXp = 0;
        }
        this.setChanged();
        this.setPillar(tierChange);
    }

    public void increaseTier(int tierIncrease) {
        int tierChange = Math.min(7 - this.xpTier, tierIncrease);
        if (!this.isMaxTier()) {
            this.xpTier += tierIncrease;
        } else {
            this.currentXp = this.getMaxXpForTier(this.xpTier);
        }
        if (this.currentXp >= this.getMaxXpForTier(this.xpTier) && !this.isMaxTier()) {
            this.currentXp = this.getMaxXpForTier(this.xpTier) - 1;
        }
        this.setChanged();
        this.setPillar(tierChange);
    }

    public void decreaseTier(int tierDecrease) {
        int tierChange = Math.min(this.xpTier - 1, tierDecrease);
        if (!this.isMinTier()) {
            this.xpTier -= tierDecrease;
        }
        if (this.currentXp >= this.getMaxXpForTier(this.xpTier) && !this.isMaxTier()) {
            this.currentXp = this.getMaxXpForTier(this.xpTier) - 1;
        }
        this.setChanged();
        this.setPillar(-tierChange);
    }

    public void setPillar(int tierChange) {
        if (this.level != null) {
            int bottomHeight = CrystallineFlower.flowerHeightBelow((LevelReader)this.level, this.getBlockPos());
            BlockPos operatingPos = this.getBlockPos().below(bottomHeight);
            int topHeight = CrystallineFlower.flowerHeightAbove((LevelReader)this.level, operatingPos);
            BlockEntity blockEntity = this.level.getBlockEntity(operatingPos);
            if (blockEntity instanceof CrystallineFlowerBlockEntity) {
                CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
                if (tierChange != 0) {
                    BlockEntity targetBlockEntity;
                    if (bottomHeight != 0 && (targetBlockEntity = this.level.getBlockEntity(this.getBlockPos().below(bottomHeight))) instanceof CrystallineFlowerBlockEntity) {
                        targetBlockEntity.loadWithComponents(crystallineFlowerBlockEntity.getUpdateTag((HolderLookup.Provider)this.level.registryAccess()), (HolderLookup.Provider)this.level.registryAccess());
                    }
                    boolean upward = tierChange > 0;
                    for (int i = 0; i < (upward ? this.xpTier : topHeight + 1); ++i) {
                        boolean placePlant = upward || i < this.xpTier;
                        this.level.setBlock(operatingPos.above(i), placePlant ? ((Block)BzBlocks.CRYSTALLINE_FLOWER.get()).defaultBlockState() : Blocks.AIR.defaultBlockState(), 2);
                        Level level = this.level;
                        if (!(level instanceof ServerLevel)) continue;
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (placePlant) continue;
                        int itemsToDrop = 0;
                        while ((double)itemsToDrop < 2.0 + (double)i / 1.5) {
                            ItemStack stack = ((HoneyCrystalShards)((Object)BzItems.HONEY_CRYSTAL_SHARDS.get())).getDefaultInstance();
                            stack.setCount(1);
                            GeneralUtils.spawnItemEntity(serverLevel, operatingPos.above(i), stack, 0.05, 0.2);
                            ++itemsToDrop;
                        }
                    }
                    operatingPos = operatingPos.above(upward ? this.xpTier - 1 : topHeight + tierChange);
                    this.level.setBlock(operatingPos, (BlockState)((Block)BzBlocks.CRYSTALLINE_FLOWER.get()).defaultBlockState().setValue((Property)CrystallineFlower.FLOWER, (Comparable)Boolean.valueOf(true)), 2);
                    BlockEntity blockEntity2 = this.level.getBlockEntity(operatingPos);
                    if (blockEntity2 instanceof CrystallineFlowerBlockEntity) {
                        CrystallineFlowerBlockEntity crystallineFlowerBlockEntity2 = (CrystallineFlowerBlockEntity)blockEntity2;
                        crystallineFlowerBlockEntity2.loadWithComponents(crystallineFlowerBlockEntity.getUpdateTag((HolderLookup.Provider)this.level.registryAccess()), (HolderLookup.Provider)this.level.registryAccess());
                        blockEntity2.setChanged();
                    }
                }
                for (int i = 0; i <= topHeight; ++i) {
                    BlockEntity blockEntity2;
                    BlockPos updatePos = operatingPos.above(i);
                    BlockState state = this.level.getBlockState(updatePos);
                    this.level.updateNeighborsAt(updatePos, state.getBlock());
                    if (i == 0 || !((blockEntity2 = this.level.getBlockEntity(updatePos)) instanceof CrystallineFlowerBlockEntity)) continue;
                    CrystallineFlowerBlockEntity crystallineFlowerBlockEntity2 = (CrystallineFlowerBlockEntity)blockEntity2;
                    crystallineFlowerBlockEntity2.loadWithComponents(crystallineFlowerBlockEntity.getUpdateTag((HolderLookup.Provider)this.level.registryAccess()), (HolderLookup.Provider)this.level.registryAccess());
                }
            }
        }
    }

    public boolean isMaxXP() {
        return this.currentXp == this.getMaxXpForTier(this.xpTier);
    }

    public boolean isMinXP() {
        return this.currentXp == 0;
    }

    public boolean isMaxTier() {
        return this.xpTier == 7;
    }

    public boolean isMinTier() {
        return this.xpTier == 0;
    }

    public int getMaxXpForTier(int tier) {
        return Math.max(1, 90 + tier * tier * 15 + BzGeneralConfigs.crystallineFlowerExtraXpNeededForTiers);
    }

    public int getXpForNextTiers(int nextTiersToCalculate) {
        int totalXpNeeded = 0;
        for (int i = 0; i < nextTiersToCalculate; ++i) {
            if (i == 0) {
                totalXpNeeded += this.getMaxXpForTier(this.xpTier) - this.currentXp;
                continue;
            }
            if (this.xpTier + i > 7) continue;
            totalXpNeeded += this.getMaxXpForTier(this.xpTier + i);
        }
        return totalXpNeeded;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput dataComponentInput) {
        super.applyImplicitComponents(dataComponentInput);
        CrystallineFlowerData crystallineFlowerData = (CrystallineFlowerData)dataComponentInput.getOrDefault((DataComponentType)BzDataComponents.CRYSTALLINE_FLOWER_DATA.get(), (Object)new CrystallineFlowerData());
        this.xpTier = crystallineFlowerData.tier();
        this.currentXp = crystallineFlowerData.experience();
        if (crystallineFlowerData.uuid().compareTo(CrystallineFlowerData.DEFAULT_UUID) != 0) {
            this.uuid = crystallineFlowerData.uuid();
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        CrystallineFlowerData crystallineFlowerData = new CrystallineFlowerData(this.xpTier, this.currentXp, this.uuid);
        builder.set((DataComponentType)BzDataComponents.CRYSTALLINE_FLOWER_DATA.get(), (Object)crystallineFlowerData);
    }

    public void removeComponentsFromTag(CompoundTag compoundTag) {
        compoundTag.remove(TIER_TAG);
        compoundTag.remove(XP_TAG);
        compoundTag.remove(UUID_TAG);
        super.removeComponentsFromTag(compoundTag);
    }
}

