/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.SuperCandleWick;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;

public interface SuperCandle {
    public static boolean canBeLit(Level level, BlockState state, BlockPos pos) {
        BlockState aboveState = level.getBlockState(pos.above());
        return aboveState.is(BzTags.CANDLE_WICKS) && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false && (Boolean)state.getValue((Property)BlockStateProperties.LIT) == false && (Boolean)aboveState.getValue((Property)BlockStateProperties.WATERLOGGED) == false && (Boolean)aboveState.getValue((Property)BlockStateProperties.LIT) == false;
    }

    public static void placeWickIfPossible(LevelAccessor levelAccessor, BlockPos blockPos, boolean lit) {
        boolean wickWaterlogged;
        ChunkAccess chunkAccess = levelAccessor.getChunk(blockPos);
        BlockPos wickPosition = SuperCandleWick.getLitWickPositionAbove(levelAccessor, blockPos);
        BlockState aboveState = chunkAccess.getBlockState(blockPos.above());
        boolean wickSpotAvaliableAbove = false;
        if (wickPosition == null) {
            if (!aboveState.is(BzTags.CANDLE_WICKS) && (aboveState.canBeReplaced() || aboveState.isAir())) {
                wickPosition = blockPos.above();
                wickSpotAvaliableAbove = true;
            } else {
                return;
            }
        }
        BlockState wickState = chunkAccess.getBlockState(wickPosition);
        boolean isBelowSoul = SuperCandleWick.isSoulBelowInRange(levelAccessor, blockPos.below());
        boolean bl = wickWaterlogged = wickState.getFluidState().is(FluidTags.WATER) && wickState.getFluidState().isSource();
        if (wickState.is((Block)BzBlocks.SUPER_CANDLE_WICK.get()) && isBelowSoul || wickState.is((Block)BzBlocks.SUPER_CANDLE_WICK_SOUL.get()) && !isBelowSoul || wickSpotAvaliableAbove) {
            if (wickState.is(BzTags.CANDLE_WICKS)) {
                lit = (Boolean)wickState.getValue((Property)BlockStateProperties.LIT);
            }
            Block wickBlock = isBelowSoul && lit ? (Block)BzBlocks.SUPER_CANDLE_WICK_SOUL.get() : (Block)BzBlocks.SUPER_CANDLE_WICK.get();
            BlockState candleWick = (BlockState)((BlockState)wickBlock.defaultBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(lit))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(wickWaterlogged));
            levelAccessor.setBlock(wickPosition, candleWick, 3);
            if (wickWaterlogged) {
                BlockState currentState;
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                mutableBlockPos.set((Vec3i)wickPosition.below());
                for (int i = 0; i < chunkAccess.getMaxBuildHeight() - mutableBlockPos.getY() && (currentState = chunkAccess.getBlockState((BlockPos)mutableBlockPos)).getBlock() instanceof SuperCandle; ++i) {
                    levelAccessor.setBlock(blockPos, (BlockState)currentState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                    mutableBlockPos.move(Direction.DOWN);
                }
            }
        }
    }

    default public boolean CandleUnlightBehaviors(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, boolean simulate) {
        if (itemStack.isEmpty() && ((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            if (!simulate) {
                SuperCandleWick.extinguish(player, level.getBlockState(blockPos.above()), (LevelAccessor)level, blockPos.above());
            }
            return true;
        }
        return false;
    }

    default public boolean CandleLightBehaviors(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand playerHand, boolean simulate) {
        if (!((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            if (itemStack.is(BzTags.INFINITE_CANDLE_LIGHTING_ITEMS)) {
                if (!simulate && this.lightCandle(level, blockPos, player) && !itemStack.isEmpty()) {
                    player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
                }
                return true;
            }
            if (itemStack.is(BzTags.DAMAGEABLE_CANDLE_LIGHTING_ITEMS)) {
                if (!simulate) {
                    boolean successfulLit = this.lightCandle(level, blockPos, player);
                    if (!itemStack.isEmpty() && successfulLit) {
                        player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
                    }
                    if (successfulLit && player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        if (!player.getAbilities().instabuild) {
                            itemStack.hurtAndBreak(1, (LivingEntity)serverPlayer, LivingEntity.getSlotForHand((InteractionHand)playerHand));
                        }
                    }
                }
                return true;
            }
            if (itemStack.is(BzTags.CONSUMABLE_CANDLE_LIGHTING_ITEMS)) {
                if (!simulate) {
                    boolean successfulLit = this.lightCandle(level, blockPos, player);
                    if (!itemStack.isEmpty() && successfulLit) {
                        player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
                    }
                    if (successfulLit && !player.getAbilities().instabuild) {
                        itemStack.shrink(1);
                    }
                }
                return true;
            }
        }
        return false;
    }

    default public boolean lightCandle(Level level, BlockPos blockPos, Player player) {
        boolean litWick = SuperCandleWick.setLit((LevelAccessor)level, level.getBlockState(blockPos.above()), blockPos.above(), true);
        if (litWick && player instanceof ServerPlayer) {
            SuperCandleWick candleWick;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Block block = level.getBlockState(blockPos.above()).getBlock();
            if (block instanceof SuperCandleWick && (candleWick = (SuperCandleWick)block).isSoul()) {
                ((GenericTrigger)((Object)BzCriterias.LIGHT_SOUL_SUPER_CANDLE_TRIGGER.get())).trigger(serverPlayer);
            }
        }
        return litWick;
    }
}

