/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.google.common.collect.MapMaker;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.PollenPuffEntity;
import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.FallingBlockEntityAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.BeeEntityInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PileOfPollen
extends FallingBlock {
    protected static final ConcurrentMap<String, Pair<Integer, Integer>> APPLIED_FALL_REDUCTION_FOR_ENTITY = new MapMaker().concurrencyLevel(2).weakKeys().makeMap();
    public static final IntegerProperty LAYERS = BlockStateProperties.LAYERS;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Shapes.empty(), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private Item item;
    public static final MapCodec<PileOfPollen> CODEC = Block.simpleCodec(PileOfPollen::new);

    public PileOfPollen() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).isViewBlocking((blockState, world, blockPos) -> true).isSuffocating((blockState, blockGetter, blockPos) -> false).noOcclusion().noCollission().strength(0.1f).replaceable().pushReaction(PushReaction.DESTROY).sound(SoundType.SNOW));
    }

    public PileOfPollen(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<? extends PileOfPollen> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{LAYERS});
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)BzItems.POLLEN_PUFF.get());
    }

    public Item asItem() {
        if (this.item == null) {
            this.item = (Item)BzItems.POLLEN_PUFF.get();
        }
        return this.item;
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return true;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPE_BY_LAYER[(Integer)blockState.getValue((Property)LAYERS)];
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return Shapes.empty();
    }

    public VoxelShape getBlockSupportShape(BlockState blockState, BlockGetter world, BlockPos blockPos) {
        return SHAPE_BY_LAYER[(Integer)blockState.getValue((Property)LAYERS)];
    }

    public VoxelShape getVisualShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPE_BY_LAYER[(Integer)blockState.getValue((Property)LAYERS)];
    }

    public boolean useShapeForLightOcclusion(BlockState blockState) {
        return true;
    }

    public boolean canSurvive(BlockState blockState, LevelReader world, BlockPos blockPos) {
        BlockState blockstate = world.getBlockState(blockPos.below());
        if (blockstate.is(BlockTags.SNOW_LAYER_CANNOT_SURVIVE_ON) || !world.getBlockState(blockPos).getFluidState().isEmpty()) {
            return false;
        }
        if (blockstate.isAir() || blockstate.is((Block)BzBlocks.PILE_OF_POLLEN.get()) || blockstate.is(BlockTags.SNOW_LAYER_CAN_SURVIVE_ON)) {
            return true;
        }
        return Block.isFaceFull((VoxelShape)blockstate.getCollisionShape((BlockGetter)world, blockPos.below()), (Direction)Direction.UP);
    }

    public BlockState updateShape(BlockState oldBlockState, Direction direction, BlockState newBlockState, LevelAccessor world, BlockPos blockPos, BlockPos blockPos1) {
        return !oldBlockState.canSurvive((LevelReader)world, blockPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(oldBlockState, direction, newBlockState, world, blockPos, blockPos1);
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (PileOfPollen.canFall(serverLevel.getBlockState(blockPos.below())) && blockPos.getY() >= serverLevel.getMinBuildHeight()) {
            FallingBlockEntity fallingblockentity = new FallingBlockEntity((Level)serverLevel, (double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5, serverLevel.getBlockState(blockPos));
            serverLevel.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
            this.falling(fallingblockentity);
            serverLevel.addFreshEntity((Entity)fallingblockentity);
        }
    }

    private static boolean canFall(BlockState blockState) {
        boolean isFullPollenPile = blockState.is((Block)BzBlocks.PILE_OF_POLLEN.get()) && (Integer)blockState.getValue((Property)LAYERS) == 8;
        return !isFullPollenPile && (blockState.isAir() || blockState.is(BlockTags.FIRE) || !blockState.getFluidState().isEmpty() || blockState.canBeReplaced());
    }

    public boolean canBeReplaced(BlockState blockState, BlockPlaceContext itemPlacementContext) {
        int layerValue = (Integer)blockState.getValue((Property)LAYERS);
        if (itemPlacementContext.getItemInHand().getItem() == this.asItem() && layerValue < 8) {
            if (!(itemPlacementContext instanceof DirectionalPlaceContext) && itemPlacementContext.replacingClickedOnBlock()) {
                return itemPlacementContext.getClickedFace() == Direction.UP;
            }
            return true;
        }
        return layerValue == 1;
    }

    public BlockState getStateForPlacement(BlockPlaceContext itemPlacementContext) {
        BlockState blockState = itemPlacementContext.getLevel().getBlockState(itemPlacementContext.getClickedPos());
        if (blockState.is((Block)this)) {
            int layerValue = (Integer)blockState.getValue((Property)LAYERS);
            return (BlockState)blockState.setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, layerValue + 1)));
        }
        return super.getStateForPlacement(itemPlacementContext);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        return (Integer)blockState.getValue((Property)LAYERS);
    }

    public void destroy(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (world.isClientSide()) {
            for (int i = 0; i < 50; ++i) {
                PileOfPollen.spawnParticles(blockState, world, blockPos, world.getRandom(), true);
                PileOfPollen.spawnParticles(world, Vec3.atCenterOf((Vec3i)blockPos), world.getRandom(), 0.055, 0.0075, 0.0);
            }
        }
    }

    public static void slowFallSpeed(Entity entity, BlockPos blockPos, int slownessPower) {
        LivingEntity livingEntity;
        ItemStack beeLeggings;
        double speedReduction;
        double d = speedReduction = entity instanceof Projectile ? 0.85 : 1.0 - (double)slownessPower * 0.1;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)entity;
            v1 = HoneyBeeLeggings.getEntityBeeLegging(livingEntity2);
        } else {
            v1 = beeLeggings = ItemStack.EMPTY;
        }
        if (!beeLeggings.isEmpty()) {
            speedReduction = Math.max(0.9, speedReduction);
        }
        Vec3 deltaMovement = entity.getDeltaMovement();
        double newYDelta = deltaMovement.y;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (serverPlayer.fallDistance > 18.0f && newYDelta < -0.9 && slownessPower >= 6) {
                ((GenericTrigger)((Object)BzCriterias.FALLING_ON_POLLEN_BLOCK_TRIGGER.get())).trigger(serverPlayer);
            }
        }
        if (deltaMovement.y > 0.0) {
            newYDelta *= 1.0 - (double)slownessPower * 0.01;
        } else if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).hasEffect(MobEffects.SLOW_FALLING)) {
            newYDelta *= 0.7 - (double)slownessPower * 0.07;
        }
        if (!entity.getType().is(BzTags.PILE_OF_POLLEN_CANNOT_SLOW)) {
            entity.setDeltaMovement(new Vec3(deltaMovement.x * speedReduction, newYDelta, deltaMovement.z * speedReduction));
        }
        if (!entity.onGround()) {
            entity.fallDistance = Math.min(entity.fallDistance, (float)Math.abs(newYDelta) / 0.07f);
        }
    }

    public void entityInside(BlockState blockState, Level world, BlockPos blockPos, Entity entity) {
        if (!blockState.is((Block)BzBlocks.PILE_OF_POLLEN.get())) {
            return;
        }
        if (entity instanceof FallingBlockEntity) {
            if (((FallingBlockEntity)entity).getBlockState().isAir() || world.isClientSide()) {
                return;
            }
            if (((FallingBlockEntity)entity).getBlockState().is((Block)BzBlocks.PILE_OF_POLLEN.get())) {
                PileOfPollen.stackPollen(blockState, world, blockPos, ((FallingBlockEntity)entity).getBlockState());
                entity.discard();
                ((FallingBlockEntityAccessor)entity).setBlockState(Blocks.AIR.defaultBlockState());
            } else {
                world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
                if (world.isClientSide()) {
                    for (int i = 0; i < (Integer)blockState.getValue((Property)LAYERS) * 30; ++i) {
                        PileOfPollen.spawnParticles(blockState, (LevelAccessor)world, blockPos, world.random, true);
                    }
                }
            }
        } else if (entity instanceof PollenPuffEntity) {
            PollenPuffEntity pollenPuffEntity = (PollenPuffEntity)entity;
            if (pollenPuffEntity.isConsumed() || !GeneralUtils.isPermissionAllowedAtSpot(world, pollenPuffEntity.getOwner(), blockPos, true)) {
                return;
            }
            PileOfPollen.stackPollen(blockState, world, blockPos, ((Block)BzBlocks.PILE_OF_POLLEN.get()).defaultBlockState());
            pollenPuffEntity.remove(Entity.RemovalReason.DISCARDED);
            pollenPuffEntity.consumed();
            if (world.isClientSide()) {
                for (int i = 0; i < 50; ++i) {
                    PileOfPollen.spawnParticles((LevelAccessor)world, pollenPuffEntity.position(), world.random, 0.055, 0.0075, 0.0);
                }
            }
        } else if (!(entity instanceof ExperienceOrb)) {
            int layerValueMinusOne = (Integer)blockState.getValue((Property)LAYERS) - 1;
            double entitySpeed = entity.getDeltaMovement().length();
            double chance = 0.22 + (double)layerValueMinusOne * 0.09;
            Pair reduction = APPLIED_FALL_REDUCTION_FOR_ENTITY.getOrDefault(entity.getStringUUID(), null);
            if (reduction == null || (Integer)reduction.getFirst() != entity.tickCount || (Integer)reduction.getSecond() < layerValueMinusOne && (Integer)reduction.getFirst() == entity.tickCount) {
                int diffInLayer = reduction == null ? layerValueMinusOne : layerValueMinusOne - (Integer)reduction.getSecond();
                PileOfPollen.slowFallSpeed(entity, blockPos, diffInLayer);
                APPLIED_FALL_REDUCTION_FOR_ENTITY.put(entity.getStringUUID(), (Pair<Integer, Integer>)Pair.of((Object)entity.tickCount, (Object)layerValueMinusOne));
            }
            if (entitySpeed > 1.0E-5 && (double)world.random.nextFloat() < chance) {
                int particleStrength;
                int particleNumber = (int)(entitySpeed / 0.0045);
                int n = particleStrength = entity instanceof ItemEntity ? Math.min(10, particleNumber / 3) : Math.min(20, particleNumber);
                if (world.isClientSide()) {
                    for (int i = 0; i < particleNumber; ++i) {
                        if (particleNumber > 5) {
                            PileOfPollen.spawnParticles(blockState, (LevelAccessor)world, blockPos, world.random, true);
                        }
                        PileOfPollen.spawnParticles((LevelAccessor)world, entity.position().add(entity.getDeltaMovement().multiply(2.0, 2.0, 2.0)).add(0.0, 0.75, 0.0), world.random, 0.006 * (double)particleStrength, 7.5E-4 * (double)particleStrength, 0.006 * (double)particleStrength);
                    }
                } else if (!(entity instanceof Player) && !(entity instanceof ItemEntity)) {
                    PileOfPollen.spawnParticlesServer((LevelAccessor)world, entity.position().add(entity.getDeltaMovement().multiply(2.0, 2.0, 2.0)).add(0.0, 0.75, 0.0), world.random, 0.006 * (double)particleStrength, 7.5E-4 * (double)particleStrength, 0.006 * (double)particleStrength, particleNumber);
                }
            }
            if (entity instanceof Bee && !((Bee)entity).hasNectar() && entity.getType().is(BzTags.POLLEN_PUFF_CAN_POLLINATE)) {
                ((BeeEntityInvoker)entity).callSetHasNectar(true);
                ((Bee)entity).resetTicksWithoutNectarSinceExitingHive();
                if (layerValueMinusOne == 0) {
                    world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
                } else {
                    world.setBlock(blockPos, (BlockState)blockState.setValue((Property)LAYERS, (Comparable)Integer.valueOf(layerValueMinusOne)), 3);
                }
            }
            if (entity instanceof Panda) {
                Panda pandaEntity = (Panda)entity;
                PileOfPollen.pandaSneezing(pandaEntity);
            }
            if (!entity.level().isClientSide() && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                PileOfPollen.applyHiddenEffectIfBuried(livingEntity, blockState, blockPos, true);
            }
        }
    }

    public static void reapplyHiddenEffectIfInsidePollenPile(LivingEntity livingEntity) {
        AABB aabb = livingEntity.getBoundingBox();
        BlockPos minCorner = BlockPos.containing((double)(aabb.minX + 0.001), (double)(aabb.minY + 0.001), (double)(aabb.minZ + 0.001));
        BlockPos maxCorner = BlockPos.containing((double)(aabb.maxX - 0.001), (double)(aabb.maxY - 0.001), (double)(aabb.maxZ - 0.001));
        Level level = livingEntity.level();
        if (!level.isClientSide() && level.hasChunksAt(minCorner, maxCorner)) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int x = minCorner.getX(); x <= maxCorner.getX(); ++x) {
                for (int y = minCorner.getY(); y <= maxCorner.getY(); ++y) {
                    for (int z = minCorner.getZ(); z <= maxCorner.getZ(); ++z) {
                        mutableBlockPos.set(x, y, z);
                        BlockState blockState = level.getBlockState((BlockPos)mutableBlockPos);
                        if (!blockState.is((Block)BzBlocks.PILE_OF_POLLEN_SUSPICIOUS.get())) continue;
                        PileOfPollen.applyHiddenEffectIfBuried(livingEntity, blockState, (BlockPos)mutableBlockPos, false);
                    }
                }
            }
        }
    }

    static void applyHiddenEffectIfBuried(LivingEntity livingEntity, BlockState blockState, BlockPos blockPos, boolean doesNotRefreshExistingHidden) {
        Registry mobEffects = livingEntity.level().registryAccess().registryOrThrow(Registries.MOB_EFFECT);
        Holder.Reference hiddenEffectReference = (Holder.Reference)mobEffects.getHolder(BzEffects.HIDDEN.getId()).get();
        if (doesNotRefreshExistingHidden && livingEntity.hasEffect((Holder)hiddenEffectReference)) {
            return;
        }
        AABB blockBounds = blockState.getShape((BlockGetter)livingEntity.level(), blockPos).bounds().move((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        if (blockBounds.contains(livingEntity.getEyePosition())) {
            livingEntity.addEffect(new MobEffectInstance((Holder)hiddenEffectReference, 10, 1, true, false, true));
        } else if (blockBounds.contains(livingEntity.getEyePosition().add(0.0, -0.2, 0.0))) {
            livingEntity.addEffect(new MobEffectInstance((Holder)hiddenEffectReference, 10, 0, true, false, true));
        }
    }

    public static void stackPollen(BlockState blockState, Level world, BlockPos blockPos, BlockState pollonToStack) {
        BlockState lastSetState = null;
        int initialLayerValue = (Integer)blockState.getValue((Property)LAYERS);
        int layersToAdd = (Integer)pollonToStack.getValue((Property)LAYERS);
        if (initialLayerValue < 8) {
            int layerToMax = 8 - initialLayerValue;
            lastSetState = (BlockState)blockState.setValue((Property)LAYERS, (Comparable)Integer.valueOf(initialLayerValue + Math.min(layerToMax, layersToAdd)));
            world.setBlock(blockPos, lastSetState, 3);
            layersToAdd -= layerToMax;
        }
        BlockState aboveState = world.getBlockState(blockPos.above());
        if (layersToAdd > 0 && aboveState.is((Block)BzBlocks.PILE_OF_POLLEN.get())) {
            PileOfPollen.stackPollen(aboveState, world, blockPos.above(), (BlockState)blockState.setValue((Property)LAYERS, (Comparable)Integer.valueOf(layersToAdd)));
        } else {
            if (layersToAdd > 0 && (aboveState.isAir() || aboveState.is(BzTags.AIR_LIKE))) {
                lastSetState = (BlockState)blockState.setValue((Property)LAYERS, (Comparable)Integer.valueOf(layersToAdd));
                world.setBlock(blockPos.above(), (BlockState)blockState.setValue((Property)LAYERS, (Comparable)Integer.valueOf(layersToAdd)), 3);
            }
            if (world.isClientSide() && lastSetState != null) {
                for (int i = 0; i < 40; ++i) {
                    PileOfPollen.spawnParticles(lastSetState, (LevelAccessor)world, blockPos, world.random, true);
                }
            }
        }
    }

    public static void pandaSneezing(Panda pandaEntity) {
        if (!pandaEntity.level().isClientSide() && pandaEntity.getRandom().nextFloat() < 0.005f && pandaEntity.level().getBlockState(pandaEntity.blockPosition()).is((Block)BzBlocks.PILE_OF_POLLEN.get())) {
            pandaEntity.sneeze(true);
        }
    }

    public void animateTick(BlockState blockState, Level world, BlockPos blockPos, RandomSource random) {
        int layerValue = (Integer)blockState.getValue((Property)LAYERS);
        double chance = 0.015f + (float)layerValue * 0.008f;
        if ((double)random.nextFloat() < chance) {
            PileOfPollen.spawnParticles(blockState, (LevelAccessor)world, blockPos, random, false);
        }
    }

    public int getDustColor(BlockState blockState, BlockGetter blockReader, BlockPos blockPos) {
        return 0xFFAA00;
    }

    public static void spawnParticles(BlockState blockState, LevelAccessor world, BlockPos blockPos, RandomSource random, boolean disturbed) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = blockPos.relative(direction);
            if (world.getBlockState(blockpos).isSolidRender((BlockGetter)world, blockpos)) continue;
            double speedYModifier = disturbed ? 0.05 : 0.005;
            double speedXZModifier = disturbed ? 0.03 : 0.005;
            VoxelShape currentShape = SHAPE_BY_LAYER[(Integer)blockState.getValue((Property)LAYERS)];
            double yHeight = currentShape.max(Direction.Axis.Y) - currentShape.min(Direction.Axis.Y);
            Direction.Axis directionAxis = direction.getAxis();
            double xOffset = directionAxis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.getStepX() : (double)random.nextFloat();
            double yOffset = directionAxis == Direction.Axis.Y ? yHeight * (double)direction.getStepY() : (double)random.nextFloat() * yHeight;
            double zOffset = directionAxis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.getStepZ() : (double)random.nextFloat();
            world.addParticle((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), (double)blockPos.getX() + xOffset, (double)blockPos.getY() + yOffset, (double)blockPos.getZ() + zOffset, random.nextGaussian() * speedXZModifier, random.nextGaussian() * speedYModifier + (disturbed ? 0.01 : 0.0), random.nextGaussian() * speedXZModifier);
            return;
        }
    }

    public static void spawnParticles(LevelAccessor world, Vec3 location, RandomSource random, double speedXZModifier, double speedYModifier, double initYSpeed) {
        double xOffset = (double)random.nextFloat() * 0.3 - 0.15;
        double yOffset = (double)random.nextFloat() * 0.3 - 0.15;
        double zOffset = (double)random.nextFloat() * 0.3 - 0.15;
        world.addParticle((ParticleOptions)BzParticles.POLLEN_PARTICLE.get(), location.x() + xOffset, location.y() + yOffset, location.z() + zOffset, random.nextGaussian() * speedXZModifier, random.nextGaussian() * speedYModifier + initYSpeed, random.nextGaussian() * speedXZModifier);
    }

    public static void spawnParticlesServer(LevelAccessor world, Vec3 location, RandomSource random, double speedXZModifier, double speedYModifier, double initYSpeed, int numberOfParticles) {
        if (world.isClientSide()) {
            return;
        }
        double xOffset = (double)random.nextFloat() * 0.3 - 0.15;
        double yOffset = (double)random.nextFloat() * 0.3 - 0.15;
        double zOffset = (double)random.nextFloat() * 0.3 - 0.15;
        ((ServerLevel)world).sendParticles((ParticleOptions)((SimpleParticleType)BzParticles.POLLEN_PARTICLE.get()), location.x() + xOffset, location.y() + yOffset, location.z() + zOffset, numberOfParticles, random.nextGaussian() * speedXZModifier, random.nextGaussian() * speedYModifier + initYSpeed, random.nextGaussian() * speedXZModifier, (double)0.02f);
    }
}

