/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FilledPorousHoneycomb
extends Block {
    public static final MapCodec<FilledPorousHoneycomb> CODEC = Block.simpleCodec(FilledPorousHoneycomb::new);

    public FilledPorousHoneycomb() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BANJO).strength(0.5f, 0.5f).sound(SoundType.CORAL_BLOCK).speedFactor(0.8f));
    }

    public FilledPorousHoneycomb(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<? extends FilledPorousHoneycomb> codec() {
        return CODEC;
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level world, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        if (itemStack.getItem() == Items.GLASS_BOTTLE) {
            world.setBlock(position, ((Block)BzBlocks.POROUS_HONEYCOMB.get()).defaultBlockState(), 3);
            world.playSound(playerEntity, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
            GeneralUtils.givePlayerItem(playerEntity, playerHand, new ItemStack((ItemLike)Items.HONEY_BOTTLE), false, true);
            Level level = playerEntity.level();
            if ((level.dimension().location().equals((Object)Bumblezone.MOD_DIMENSION_ID) || BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) && !playerEntity.isCreative() && !playerEntity.isSpectator() && BzBeeAggressionConfigs.aggressiveBees) {
                ServerPlayer serverPlayer;
                Registry mobEffects = level.registryAccess().registryOrThrow(Registries.MOB_EFFECT);
                boolean hasProtection = playerEntity.hasEffect((Holder)mobEffects.getHolder(BzEffects.PROTECTION_OF_THE_HIVE.getId()).get());
                if (!hasProtection && playerEntity instanceof ServerPlayer && !EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)playerEntity) && world.getDifficulty() != Difficulty.PEACEFUL) {
                    MutableComponent message = Component.translatable((String)"system.the_bumblezone.no_protection").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED);
                    serverPlayer.displayClientMessage((Component)message, true);
                    playerEntity.addEffect(new MobEffectInstance((Holder)mobEffects.getHolder(BzEffects.WRATH_OF_THE_HIVE.getId()).get(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
                }
                if (hasProtection && playerEntity instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)playerEntity;
                    ((GenericTrigger)((Object)BzCriterias.HONEY_PERMISSION_TRIGGER.get())).trigger(serverPlayer);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, world, position, playerEntity, playerHand, raytraceResult);
    }

    public void entityInside(BlockState state, Level level, BlockPos blockPos, Entity entity) {
        FilledPorousHoneycomb.beeHoneyTake(state, level, blockPos, entity);
    }

    public void stepOn(Level level, BlockPos blockPos, BlockState state, Entity entity) {
        FilledPorousHoneycomb.beeHoneyTake(state, level, blockPos, entity);
    }

    public static void beeHoneyTake(BlockState state, Level level, BlockPos blockPos, Entity entity) {
        Bee beeEntity;
        if (entity instanceof Bee && !(beeEntity = (Bee)entity).isDeadOrDying() && beeEntity.getHealth() < beeEntity.getMaxHealth() && state.is((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
            beeEntity.heal(Math.min(4.0f, beeEntity.getMaxHealth() - beeEntity.getHealth()));
            level.setBlock(blockPos, ((Block)BzBlocks.POROUS_HONEYCOMB.get()).defaultBlockState(), 3);
            if (level.isClientSide()) {
                return;
            }
            Vec3 centerOfBee = beeEntity.getBoundingBox().getCenter();
            double spread = 0.25;
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.FALLING_HONEY, centerOfBee.x(), centerOfBee.y(), centerOfBee.z(), 10, spread, spread, spread, 0.0);
        }
    }

    public void animateTick(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        for (int i = 0; i < random.nextInt(2); ++i) {
            this.spawnHoneyParticles(world, random, position, blockState);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        return 1;
    }

    private void spawnHoneyParticles(Level world, RandomSource random, BlockPos position, BlockState blockState) {
        VoxelShape currentBlockShape;
        double yEndHeight;
        if (random.nextFloat() < 0.08f && (yEndHeight = (currentBlockShape = blockState.getCollisionShape((BlockGetter)world, position)).max(Direction.Axis.Y)) >= 1.0 && !blockState.is(BlockTags.IMPERMEABLE)) {
            double yStartHeight = currentBlockShape.min(Direction.Axis.Y);
            if (yStartHeight > 0.0) {
                this.addHoneyParticle(world, random, position, currentBlockShape, (double)position.getY() + yStartHeight - 0.05);
            } else {
                BlockPos belowBlockpos = position.below();
                BlockState belowBlockstate = world.getBlockState(belowBlockpos);
                VoxelShape belowBlockShape = belowBlockstate.getCollisionShape((BlockGetter)world, belowBlockpos);
                double yEndHeight2 = belowBlockShape.max(Direction.Axis.Y);
                if ((yEndHeight2 < 1.0 || !belowBlockstate.isSolidRender((BlockGetter)world, belowBlockpos)) && belowBlockstate.getFluidState().isEmpty()) {
                    this.addHoneyParticle(world, random, position, currentBlockShape, (double)position.getY() - 0.05);
                }
            }
        }
    }

    private void addHoneyParticle(Level world, RandomSource random, BlockPos blockPos, VoxelShape blockShape, double height) {
        this.addHoneyParticle(world, random, (double)blockPos.getX() + blockShape.min(Direction.Axis.X), (double)blockPos.getX() + blockShape.max(Direction.Axis.X), (double)blockPos.getZ() + blockShape.min(Direction.Axis.Z), (double)blockPos.getZ() + blockShape.max(Direction.Axis.Z), height);
    }

    private void addHoneyParticle(Level world, RandomSource random, double xMin, double xMax, double zMax, double zMin, double yHeight) {
        world.addParticle((ParticleOptions)ParticleTypes.DRIPPING_HONEY, Mth.lerp((double)random.nextDouble(), (double)xMin, (double)xMax), yHeight, Mth.lerp((double)random.nextDouble(), (double)zMax, (double)zMin), 0.0, 0.0, 0.0);
    }
}

