/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.entities.living.CosmicCrystalEntity;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.platform.BlockExtension;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import com.telepathicgrunt.the_bumblezone.worldgen.processors.ArenaSpecialBlockHandlerProcessor;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class EssenceBlock
extends BaseEntityBlock
implements BlockExtension {
    public static final GeneralUtils.Lazy<StructurePlaceSettings> PLACEMENT_SETTINGS = new GeneralUtils.Lazy<StructurePlaceSettings>(() -> new StructurePlaceSettings().setRotation(Rotation.NONE).setMirror(Mirror.NONE).setLiquidSettings(LiquidSettings.IGNORE_WATERLOGGING).setIgnoreEntities(true).setKnownShape(true).addProcessor((StructureProcessor)new BlockIgnoreProcessor(List.of((Block)BzBlocks.ESSENCE_BLOCK_RED.get(), (Block)BzBlocks.ESSENCE_BLOCK_PURPLE.get(), (Block)BzBlocks.ESSENCE_BLOCK_BLUE.get(), (Block)BzBlocks.ESSENCE_BLOCK_GREEN.get(), (Block)BzBlocks.ESSENCE_BLOCK_YELLOW.get(), (Block)BzBlocks.ESSENCE_BLOCK_WHITE.get(), (Block)BzBlocks.INFINITY_BARRIER.get()))).addProcessor((StructureProcessor)new ArenaSpecialBlockHandlerProcessor(false)));
    public static final GeneralUtils.Lazy<StructurePlaceSettings> PLACEMENT_SETTINGS_WITH_ENTITIES = new GeneralUtils.Lazy<StructurePlaceSettings>(() -> new StructurePlaceSettings().setRotation(Rotation.NONE).setMirror(Mirror.NONE).setLiquidSettings(LiquidSettings.IGNORE_WATERLOGGING).setIgnoreEntities(false).setKnownShape(true).addProcessor((StructureProcessor)new BlockIgnoreProcessor(List.of((Block)BzBlocks.ESSENCE_BLOCK_RED.get(), (Block)BzBlocks.ESSENCE_BLOCK_PURPLE.get(), (Block)BzBlocks.ESSENCE_BLOCK_BLUE.get(), (Block)BzBlocks.ESSENCE_BLOCK_GREEN.get(), (Block)BzBlocks.ESSENCE_BLOCK_YELLOW.get(), (Block)BzBlocks.ESSENCE_BLOCK_WHITE.get()))).addProcessor((StructureProcessor)new ArenaSpecialBlockHandlerProcessor(true)));

    protected EssenceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getOcclusionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return Shapes.block();
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            Vec3 center;
            ServerPlayer serverPlayer;
            boolean isNonEssencedServerPlayer;
            EntityCollisionContext ctx = (EntityCollisionContext)context;
            Entity entity = ctx.getEntity();
            if (entity == null || entity instanceof CosmicCrystalEntity || entity.isSpectator()) {
                return Shapes.empty();
            }
            boolean isInBounds = entity.getBoundingBox().inflate(0.01).intersects(new AABB(Vec3.atLowerCornerOf((Vec3i)blockPos), Vec3.atLowerCornerOf((Vec3i)blockPos.offset(1, 1, 1))));
            if (!isInBounds) {
                return Shapes.empty();
            }
            boolean isClientside = entity.level().isClientSide();
            boolean isNonPlayer = entity instanceof LivingEntity && !(entity instanceof Player);
            boolean bl = isNonEssencedServerPlayer = entity instanceof ServerPlayer && !EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)entity);
            if (isClientside || isNonPlayer || isNonEssencedServerPlayer) {
                if (!isClientside) {
                    if (entity instanceof ServerPlayer) {
                        EssenceBlockEntity essenceBlockEntity;
                        serverPlayer = (ServerPlayer)entity;
                        BlockEntity blockEntity = level.getBlockEntity(blockPos);
                        if (blockEntity instanceof EssenceBlockEntity && (essenceBlockEntity = (EssenceBlockEntity)blockEntity).getPlayerInArena().isEmpty()) {
                            serverPlayer.displayClientMessage((Component)Component.translatable((String)"essence.the_bumblezone.missing_essence_effect").withStyle(ChatFormatting.RED), true);
                        }
                    }
                    entity.hurt(entity.damageSources().magic(), 0.5f);
                }
                center = Vec3.atCenterOf((Vec3i)blockPos);
                entity.push(entity.getX() - center.x(), entity.getY() - center.y(), entity.getZ() - center.z());
                return Shapes.block();
            }
            this.entityInside(blockState, entity.level(), blockPos, entity);
            center = Vec3.atCenterOf((Vec3i)blockPos);
            entity.push(entity.getX() - center.x(), entity.getY() - center.y(), entity.getZ() - center.z());
        }
        return Shapes.empty();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new EssenceBlockEntity(blockPos, blockState);
    }

    public abstract ResourceLocation getArenaNbt();

    public abstract int getEventTimeFrame();

    public abstract void performUniqueArenaTick(ServerLevel var1, BlockPos var2, BlockState var3, EssenceBlockEntity var4);

    public abstract ServerEssenceEvent getServerEssenceEvent();

    public abstract ResourceLocation getEssenceItemReward();

    public abstract void awardPlayerWinStat(ServerPlayer var1);

    public abstract int getEssenceXpReward();

    public abstract boolean hasMiningFatigue();

    public void onPlayerEnter(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
    }

    public void onPlayerLeave(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        if (serverPlayer.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            serverPlayer.removeEffect(MobEffects.DIG_SLOWDOWN);
        }
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    public void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        Block block;
        ServerPlayer touchingPlayer;
        if (entity instanceof ServerPlayer && EssenceOfTheBees.hasEssence(touchingPlayer = (ServerPlayer)entity) && (block = blockState.getBlock()) instanceof EssenceBlock) {
            EssenceBlockEntity essenceBlockEntity;
            EssenceBlock essenceBlock = (EssenceBlock)block;
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = serverLevel.getBlockEntity(blockPos);
            if (blockEntity instanceof EssenceBlockEntity && (essenceBlockEntity = (EssenceBlockEntity)blockEntity).getPlayerInArena().isEmpty()) {
                StructureTemplateManager structureTemplateManager = serverLevel.getStructureManager();
                Optional optionalStructureTemplate = structureTemplateManager.get(this.getArenaNbt());
                optionalStructureTemplate.ifPresentOrElse(loadingStructureTemplate -> {
                    StructureTemplate savingStructureTemplate;
                    Vec3i size = loadingStructureTemplate.getSize();
                    BlockPos negativeHalfLengths = new BlockPos(-size.getX() / 2, -size.getY() / 2, -size.getZ() / 2);
                    essenceBlockEntity.setArenaSize(new BlockPos(size));
                    try {
                        savingStructureTemplate = structureTemplateManager.getOrCreate(essenceBlockEntity.getSavedNbtLocation());
                    }
                    catch (Exception exception) {
                        Bumblezone.LOGGER.error("Bumblezone Essence Block failed to create the NBT file to save area - {} - {} - {} - Location: {} - Error: {}", new Object[]{blockState, blockPos, this.getArenaNbt(), essenceBlockEntity.getSavedNbtLocationAsString(), exception});
                        return;
                    }
                    savingStructureTemplate.fillFromWorld((Level)serverLevel, blockPos.offset((Vec3i)negativeHalfLengths), size, !PLACEMENT_SETTINGS.getOrFillFromInternal().isIgnoreEntities(), (Block)essenceBlock);
                    try {
                        structureTemplateManager.save(essenceBlockEntity.getSavedNbtLocation());
                    }
                    catch (Exception exception) {
                        Bumblezone.LOGGER.error("Bumblezone Essence Block failed to save area into NBT file - {} - {} - {} - Location: {} - Error: {}", new Object[]{blockState, blockPos, this.getArenaNbt(), essenceBlockEntity.getSavedNbtLocationAsString(), exception});
                        return;
                    }
                    GeneralUtils.placeInWorldWithoutNeighborUpdate((ServerLevelAccessor)serverLevel, loadingStructureTemplate, blockPos.offset((Vec3i)negativeHalfLengths), blockPos.offset((Vec3i)negativeHalfLengths), PLACEMENT_SETTINGS_WITH_ENTITIES.getOrFillFromInternal().setRotationPivot(blockPos), serverLevel.getRandom(), 18);
                    List players = ((ServerLevel)level).getPlayers(p -> blockPos.getX() + size.getX() > p.blockPosition().getX() && blockPos.getY() + size.getY() > p.blockPosition().getY() && blockPos.getZ() + size.getZ() > p.blockPosition().getZ() && blockPos.getX() - size.getX() < p.blockPosition().getX() && blockPos.getY() - size.getY() < p.blockPosition().getY() && blockPos.getZ() - size.getZ() < p.blockPosition().getZ());
                    essenceBlockEntity.getPlayerInArena().clear();
                    for (ServerPlayer serverPlayer : players) {
                        essenceBlock.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
                        essenceBlockEntity.getPlayerInArena().add(serverPlayer.getUUID());
                        if (serverPlayer != touchingPlayer) {
                            serverPlayer.setDeltaMovement(touchingPlayer.getDeltaMovement().x(), touchingPlayer.getDeltaMovement().y(), touchingPlayer.getDeltaMovement().z());
                            serverPlayer.teleportTo(touchingPlayer.getX(), touchingPlayer.getY(), touchingPlayer.getZ());
                        }
                        EssenceBlock.spawnParticles(serverLevel, serverPlayer.position(), serverPlayer.getRandom());
                        for (int x = -1; x <= 1; ++x) {
                            for (int z = -1; z <= 1; ++z) {
                                ChunkPos chunkPos = new ChunkPos(blockPos);
                                serverLevel.getChunk(chunkPos.x + x, chunkPos.z + z).setInhabitedTime(1512000L);
                            }
                        }
                    }
                    essenceBlockEntity.getEventBar().setProgress(1.0f);
                    essenceBlockEntity.setEventTimer(this.getEventTimeFrame());
                    essenceBlockEntity.setChanged();
                }, () -> Bumblezone.LOGGER.error("Bumblezone Essence Block failed to even detect the nbt file at all {} - {} - {}", new Object[]{essenceBlockEntity, blockState, this.getArenaNbt()}));
            }
        }
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        for (int i = 0; i <= 2; ++i) {
            level.addParticle((ParticleOptions)BzParticles.SPARKLE_PARTICLE.get(), (double)blockPos.getX() + randomSource.nextDouble() * 1.5 - 0.25, (double)blockPos.getY() + randomSource.nextDouble() * 1.5 - 0.25, (double)blockPos.getZ() + randomSource.nextDouble() * 1.5 - 0.25, randomSource.nextGaussian() * 0.003, randomSource.nextGaussian() * 0.003, randomSource.nextGaussian() * 0.003);
        }
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random) {
        world.sendParticles((ParticleOptions)ParticleTypes.FIREWORK, location.x(), location.y() + 1.0, location.z(), 100, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1 + 0.1, random.nextGaussian() * 0.1, (double)random.nextFloat() * 0.4 + (double)0.2f);
        world.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, location.x(), location.y() + 1.0, location.z(), 400, 1.0, 1.0, 1.0, (double)random.nextFloat() * 0.5 + (double)1.2f);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return EssenceBlock.createEssenceTicker(level, blockEntityType, (BlockEntityType<? extends EssenceBlockEntity>)((BlockEntityType)BzBlockEntities.ESSENCE_BLOCK.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createEssenceTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends EssenceBlockEntity> blockEntityType2) {
        return level.isClientSide ? null : EssenceBlock.createTickerHelper(blockEntityType, blockEntityType2, EssenceBlockEntity::serverTick);
    }

    @Override
    public OptionalBoolean bz$shouldNotDisplayFluidOverlay() {
        return OptionalBoolean.TRUE;
    }
}

