/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.variable;

import java.util.HashMap;
import java.util.Map;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.variable.VariableHolder;

public class VariableStorage {
    private final Map<String, Object> contents = new HashMap<String, Object>();

    public VariableStorage() {
    }

    public VariableStorage(Map<String, Object> objects) {
        VariableStorage.storeGlobal(this);
        this.contents.putAll(objects);
    }

    public VariableStorage(VariableHolder holder) {
        VariableStorage.storeGlobal(this);
        this.store("id", holder.getId());
        Map<String, Object> variables = holder.getVariables();
        if (variables == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            this.store(entry.getKey(), entry.getValue());
        }
    }

    public void store(String key, Object value) {
        this.contents.put(key, value);
    }

    public Map<String, Object> getContents() {
        return this.contents;
    }

    public <T> T retrieve(String key) {
        return (T)this.contents.get(key);
    }

    public void remove(String key) {
        this.contents.remove(key);
    }

    public boolean contains(String key) {
        return this.contents.containsKey(key);
    }

    public void inherit(VariableStorage storage, boolean override) {
        for (Map.Entry<String, Object> entry : storage.contents.entrySet()) {
            if (!override && this.contents.containsKey(entry.getKey())) continue;
            this.contents.put(entry.getKey(), entry.getValue());
        }
    }

    public static void storeGlobal(VariableStorage storage) {
        RocketClientMod mod = RocketClientMod.getInstance();
        storage.store("modpackId", mod.getModpackId());
        storage.store("packId", mod.getPackMetadata().getId());
        storage.store("version", mod.getPackMetadata().getVersion().getName());
        storage.store("versionId", Integer.toString(mod.getPackMetadata().getVersion().getId()));
        storage.store("isInBeta", mod.isBetaAccess());
        storage.store("betaUrl", mod.getBetaUrl() == null ? "" : mod.getBetaUrl());
    }
}

