/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.layout.type;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.list.IListScreen;
import net.rocketplatform.game.client.mod.ui.template.layout.type.list.ListLayoutList;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractListLayoutTemplate
extends LayoutTemplate {
    protected List<ListEntry> entries;
    @SerializedName(value="render_background")
    public Boolean renderBackground;
    @SerializedName(value="entry_loader")
    protected ListEntryLoader loader;
    @SerializedName(value="empty_entry")
    protected Component emptyEntry;

    public AbstractListLayoutTemplate(String type, String id, Component title, List<ElementTemplate<?>> elements) {
        super(type, id, title, elements);
    }

    public ListEntryLoader getEntryLoader() {
        return this.loader;
    }

    public Component getEmptyEntry() {
        return this.emptyEntry;
    }

    @Override
    public final Screen createScreen0(@Nullable VariableStorage storage) {
        if (this.loader == null) {
            return this.createListScreen(storage, List.of());
        }
        CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> future = this.loader.loadEntries(storage);
        if (future.isDone() && !future.isCompletedExceptionally()) {
            List<ListEntryLoader.ListEntryTemplate> list2 = future.join();
            Object screen = this.createListScreen(storage, list2);
            IListScreen listScreen = (IListScreen)screen;
            if (list2.isEmpty() && this.emptyEntry != null) {
                listScreen.onListCreate(layoutList -> layoutList.addEntry(new ListLayoutList.EmptyHeader(listScreen.getTemplateScreen(), this.emptyEntry, (ListLayoutList)((Object)layoutList), null, null)));
            }
            return screen;
        }
        Object screen = this.createListScreen(storage, new ArrayList<ListEntryLoader.ListEntryTemplate>());
        IListScreen listScreen = (IListScreen)screen;
        listScreen.onListCreate(list -> {
            ListLayoutList.LoadingHeader loadingHeader = new ListLayoutList.LoadingHeader(listScreen.getTemplateScreen(), (ListLayoutList)((Object)list), null, null);
            list.addEntry(loadingHeader);
        });
        future.whenComplete((entryTemplates, e) -> {
            if (e != null) {
                RocketClientMod.getLogger().error("Failed to load list entries", e);
                return;
            }
            ListLayoutList list = listScreen.getList();
            ArrayList<ListLayoutList.ListEntry> entries = new ArrayList<ListLayoutList.ListEntry>();
            for (ListEntryLoader.ListEntryTemplate template : entryTemplates) {
                ListEntry entry = template.entry();
                ListLayoutList.ListEntry internalEntry = new ListLayoutList.ListEntry(listScreen.getTemplateScreen(), list, entry, template.storage());
                entries.add(internalEntry);
            }
            if (entries.isEmpty() && this.emptyEntry != null) {
                entries.add(new ListLayoutList.EmptyHeader(listScreen.getTemplateScreen(), this.emptyEntry, list, null, null));
            }
            list.refreshEntries(entries);
        });
        return screen;
    }

    public abstract <T extends Screen> T createListScreen(@Nullable VariableStorage var1, List<ListEntryLoader.ListEntryTemplate> var2);

    public record ListEntry(String id, List<ElementTemplate<?>> elements, @SerializedName(value="required_double_click_variable") String requiredDoubleClickVariable, ElementCallback callback, @SerializedName(value="selected_callback") ElementCallback selectedCallback) implements CallbackHolder
    {
        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public ElementCallback getCallback() {
            return this.callback;
        }
    }
}

