/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type;

import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.type.text.TextFormatter;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.ui.widget.MultilineStringWidget;
import net.rocketplatform.game.client.mod.ui.widget.StringWidget;
import org.joml.Vector2i;

public class TextElementTemplate
extends WidgetElementTemplate {
    private static final String WIDTH_KEY = "width";
    private static final String HEIGHT_KEY = "height";
    private static final int DEFAULT_WIDTH = 150;
    private static final int DEFAULT_HEIGHT = 9;
    private Component text;
    private String alignment;
    private String formatter;
    private Component tooltip;
    private boolean wrap;
    private boolean shadow;

    public TextElementTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    public TextElementTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback, Component text, String alignment, String formatter, Component tooltip, boolean wrap, boolean shadow, Map<String, Object> options, String requiredDisplayVariable) {
        super(type, id, position, callback);
        this.text = text;
        this.alignment = alignment;
        this.formatter = formatter;
        this.tooltip = tooltip;
        this.wrap = wrap;
        this.shadow = shadow;
        this.options = options;
        this.requiredDisplayVariable = requiredDisplayVariable;
    }

    public int getWidth() {
        return this.getOption(WIDTH_KEY, 150);
    }

    public int getHeight() {
        return this.getOption(HEIGHT_KEY, 9);
    }

    public Component getText() {
        return this.text;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public String getFormatter() {
        return this.formatter;
    }

    public Component getTooltip() {
        return this.tooltip;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    @Override
    public Widget createElement0(final TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, VariableStorage variableStorage) {
        Widget widget;
        Vector2i pos = this.getPivot().apply(elementWidth, elementHeight, this.getWidth(), this.getHeight());
        pos.add(offsetX + this.getPosition().x(), offsetY + this.getPosition().y());
        Component replacedText = VariableProcessor.processComponent(this.text, variableStorage);
        if (this.formatter != null) {
            TextFormatter formatter = TextFormatter.FORMATS.get(this.formatter);
            if (formatter != null) {
                replacedText = (Component)formatter.apply(replacedText);
            } else {
                RocketClientMod.getLogger().warn("Unknown formatter: {}", (Object)this.formatter);
            }
        }
        if (this.wrap) {
            widget = new MultilineStringWidget(screen.getPanel(), replacedText, this.shadow){

                public boolean mousePressed(MouseButton button) {
                    if (this.isMouseOver()) {
                        if (this.getWidgetType() != WidgetType.DISABLED) {
                            TextElementTemplate.this.runCallbacks(screen);
                        }
                        return true;
                    }
                    return false;
                }
            }.setMaxWidth(this.getWidth());
        } else {
            widget = new StringWidget(screen.getPanel(), this.tooltip, this.shadow){

                public boolean mousePressed(MouseButton button) {
                    if (this.isMouseOver()) {
                        if (this.getWidgetType() != WidgetType.DISABLED) {
                            TextElementTemplate.this.runCallbacks(screen);
                        }
                        return true;
                    }
                    return false;
                }
            };
            String alignment = this.alignment;
            if (this.alignment == null) {
                alignment = "left";
            }
            StringWidget stringWidget = (StringWidget)widget;
            switch (alignment) {
                case "center": {
                    stringWidget.alignCenter();
                    break;
                }
                case "left": {
                    stringWidget.alignLeft();
                    break;
                }
                case "right": {
                    stringWidget.alignRight();
                }
            }
            stringWidget.setMessage(replacedText);
        }
        widget.setPosAndSize(pos.x(), pos.y(), this.getWidth(), this.getHeight());
        return widget;
    }
}

